/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.ScriptingException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.ObjectName;

public class ConfigNameCache {
    private static TraceComponent tc = Tr.register(class$com$ibm$ws$scripting$ConfigNameCache == null ? (class$com$ibm$ws$scripting$ConfigNameCache = ConfigNameCache.class$("com.ibm.ws.scripting.ConfigNameCache")) : class$com$ibm$ws$scripting$ConfigNameCache, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private Hashtable cache = null;
    private int cacheSize = 0;
    private ConfigHelper configHelper = null;
    private Session session;
    private ConfigService configServiceProxy = null;
    static /* synthetic */ Class class$com$ibm$ws$scripting$ConfigNameCache;

    public ConfigNameCache(ConfigHelper configHelper, int n, Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigNameCache");
        }
        this.configHelper = configHelper;
        this.cacheSize = n;
        this.session = session;
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigNameCache");
        }
    }

    protected void reconnect() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reconnect");
        }
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reconnect");
        }
    }

    private void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.cache = new Hashtable(this.cacheSize);
        this.configServiceProxy = AdminConfigClient.getConfigService();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void add(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add - " + string);
        }
        if (this.cache.contains(string) && string2.equals((String)this.cache.get(string))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "add - in cache already");
            }
            return;
        }
        string = this.configHelper.cleanString(string);
        this.cache.put(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add");
        }
    }

    public String getType(String string) throws ScriptingException, AdminException, ConnectorException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType");
        }
        if ((string2 = (String)this.cache.get(string)) == null) {
            ObjectName objectName = this.configHelper.stringToObjectName(string);
            ObjectName[] objectNameArray = this.configServiceProxy.queryConfigObjects(this.session, null, objectName, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                ObjectName[] objectNameArray2;
                ConfigDataId configDataId;
                string2 = objectNameArray[i].getKeyProperty("_Websphere_Config_Data_Type");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found type " + string2 + " for name " + string);
                }
                if ((configDataId = ConfigServiceHelper.getConfigDataId(objectNameArray[i])).isResolved()) continue;
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Id is not resolved; need to make another call.");
                }
                if ((objectNameArray2 = this.configServiceProxy.queryConfigObjects(this.session, null, objectNameArray[i], null)) == null || objectNameArray2.length != 1) {
                    throw new ScriptingException("Cannot get resolved confid id" + configDataId);
                }
                string = objectNameArray2[0].getKeyProperty("_Websphere_Config_Data_Id");
            }
            if (string2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding: " + string + " as type " + string2);
                }
                this.add(string, string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType");
        }
        return string2;
    }

    public void dumpNameCache() {
        Enumeration enumeration = this.cache.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.cache.get(string);
            System.out.println(string + "\t" + string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

