/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminAppClient;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ExtensionHelper;
import com.ibm.ws.scripting.HelpSupport;
import com.ibm.ws.scripting.ScriptingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.python.core.Py;

public class WasxShell
extends AbstractShell {
    private static final String TRACE_PROP = "com.ibm.ws.scripting.traceString";
    private static final String TRACE_FILE_PROP = "com.ibm.ws.scripting.traceFile";
    private static final String WSADMIN_PROPERTIES = "com.ibm.ws.scripting.wsadminprops";
    private static TraceComponent tc = Tr.register(class$com$ibm$ws$scripting$WasxShell == null ? (class$com$ibm$ws$scripting$WasxShell = WasxShell.class$("com.ibm.ws.scripting.WasxShell")) : class$com$ibm$ws$scripting$WasxShell, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    protected ArrayList profiles = new ArrayList(3);
    protected String targetScript = null;
    private static AbstractShell _shell = null;
    private AdminConfigClient configObject = null;
    private static final String PROFILES_PROP = "com.ibm.ws.scripting.profiles";
    private ShutdownHook shutdownHook;
    static /* synthetic */ Class class$com$ibm$ws$scripting$WasxShell;

    public WasxShell() {
        this.bundle = ResourceBundle.getBundle("com.ibm.ws.scripting.resources.wscpMessage", Locale.getDefault());
        this.prompt = "wsadmin>";
        this.shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public static AbstractShell getShell() {
        if (_shell == null) {
            _shell = new WasxShell();
        }
        return _shell;
    }

    public Object executeCommand(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeCommands");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeCommands");
        }
        return null;
    }

    protected boolean parseAndValidateInput(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseAndValidateInput");
        }
        boolean bl = true;
        boolean bl2 = false;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl2) {
                this.scriptParms.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("-javaoption")) {
                ++i;
                continue;
            }
            if (stringArray[i].regionMatches(true, 0, "-help", 0, stringArray[i].length()) || stringArray[i].equals("-?")) {
                this.showHelp();
                bl = false;
                break;
            }
            if (stringArray[i].equals("-c")) {
                if (i + 1 < stringArray.length) {
                    this.commands.add(stringArray[++i]);
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "DASH_C_NEEDS_FOLLOWING_COMMAND", "\"-c\" must be followed by a command.");
                bl = false;
                break;
            }
            if (stringArray[i].equals("-f")) {
                if (i + 1 < stringArray.length) {
                    this.targetScript = stringArray[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[]{"-f"}, "OPTION_NEEDS_FOLLOWING_FILENAME", "\"-f\" must be followed by a file name.");
                bl = false;
                break;
            }
            if (stringArray[i].equals("-p")) {
                if (i + 1 < stringArray.length) {
                    this.propfiles.add(stringArray[++i]);
                    continue;
                }
                returnCode = this.issueMessage(new Object[]{"-p"}, "OPTION_NEEDS_FOLLOWING_FILENAME", "\"-p\" must be followed by a file name.");
                bl = false;
                break;
            }
            if (stringArray[i].equals("-profile")) {
                if (i + 1 < stringArray.length) {
                    this.profiles.add(stringArray[++i]);
                    continue;
                }
                returnCode = this.issueMessage(new Object[]{"-profile"}, "OPTION_NEEDS_FOLLOWING_FILENAME", "\"-profile\" must be followed by a file name.");
                bl = false;
                break;
            }
            if (stringArray[i].equals("-internalLang")) {
                if (i + 1 >= stringArray.length) continue;
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-lang")) {
                if (i + 1 >= stringArray.length) {
                    returnCode = this.issueMessage(new Object[0], "DASH_LANG_NEEDS_FOLLOWING_LANGUAGE", "\"-lang\" must be followed by a language identifier.");
                    bl = false;
                    break;
                }
                this.lang = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-conntype")) {
                if (i + 1 < stringArray.length) {
                    ++i;
                    if ((i = this.processConnType(stringArray, i)) >= 0) continue;
                    bl = false;
                    break;
                }
                returnCode = this.issueMessage(new Object[0], "DASH_CONNTYPE_NEEDS_FOLLOWING_CONN", "-conntype must be followed by connection type information.");
                bl = false;
                break;
            }
            if (stringArray[i].equals("-host")) {
                if (i + 1 < stringArray.length) {
                    this.argHost = stringArray[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "HOST_REQUIRES_ARG", "The \"-host\" option requires a host name.");
                continue;
            }
            if (stringArray[i].equals("-port")) {
                if (i + 1 < stringArray.length) {
                    this.argPort = stringArray[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "PORT_REQUIRES_ARG", "The \"-port\" option requires a port number.");
                continue;
            }
            if (stringArray[i].equals("-user") || stringArray[i].equals("-username")) {
                if (i + 1 < stringArray.length) {
                    this.argUser = stringArray[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "USER_REQUIRES_ARG", "The \"-user\" option requires a userid.");
                continue;
            }
            if (stringArray[i].equals("-password")) {
                if (i + 1 < stringArray.length) {
                    this.argPassword = stringArray[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "PASSWORD_REQUIRES_ARG", "The \"-password\" option requires a password.");
                continue;
            }
            if (stringArray[i].equals("-wsadmin_classpath")) {
                if (i + 1 < stringArray.length) {
                    this.argClasspath = stringArray[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "CLASSPATH_REQUIRES_ARG", "WASX7299E: \"-wsadmin_classpath\" option must be followed by a classpath.");
                continue;
            }
            if (stringArray[i].equals("--")) {
                bl2 = true;
                continue;
            }
            this.scriptParms.add(stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseAndValidateInput");
        }
        if (bl) {
            if (this.lang == null && string != null) {
                this.lang = string;
            }
            if (this.lang != null) {
                if (string != null && !string.equals(this.lang)) {
                    returnCode = this.issueMessage(new Object[0], "WASX7395E", "You have used both -lang and -internalLang options. However, they do not have the same value. Use either -lang or -internalLang option.");
                    bl = false;
                } else if (string == null && !this.lang.equalsIgnoreCase("jacl") && !this.lang.equalsIgnoreCase("jython")) {
                    returnCode = this.issueMessage(new Object[]{this.lang}, "LANGUAGE_NOT_SUPPORTED", "Language \"" + this.lang + "\" is not supported.");
                    bl = false;
                } else if (!BSFManager.isLanguageRegistered((String)this.lang)) {
                    returnCode = this.issueMessage(new Object[]{this.lang}, "LANGUAGE_NOT_REGISTERED", "Language \"" + this.lang + "\" is not registered to BSF.");
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected boolean declareBeans(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "declareBeans");
        }
        if (this.mgr == null) {
            return false;
        }
        try {
            if (object != null) {
                this.mgr.declareBean("AdminControl", object, object.getClass());
            }
            HelpSupport helpSupport = null;
            try {
                helpSupport = new HelpSupport(this);
            }
            catch (ScriptingException scriptingException) {
                returnCode = this.retcodeFromMessage(scriptingException.getMessage());
            }
            if (helpSupport != null) {
                this.mgr.declareBean("Help", (Object)helpSupport, helpSupport.getClass());
            } else {
                Tr.debug(tc, "Help is null");
            }
            this.configObject = new AdminConfigClient(this);
            if (this.configObject != null) {
                this.mgr.declareBean("AdminConfig", (Object)this.configObject, this.configObject.getClass());
            } else {
                Tr.debug(tc, "Config is null");
            }
            AdminAppClient adminAppClient = new AdminAppClient(this);
            this.mgr.declareBean("AdminApp", (Object)adminAppClient, adminAppClient.getClass());
            ExtensionHelper.processRegisterBeansInExtensions(_shell, this.mgr);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "declareBeans");
            }
            return true;
        }
        catch (Exception exception) {
            returnCode = this.logAndIssueMessage(new Object[]{"AdminControl", exception}, "EXCEPTION_DECLARING_BEAN", "BSFException received declaring \"AdminControl\": " + exception, exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "declareBeans");
            }
            return false;
        }
    }

    protected void executeProfiles() {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeProfiles");
        }
        if (this.lang != null && this.lang.equals("jython")) {
            Py.defaultSystemState.setClassLoader(Thread.currentThread().getContextClassLoader());
            if (this.argClasspath != null) {
                System.setProperty("java.class.path", this.saveClasspath);
            }
        }
        String string = System.getProperty(PROFILES_PROP);
        int n = 0;
        if (string != null) {
            string = this.normalizeFQPathName(string);
            object = new StringTokenizer(string, File.pathSeparator, false);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                this.profiles.add(n, string2);
                ++n;
            }
        }
        object = null;
        for (int i = 0; i < this.profiles.size(); ++i) {
            String string3;
            Object object2;
            String string4;
            block19: {
                block20: {
                    String string5;
                    block18: {
                        string4 = (String)this.profiles.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "processing profile: " + string4);
                        }
                        string5 = null;
                        try {
                            string5 = BSFManager.getLangFromFilename((String)string4);
                        }
                        catch (BSFException bSFException) {
                            returnCode = this.issueMessage(new Object[]{string4}, "CANNOT_FIND_LANG", "Cannot determine scripting language for file: \"" + string4 + "\" -- please specify \"-lang\" option on the command line.");
                            continue;
                        }
                        if (this.lang != null) break block18;
                        this.lang = string5;
                        break block19;
                    }
                    if (this.lang.equals(string5)) break block19;
                    if (i >= n) break block20;
                    object2 = new File(string4);
                    string3 = ((File)object2).getParent();
                    String string6 = File.separator;
                    String string7 = ((File)object2).getName();
                    int n2 = string7.lastIndexOf(".");
                    if (n2 <= -1) break block19;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string3);
                    stringBuffer.append(string6);
                    stringBuffer.append(string7.substring(0, n2));
                    if (this.lang.equalsIgnoreCase("jacl")) {
                        stringBuffer.append(".jacl");
                    } else if (this.lang.equalsIgnoreCase("jython")) {
                        stringBuffer.append(".py");
                    }
                    string4 = stringBuffer.toString();
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug(tc, "converted profile name: " + string4);
                    break block19;
                }
                returnCode = this.issueMessage(new Object[]{string4, this.lang}, "WASX7227W", "Profile " + string4 + " is in the wrong language and will not be executed; language used is " + this.lang);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using language: " + this.lang);
            }
            try {
                object = new FileReader(string4);
                object2 = this.getSanitizedScriptString((Reader)object);
                this.mgr.exec(this.lang, string4, 0, 0, object2);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                returnCode = this.logAndIssueMessage(new Object[]{string4}, "FILE_NOT_FOUND", "Cannot find file \"" + string4 + "\"", fileNotFoundException);
                continue;
            }
            catch (IOException iOException) {
                returnCode = this.logAndIssueMessage(new Object[]{string4, iOException}, "ERROR_READING_FILE", "Cannot read file \"" + string4 + "\"", iOException);
                continue;
            }
            catch (BSFException bSFException) {
                string3 = this.getStringFromException(bSFException);
                this.logException(bSFException, string3);
                returnCode = this.issueMessage(new Object[]{string4, string3}, "ERROR_RUNNING_FILE", "Problem running file \"" + string4 + "\"");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeProfiles");
        }
    }

    protected void showHelp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showHelp");
        }
        Object[] objectArray = new Object[]{};
        String string = this.getFormattedMessage("GENERAL_HELP", objectArray, "Syntax: wsadmin [options]");
        System.out.println(string);
        returnCode = this.retcodeFromMessage(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showHelp");
        }
    }

    protected String getTargetScript() {
        return this.targetScript;
    }

    protected void initializePropFileSet() {
        String string;
        String string2;
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializePropFileSet");
        }
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("wsadmin.properties");
        InputStream inputStream = null;
        if (uRL != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attempting to use resource from classloader");
            }
            try {
                inputStream = uRL.openStream();
                System.getProperties().load(inputStream);
                this.loadedPropfiles.add(uRL.getFile());
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught exception: " + iOException.toString());
                }
                uRL = null;
            }
        }
        if (uRL == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attempting to use server.root/properties");
            }
            if ((file = new File(string2 = System.getProperty("server.root") + File.separator + "properties" + File.separator + "wsadmin.properties")).canRead()) {
                try {
                    System.getProperties().load(new FileInputStream(file));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    returnCode = this.issueMessage(new Object[]{string2}, "FILE_NOT_FOUND", "Cannot find file " + string2);
                }
                catch (IOException iOException) {
                    returnCode = this.issueMessage(new Object[]{string2, iOException}, "EXCEPTION_LOADING_PROPERTIES_FILE", "Exception received while loading properties file; exception information: " + iOException);
                }
                this.loadedPropfiles.add(file.getAbsolutePath());
            }
        }
        if ((string2 = System.getProperty("user.home")) == null) {
            string2 = File.separator;
        } else if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        string2 = string2 + "wsadmin.properties";
        file = new File(string2);
        if (file.canRead()) {
            try {
                System.getProperties().load(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                returnCode = this.logAndIssueMessage(new Object[]{string2}, "FILE_NOT_FOUND", "Cannot find file " + string2, fileNotFoundException);
            }
            catch (IOException iOException) {
                returnCode = this.issueMessage(new Object[]{string2, iOException}, "EXCEPTION_LOADING_PROPERTIES_FILE", "Exception received while loading properties file; exception information: " + iOException);
            }
            this.loadedPropfiles.add(file.getAbsolutePath());
        }
        if ((string = System.getProperty(WSADMIN_PROPERTIES)) != null && string.length() > 0) {
            file = new File(string);
            try {
                System.getProperties().load(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                returnCode = this.logAndIssueMessage(new Object[]{string}, "FILE_NOT_FOUND", "Cannot find file " + string, fileNotFoundException);
            }
            catch (IOException iOException) {
                returnCode = this.issueMessage(new Object[]{string, iOException}, "EXCEPTION_LOADING_PROPERTIES_FILE", "Exception received while loading properties file; exception information: " + iOException);
            }
            this.loadedPropfiles.add(file.getAbsolutePath());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializePropFileSet");
        }
    }

    protected int retcodeFromMessage(String string) {
        int n = 0;
        if (string.startsWith("WASX")) {
            String string2 = string.substring(4, 8);
            try {
                n = Integer.parseInt(string2);
                n %= 256;
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    protected void setTrace() {
        String string = System.getProperty(TRACE_PROP);
        String string2 = System.getProperty(TRACE_FILE_PROP);
        String string3 = null;
        string3 = string2 != null ? "named file" : "stdout";
        ManagerAdmin.configureClientTrace(string, string3, string2, true, null, false);
    }

    protected void welcome() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "welcome");
        }
        Object[] objectArray = new Object[]{};
        String string = new String();
        if (this.lang == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "welcome -- no lang.");
            }
            return;
        }
        if (this.lang.equals("jacl")) {
            string = this.getFormattedMessage("JACL_WELCOME_HELP", objectArray, "For help, enter: \"$Help help\"");
        } else if (this.lang.equals("javascript")) {
            string = this.getFormattedMessage("JAVASCRIPT_WELCOME_HELP", objectArray, "For help, enter: \"Help.help()");
        } else if (this.lang.equals("jython")) {
            string = this.getFormattedMessage("JYTHON_WELCOME_HELP", objectArray, "For help, enter: \"Help.help()");
        }
        System.out.println(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "welcome");
        }
    }

    protected boolean timeToGo() {
        boolean bl = true;
        try {
            if (this.configObject != null) {
                bl = !this.configObject.hasChanges();
            }
        }
        catch (ScriptingException scriptingException) {
            Tr.audit(tc, "WASX7331I", new Object[]{scriptingException.toString()});
        }
        return bl;
    }

    protected void leaving(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "leaving");
        }
        boolean bl2 = true;
        if (this.configObject != null) {
            try {
                this.configObject.checkService();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "leaving; config service not running");
                }
                return;
            }
            try {
                bl2 = this.configObject.hasChanges();
                if (bl2) {
                    if (bl) {
                        this.configObject.save();
                    } else {
                        String string = this.getTargetScript();
                        if (string != null) {
                            Object[] objectArray = new Object[]{string};
                            Tr.audit(tc, "WASX7309W", objectArray);
                            String string2 = this.getFormattedMessage("WASX7309W", objectArray, "No \"save\" was performed before the script " + string + " exited; configuration changes will not be saved.");
                            System.out.println(string2);
                        } else {
                            Object[] objectArray = new Object[]{};
                            Tr.audit(tc, "WASX7341W", objectArray);
                            String string3 = this.getFormattedMessage("WASX7341W", objectArray, "No \"save\" was performed before the interactive session exited; configuration changes will not be saved.");
                            System.out.println(string3);
                        }
                    }
                }
                this.configObject.reset();
                if (this.shutdownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
            }
            catch (Exception exception) {
                this.setLastException(exception);
                String string = this.getStringFromException(null);
                this.logException(null, string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "leaving");
        }
    }

    public static void main(String[] stringArray) {
        AbstractShell abstractShell = WasxShell.getShell();
        abstractShell.run(stringArray);
        System.exit(returnCode);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "shutdown hook run");
            }
            ShutdownHook shutdownHook = this;
            synchronized (shutdownHook) {
                ShutdownHook shutdownHook2 = WasxShell.this.shutdownHook;
                WasxShell.this.shutdownHook = null;
                if (shutdownHook2 == null) {
                    return;
                }
            }
            WasxShell.this.leaving(false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "shutdown hook run");
            }
        }
    }
}

