/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.types;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.types.BaseTSHelper;
import com.ibm.ws.scripting.types.SecurityTSHelper;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class FIPSTSHelper
extends BaseTSHelper {
    private static TraceComponent tc = Tr.register(class$com$ibm$ws$scripting$types$FIPSTSHelper == null ? (class$com$ibm$ws$scripting$types$FIPSTSHelper = FIPSTSHelper.class$("com.ibm.ws.scripting.types.FIPSTSHelper")) : class$com$ibm$ws$scripting$types$FIPSTSHelper, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    protected static final String ALL_PROVIDER = "lookThroughAllSSLConfig";
    protected static final String DOMAIN = "WebSphere";
    protected static final String PROVIDER_MSG_ID = "SECURITY_NONFIPS_PROVIDER";
    protected static final String SSLCONFIG_MSG_ID = "SECURITY_NONFIPS_PROVIDER";
    protected static final String FIPS_MSG_ID = "SECURITY_NONFIPS_SSL";
    protected static final String PROVIDER_VALIDATION = "com.ibm.ssl.contextProvider";
    protected static final String SSLCONFIG_VALIDATION = "sslConfig";
    protected static final String FIPS_VALIDATION = "com.ibm.security.useFIPS";
    protected static final String ALL_VALIDATION = "all";
    protected String msgId = "SECURITY_NONFIPS_PROVIDER";
    protected String validationType = "com.ibm.ssl.contextProvider";
    protected Hashtable helperTable;
    protected ConfigNameCache nameCache;
    static /* synthetic */ Class class$com$ibm$ws$scripting$types$FIPSTSHelper;

    public FIPSTSHelper(AdminConfigClient adminConfigClient, AbstractShell abstractShell, Hashtable hashtable, ConfigNameCache configNameCache) {
        super(adminConfigClient, abstractShell);
        this.helperTable = hashtable;
        this.nameCache = configNameCache;
    }

    public abstract void reset();

    protected abstract boolean validate(AttributeList var1, ObjectName var2) throws ScriptingException, AdminException, ConnectorException;

    protected AttributeList getAttributeListFromON(ObjectName objectName) {
        AttributeList attributeList;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAttributeListFromON - " + objectName);
            }
            attributeList = null;
            try {
                attributeList = this._proxy.getAttributes(this._client.getCurrentSession(), objectName, null, false);
            }
            catch (ConfigServiceException configServiceException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, configServiceException.toString());
                }
            }
            catch (ConnectorException connectorException) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, connectorException.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeListFromON");
        }
        return attributeList;
    }

    protected boolean isFIPSEnabled(ObjectName objectName) throws ScriptingException, AdminException, ConnectorException {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFIPSEnabled");
        }
        boolean bl = false;
        int n = 0;
        String string = this.getConfigPath(objectName);
        ObjectName objectName2 = null;
        if (string != null && (objectNameArray = this.getObjectNameListForType("Security", null)) != null) {
            String string2;
            int n2;
            for (n2 = 0; n2 < objectNameArray.length; ++n2) {
                string2 = this.getConfigPath(objectNameArray[n2]);
                if (!string.equals(string2)) continue;
                objectName2 = objectNameArray[n2];
                break;
            }
            if (objectName2 != null) {
                n = this.checkFIPS(objectName2);
            }
            if (n == 0 && string.indexOf("/servers/") > 0) {
                objectName2 = null;
                for (n2 = 0; n2 < objectNameArray.length; ++n2) {
                    string2 = this.getConfigPath(objectNameArray[n2]);
                    if (string2.indexOf("/servers/") != -1) continue;
                    objectName2 = objectNameArray[n2];
                    break;
                }
                if (objectName2 != null) {
                    n = this.checkFIPS(objectName2);
                }
            }
        }
        if (n == 1) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFIPSEnabled - " + bl);
        }
        return bl;
    }

    protected void setValidationType(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setValidationType - " + string);
        }
        this.validationType = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setValidationType");
        }
    }

    protected void setMessageId(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMessageId - " + string);
        }
        this.msgId = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMessageId");
        }
    }

    protected FIPSTSHelper getTSHelper(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTSHelper - " + string);
        }
        FIPSTSHelper fIPSTSHelper = (FIPSTSHelper)this.helperTable.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTSHelper - " + fIPSTSHelper);
        }
        return fIPSTSHelper;
    }

    protected ObjectName[] getObjectNameListForType(String string, ObjectName objectName) throws ScriptingException, AdminException, ConnectorException {
        ObjectName[] objectNameArray;
        block14: {
            ObjectName objectName2;
            ObjectName objectName3;
            block13: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getObjectNameListForType", new Object[]{string, objectName});
                }
                objectName3 = null;
                objectName2 = null;
                objectNameArray = null;
                Hashtable<String, String> hashtable = null;
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                if (objectName != null) {
                    hashtable = objectName.getKeyPropertyList();
                    String string2 = objectName.getKeyProperty("_Websphere_Config_Data_Display_Name");
                    String string3 = objectName.getKeyProperty("_Websphere_Config_Data_Id");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "displayName: " + string2 + " configId: " + string3);
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    if (string2 != null) {
                        stringBuffer.append(stringBuffer);
                    }
                    stringBuffer.append("(");
                    stringBuffer.append(string3);
                    stringBuffer.append(")");
                    String string4 = this.nameCache.getType(stringBuffer.toString());
                    hashtable.put("_Websphere_Config_Data_Type", string4);
                }
                hashtable2.put("_Websphere_Config_Data_Type", string);
                try {
                    objectName2 = new ObjectName(DOMAIN, hashtable2);
                    if (hashtable != null) {
                        objectName3 = new ObjectName(DOMAIN, hashtable);
                    }
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug(tc, malformedObjectNameException.toString());
                }
            }
            if (objectName2 != null) {
                try {
                    objectNameArray = this._proxy.queryConfigObjects(this._client.getCurrentSession(), objectName3, objectName2, null);
                }
                catch (ConfigServiceException configServiceException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, configServiceException.toString());
                    }
                }
                catch (ConnectorException connectorException) {
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, connectorException.toString());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectNameListForType - " + objectNameArray);
        }
        return objectNameArray;
    }

    protected String getConfigPath(ObjectName objectName) {
        int n;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigPath - " + objectName);
        }
        String string2 = null;
        if (objectName != null && (string = objectName.getKeyProperty("_Websphere_Config_Data_Id")) != null && (n = string.lastIndexOf("#")) > 0) {
            string2 = string.substring(0, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigPath - " + string2);
        }
        return string2;
    }

    private int checkFIPS(ObjectName objectName) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkFIPS - " + objectName);
        }
        int n = 0;
        AttributeList attributeList = this.getAttributeListFromON(objectName);
        if (attributeList != null) {
            ArrayList arrayList;
            block12: {
                arrayList = null;
                try {
                    arrayList = (ArrayList)ConfigServiceHelper.getAttributeValue(attributeList, "properties");
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, attributeNotFoundException.toString());
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "arList: " + arrayList);
            }
            if (arrayList != null) {
                SecurityTSHelper securityTSHelper = (SecurityTSHelper)this.getTSHelper("Security");
                for (int i = 0; i < arrayList.size(); ++i) {
                    AttributeList attributeList2 = null;
                    Object e = arrayList.get(i);
                    if (e instanceof ObjectName) {
                        AttributeList attributeList3 = this.getAttributeListFromON((ObjectName)e);
                        if (attributeList3 != null) {
                            attributeList2 = attributeList3;
                        }
                    } else if (e instanceof AttributeList) {
                        attributeList2 = (AttributeList)e;
                    }
                    if ((n = securityTSHelper.checkFIPSProperty(attributeList2)) != 0) break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkFIPS - " + n);
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

