/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

class DHPublicKey
implements PublicKey,
javax.crypto.interfaces.DHPublicKey,
Serializable {
    static final long serialVersionUID = 2607870640963059136L;
    private BigInteger y;
    private byte[] key;
    private byte[] encodedKey;
    private BigInteger p;
    private BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.y = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(DHPublicKey.a("}\f\u00106>JM\u000e*>Z\u0018\u001d=q\u007f>0v`\u001e\b\u0010;>Z\u0004\u0010?"));
        }
    }

    public DHPublicKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException(DHPublicKey.a("w\u0003\b9=W\t^34GM\u00187#S\f\n"));
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new InvalidKeyException(DHPublicKey.a("\u007f\u0001\u0019\u00115\u001e\u0004\rx?Q\u0019^9qm(/\r\u0014p.;"));
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException(DHPublicKey.a("n\f\f9<[\u0019\u001b*\"\u001e\u0000\u0017+\"W\u0003\u0019"));
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new InvalidKeyException(DHPublicKey.a("p\u0018\u00124qN\f\f9<[\u0019\u001b*\""));
            }
            if (derValue3.getTag() != 48) {
                throw new InvalidKeyException(DHPublicKey.a("n\f\f9<[\u0019\u001b*\"\u001e\u0003\u0011,q_M-\u001d\u0000k(0\u001b\u0014"));
            }
            derValue3.getData().reset();
            this.p = derValue3.getData().getInteger();
            this.g = derValue3.getData().getInteger();
            if (derValue3.getData().available() != 0) {
                this.l = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new InvalidKeyException(DHPublicKey.a("{\u0015\n*0\u001e\u001d\u001f*0S\b\n=#\u001e\t\u001f,0"));
            }
            this.key = derValue.getData().getBitString();
            this.a();
            if (derValue.getData().available() != 0) {
                throw new InvalidKeyException(DHPublicKey.a("{\u0015\u001d=\"MM\u0015=(\u001e\t\u001f,0"));
            }
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException(DHPublicKey.a("n\u001f\u0017.0J\bS.0R\u0018\u001bx=[\u0003\u0019,9\u001e\u0019\u00117q\\\u0004\u0019"));
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public String getFormat() {
        return DHPublicKey.a("fCKhh");
    }

    public String getAlgorithm() {
        return DHPublicKey.a("z%");
    }

    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putInteger(this.p);
                derOutputStream2.putInteger(this.g);
                if (this.l != 0) {
                    derOutputStream2.putInteger(BigInteger.valueOf(this.l));
                }
                DerValue derValue = new DerValue(48, derOutputStream2.toByteArray());
                derOutputStream.putDerValue(derValue);
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream);
                derOutputStream3.putBitString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream3);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public BigInteger getY() {
        return this.y;
    }

    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(DHPublicKey.a("w/3\u0012\u0012{M:17X\u0004\u001bu\u0019[\u0001\u001250PM.-3R\u0004\u001dx\u001a[\u0014DR(\u0004g") + this.y.toString() + "\n" + DHPublicKey.a("NWt") + this.p.toString() + "\n" + DHPublicKey.a("YWt") + this.g.toString());
        if (this.l != 0) {
            stringBuffer.append(DHPublicKey.a("4\u0001DRq\u001eM^") + this.l);
        }
        return stringBuffer.toString();
    }

    private void a() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public int hashCode() {
        int n2 = 0;
        byte[] byArray = this.getEncoded();
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            n2 += byArray[i2] * i2;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PublicKey)) {
            return false;
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = ((PublicKey)object).getEncoded();
        return Arrays.equals(byArray, byArray2);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 62;
                        break;
                    }
                    case 1: {
                        n5 = 109;
                        break;
                    }
                    case 2: {
                        n5 = 126;
                        break;
                    }
                    case 3: {
                        n5 = 88;
                        break;
                    }
                    default: {
                        n5 = 81;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

