/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.j;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signer;
import java.util.Enumeration;
import java.util.Hashtable;

public class IdentityDatabase
extends IdentityScope
implements Serializable {
    private static final long serialVersionUID = 4923799573357658384L;
    private static final boolean debug = false;
    private static final boolean error = true;
    File sourceFile;
    Hashtable identities = new Hashtable();

    IdentityDatabase() throws InvalidParameterException {
        this(IdentityDatabase.d("_Y\u000e=\u001a_U\u0013.[\u0003\u0012"));
    }

    public IdentityDatabase(File file) throws InvalidParameterException {
        this(file.getName());
        this.sourceFile = file;
    }

    public IdentityDatabase(String string) throws InvalidParameterException {
        super(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IdentityDatabase fromStream(InputStream inputStream) throws IOException {
        IdentityDatabase identityDatabase = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            if (object instanceof IdentityDatabase) {
                identityDatabase = (IdentityDatabase)object;
            } else {
                Enumeration enumeration = ((sun.security.provider.IdentityDatabase)object).identities();
                identityDatabase = new IdentityDatabase();
                while (enumeration.hasMoreElements()) {
                    try {
                        identityDatabase.addIdentity((Identity)enumeration.nextElement());
                    }
                    catch (KeyManagementException keyManagementException) {
                        throw new IOException(keyManagementException.getMessage());
                    }
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            IdentityDatabase.a(IdentityDatabase.d("yT\u0014:U^T\u0012<\u0019I\u001c\u0013&\u0001\r^\u0018i\u001dLL\r,\u001bDR\u001ag"), classNotFoundException);
            IdentityDatabase.b(IdentityDatabase.d("yT\u0018i\u0003HN\u000e \u001aC\u001c\u0012/UYT\u0018i\u0011LH\u001c+\u0014^Y] \u0006\rS\u001f:\u001aAY\t,[\r\u007f\u001c'\u001bBH] \u001bDH\u0014(\u0019DF\u0018g"));
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.a(IdentityDatabase.d("yT\u0014:U^T\u0012<\u0019I\u001c\u0013&\u0001\r^\u0018i\u001dLL\r,\u001bDR\u001ag"), invalidClassException);
            IdentityDatabase.b(IdentityDatabase.d("xR\u001c+\u0019H\u001c\t&UDR\u0014=\u001cLP\u00143\u0010\rO\u0004:\u0001HQ] \u0011HR\t \u0001T\u001c\u000e*\u001a]YGiUdR\u000b(\u0019DX>%\u0014^O81\u0016HL\t \u001aC\u0012]C!EU\u000ei\u001c^\u001c\u0010&\u0006Y\u001c\u0011 \u001eHP\u0004i\u0011XY]=\u001a\r]]:\u0010_U\u001c%\u001cW]\t \u001aC\u001c\u000b,\u0007^U\u0012'\u001cC[]9\u0007B^\u0011,\u0018\u0017\u001c\u001ci\u0016A]\u000e:UXO\u0018-UDR]\"\u0010T\u001c\u0010(\u001bL[\u0018$\u0010CH]>\u0014^\u001c\u0012+\u0006BP\u0018=\u0010I"));
        }
        catch (StreamCorruptedException streamCorruptedException) {
            IdentityDatabase.a(IdentityDatabase.d("yT\u0018i\u0006HN\u0014(\u0019DF\u001c=\u001cBR]:\u0001_Y\u001c$UDO]*\u001a_N\b9\u0001HXSi C]\u001f%\u0010\rH\u0012i\u0019B]\u0019g"), streamCorruptedException);
            IdentityDatabase.b(IdentityDatabase.d("xR\u001c+\u0019H\u001c\t&UDR\u0014=\u001cLP\u00143\u0010\rO\u0004:\u0001HQ] \u0011HR\t \u0001T\u001c\u000e*\u001a]YSi&YN\u0018(\u0018nS\u000f;\u0005XH\u0018-0U_\u00189\u0001DS\u0013g"));
        }
        if (identityDatabase != null) return identityDatabase;
        return new IdentityDatabase(IdentityDatabase.d("XR\u0014'\u001cYU\u001c%\u001cWY\u0019"));
    }

    public static IdentityDatabase fromFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        IdentityDatabase identityDatabase = IdentityDatabase.fromStream(fileInputStream);
        identityDatabase.sourceFile = file;
        return identityDatabase;
    }

    public int size() {
        return this.identities.size();
    }

    public Identity getIdentity(String string) {
        Identity identity = (Identity)this.identities.get(string);
        if (identity instanceof Signer) {
            this.c(IdentityDatabase.d("JY\tg\u0006D[\u0013,\u0007"));
        }
        return identity;
    }

    public Identity getIdentity(PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        Enumeration enumeration = this.identities();
        while (enumeration.hasMoreElements()) {
            Identity identity = (Identity)enumeration.nextElement();
            PublicKey publicKey2 = identity.getPublicKey();
            if (publicKey2 == null || !this.a(publicKey2, publicKey)) continue;
            if (identity instanceof Signer) {
                this.c(IdentityDatabase.d("JY\tg\u0006D[\u0013,\u0007"));
            }
            return identity;
        }
        return null;
    }

    private boolean a(Key key, Key key2) {
        if (key == key2) {
            return true;
        }
        return MessageDigest.isEqual(key.getEncoded(), key2.getEncoded());
    }

    public void addIdentity(Identity identity) throws KeyManagementException {
        this.c(IdentityDatabase.d("LX\u0019g\u001cIY\u0013=\u001cYE"));
        Identity identity2 = this.getIdentity(identity.getName());
        Identity identity3 = this.getIdentity(identity.getPublicKey());
        String string = null;
        if (identity2 != null) {
            string = IdentityDatabase.d("C]\u0010,UNS\u0013/\u0019D_\t");
        }
        if (identity3 != null) {
            string = IdentityDatabase.d("FY\u0004i\u0016BR\u001b%\u001cNH");
        }
        if (string != null) {
            throw new KeyManagementException(string);
        }
        this.identities.put(identity.getName(), identity);
    }

    public void removeIdentity(Identity identity) throws KeyManagementException {
        this.c(IdentityDatabase.d("_Y\u0010&\u0003H\u0012\u0014-\u0010CH\u0014=\f"));
        String string = identity.getName();
        if (this.identities.get(string) == null) {
            throw new KeyManagementException(IdentityDatabase.d("YT\u0018;\u0010\rU\u000ei\u001bB\u001c\u0014-\u0010CH\u0014=\f\rR\u001c$\u0010I\u001c") + string + IdentityDatabase.d("\rU\u0013i") + this);
        }
        this.identities.remove(string);
    }

    public Enumeration identities() {
        return this.identities.elements();
    }

    void a(File file) {
        this.sourceFile = file;
    }

    File a() {
        return this.sourceFile;
    }

    public void save(OutputStream outputStream) throws IOException {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.a(IdentityDatabase.d("yT\u0014:U^T\u0012<\u0019I\u001c\u0013&\u0001\r^\u0018i\u001dLL\r,\u001bDR\u001ag"), invalidClassException);
            return;
        }
    }

    void b(File file) throws IOException {
        this.a(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.save(fileOutputStream);
    }

    public void save() throws IOException {
        if (this.sourceFile == null) {
            throw new IOException(IdentityDatabase.d("YT\u0014:UI]\t(\u0017LO\u0018i\u001dLO]'\u001a\rO\u0012<\u0007NY]/\u001cAY"));
        }
        this.b(this.sourceFile);
    }

    private static File b() {
        String string = Security.getProperty(IdentityDatabase.d("DX\u0018'\u0001DH\u0004g\u0011LH\u001c+\u0014^Y"));
        if (string == null) {
            string = System.getProperty(IdentityDatabase.d("XO\u0018;[ES\u0010,")) + File.separatorChar + IdentityDatabase.d("DX\u0018'\u0001DH\u0004-\u0017\u0003S\u001f#");
        }
        return new File(string);
    }

    private static void c() {
        File file = IdentityDatabase.b();
        try {
            IdentityDatabase identityDatabase;
            if (file.exists()) {
                IdentityDatabase.a(IdentityDatabase.d("AS\u001c-\u001cC[]:\f^H\u0018$UI]\t(\u0017LO\u0018i\u0013_S\u0010i\u0013DP\u0018sU") + file);
                identityDatabase = IdentityDatabase.fromFile(file);
            } else {
                identityDatabase = new IdentityDatabase(file);
            }
            IdentityScope.setSystemScope(identityDatabase);
            IdentityDatabase.a(IdentityDatabase.d("~E\u000e=\u0010@\u001c\u0019(\u0001L^\u001c:\u0010\rU\u0013 \u0001D]\u0011 \u000fHXGi") + identityDatabase);
        }
        catch (IOException iOException) {
            IdentityDatabase.a(IdentityDatabase.d("hN\u000f&\u0007\rU\u0013 \u0001D]\u0011 \u000fDR\u001ai\u001cIY\u0013=\u001cYE]-\u0014Y]\u001f(\u0006H\u0006]") + file, iOException);
            return;
        }
        catch (InvalidParameterException invalidParameterException) {
            IdentityDatabase.a(IdentityDatabase.d("hN\u000f&\u0007\rH\u000f0\u001cC[]=\u001a\rU\u0013:\u0001LR\t \u0014YY](U^E\u000e=\u0010@\u001c\u0014-\u0010CH\u0014=\u001cHO]-\u0017\rU\u0013i") + file, invalidParameterException);
            return;
        }
    }

    public String toString() {
        return IdentityDatabase.d("NS\u0010g\u001cOQS*\u0007TL\t&[]N\u0012?\u001cIY\u000fg<IY\u0013=\u001cYE9(\u0001L^\u001c:\u0010\u0001\u001c\u000e&\u0000__\u0018i\u0013DP\u0018sU") + this.sourceFile;
    }

    private static void a(String string) {
    }

    private static void a(String string, Throwable throwable) {
    }

    private static void b(String string) {
        System.err.println(string);
    }

    void c(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            string = this.getClass().getName() + "." + string + "." + this.d();
            securityManager.checkSecurityAccess(string);
        }
    }

    String d() {
        String string = this.getName();
        if (this.getScope() != null) {
            string = string + "." + this.getScope().getName();
        }
        return string;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.c(IdentityDatabase.d("^Y\u000f \u0014AU\u0007,[DX\u0018'\u0001DH\u0004g\u0011LH\u001c+\u0014^Y"));
        objectOutputStream.writeObject(this.identities);
        objectOutputStream.writeObject(this.sourceFile);
    }

    static void e() {
        IdentityDatabase.c();
    }

    static {
        AccessController.doPrivileged(new j());
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String d(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 45;
                        break;
                    }
                    case 1: {
                        n5 = 60;
                        break;
                    }
                    case 2: {
                        n5 = 125;
                        break;
                    }
                    case 3: {
                        n5 = 73;
                        break;
                    }
                    default: {
                        n5 = 117;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

