/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;

final class RSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateKey,
Serializable {
    static final long serialVersionUID = -5387735831354112582L;
    private BigInteger modulus;
    private BigInteger privateExponent;

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.modulus = bigInteger;
        this.privateExponent = bigInteger2;
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(RSAPrivateKey.a("\u0018\u0013\f'@[\u0012\u0016?\u0004?9+kA\u0015\u001f\u0016/AA\\") + iOException.getMessage());
        }
    }

    public RSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public String toString() {
        return RSAPrivateKey.a("2>4\u0001g>\\+\u0018e[,\u000b\"R\u001a\b\u001cko\u001e\u0005CAI\u0014\u0018\f'Q\bFs") + this.modulus.toString() + "\n" + RSAPrivateKey.a("\u000b\u000e\u0010=E\u000f\u0019Y.\\\u000b\u0013\u0017.J\u000fFs") + this.privateExponent.toString() + "\n";
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            this.modulus = derValue.getData().getInteger();
            this.privateExponent = derValue.getData().getInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(RSAPrivateKey.a("2\u0012\u000f*H\u0012\u0018Y\u0019w:,\u000b\"R\u001a\b\u001c\u0000A\u0002\\\u001c%G\u0014\u0018\u0010%CW\\\u001d*P\u001a\\\u0016=A\t\u000e\f%"));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 123;
                        break;
                    }
                    case 1: {
                        n5 = 124;
                        break;
                    }
                    case 2: {
                        n5 = 121;
                        break;
                    }
                    case 3: {
                        n5 = 75;
                        break;
                    }
                    default: {
                        n5 = 36;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

