/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;

final class RSAPublicKey
extends X509Key
implements java.security.interfaces.RSAPublicKey,
Serializable {
    static final long serialVersionUID = -6195576206650062694L;
    private BigInteger modulus;
    private BigInteger publicExponent;

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(RSAPublicKey.a("\ny\u0016\n\u001fIx\f\u0012[-S1F\u001e\u0007u\f\u0002\u001eS6") + iOException.getMessage());
        }
    }

    public RSAPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public String toString() {
        return RSAPublicKey.a(" T.,8,615:IF\u0016\u0004\u0017\u0000uC-\u001e\u0010,i\u000b\u0014\rc\u000f\u0013\bS\u001c") + this.modulus.toString() + "\n" + RSAPublicKey.a("\u0019c\u0001\n\u0012\n6\u0006\u001e\u000b\u0006x\u0006\b\u000fS\u001c") + this.publicExponent.toString() + "\n";
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            this.modulus = derValueArray[0].getInteger();
            this.publicExponent = derValueArray[1].getInteger();
        }
        catch (Exception exception) {
            throw new InvalidKeyException(RSAPublicKey.a(" x\u0015\u0007\u0017\u0000rC\r\u001e\u00106\u0015\u0007\u0017\u001csCl") + exception.getMessage());
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 105;
                        break;
                    }
                    case 1: {
                        n5 = 22;
                        break;
                    }
                    case 2: {
                        n5 = 99;
                        break;
                    }
                    case 3: {
                        n5 = 102;
                        break;
                    }
                    default: {
                        n5 = 123;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

