/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.soap.soapenabler;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.soap.soapenabler.ServiceDescriptor;
import com.ibm.soap.soapenabler.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.soap.server.DeploymentDescriptor;

public class SoapModuleDescriptor {
    private List serviceList = new Vector();
    private String templateWARUri = null;
    private String targetWARUri = null;
    private String contextRoot = null;
    private String charEnc = "ISO-8859-1";
    private static NLS myNLS = new NLS("com.ibm.soap.soapenabler.properties.SoapEnabler");

    public void setServices(List list) {
        this.serviceList = list;
    }

    public List getServices() {
        return this.serviceList;
    }

    public void setTemplateWARUri(String string) {
        this.templateWARUri = string;
    }

    public String getTemplateWARUri() {
        return this.templateWARUri;
    }

    public void setTargetWARUri(String string) {
        this.targetWARUri = string;
    }

    public String getTargetWARUri() {
        return this.targetWARUri;
    }

    public void setContextRoot(String string) {
        this.contextRoot = string;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public String getClassPath() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.serviceList.iterator();
        while (iterator.hasNext()) {
            ServiceDescriptor serviceDescriptor = (ServiceDescriptor)iterator.next();
            hashSet.addAll(serviceDescriptor.getClassPathEntries());
        }
        return Utils.getSpaceSeparatedString(hashSet);
    }

    public File getDDSFile() throws IllegalArgumentException, IOException {
        File file = File.createTempFile("dds", ".xml");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.charEnc);
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.println("<root>");
        Iterator iterator = this.serviceList.iterator();
        while (iterator.hasNext()) {
            ServiceDescriptor serviceDescriptor = (ServiceDescriptor)iterator.next();
            DeploymentDescriptor deploymentDescriptor = serviceDescriptor.getDeploymentDescriptor();
            if (deploymentDescriptor == null) {
                throw new IllegalArgumentException("ERROR: Every ServiceDescriptor must have a DeploymentDescriptor specified.");
            }
            deploymentDescriptor.toXML(printWriter);
        }
        printWriter.println("</root>");
        printWriter.flush();
        fileOutputStream.close();
        file.deleteOnExit();
        return file;
    }
}

