/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.soap.soapenabler;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.etools.application.Application;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.archive.ArchiveManifest;
import com.ibm.etools.archive.LoadStrategy;
import com.ibm.etools.archive.exception.ArchiveException;
import com.ibm.etools.archive.exception.OpenFailureException;
import com.ibm.etools.archive.exception.ReopenException;
import com.ibm.etools.archive.exception.SaveFailureException;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.ReadOnlyDirectory;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.soap.soapenabler.SoapModuleDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class Utils {
    public static boolean verbose = true;
    public static boolean askInstallAdmin = true;
    private static NLS myNLS = new NLS("com.ibm.soap.soapenabler.properties.SoapEnabler");

    public static void addJarEntry(JarEntry jarEntry, String string, byte[] byArray, JarOutputStream jarOutputStream) throws IOException {
        JarEntry jarEntry2 = null;
        jarEntry2 = jarEntry != null ? new JarEntry(jarEntry) : new JarEntry(string);
        jarOutputStream.putNextEntry(jarEntry2);
        if (byArray != null) {
            jarOutputStream.write(byArray);
        }
        jarOutputStream.closeEntry();
    }

    public static void copyJarInto(File file, JarOutputStream jarOutputStream, List list) throws IOException {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            byte[] byArray = null;
            if (list != null && list.contains(jarEntry.getName())) continue;
            if (!jarEntry.isDirectory()) {
                byArray = Utils.getBytesFromJarEntry(jarFile, jarEntry);
            }
            Utils.addJarEntry(jarEntry, null, byArray, jarOutputStream);
        }
        jarFile.close();
    }

    public static byte[] getBytesFromJarEntry(JarFile jarFile, JarEntry jarEntry) throws IOException {
        InputStream inputStream = jarFile.getInputStream(jarEntry);
        byte[] byArray = new byte[(int)jarEntry.getSize()];
        Utils.fillWithBytesFromInputStream(byArray, inputStream);
        return byArray;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        byte[] byArray = null;
        if (file != null) {
            FileInputStream fileInputStream = new FileInputStream(file);
            byArray = new byte[(int)file.length()];
            Utils.fillWithBytesFromInputStream(byArray, fileInputStream);
            fileInputStream.close();
        }
        return byArray;
    }

    public static void fillWithBytesFromInputStream(byte[] byArray, InputStream inputStream) throws IOException {
        for (int i = 0; i < byArray.length; i += inputStream.read(byArray, i, byArray.length - i)) {
        }
        inputStream.close();
    }

    public static File getFileFromName(String string) throws IOException {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            file = null;
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
            if (inputStream != null) {
                int n;
                File file2 = File.createTempFile(string, null);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                while ((n = inputStream.read()) != -1) {
                    fileOutputStream.write(n);
                }
                fileOutputStream.close();
                inputStream.close();
                file = file2;
            }
        }
        return file;
    }

    public static String getStringInput(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = null;
        while (string2 == null || string2.equals("")) {
            System.out.print(string);
            string2 = bufferedReader.readLine();
        }
        return string2;
    }

    public static int getIntegerInput(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = null;
        int n = -1;
        while (n < 0) {
            try {
                System.out.print(string);
                string2 = bufferedReader.readLine();
                if (string2 == null) continue;
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(myNLS.getString("com.ibm.soap.soapenabler.pleaseentervalidinteger", "Please enter a valid integer."));
            }
        }
        return n;
    }

    public static boolean getBooleanInput(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = null;
        Boolean bl = null;
        while (bl == null) {
            System.out.print(string);
            string2 = bufferedReader.readLine();
            if (string2 == null || string2.length() <= 0) continue;
            String string3 = string2.substring(0, 1);
            if (string3.equalsIgnoreCase("y")) {
                bl = new Boolean(true);
                continue;
            }
            if (string3.equalsIgnoreCase("n")) {
                bl = new Boolean(false);
                continue;
            }
            Object[] objectArray = new String[]{"y", "n"};
            System.err.println(myNLS.getFormattedMessage("com.ibm.soap.soapenabler.pleaseenter", objectArray, "Please enter {0} or {1}."));
        }
        return bl;
    }

    public static File getReadFileInput(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = null;
        File file = null;
        while (file == null) {
            System.out.print(string);
            string2 = bufferedReader.readLine();
            if (string2 == null || (file = new File(string2)).exists() && file.isFile()) continue;
            System.err.println(myNLS.getString("com.ibm.soap.soapenabler.enterexistingfile", "Please enter the name of an existing file."));
            file = null;
        }
        return file;
    }

    public static int getListChoiceInput(BufferedReader bufferedReader, String string, List list) throws IOException {
        String string2 = " (";
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)list.get(i);
            string2 = string2 + (i > 0 ? ", " : "") + "[" + (i + 1) + "] " + string3;
        }
        string = string + string2 + "): ";
        String string4 = null;
        int n2 = -1;
        while (n2 < 1 || n2 > n) {
            System.out.print(string);
            string4 = bufferedReader.readLine();
            if (string4 == null) continue;
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 >= 1 && n2 <= n) continue;
            Object[] objectArray = new String[]{"" + n};
            System.err.println(myNLS.getFormattedMessage("com.ibm.soap.soapenabler.entervalidint", objectArray, "Please enter a valid integer between 1 and {0}."));
        }
        return n2 - 1;
    }

    public static String getSpaceSeparatedString(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        if (collection != null) {
            String[] stringArray = collection.toArray(new String[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append((i > 0 ? " " : "") + stringArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    public static void addModule(SoapModuleDescriptor soapModuleDescriptor, CommonarchiveFactory commonarchiveFactory, Application application, EARFile eARFile) throws IOException, ArchiveException, OpenFailureException, SaveFailureException, ReopenException {
        String string = soapModuleDescriptor.getTemplateWARUri();
        String string2 = soapModuleDescriptor.getTargetWARUri();
        String string3 = soapModuleDescriptor.getContextRoot();
        File file = Utils.getFileFromName(string);
        if (file == null) {
            Object[] objectArray = new String[]{string};
            throw new IOException(myNLS.getFormattedMessage("com.ibm.soap.soapenabler.cantfind", objectArray, "ERROR: Cannot find file {0}.  Either specify an accurate path for the SoapModuleDescriptor's templateWARUri, or ensure that the directory containing this file is on your classpath."));
        }
        LoadStrategy loadStrategy = commonarchiveFactory.createLoadStrategy(file.getPath());
        WARFile wARFile = commonarchiveFactory.openWARFile(loadStrategy, string2);
        ArchiveManifest archiveManifest = wARFile.getManifest();
        archiveManifest.setManifestVersion("1.0");
        archiveManifest.setClassPath(soapModuleDescriptor.getClassPath());
        File file2 = soapModuleDescriptor.getDDSFile();
        File file3 = file2.getParentFile();
        ReadOnlyDirectory readOnlyDirectory = commonarchiveFactory.openReadOnlyDirectory(file3.getPath());
        com.ibm.etools.commonarchive.File file4 = readOnlyDirectory.getFile(file2.getName());
        file4.setURI("dds.xml");
        if (wARFile.containsFile("dds.xml")) {
            wARFile.remove(wARFile.getFile("dds.xml"));
        }
        wARFile.addCopy(file4);
        if (askInstallAdmin) {
            Utils.checkAndInstallAdmin(wARFile, commonarchiveFactory);
        }
        eARFile.addCopy((ModuleFile)wARFile);
        WebModule webModule = (WebModule)application.getModule(string2);
        webModule.setContextRoot(string3);
    }

    private static void checkAndInstallAdmin(WARFile wARFile, CommonarchiveFactory commonarchiveFactory) throws IOException, ArchiveException {
        Object[] objectArray;
        String string;
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        System.out.print("\n");
        System.out.println(myNLS.getString("com.ibm.soap.soapenabler.installadmin", "Do you wish to install the administration client?"));
        System.out.println(myNLS.getString("com.ibm.soap.soapenabler.installadminwarning", "Warning, you should not install this client in a production ear unless you intend to secure the URI to it."));
        System.out.print("\n");
        while (!(string = Utils.getStringInput(bufferedReader, myNLS.getFormattedMessage("com.ibm.soap.soapenabler.promptclinetinstall", objectArray = new String[]{"y", "n"}, "Install the administration client; ({0} = yes / {1} = no)?"))).equalsIgnoreCase("y") && !string.equalsIgnoreCase("n")) {
        }
        if (string.equalsIgnoreCase("y")) {
            objectArray = new String[]{"toc.jsp", "list.jsp", "start.jsp", "stop.jsp", "showdetails.jsp", "header.html", "index.html", "soapadmin.gif", "blankpage.html"};
            int n = 9;
            for (int i = 0; i < n; ++i) {
                File file = Utils.getFileFromName((String)objectArray[i]);
                File file2 = file.getParentFile();
                ReadOnlyDirectory readOnlyDirectory = commonarchiveFactory.openReadOnlyDirectory(file2.getPath());
                com.ibm.etools.commonarchive.File file3 = readOnlyDirectory.getFile(file.getName());
                file3.setURI("admin/" + (String)objectArray[i]);
                wARFile.addCopy(file3);
            }
        }
    }

    public static void backupEar(String string) throws IOException {
        int n;
        Object[] objectArray = new String[]{string};
        System.out.print("\n");
        System.out.println("*** " + myNLS.getFormattedMessage("com.ibm.soap.soapenabler.utils.backingupear", objectArray, "Backing up EAR file to: {0}~"));
        System.out.print("\n");
        File file = new File(string);
        File file2 = new File(file.getAbsolutePath() + "~");
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        byte[] byArray = new byte[1024];
        while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.close();
        bufferedInputStream.close();
    }
}

