/*
 * Decompiled with CFR 0.152.
 */
package jaxp;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;
import sax.latin.LatinSAX2Parser;
import sax.latin.LatinWFCSAX2DocumentEntityParser;
import sax.latin.LatinWFCSAX2Parser;
import sax.utf16.UTF16WFCSAX2DocumentEntityParser;
import sax.utf16.UTF16WFCSAX2Parser;

public class SAXParserImpl
extends SAXParser {
    private XMLReader xmlReader;
    private Parser parser;
    private boolean validating;
    private boolean namespaceAware;

    SAXParserImpl(SAXParserFactory sAXParserFactory, Hashtable hashtable) throws SAXException {
        String string = System.getProperty("b2bxml.jaxp.SAXParser", "LatinWFCSAX2DocumentEntityParser");
        this.xmlReader = string.equals("LatinWFCSAX2DocumentEntityParser") ? new LatinWFCSAX2DocumentEntityParser() : (string.equals("LatinWFCSAX2Parser") ? new LatinWFCSAX2Parser() : (string.equals("UTF16WFCSAX2DocumentEntityParser") ? new UTF16WFCSAX2DocumentEntityParser() : (string.equals("UTF16WFCSAX2Parser") ? new UTF16WFCSAX2Parser() : (string.equals("LatinSAX2Parser") ? new LatinSAX2Parser() : new LatinWFCSAX2DocumentEntityParser()))));
        this.namespaceAware = sAXParserFactory.isNamespaceAware();
        String string2 = "http://xml.org/sax/features/namespaces";
        this.xmlReader.setFeature(string2, this.namespaceAware);
        this.setFeatures(hashtable);
    }

    private void setFeatures(Hashtable hashtable) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl = (Boolean)hashtable.get(string);
                this.xmlReader.setFeature(string, bl);
            }
        }
    }

    public Parser getParser() throws SAXException {
        if (this.parser == null) {
            this.parser = new XMLReaderAdapter(this.xmlReader);
            this.parser.setDocumentHandler(new HandlerBase());
        }
        return this.parser;
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.xmlReader.setProperty(string, object);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xmlReader.getProperty(string);
    }
}

