/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.cache;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.agent.cache.NI1750AgentCache;
import com.ibm.storage.ess.ni.agent.cache.NI2107AgentCache;
import com.ibm.storage.ess.ni.agent.cache.NIAgentCacheUpdateThread;
import com.ibm.storage.ess.ni.agent.cache.NIAgentState;
import com.ibm.storage.ess.ni.agent.cache.NIDefaultAgentCache;
import com.ibm.storage.ess.ni.agent.sfiserver.lssinfo.NIPAIoctlLssInfo;
import com.ibm.storage.ess.ni.commandagent.NICommandAgent;
import com.ibm.storage.ess.ni.commandagent.common.NILssInfo;
import com.ibm.storage.ess.ni.commandagent.common.NIOwnership;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;

public abstract class NIAgentCache
implements NIOwnership {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$cache$NIAgentCache == null ? (class$com$ibm$storage$ess$ni$agent$cache$NIAgentCache = NIAgentCache.class$("com.ibm.storage.ess.ni.agent.cache.NIAgentCache")) : class$com$ibm$storage$ess$ni$agent$cache$NIAgentCache);
    public static final int SERVER_0 = 0;
    public static final int SERVER_1 = 1;
    public static final int TYPE_CKD = 0;
    public static final int TYPE_FB = 1;
    public static final int UNDEFINED_LSS = -1;
    private static final long UPDATE_TIMEOUT = 15000L;
    private static final NIAgentCacheUpdateThread updateThread = new NIAgentCacheUpdateThread();
    public static final NIAgentCache CACHE;
    protected String mtms;
    protected int serverNum;
    protected boolean leader;
    protected long wwnn;
    protected NILssInfo lssInfo = new NIPAIoctlLssInfo(new byte[]{0});
    protected NIAgentState state = new NIAgentState();
    private boolean updateTimedOut = false;
    private NICommandAgent commandAgent = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$cache$NIAgentCache;

    protected NIAgentCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update() {
        this.state.setState(3);
        this.updateImpl();
        NIAgentState nIAgentState = this.state;
        synchronized (nIAgentState) {
            this.state.setState(1);
            this.updateTimedOut = false;
            this.state.notifyAll();
        }
    }

    protected abstract void updateImpl();

    private static NIAgentCache constructCacheObject() {
        NIAgentCache nIAgentCache = null;
        int n = NIAgentProperties.getAgentType();
        switch (n) {
            case 2: {
                nIAgentCache = new NI2107AgentCache();
                break;
            }
            case 4: {
                nIAgentCache = new NI1750AgentCache();
                break;
            }
            default: {
                nIAgentCache = new NIDefaultAgentCache();
            }
        }
        nIAgentCache.scheduleUpdate();
        logger.debug_general("agent cache type: " + nIAgentCache.getClass(), "NIAgentCache", "constructCacheObject", null);
        return nIAgentCache;
    }

    public boolean isLeaderNode() {
        return this.leader;
    }

    public boolean isLocallyOwned(int n) {
        return this.lssInfo.isOwnedBy(this.serverNum, n) || n % 2 == this.serverNum && !this.lssInfo.exists(n);
    }

    public boolean exists(int n) {
        return this.lssInfo.exists(n);
    }

    public String getMTMS() {
        return this.mtms;
    }

    public long getWWNN() {
        return this.wwnn;
    }

    public int getLSSType(int n) {
        return this.lssInfo.getLssType(n);
    }

    public int getOwningServerNumber(int n) {
        return this.lssInfo.getOwningServerNumber(n);
    }

    public boolean isOwnedBy(int n, int n2) {
        return this.lssInfo.isOwnedBy(n, n2);
    }

    public int getLssType(int n) {
        return this.lssInfo.getLssType(n);
    }

    public boolean isType(int n, int n2) {
        return this.lssInfo.isType(n, n2);
    }

    public boolean areVolumesDefined(int n) {
        return this.lssInfo.areVolumesDefined(n);
    }

    public int getFirstVolNum(int n) {
        return this.lssInfo.getFirstVolNum(n);
    }

    public int getLastVolNum(int n) {
        return this.lssInfo.getLastVolNum(n);
    }

    public int getServerNum() {
        return this.serverNum;
    }

    public abstract int getFirstLssNum();

    public void scheduleUpdate() {
        updateThread.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpdating() {
        boolean bl = false;
        NIAgentState nIAgentState = this.state;
        synchronized (nIAgentState) {
            boolean bl2 = bl = this.state.getState() == 3;
            if (bl && !this.updateTimedOut) {
                try {
                    long l = System.currentTimeMillis();
                    this.state.wait(15000L);
                    if (System.currentTimeMillis() - l > 15000L) {
                        this.updateTimedOut = bl;
                        logger.warning("Timed out waiting for update to complete.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    logger.warning("waiting for update was interrupted");
                    logger.throwable((Throwable)interruptedException);
                }
            }
        }
        return bl;
    }

    public void setCommandAgent(NICommandAgent nICommandAgent) {
        this.commandAgent = nICommandAgent;
    }

    public NICommandAgent getCommandAgent() {
        return this.commandAgent;
    }

    public boolean isStarting() {
        return this.state.getState() == 2;
    }

    public NIAgentState getState() {
        this.isUpdating();
        return (NIAgentState)this.state.clone();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        updateThread.start();
        CACHE = NIAgentCache.constructCacheObject();
    }
}

