/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.common.convert;

import com.ibm.rsct.util.CtArray;
import com.ibm.rsct.util.CtBinary;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtFloat32;
import com.ibm.rsct.util.CtInt32;
import com.ibm.rsct.util.CtInt32Array;
import com.ibm.rsct.util.CtInt64;
import com.ibm.rsct.util.CtString;
import com.ibm.rsct.util.CtStructuredData;
import com.ibm.rsct.util.CtUint64;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIArray;
import com.ibm.storage.ess.ni.application.resource.NIPortMask;
import com.ibm.storage.ess.ni.application.resource.NIRank;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model3;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model3TPF;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model6;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUTypeBS2000;
import com.ibm.storage.ess.ni.option.config.NIDataType;
import com.ibm.storage.ess.ni.option.config.NIDataType3380;
import com.ibm.storage.ess.ni.option.config.NIDataType3390;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock512;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Protected;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Unprotected;
import com.ibm.storage.ess.ni.option.config.NIDeviceType;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB;
import com.ibm.storage.ess.ni.option.config.NIESSState;
import com.ibm.storage.ess.ni.option.config.NIESSStateFenced;
import com.ibm.storage.ess.ni.option.config.NIESSStateForcedQuiescing;
import com.ibm.storage.ess.ni.option.config.NIESSStateOffline;
import com.ibm.storage.ess.ni.option.config.NIESSStateOnline;
import com.ibm.storage.ess.ni.option.config.NIESSStateQuiescing;
import com.ibm.storage.ess.ni.option.config.NIESSStateQuiescingException;
import com.ibm.storage.ess.ni.option.config.NIESSStateResuming;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.option.config.NIFabricTopology;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyFCArbitratedLoop;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyFicon;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyScsiFcp;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyScsiFcpFicon;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyUnknown;
import com.ibm.storage.ess.ni.option.config.NIRaidType;
import com.ibm.storage.ess.ni.option.config.NIRaidType10;
import com.ibm.storage.ess.ni.option.config.NIRaidType5;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlMode;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlModeIndetermined;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlModeLocal;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteHMCAuto;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteHMCManual;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteHMCScheduled;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteHMCScheduledAuto;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteS390PowerControl;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupType;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeCopyServices;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconAll;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconMixedMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520All;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520Map256;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520Mask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIAll;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMap256;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMixedMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeType;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDBase;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDCrossCUAlias;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDMap;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDSingleCuAlias;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeFixedBlockBase;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeFixedBlockMap;
import java.net.InetAddress;
import java.util.Arrays;

public class NItoMcConverter {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$common$convert$NIfromMcConverter == null ? (class$com$ibm$storage$ess$ni$agent$common$convert$NIfromMcConverter = NItoMcConverter.class$("com.ibm.storage.ess.ni.agent.common.convert.NIfromMcConverter")) : class$com$ibm$storage$ess$ni$agent$common$convert$NIfromMcConverter);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$common$convert$NIfromMcConverter;

    private NItoMcConverter() {
    }

    public static CtInt32 fromBoolean(boolean bl) {
        int n = 0;
        if (bl) {
            n = 1;
        }
        return new CtInt32(n);
    }

    public static CtString fromString(String string) {
        if (string != null) {
            return new CtString(string);
        }
        return new CtString("");
    }

    public static CtArray fromStringArray(String[] stringArray) {
        CtString[] ctStringArray = new CtString[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            ctStringArray[n] = new CtString(stringArray[n]);
            ++n;
        }
        return new CtArray(19, (CtDataType[])ctStringArray);
    }

    public static CtInt32 fromInt(int n) {
        return new CtInt32(n);
    }

    public static CtInt64 fromLong(long l) {
        return new CtInt64(l);
    }

    public static CtFloat32 fromFloat(float f) {
        return new CtFloat32(f);
    }

    public static CtString hexStringFromLong(long l, int n) {
        String string = Long.toHexString(l);
        int n2 = 0;
        while (string.length() < n) {
            string = "0" + string;
            ++n2;
        }
        return new CtString(string.toUpperCase());
    }

    public static CtBinary binaryFromLong(long l, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(l / (long)(8 ^ n2));
            ++n2;
        }
        return new CtBinary(byArray);
    }

    public static CtInt32 fromPercentage(float f) {
        return new CtInt32((int)(f * 100.0f));
    }

    public static CtArray fromStoragePlexIPAddressess(InetAddress[] inetAddressArray) {
        CtString[] ctStringArray = new CtString[inetAddressArray.length];
        int n = 0;
        while (n < inetAddressArray.length) {
            ctStringArray[n] = new CtString(inetAddressArray[n].getHostAddress());
            ++n;
        }
        return new CtArray(19, (CtDataType[])ctStringArray);
    }

    public static CtArray fromStoragePlexHostName(InetAddress[] inetAddressArray) {
        CtString[] ctStringArray = new CtString[inetAddressArray.length];
        int n = 0;
        while (n < inetAddressArray.length) {
            ctStringArray[n] = new CtString(inetAddressArray[n].getHostName());
            ++n;
        }
        return new CtArray(19, (CtDataType[])ctStringArray);
    }

    public static CtInt32 fromESSState(NIESSState nIESSState) throws NIServerException {
        int n = -1;
        if (nIESSState instanceof NIESSStateOnline) {
            n = 0;
        } else if (nIESSState instanceof NIESSStateOffline) {
            n = 1;
        } else if (nIESSState instanceof NIESSStateResuming) {
            n = 2;
        } else if (nIESSState instanceof NIESSStateQuiescing) {
            n = 3;
        } else if (nIESSState instanceof NIESSStateQuiescingException) {
            n = 4;
        } else if (nIESSState instanceof NIESSStateForcedQuiescing) {
            n = 5;
        } else if (nIESSState instanceof NIESSStateFenced) {
            n = 6;
        } else {
            n = 0;
            logger.error("Bad ESS state of " + nIESSState + ". Setting state to the default value of online");
        }
        return new CtInt32(n);
    }

    public static CtInt32 fromSfPowerMode(NISFPowerControlMode nISFPowerControlMode) {
        int n = -1;
        if (nISFPowerControlMode instanceof NISFPowerControlModeIndetermined) {
            n = -1;
        }
        if (nISFPowerControlMode instanceof NISFPowerControlModeLocal) {
            n = 0;
        } else if (nISFPowerControlMode instanceof NISFPowerControlModeRemoteHMCAuto) {
            n = 3;
        } else if (nISFPowerControlMode instanceof NISFPowerControlModeRemoteHMCManual) {
            n = 1;
        } else if (nISFPowerControlMode instanceof NISFPowerControlModeRemoteHMCScheduled) {
            n = 2;
        } else if (nISFPowerControlMode instanceof NISFPowerControlModeRemoteHMCScheduledAuto) {
            n = 4;
        } else if (nISFPowerControlMode instanceof NISFPowerControlModeRemoteS390PowerControl) {
            n = 5;
        }
        return new CtInt32(n);
    }

    public static CtString fromRaidType(NIRaidType nIRaidType) throws NIServerException {
        String string = null;
        if (nIRaidType instanceof NIRaidType5) {
            string = "RAID5";
        } else if (nIRaidType instanceof NIRaidType10) {
            string = "RAID10";
        } else {
            throw new NIServerException(2, "Bad raidType of " + nIRaidType);
        }
        return new CtString(string);
    }

    public static CtInt32Array arraySitesFromArray(NIArray nIArray) {
        int[] nArray = new int[nIArray.getArraySites().length];
        int n = 0;
        while (n < nIArray.getArraySites().length) {
            NIArraySiteID nIArraySiteID = nIArray.getArraySites()[n];
            nArray[n] = nIArraySiteID.getArraySiteNumber();
            ++n;
        }
        return new CtInt32Array(nArray);
    }

    public static CtString fromDeviceType(NIDeviceType nIDeviceType) throws NIServerException {
        String string = null;
        if (nIDeviceType instanceof NIDeviceTypeCKD) {
            string = "CKD";
        } else if (nIDeviceType instanceof NIDeviceTypeFB) {
            string = "FB";
        } else {
            throw new NIServerException(2, "Bad deviceType of " + nIDeviceType);
        }
        return new CtString(string);
    }

    public static CtUint64 fromRequestedCapacity(long l) {
        return new CtUint64(l);
    }

    public static CtInt32 fromVolumeType(NIVolumeType nIVolumeType) throws NIServerException {
        int n;
        if (nIVolumeType instanceof NIVolumeTypeCKDBase) {
            n = 10;
        } else if (nIVolumeType instanceof NIVolumeTypeCKDCrossCUAlias) {
            n = 12;
        } else if (nIVolumeType instanceof NIVolumeTypeCKDMap) {
            n = 13;
        } else if (nIVolumeType instanceof NIVolumeTypeCKDSingleCuAlias) {
            n = 11;
        } else if (nIVolumeType instanceof NIVolumeTypeFixedBlockBase) {
            n = 20;
        } else if (nIVolumeType instanceof NIVolumeTypeFixedBlockMap) {
            n = 21;
        } else {
            throw new NIServerException(2, "bad volumeType of " + nIVolumeType);
        }
        return new CtInt32(n);
    }

    public static CtInt32 fromCuBaseType(NICKDBaseCUType nICKDBaseCUType) throws NIServerException {
        int n;
        if (nICKDBaseCUType instanceof NICKDBaseCUType3990Model3) {
            n = 0;
        } else if (nICKDBaseCUType instanceof NICKDBaseCUType3990Model3TPF) {
            n = 1;
        } else if (nICKDBaseCUType instanceof NICKDBaseCUType3990Model6) {
            n = 2;
        } else if (nICKDBaseCUType instanceof NICKDBaseCUTypeBS2000) {
            n = 3;
        } else {
            throw new NIServerException(2, "bad CuBaseType of " + nICKDBaseCUType);
        }
        return new CtInt32(n);
    }

    public static CtInt32 fromDataType(NIDataType nIDataType) throws NIServerException {
        int n;
        if (nIDataType instanceof NIDataTypeBlock512) {
            n = 0;
        } else if (nIDataType instanceof NIDataTypeBlock520Protected) {
            n = 1;
        } else if (nIDataType instanceof NIDataTypeBlock520Unprotected) {
            n = 2;
        } else if (nIDataType instanceof NIDataType3380) {
            n = 10;
        } else if (nIDataType instanceof NIDataType3390) {
            n = 11;
        } else {
            throw new NIServerException(2, "bad dataType of " + nIDataType);
        }
        return new CtInt32(n);
    }

    public static CtString fromVolumeID(NIVolumeID nIVolumeID) throws NIServerException {
        StringBuffer stringBuffer = new StringBuffer();
        if (nIVolumeID.getLSS().getLSSNumber() < 16) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toHexString(nIVolumeID.getLSS().getLSSNumber()).toUpperCase());
        if (nIVolumeID.getVolNumber() < 16) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toHexString(nIVolumeID.getVolNumber()).toUpperCase());
        return new CtString(stringBuffer.toString().toUpperCase());
    }

    public static CtString fromLSSID(NILSSID nILSSID) throws NIServerException {
        StringBuffer stringBuffer = new StringBuffer();
        if (nILSSID.getLSSNumber() < 16) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toHexString(nILSSID.getLSSNumber()).toUpperCase());
        return new CtString(stringBuffer.toString().toUpperCase());
    }

    public static CtInt32Array arraysFromRank(NIRank nIRank) {
        NIArrayID[] nIArrayIDArray = nIRank.getArrayIDs();
        int[] nArray = new int[nIArrayIDArray.length];
        int n = 0;
        while (n < nIArrayIDArray.length) {
            nArray[n] = nIArrayIDArray[n].getArrayNumber();
            ++n;
        }
        return new CtInt32Array(nArray);
    }

    public static CtInt32 fromExtentType(NIExtentType nIExtentType) throws NIServerException {
        int n;
        if (nIExtentType instanceof NIExtentTypeCKD) {
            n = 132;
        } else if (nIExtentType instanceof NIExtentTypeFB) {
            n = 4;
        } else {
            throw new NIServerException(2, "bad extentType of " + nIExtentType);
        }
        return new CtInt32(n);
    }

    public static CtInt32 fromAttachingPortTopology(NIFabricTopology nIFabricTopology) throws NIServerException {
        int n = 0;
        if (nIFabricTopology instanceof NIFabricTopologyFCArbitratedLoop) {
            n = 2;
        } else if (nIFabricTopology instanceof NIFabricTopologyScsiFcp) {
            n = 1;
        } else if (nIFabricTopology instanceof NIFabricTopologyUnknown) {
            n = 0;
        } else {
            throw new NIServerException(2, "Bad topology of " + nIFabricTopology);
        }
        return new CtInt32(n);
    }

    public static CtInt32 fromFCPortTopology(NIFabricTopology nIFabricTopology) throws NIServerException {
        int n = 0;
        if (nIFabricTopology instanceof NIFabricTopologyFCArbitratedLoop) {
            n = 2;
        } else if (nIFabricTopology instanceof NIFabricTopologyScsiFcp) {
            n = 1;
        } else if (nIFabricTopology instanceof NIFabricTopologyFicon) {
            n = 3;
        } else if (nIFabricTopology instanceof NIFabricTopologyScsiFcpFicon) {
            n = 4;
        } else if (nIFabricTopology instanceof NIFabricTopologyUnknown) {
            n = 0;
        } else {
            throw new NIServerException(2, "Bad topology of " + nIFabricTopology);
        }
        return new CtInt32(n);
    }

    public static CtString fromPortMask(NIPortMask nIPortMask) throws NIServerException {
        return new CtString(nIPortMask.toString());
    }

    public static CtInt32 fromVolumeGroupType(NIVolumeGroupType nIVolumeGroupType) throws NIServerException {
        int n;
        if (nIVolumeGroupType instanceof NIVolumeGroupTypeCopyServices) {
            n = 801;
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeFiconEsconAll) {
            n = 10;
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeFiconEsconMask) {
            n = 11;
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeFiconEsconMixedMask) {
            n = 12;
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520All) {
            n = 30;
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Map256) {
            n = 32;
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Mask) {
            n = 31;
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIAll) {
            n = 20;
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMap256) {
            n = 22;
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMask) {
            n = 21;
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMixedMask) {
            n = 23;
        } else {
            throw new NIServerException(2, "bad volumeGroupType of " + nIVolumeGroupType);
        }
        return new CtInt32(n);
    }

    public static CtInt32 fromVolumeGroupID(NIVolumeGroupID nIVolumeGroupID) throws NIServerException {
        if (nIVolumeGroupID != null) {
            return new CtInt32(nIVolumeGroupID.getVolumeGroupNumber());
        }
        return new CtInt32(-1);
    }

    public static CtString intToString(int n) {
        String string = String.valueOf(n);
        int n2 = 0;
        while (string.length() <= 2) {
            string = "0" + string;
            ++n2;
        }
        return new CtString(string);
    }

    public static CtStructuredData toChangeVolumeMap(NIVolumeID[] nIVolumeIDArray) {
        byte[] byArray = new byte[512];
        Arrays.fill(byArray, (byte)-1);
        int n = 0;
        while (n < nIVolumeIDArray.length) {
            NIVolumeID nIVolumeID = nIVolumeIDArray[n];
            if (nIVolumeID != null) {
                byArray[n * 2] = (byte)nIVolumeID.getLSS().getLSSNumber();
                byArray[n * 2 + 1] = (byte)nIVolumeID.getVolNumber();
            }
            ++n;
        }
        return new CtStructuredData(new CtDataType[]{new CtBinary(byArray)});
    }

    public static CtStructuredData toChangeVolumeMask(NIVolumeID[] nIVolumeIDArray) {
        byte[] byArray = new byte[8192];
        Arrays.fill(byArray, (byte)0);
        int n = 0;
        while (n < nIVolumeIDArray.length) {
            NIVolumeID nIVolumeID = nIVolumeIDArray[n];
            int n2 = nIVolumeID.getLSS().getLSSNumber();
            int n3 = nIVolumeID.getVolNumber();
            int n4 = (n2 & 0xFF) << 8 | n3 & 0xFF;
            int n5 = n4 / 8;
            byArray[n5] = (byte)(byArray[n5] | 1 << 7 - n4 % 8);
            ++n;
        }
        return new CtStructuredData(new CtDataType[]{new CtBinary(byArray)});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

