/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.common.convert.host;

import com.ibm.rsct.rmcjni.McAttribute;
import com.ibm.rsct.util.CtDataType;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceCreationConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceModificationConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIfromMcConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NItoMcConverter;
import com.ibm.storage.ess.ni.application.resource.NIFiconHost;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroup;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIFCPPortID;
import com.ibm.storage.ess.ni.identifiers.NIFiconHostID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.resource.NIFiconHostImpl;
import java.util.Hashtable;

public class NIFICONHostConverter
implements NIResourceConverter,
NIResourceCreationConverter,
NIResourceModificationConverter {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$common$convert$host$NIFICONHostConverter == null ? (class$com$ibm$storage$ess$ni$agent$common$convert$host$NIFICONHostConverter = NIFICONHostConverter.class$("com.ibm.storage.ess.ni.agent.common.convert.host.NIFICONHostConverter")) : class$com$ibm$storage$ess$ni$agent$common$convert$host$NIFICONHostConverter);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$common$convert$host$NIFICONHostConverter;

    public McAttribute[] toMcAttributes_forCreate(NIResource nIResource) throws NIServerException {
        NIFiconHost nIFiconHost = (NIFiconHost)nIResource;
        McAttribute[] mcAttributeArray = new McAttribute[9];
        mcAttributeArray[0] = new McAttribute("aWWPN", 0, (CtDataType)NItoMcConverter.hexStringFromLong(nIFiconHost.getWwnn(), 8));
        mcAttributeArray[1] = new McAttribute("userName", 0, (CtDataType)NItoMcConverter.fromString(nIFiconHost.getUserHostName()));
        mcAttributeArray[2] = new McAttribute("userDescription", 0, (CtDataType)NItoMcConverter.fromString(nIFiconHost.getUserHostDescription()));
        mcAttributeArray[3] = new McAttribute("ficonVolumeGroup", 0, (CtDataType)NItoMcConverter.fromVolumeGroupID((NIVolumeGroupID)nIFiconHost.getVolGroup().getID()));
        return mcAttributeArray;
    }

    public McAttribute[] toMcAttributes_forModify(NIResource nIResource) throws NIServerException {
        NIFiconHost nIFiconHost = (NIFiconHost)nIResource;
        McAttribute[] mcAttributeArray = new McAttribute[]{new McAttribute("userName", 0, (CtDataType)NItoMcConverter.fromString(nIFiconHost.getUserHostName())), new McAttribute("userDescription", 0, (CtDataType)NItoMcConverter.fromString(nIFiconHost.getUserHostDescription()))};
        return mcAttributeArray;
    }

    public NIResource toResource(McAttribute[] mcAttributeArray) throws NIServerException {
        if (mcAttributeArray == null) {
            logger.error("Attributes were null while querying the NIHAPort.");
            throw new NIServerException(1, "Attributes were null while querying the NIHAPort.");
        }
        Hashtable<String, CtDataType> hashtable = new Hashtable<String, CtDataType>();
        int n = 0;
        while (n < mcAttributeArray.length) {
            hashtable.put(mcAttributeArray[n].getName(), mcAttributeArray[n].getValue());
            ++n;
        }
        NIESSID nIESSID = NIfromMcConverter.toEssID((CtDataType)hashtable.get("storageFacilityImageMTMS"));
        int n2 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("ficonHost"));
        long l = NIfromMcConverter.byteArrayToLong((CtDataType)hashtable.get("aWWPN"));
        NIVolumeGroup nIVolumeGroup = NIfromMcConverter.toVolumeGroup((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("ficonVolumeGroup"), (CtDataType)hashtable.get("userName"));
        String string = NIfromMcConverter.toString((CtDataType)hashtable.get("userName"));
        String string2 = NIfromMcConverter.toString((CtDataType)hashtable.get("userDescription"));
        NIFiconHostImpl nIFiconHostImpl = new NIFiconHostImpl(new NIFiconHostID(nIESSID, n2), l, nIVolumeGroup, string, string2);
        return nIFiconHostImpl;
    }

    public NIResourceID toResourceID(McAttribute[] mcAttributeArray) throws NIServerException {
        Hashtable<String, CtDataType> hashtable = new Hashtable<String, CtDataType>();
        int n = 0;
        while (n < mcAttributeArray.length) {
            hashtable.put(mcAttributeArray[n].getName(), mcAttributeArray[n].getValue());
            ++n;
        }
        NIESSID nIESSID = NIfromMcConverter.toEssID((CtDataType)hashtable.get("storageFacilityImageMTMS"));
        return nIESSID;
    }

    public String toSelectString(NIResourceID nIResourceID) throws NIServerException {
        NIFCPPortID nIFCPPortID = (NIFCPPortID)nIResourceID;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ficonHost");
        stringBuffer.append("==");
        stringBuffer.append(Integer.toString(nIFCPPortID.getPortID()));
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Constants {
        public static final String CLASS_NAME = "IBM.EssFiconHost";

        public static interface Attr {
            public static final String SFI_MTMS = "storageFacilityImageMTMS";
            public static final String FICON_HOST = "ficonHost";
            public static final String WWPN = "aWWPN";
            public static final String VOLUME_GROUP = "ficonVolumeGroup";
            public static final String LIMIT_INBAND_CS = "limitInBandCopyServices";
            public static final String INBAND_CS_ENABLED = "inBandCopyServicesEnabled";
            public static final String OVERRIDE_PRIORITY = "overrideDefaultPriority";
            public static final String OVERRIDE_PRIORITY_VALUE = "overrideDefaultPriorityValue";
            public static final String CKD_PRIORITY_OFFSET = "ckdPriorityOffset";
            public static final String STATUS = "status";
            public static final String USER_NAME = "userName";
            public static final String USER_DESCRIPTION = "userDescription";
        }
    }
}

