/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.common.convert.host;

import com.ibm.rsct.rmcjni.McAttribute;
import com.ibm.rsct.rmcjni.McClassActionRsp;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtString;
import com.ibm.rsct.util.CtStructuredData;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceCreationConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceModificationConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceQueryClassActionConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIfromMcConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NItoMcConverter;
import com.ibm.storage.ess.ni.application.resource.NIPortMask;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.application.resource.NISCSIHostPort;
import com.ibm.storage.ess.ni.application.results.NIHostUserNamesResult;
import com.ibm.storage.ess.ni.application.results.NIPortProfilesResult;
import com.ibm.storage.ess.ni.application.results.NIResult;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIFabricTopology;
import com.ibm.storage.ess.ni.resource.NISCSIHostPortImpl;
import com.ibm.storage.ess.ni.results.NIHostUserNamesResultImpl;
import com.ibm.storage.ess.ni.results.NIPortProfilesResultImpl;
import java.util.Hashtable;

public class NISCSIHostPortConverter
implements NIResourceConverter,
NIResourceCreationConverter,
NIResourceModificationConverter,
NIResourceQueryClassActionConverter {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$common$convert$host$NISCSIHostPortConverter == null ? (class$com$ibm$storage$ess$ni$agent$common$convert$host$NISCSIHostPortConverter = NISCSIHostPortConverter.class$("com.ibm.storage.ess.ni.agent.common.convert.host.NISCSIHostPortConverter")) : class$com$ibm$storage$ess$ni$agent$common$convert$host$NISCSIHostPortConverter);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$common$convert$host$NISCSIHostPortConverter;

    public McAttribute[] toMcAttributes_forCreate(NIResource nIResource) throws NIServerException {
        NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)nIResource;
        McAttribute[] mcAttributeArray = new McAttribute[]{new McAttribute("aWWPN", 0, (CtDataType)NItoMcConverter.hexStringFromLong(nISCSIHostPort.getWWPN(), 16)), new McAttribute("portProfile", 0, (CtDataType)NItoMcConverter.fromString(nISCSIHostPort.getPortProfile())), new McAttribute("userHostName", 0, (CtDataType)NItoMcConverter.fromString(nISCSIHostPort.getUserHostName())), new McAttribute("userHostDescription", 0, (CtDataType)NItoMcConverter.fromString(nISCSIHostPort.getUserHostDescription()))};
        return mcAttributeArray;
    }

    public McAttribute[] toMcAttributes_forModify(NIResource nIResource) throws NIServerException {
        NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)nIResource;
        McAttribute[] mcAttributeArray = new McAttribute[]{nISCSIHostPort.getVolumeGroup() != null ? new McAttribute("scsiVolumeGroup", 0, (CtDataType)NItoMcConverter.fromInt(nISCSIHostPort.getVolumeGroup().getVolumeGroupNumber())) : new McAttribute("scsiVolumeGroup", 0, (CtDataType)NItoMcConverter.fromInt(-1)), new McAttribute("logicalBlockSize", 0, (CtDataType)NItoMcConverter.fromInt(nISCSIHostPort.getLogicalBlockSize())), new McAttribute("addressDiscovery", 0, (CtDataType)NItoMcConverter.fromInt(nISCSIHostPort.getAddressDiscovery())), new McAttribute("userHostName", 0, (CtDataType)NItoMcConverter.fromString(nISCSIHostPort.getUserHostName())), new McAttribute("userHostDescription", 0, (CtDataType)NItoMcConverter.fromString(nISCSIHostPort.getUserHostDescription())), new McAttribute("hostType", 0, (CtDataType)NItoMcConverter.fromString(nISCSIHostPort.getHostType())), new McAttribute("portGroup", 0, (CtDataType)NItoMcConverter.fromInt(nISCSIHostPort.getPortGroup())), new McAttribute("portProfile", 0, (CtDataType)NItoMcConverter.fromString(nISCSIHostPort.getPortProfile())), nISCSIHostPort.getPortMask() != null ? new McAttribute("ioPortMask", 0, (CtDataType)NItoMcConverter.fromPortMask(nISCSIHostPort.getPortMask())) : new McAttribute("ioPortMask", 0, (CtDataType)NItoMcConverter.fromPortMask(new NIPortMask("2107"))), nISCSIHostPort.getAttachingPortTopology() != null ? new McAttribute("attachingPortTopology", 0, (CtDataType)NItoMcConverter.fromAttachingPortTopology(nISCSIHostPort.getAttachingPortTopology())) : new McAttribute("attachingPortTopology", 0, (CtDataType)NItoMcConverter.fromAttachingPortTopology(nISCSIHostPort.getAttachingPortTopology()))};
        return mcAttributeArray;
    }

    public NIResource toResource(McAttribute[] mcAttributeArray) throws NIServerException {
        if (mcAttributeArray == null) {
            logger.error("Attributes were null while querying the NIScsiHostPort.");
            throw new NIServerException(1, "Attributes were null while querying the NIScsiHostPort.");
        }
        Hashtable<String, CtDataType> hashtable = new Hashtable<String, CtDataType>();
        int n = 0;
        while (n < mcAttributeArray.length) {
            hashtable.put(mcAttributeArray[n].getName(), mcAttributeArray[n].getValue());
            ++n;
        }
        NISCSIHostPortID nISCSIHostPortID = NIfromMcConverter.toSCSIHostPortID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("scsiHostPort"));
        long l = NIfromMcConverter.toLongfromHexString((CtDataType)hashtable.get("aWWPN"));
        NIVolumeGroupID nIVolumeGroupID = NIfromMcConverter.toVolumeGroupID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("scsiVolumeGroup"));
        String string = NIfromMcConverter.toString((CtDataType)hashtable.get("portProfile"));
        String string2 = NIfromMcConverter.toString((CtDataType)hashtable.get("userHostName"));
        String string3 = NIfromMcConverter.toString((CtDataType)hashtable.get("userHostDescription"));
        String string4 = NIfromMcConverter.toString((CtDataType)hashtable.get("hostType"));
        int n2 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("logicalBlockSize"));
        int n3 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("addressDiscovery"));
        NIFabricTopology nIFabricTopology = NIfromMcConverter.toAttachingPortTopology((CtDataType)hashtable.get("attachingPortTopology"));
        int n4 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("portGroup"));
        NIPortMask nIPortMask = NIfromMcConverter.toPortMask((CtDataType)hashtable.get("ioPortMask"));
        NISCSIHostPortImpl nISCSIHostPortImpl = new NISCSIHostPortImpl(nISCSIHostPortID, l, nIVolumeGroupID, string, string2, string3, string4, n2, n3, nIFabricTopology, n4, nIPortMask);
        return nISCSIHostPortImpl;
    }

    public NIResourceID toResourceID(McAttribute[] mcAttributeArray) throws NIServerException {
        if (mcAttributeArray == null) {
            logger.error("Attributes were null while querying the NIHAPort.");
            throw new NIServerException(1, "Attributes were null while querying the NIHAPort.");
        }
        Hashtable<String, CtDataType> hashtable = new Hashtable<String, CtDataType>();
        int n = 0;
        while (n < mcAttributeArray.length) {
            hashtable.put(mcAttributeArray[n].getName(), mcAttributeArray[n].getValue());
            ++n;
        }
        NISCSIHostPortID nISCSIHostPortID = NIfromMcConverter.toSCSIHostPortID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("scsiHostPort"));
        return nISCSIHostPortID;
    }

    public String toSelectString(NIResourceID nIResourceID) throws NIServerException {
        NISCSIHostPortID nISCSIHostPortID = (NISCSIHostPortID)nIResourceID;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("scsiHostPort==");
        stringBuffer.append(Integer.toString(nISCSIHostPortID.getPortID()));
        return stringBuffer.toString();
    }

    public String toSelectStringHostName(NIESSID nIESSID, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("userHostName");
        stringBuffer.append("==");
        stringBuffer.append("\"");
        stringBuffer.append(string);
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public String toSelectStringPortIDs(NISCSIHostPortID[] nISCSIHostPortIDArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nISCSIHostPortIDArray.length) {
            if (n > 0) {
                stringBuffer.append(" OR ");
            }
            int n2 = nISCSIHostPortIDArray[n].getPortID();
            stringBuffer.append("scsiHostPort");
            stringBuffer.append("==");
            stringBuffer.append(n2);
            ++n;
        }
        return stringBuffer.toString();
    }

    public CtStructuredData toQueryPortProfilesAction() {
        return null;
    }

    public CtStructuredData toQueryUserNamesAction() {
        return null;
    }

    public NIResult convertQueryClassAction(String string, McClassActionRsp[] mcClassActionRspArray, NIESSID nIESSID) throws NIServerException {
        NIResult nIResult = null;
        if (string.equals("listPortProfiles")) {
            nIResult = this.fromQueryPortProfilesAction(mcClassActionRspArray, nIESSID);
        } else if (string.equals("listUserHostNames")) {
            nIResult = this.fromQueryUserNamesAction(mcClassActionRspArray, nIESSID);
        }
        return nIResult;
    }

    public NIPortProfilesResult fromQueryPortProfilesAction(McClassActionRsp[] mcClassActionRspArray, NIESSID nIESSID) throws NIServerException {
        CtStructuredData ctStructuredData = mcClassActionRspArray[0].getData()[0];
        int n = 0;
        if (ctStructuredData != null) {
            n = ctStructuredData.getElementCount();
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            CtDataType ctDataType = null;
            try {
                ctDataType = ctStructuredData.getData(n2);
            }
            catch (Exception exception) {
                logger.error("Caught exception from CtStructuredData.getData(int) on element " + n2 + ".");
                logger.throwable((Throwable)exception);
                throw new NIServerException(1, "Caught exception from CtStructuredData.getData(int) on element " + n2 + ".");
            }
            stringArray[n2] = NIfromMcConverter.toString((CtDataType)((CtString)ctDataType));
            ++n2;
        }
        return new NIPortProfilesResultImpl(stringArray, 0L);
    }

    public NIHostUserNamesResult fromQueryUserNamesAction(McClassActionRsp[] mcClassActionRspArray, NIESSID nIESSID) throws NIServerException {
        int n = 0;
        CtStructuredData ctStructuredData = null;
        if (mcClassActionRspArray[0].getData() != null) {
            ctStructuredData = mcClassActionRspArray[0].getData()[0];
        }
        if (ctStructuredData != null) {
            n = ctStructuredData.getElementCount();
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            CtDataType ctDataType = null;
            try {
                ctDataType = ctStructuredData.getData(n2);
            }
            catch (Exception exception) {
                logger.error("Caught exception from CtStructuredData.getData(int) on element " + n2 + ".");
                logger.throwable((Throwable)exception);
                throw new NIServerException(1, "Caught exception from CtStructuredData.getData(int) on element " + n2 + ".");
            }
            stringArray[n2] = NIfromMcConverter.toString((CtDataType)((CtString)ctDataType));
            ++n2;
        }
        return new NIHostUserNamesResultImpl(true, 0L, stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Constants {
        public static final int WWPN_LENGTH = 16;
        public static final String CLASS_NAME = "IBM.EssScsiHostPort";

        public static interface ClassAct {
            public static final String QUERY_PORT_PROFILES = "listPortProfiles";
            public static final String QUERY_USER_HOST_NAMES = "listUserHostNames";
        }

        public static interface RsrcAct {
        }

        public static interface Attr {
            public static final String SFI_MTMS = "storageFacilityImageMTMS";
            public static final String SCSI_HOST = "scsiHostPort";
            public static final String WWPN = "aWWPN";
            public static final String VOLUME_GROUP = "scsiVolumeGroup";
            public static final String HOST_NAME = "userHostName";
            public static final String HOST_DESCRIPTION = "userHostDescription";
            public static final String HOST_TYPE = "hostType";
            public static final String BLOCK_SIZE = "logicalBlockSize";
            public static final String ADDRESS_DISCOVERY = "addressDiscovery";
            public static final String PORT_TOPOLOGY = "attachingPortTopology";
            public static final String PORT_PROFILE = "portProfile";
            public static final String PORT_GROUP = "portGroup";
            public static final String PORT_MASK = "ioPortMask";
        }
    }
}

