/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.common.convert.logical;

import com.ibm.rsct.rmcjni.McActionRsp;
import com.ibm.rsct.rmcjni.McAttribute;
import com.ibm.rsct.util.CtDataType;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceCreationConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceModificationConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceQueryActionConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIfromMcConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NItoMcConverter;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.application.results.NIResult;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.identifiers.NIAddressGroupID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType;
import com.ibm.storage.ess.ni.option.config.NIDeviceType;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.resource.NILSSImpl;
import java.util.Hashtable;

public class NILSSConverter
implements NIResourceConverter,
NIResourceModificationConverter,
NIResourceCreationConverter,
NIResourceQueryActionConverter {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$common$convert$logical$NILSSConverter == null ? (class$com$ibm$storage$ess$ni$agent$common$convert$logical$NILSSConverter = NILSSConverter.class$("com.ibm.storage.ess.ni.agent.common.convert.logical.NILSSConverter")) : class$com$ibm$storage$ess$ni$agent$common$convert$logical$NILSSConverter);
    private static final int NUM_CKD_MODIFIABLE_ATTRS = 7;
    private static final int NUM_FB_MODIFIABLE_ATTRS = 5;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$common$convert$logical$NILSSConverter;

    public McAttribute[] toMcAttributes_forCreate(NIResource nIResource) throws NIServerException {
        NILSS nILSS = (NILSS)nIResource;
        McAttribute[] mcAttributeArray = new McAttribute[]{new McAttribute("logicalSubsystem", 0, (CtDataType)NItoMcConverter.hexStringFromLong(((NILSSID)nILSS.getID()).getLSSNumber(), 2)), new McAttribute("deviceType", 0, (CtDataType)NItoMcConverter.fromDeviceType(nILSS.getDeviceType())), new McAttribute("subsystemIdentifier", 0, (CtDataType)NItoMcConverter.hexStringFromLong(nILSS.getSSID(), 4)), new McAttribute("ckdBaseCUType", 0, (CtDataType)NItoMcConverter.fromCuBaseType(nILSS.getCUBaseType()))};
        return mcAttributeArray;
    }

    public McAttribute[] toMcAttributes_forModify(NIResource nIResource) throws NIServerException {
        NILSS nILSS = (NILSS)nIResource;
        boolean bl = nILSS.getDeviceType() instanceof NIDeviceTypeCKD;
        McAttribute[] mcAttributeArray = bl ? new McAttribute[7] : new McAttribute[5];
        int n = 0;
        if (bl) {
            mcAttributeArray[n++] = new McAttribute("subsystemIdentifier", 0, (CtDataType)NItoMcConverter.hexStringFromLong(nILSS.getSSID(), 4));
            mcAttributeArray[n++] = new McAttribute("ckdBaseCUType", 0, (CtDataType)NItoMcConverter.fromCuBaseType(nILSS.getCUBaseType()));
        }
        mcAttributeArray[n++] = new McAttribute("ccSessionTimeout", 0, (CtDataType)NItoMcConverter.fromInt(nILSS.getCCTimeout()));
        mcAttributeArray[n++] = new McAttribute("xrcSessionTimeout", 0, (CtDataType)NItoMcConverter.fromInt(nILSS.getXRCTimeout()));
        mcAttributeArray[n++] = new McAttribute("criticalModeEnabled", 0, (CtDataType)NItoMcConverter.fromBoolean(nILSS.isCriticalModeEnabled()));
        mcAttributeArray[n++] = new McAttribute("extendedLongBusyEnabled", 0, (CtDataType)NItoMcConverter.fromBoolean(nILSS.isELBEnabled()));
        mcAttributeArray[n++] = new McAttribute("extendedLongBusyTime", 0, (CtDataType)NItoMcConverter.fromInt(nILSS.getELBActiveTime()));
        return mcAttributeArray;
    }

    public NIResource toResource(McAttribute[] mcAttributeArray) throws NIServerException {
        if (mcAttributeArray == null) {
            logger.error("Attributes were null while querying the NIRank.");
            throw new NIServerException(1, "Attributes were null while querying the NIRank.");
        }
        Hashtable<String, CtDataType> hashtable = new Hashtable<String, CtDataType>();
        int n = 0;
        while (n < mcAttributeArray.length) {
            hashtable.put(mcAttributeArray[n].getName(), mcAttributeArray[n].getValue());
            ++n;
        }
        NILSSID nILSSID = NIfromMcConverter.toLssId((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("logicalSubsystem"), (CtDataType)hashtable.get("subsystemIdentifier"));
        NIDeviceType nIDeviceType = NIfromMcConverter.toDeviceType((CtDataType)hashtable.get("deviceType"));
        NIAddressGroupID nIAddressGroupID = NIfromMcConverter.toAddressGroupID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("addressGroup"));
        int n2 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("numberConfiguredDevices"));
        NICKDBaseCUType nICKDBaseCUType = NIfromMcConverter.toCuBaseType((CtDataType)hashtable.get("ckdBaseCUType"));
        boolean bl = NIfromMcConverter.toBoolean((CtDataType)hashtable.get("criticalModeEnabled"));
        boolean bl2 = NIfromMcConverter.toBoolean((CtDataType)hashtable.get("extendedLongBusyEnabled"));
        int n3 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("ccSessionTimeout"));
        int n4 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("xrcSessionTimeout"));
        int n5 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("extendedLongBusyTime"));
        NILSSImpl nILSSImpl = new NILSSImpl(nILSSID, nIDeviceType, nIAddressGroupID, n2, nICKDBaseCUType, bl, bl2, n5, n3, n4);
        return nILSSImpl;
    }

    public NIResourceID toResourceID(McAttribute[] mcAttributeArray) throws NIServerException {
        if (mcAttributeArray == null) {
            logger.error("Attributes were null while querying the NIHAPort.");
            throw new NIServerException(1, "Attributes were null while querying the NIHAPort.");
        }
        Hashtable<String, CtDataType> hashtable = new Hashtable<String, CtDataType>();
        int n = 0;
        while (n < mcAttributeArray.length) {
            hashtable.put(mcAttributeArray[n].getName(), mcAttributeArray[n].getValue());
            ++n;
        }
        NILSSID nILSSID = NIfromMcConverter.toLssId((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("logicalSubsystem"), (CtDataType)hashtable.get("subsystemIdentifier"));
        return nILSSID;
    }

    public String toSelectString(NIResourceID nIResourceID) throws NIServerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("logicalSubsystem==\"");
        stringBuffer.append(NItoMcConverter.hexStringFromLong(((NILSSID)nIResourceID).getLSSNumber(), 2).getData());
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public String toSelectStringWithDeviceType(NIDeviceType nIDeviceType) throws NIServerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("deviceType==\"");
        stringBuffer.append(NItoMcConverter.fromDeviceType(nIDeviceType).getData());
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public NIResult convertQueryAction(String string, McActionRsp[] mcActionRspArray, NIESSID nIESSID) throws NIServerException {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Constants {
        public static final String CLASS_NAME = "IBM.EssLogicalSubsystem";

        public static interface ClassAct {
        }

        public static interface RsrcAct {
        }

        public static interface Attr {
            public static final String SFI_MTMS = "storageFacilityImageMTMS";
            public static final String DEVICE_TYPE = "deviceType";
            public static final String LSS_GROUP = "lssGroup";
            public static final String ADDRESS_GROUP = "addressGroup";
            public static final String LSS = "logicalSubsystem";
            public static final String CKD_BASE = "ckdBaseCUType";
            public static final String SSID = "subsystemIdentifier";
            public static final String CONFIGURED_DISK = "numberConfiguredDevices";
            public static final String ELB_ENABLED = "extendedLongBusyEnabled";
            public static final String CRITICAL_MODE_ENABLED = "criticalModeEnabled";
            public static final String CC_TIMEOUT = "ccSessionTimeout";
            public static final String XRC_TIMEOUT = "xrcSessionTimeout";
            public static final String ELB_TIME = "extendedLongBusyTime";
        }
    }
}

