/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.common.convert.logical;

import com.ibm.rsct.rmcjni.McActionRsp;
import com.ibm.rsct.rmcjni.McAttribute;
import com.ibm.rsct.util.CtArray;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtInt32;
import com.ibm.rsct.util.CtString;
import com.ibm.rsct.util.CtStructuredData;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceCreationConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceQueryActionConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIfromMcConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NItoMcConverter;
import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NIRank;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroupVolumeList;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIExtentUsageResult;
import com.ibm.storage.ess.ni.application.results.NIResult;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIRaidType;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeCopyServices;
import com.ibm.storage.ess.ni.resource.NIRankImpl;
import com.ibm.storage.ess.ni.results.NIConfigQueryResultImpl;
import com.ibm.storage.ess.ni.results.NIExtentUsageResultImpl;
import java.util.Hashtable;
import java.util.Vector;

public class NIRankConverter
implements NIResourceConverter,
NIResourceCreationConverter,
NIResourceQueryActionConverter {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$common$convert$logical$NIRankConverter == null ? (class$com$ibm$storage$ess$ni$agent$common$convert$logical$NIRankConverter = NIRankConverter.class$("com.ibm.storage.ess.ni.agent.common.convert.logical.NIRankConverter")) : class$com$ibm$storage$ess$ni$agent$common$convert$logical$NIRankConverter);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$common$convert$logical$NIRankConverter;

    public McAttribute[] toMcAttributes_forCreate(NIResource nIResource) throws NIServerException {
        NIRank nIRank = (NIRank)nIResource;
        McAttribute[] mcAttributeArray = new McAttribute[]{new McAttribute("arrays", 0, (CtDataType)NItoMcConverter.arraysFromRank(nIRank)), new McAttribute("segmentType", 0, (CtDataType)NItoMcConverter.fromExtentType(nIRank.getExtentType()))};
        return mcAttributeArray;
    }

    public NIResource toResource(McAttribute[] mcAttributeArray) throws NIServerException {
        if (mcAttributeArray == null) {
            logger.error("Attributes were null while querying the NIRank.");
            throw new NIServerException(1, "Attributes were null while querying the NIRank.");
        }
        Hashtable<String, CtDataType> hashtable = new Hashtable<String, CtDataType>();
        int n = 0;
        while (n < mcAttributeArray.length) {
            hashtable.put(mcAttributeArray[n].getName(), mcAttributeArray[n].getValue());
            ++n;
        }
        NIRankID nIRankID = NIfromMcConverter.toRankID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("rank"));
        NIArrayID[] nIArrayIDArray = NIfromMcConverter.toArrayIDArray((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtArray)hashtable.get("arrays"));
        NIExtentType nIExtentType = NIfromMcConverter.toExtentType((CtDataType)hashtable.get("segmentType"));
        NIExtentPoolID nIExtentPoolID = NIfromMcConverter.toExtentPoolID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("segmentPool"));
        String string = NIfromMcConverter.toString((CtDataType)hashtable.get("rankSerialNumber"));
        boolean bl = NIfromMcConverter.toBoolean((CtDataType)hashtable.get("virtualRank"));
        int n2 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("rankGroup"));
        NIRaidType nIRaidType = NIfromMcConverter.toRaidType((CtDataType)hashtable.get("raidType"));
        long l = NIfromMcConverter.toLong((CtDataType)hashtable.get("numberWideArrays"));
        long l2 = NIfromMcConverter.toLong((CtDataType)hashtable.get("numberNarrowArrays"));
        long l3 = NIfromMcConverter.toLong((CtDataType)hashtable.get("trackSize"));
        long l4 = NIfromMcConverter.toLong((CtDataType)hashtable.get("stripSize"));
        long l5 = NIfromMcConverter.toLong((CtDataType)hashtable.get("strideSize"));
        long l6 = NIfromMcConverter.toLong((CtDataType)hashtable.get("segmentSize"));
        int n3 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("dataState"));
        int n4 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("configurationState"));
        long l7 = NIfromMcConverter.toLong((CtDataType)hashtable.get("numberSegments"));
        long l8 = NIfromMcConverter.toLongfromHexString((CtDataType)hashtable.get("errorCode"));
        NIRankImpl nIRankImpl = new NIRankImpl(nIRankID, nIArrayIDArray, nIExtentType, nIExtentPoolID, string, n2, nIRaidType, l, l2, l3, l4, l5, l6, n3, n4, l7);
        nIRankImpl.setErrorCode(l8);
        return nIRankImpl;
    }

    public NIResourceID toResourceID(McAttribute[] mcAttributeArray) throws NIServerException {
        Hashtable<String, CtDataType> hashtable = new Hashtable<String, CtDataType>();
        int n = 0;
        while (n < mcAttributeArray.length) {
            hashtable.put(mcAttributeArray[n].getName(), mcAttributeArray[n].getValue());
            ++n;
        }
        NIRankID nIRankID = NIfromMcConverter.toRankID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("rank"));
        return nIRankID;
    }

    public String toSelectString(NIResourceID nIResourceID) throws NIServerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("rank==");
        stringBuffer.append(((NIRankID)nIResourceID).getRankNumber());
        return stringBuffer.toString();
    }

    public CtStructuredData toAssignAction(NIExtentPool nIExtentPool) {
        return new CtStructuredData(new CtDataType[]{new CtInt32(((NIExtentPoolID)nIExtentPool.getID()).getExtentPoolNumber())});
    }

    public CtStructuredData toUnassignAction() {
        return null;
    }

    public CtStructuredData toReserveAction() {
        return null;
    }

    public CtStructuredData toReleaseAction() {
        return null;
    }

    public CtStructuredData toQueryExtentUsageAction() {
        return null;
    }

    public CtStructuredData toQueryVolumesAction() {
        return null;
    }

    public NIResult convertQueryAction(String string, McActionRsp[] mcActionRspArray, NIESSID nIESSID) throws NIServerException {
        NIResult nIResult = null;
        if (string.equals("queryExtentUsage")) {
            nIResult = this.fromQueryExtentUsageAction(mcActionRspArray, nIESSID);
        } else if (string.equals("queryLogicalVolumes")) {
            nIResult = this.fromQueryVolumesAction(mcActionRspArray, nIESSID);
        }
        return nIResult;
    }

    private NIExtentUsageResult fromQueryExtentUsageAction(McActionRsp[] mcActionRspArray, NIESSID nIESSID) throws NIServerException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        NIExtentPoolID nIExtentPoolID = null;
        NIRankID nIRankID = null;
        NIExtentType nIExtentType = null;
        int n5 = 0;
        CtStructuredData ctStructuredData = mcActionRspArray[0].getData()[0];
        int n6 = 0;
        while (n6 < ctStructuredData.getElementCount()) {
            CtDataType ctDataType = null;
            try {
                ctDataType = ctStructuredData.getData(n6);
            }
            catch (Exception exception) {
                logger.error("Caught exception from CtStructuredData.getData(int) on element " + n6 + ".");
                logger.throwable((Throwable)exception);
                throw new NIServerException(1, "Caught exception from CtStructuredData.getData(int) on element " + n6 + ".");
            }
            switch (n6) {
                case 0: {
                    nIRankID = new NIRankID(nIESSID, NIfromMcConverter.toInteger(ctDataType));
                    break;
                }
                case 1: {
                    nIExtentPoolID = new NIExtentPoolID(nIESSID, NIfromMcConverter.toInteger(ctDataType));
                    break;
                }
                case 2: {
                    nIExtentType = NIfromMcConverter.toExtentType(ctDataType);
                    break;
                }
                case 3: {
                    n2 = NIfromMcConverter.toInteger(ctDataType);
                    break;
                }
                case 4: {
                    n = NIfromMcConverter.toInteger(ctDataType);
                    break;
                }
                case 5: {
                    n3 = NIfromMcConverter.toInteger(ctDataType);
                    break;
                }
                case 6: {
                    n4 = NIfromMcConverter.toInteger(ctDataType);
                    break;
                }
            }
            ++n6;
        }
        return new NIExtentUsageResultImpl(true, 0L, n, n2, n3, n4, nIExtentPoolID, nIRankID, nIExtentType, n5);
    }

    private NIConfigQueryResult fromQueryVolumesAction(McActionRsp[] mcActionRspArray, NIESSID nIESSID) throws NIServerException {
        System.out.println("Working up to this point!");
        int n = 4;
        CtStructuredData ctStructuredData = mcActionRspArray[0].getData()[0];
        CtDataType ctDataType = null;
        try {
            ctDataType = ctStructuredData.getData(n);
        }
        catch (Exception exception) {
            logger.error("Caught exception from CtStructuredData.getData(int) on element " + n + ".");
            logger.throwable((Throwable)exception);
            throw new NIServerException(1, "Caught exception from CtStructuredData.getData(int) on element " + n + ".");
        }
        NIVolumeGroupVolumeList nIVolumeGroupVolumeList = NIfromMcConverter.toVolumeMask(ctDataType, (CtDataType)new CtString(nIESSID.toString()), NIVolumeGroupTypeCopyServices.Option);
        Vector vector = nIVolumeGroupVolumeList.getVolumesInVolumeGroup();
        return new NIConfigQueryResultImpl(vector, true, 0L);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Constants {
        public static final String CLASS_NAME = "IBM.EssRank";

        public static interface RsrcAct {
            public static final String ASSIGN_RANKS = "assign";
            public static final String UNASSIGN_RANKS = "unassign";
            public static final String RESERVE_RANKS = "reserve";
            public static final String RELEASE_RANKS = "release";
            public static final String QUERY_EXTENT_USAGE = "queryExtentUsage";
            public static final String QUERY_LOGICAL_VOLUMES = "queryLogicalVolumes";
        }

        public static interface Attr {
            public static final String SFI_MTMS = "storageFacilityImageMTMS";
            public static final String RANK = "rank";
            public static final String SERIAL_NUMBER = "rankSerialNumber";
            public static final String VIRTUAL_RANK = "virtualRank";
            public static final String EXTENT_POOL = "segmentPool";
            public static final String RANK_GROUP = "rankGroup";
            public static final String EXTENT_TYPE = "segmentType";
            public static final String NUMBER_SEGMENTS = "numberSegments";
            public static final String RAID_TYPE = "raidType";
            public static final String ARRAYS = "arrays";
            public static final String NUMBER_WIDE_ARRAYS = "numberWideArrays";
            public static final String NUMBER_NARROW_ARRAYS = "numberNarrowArrays";
            public static final String TRACK_SIZE = "trackSize";
            public static final String STRIP_SIZE = "stripSize";
            public static final String STRIDE_SIZE = "strideSize";
            public static final String SEGMENT_SIZE = "segmentSize";
            public static final String DATA_STATE = "dataState";
            public static final String CONFIGURATION_STATE = "configurationState";
            public static final String CREATION_DATE = "creationDate";
            public static final String ERROR_CODE = "errorCode";
        }
    }
}

