/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.common.convert.logical;

import com.ibm.rsct.rmcjni.McActionRsp;
import com.ibm.rsct.rmcjni.McAttribute;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtString;
import com.ibm.rsct.util.CtStructuredData;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceCreationConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceModificationConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIResourceQueryActionConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NIfromMcConverter;
import com.ibm.storage.ess.ni.agent.common.convert.NItoMcConverter;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.results.NIExtentSummaryResult;
import com.ibm.storage.ess.ni.application.results.NIQueryRankExtentsResult;
import com.ibm.storage.ess.ni.application.results.NIResult;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.identifiers.NIAddressGroupID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NILSSGroupID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIDataType;
import com.ibm.storage.ess.ni.option.config.NIDeviceType;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIVolumeType;
import com.ibm.storage.ess.ni.resource.NIVolumeImpl;
import com.ibm.storage.ess.ni.results.NIExtentSummaryResultImpl;
import com.ibm.storage.ess.ni.results.NIQueryRankExtentsResultImpl;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class NIVolumeConverter
implements NIResourceConverter,
NIResourceModificationConverter,
NIResourceCreationConverter,
NIResourceQueryActionConverter {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$common$convert$logical$NIVolumeConverter == null ? (class$com$ibm$storage$ess$ni$agent$common$convert$logical$NIVolumeConverter = NIVolumeConverter.class$("com.ibm.storage.ess.ni.agent.common.convert.logical.NIVolumeConverter")) : class$com$ibm$storage$ess$ni$agent$common$convert$logical$NIVolumeConverter);
    private static final String SET_ORG_BASE_VOL_ID = "setOriginalBaseVolumeID";
    private static final String SET_DATA_TYPE = "setDataType";
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$common$convert$logical$NIVolumeConverter;

    public McAttribute[] toMcAttributes_forCreate(NIResource nIResource) throws NIServerException {
        NIVolume nIVolume = (NIVolume)nIResource;
        McAttribute[] mcAttributeArray = null;
        int n = 0;
        if (nIVolume.isAlias()) {
            if (nIVolume.getAliasMapVolumeGroup() != null) {
                mcAttributeArray = new McAttribute[5];
                mcAttributeArray[n++] = new McAttribute("aliasVolumeGroup", 0, (CtDataType)NItoMcConverter.fromVolumeGroupID(nIVolume.getAliasMapVolumeGroup()));
            } else {
                mcAttributeArray = new McAttribute[4];
            }
            NIVolumeID nIVolumeID = (NIVolumeID)nIVolume.getID();
            mcAttributeArray[n++] = new McAttribute("logicalVolumeNumber", 0, (CtDataType)NItoMcConverter.fromVolumeID(nIVolumeID));
            nIVolumeID = nIVolume.getOriginalBaseVolumeID();
            mcAttributeArray[n++] = new McAttribute("originalBaseLogicalVolumeNumber", 0, (CtDataType)NItoMcConverter.fromVolumeID(nIVolumeID));
            mcAttributeArray[n++] = new McAttribute("volumeType", 0, (CtDataType)NItoMcConverter.fromVolumeType(nIVolume.getVolumeType()));
            mcAttributeArray[n++] = new McAttribute("userName", 0, (CtDataType)NItoMcConverter.fromString(nIVolume.getUserName()));
        } else {
            mcAttributeArray = new McAttribute[6];
            NIVolumeID nIVolumeID = (NIVolumeID)nIVolume.getID();
            mcAttributeArray[0] = new McAttribute("logicalVolumeNumber", 0, (CtDataType)NItoMcConverter.fromVolumeID(nIVolumeID));
            mcAttributeArray[1] = new McAttribute("volumeType", 0, (CtDataType)NItoMcConverter.fromVolumeType(nIVolume.getVolumeType()));
            mcAttributeArray[2] = new McAttribute("segmentPool", 0, (CtDataType)NItoMcConverter.fromInt(nIVolume.getExtentPool().getExtentPoolNumber()));
            NIDataType nIDataType = nIVolume.getDataType();
            mcAttributeArray[3] = new McAttribute("dataType", 0, (CtDataType)NItoMcConverter.fromDataType(nIDataType));
            mcAttributeArray[4] = new McAttribute("requestedCapacity", 0, (CtDataType)NItoMcConverter.fromRequestedCapacity(nIVolume.getCapacity()));
            mcAttributeArray[5] = new McAttribute("userName", 0, (CtDataType)NItoMcConverter.fromString(nIVolume.getUserName()));
        }
        return mcAttributeArray;
    }

    public McAttribute[] toMcAttributes_forModify(NIResource nIResource) throws NIServerException {
        Object object;
        NIVolumeImpl nIVolumeImpl = (NIVolumeImpl)nIResource;
        int n = 1;
        if (nIVolumeImpl.getSetMethods().contains(SET_ORG_BASE_VOL_ID)) {
            ++n;
        }
        if (nIVolumeImpl.getSetMethods().contains(SET_DATA_TYPE)) {
            ++n;
        }
        McAttribute[] mcAttributeArray = new McAttribute[n];
        mcAttributeArray[0] = new McAttribute("userName", 0, (CtDataType)NItoMcConverter.fromString(nIVolumeImpl.getUserName()));
        if (nIVolumeImpl.getSetMethods().contains(SET_ORG_BASE_VOL_ID)) {
            object = nIVolumeImpl.getOriginalBaseVolumeID() == null ? new CtString() : NItoMcConverter.fromVolumeID(nIVolumeImpl.getOriginalBaseVolumeID());
            mcAttributeArray[1] = new McAttribute("originalBaseLogicalVolumeNumber", 0, (CtDataType)object);
        }
        if (nIVolumeImpl.getSetMethods().contains(SET_DATA_TYPE)) {
            object = nIVolumeImpl.getDataType();
            mcAttributeArray[n - 1] = new McAttribute("dataType", 0, (CtDataType)NItoMcConverter.fromDataType((NIDataType)object));
        }
        return mcAttributeArray;
    }

    public NIResource toResource(McAttribute[] mcAttributeArray) throws NIServerException {
        if (mcAttributeArray == null) {
            logger.error("Attributes were null while querying the NILogicalVolume.");
            throw new NIServerException(1, "Attributes were null while querying the NILogicalVolume.");
        }
        Hashtable<String, CtDataType> hashtable = new Hashtable<String, CtDataType>();
        int n = 0;
        while (n < mcAttributeArray.length) {
            hashtable.put(mcAttributeArray[n].getName(), mcAttributeArray[n].getValue());
            ++n;
        }
        NIVolumeID nIVolumeID = NIfromMcConverter.toVolumeID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("logicalVolumeNumber"));
        String string = NIfromMcConverter.toString((CtDataType)hashtable.get("userName"));
        NIVolumeID nIVolumeID2 = NIfromMcConverter.toVolumeID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("originalBaseLogicalVolumeNumber"));
        Vector vector = new Vector();
        NIAddressGroupID nIAddressGroupID = NIfromMcConverter.toAddressGroupID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("addressGroup"));
        NIVolumeGroupID nIVolumeGroupID = NIfromMcConverter.toVolumeGroupID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("aliasVolumeGroup"));
        NIExtentPoolID nIExtentPoolID = NIfromMcConverter.toExtentPoolID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("segmentPool"));
        boolean bl = nIVolumeGroupID != null;
        NIVolumeType nIVolumeType = NIfromMcConverter.toVolumeType((CtDataType)hashtable.get("volumeType"));
        NIDataType nIDataType = NIfromMcConverter.toDataType((CtDataType)hashtable.get("dataType"));
        long l = NIfromMcConverter.toLong((CtDataType)hashtable.get("capacity"));
        int n2 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("deviceMTM"));
        int n3 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("accessState"));
        int n4 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("dataState"));
        int n5 = NIfromMcConverter.toInteger((CtDataType)hashtable.get("configurationState"));
        boolean bl2 = NIfromMcConverter.toBoolean((CtDataType)hashtable.get("dataSharingAllowed"));
        boolean bl3 = NIfromMcConverter.toBoolean((CtDataType)hashtable.get("overrideDefaultPriority"));
        long l2 = NIfromMcConverter.toLongfromHexString((CtDataType)hashtable.get("errorCode"));
        NIVolumeImpl nIVolumeImpl = new NIVolumeImpl(nIVolumeID, string, nIVolumeID2, nIAddressGroupID, nIVolumeGroupID, nIExtentPoolID, bl, nIVolumeType, nIDataType, l, n2, n3, n4, n5);
        nIVolumeImpl.setErrorCode(l2);
        return nIVolumeImpl;
    }

    public NIResourceID toResourceID(McAttribute[] mcAttributeArray) throws NIServerException {
        Hashtable<String, CtDataType> hashtable = new Hashtable<String, CtDataType>();
        int n = 0;
        while (n < mcAttributeArray.length) {
            hashtable.put(mcAttributeArray[n].getName(), mcAttributeArray[n].getValue());
            ++n;
        }
        NIVolumeID nIVolumeID = NIfromMcConverter.toVolumeID((CtDataType)hashtable.get("storageFacilityImageMTMS"), (CtDataType)hashtable.get("logicalVolumeNumber"));
        return nIVolumeID;
    }

    public String toSelectString(NIResourceID nIResourceID) throws NIServerException {
        if (nIResourceID == null) {
            return this.toSelectString();
        }
        if (nIResourceID instanceof NILSSID) {
            return this.toSelectString((NILSSID)nIResourceID);
        }
        if (nIResourceID instanceof NIAddressGroupID) {
            return this.toSelectString((NIAddressGroupID)nIResourceID);
        }
        if (nIResourceID instanceof NILSSGroupID) {
            return this.toSelectString((NILSSGroupID)nIResourceID);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("logicalVolumeNumber==\"");
        stringBuffer.append(NItoMcConverter.fromVolumeID((NIVolumeID)nIResourceID).getData());
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public String toSelectStringWithDeviceType(NIDeviceType nIDeviceType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (nIDeviceType instanceof NIDeviceTypeCKD) {
            stringBuffer.append("volumeType==");
            stringBuffer.append(10);
            stringBuffer.append(" OR ");
            stringBuffer.append("volumeType==");
            stringBuffer.append(11);
            stringBuffer.append(" OR ");
            stringBuffer.append("volumeType==");
            stringBuffer.append(12);
            stringBuffer.append(" OR ");
            stringBuffer.append("volumeType==");
            stringBuffer.append(13);
        } else if (nIDeviceType instanceof NIDeviceTypeFB) {
            stringBuffer.append("volumeType==");
            stringBuffer.append(20);
            stringBuffer.append(" OR ");
            stringBuffer.append("volumeType==");
            stringBuffer.append(21);
        }
        return stringBuffer.toString();
    }

    public String toSelectString(NILSSID nILSSID) throws NIServerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("logicalSubsystem==\"");
        stringBuffer.append(NItoMcConverter.fromLSSID(nILSSID).getData());
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public CtStructuredData toUnfenceAction() {
        return null;
    }

    public NIResult convertQueryAction(String string, McActionRsp[] mcActionRspArray, NIESSID nIESSID) throws NIServerException {
        NIResult nIResult = null;
        if (string.equals("queryExtentSummary")) {
            nIResult = this.fromQueryExtentSummaryAction(mcActionRspArray, nIESSID);
        } else if (string.equals("queryRankExtents")) {
            nIResult = this.fromQueryRankExtentsAction(mcActionRspArray, nIESSID);
        }
        return nIResult;
    }

    public CtStructuredData toQueryExtentSummaryAction() {
        return null;
    }

    public CtStructuredData toQueryRankExtentsAction() {
        return null;
    }

    private NIExtentSummaryResult fromQueryExtentSummaryAction(McActionRsp[] mcActionRspArray, NIESSID nIESSID) throws NIServerException {
        NIVolumeID nIVolumeID = null;
        NIExtentType nIExtentType = null;
        int n = 0;
        int n2 = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        CtStructuredData ctStructuredData = mcActionRspArray[0].getData()[0];
        int n3 = 0;
        while (n3 < ctStructuredData.getElementCount()) {
            CtDataType ctDataType = null;
            try {
                ctDataType = ctStructuredData.getData(n3);
            }
            catch (Exception exception) {
                logger.error("Caught exception from CtStructuredData.getData(int) on element " + n3 + ".");
                logger.throwable((Throwable)exception);
                throw new NIServerException(1, "Caught exception from CtStructuredData.getData(int) on element " + n3 + ".");
            }
            switch (n3) {
                case 0: {
                    nIVolumeID = NIfromMcConverter.toVolumeID((CtDataType)new CtString(nIESSID.toString()), ctDataType);
                    break;
                }
                case 1: {
                    nIExtentType = NIfromMcConverter.toExtentType(ctDataType);
                    break;
                }
                case 2: {
                    n = NIfromMcConverter.toInteger(ctDataType);
                    break;
                }
                case 3: {
                    n2 = NIfromMcConverter.toInteger(ctDataType);
                    break;
                }
                case 4: {
                    l = NIfromMcConverter.toLong(ctDataType);
                    break;
                }
                case 5: {
                    l2 = NIfromMcConverter.toLong(ctDataType);
                    break;
                }
                case 6: {
                    l3 = NIfromMcConverter.toLong(ctDataType);
                    break;
                }
            }
            ++n3;
        }
        return new NIExtentSummaryResultImpl(true, 0L, nIVolumeID, nIExtentType, n, n2, l, l2, l3);
    }

    private NIQueryRankExtentsResult fromQueryRankExtentsAction(McActionRsp[] mcActionRspArray, NIESSID nIESSID) throws NIServerException {
        NIVolumeID nIVolumeID = null;
        Vector<NIRankID> vector = new Vector<NIRankID>();
        NIVolumeType nIVolumeType = null;
        int n = 0;
        boolean bl = false;
        HashMap<NIRankID, Long> hashMap = new HashMap<NIRankID, Long>();
        CtStructuredData ctStructuredData = mcActionRspArray[0].getData()[0];
        int n2 = 0;
        while (n2 < ctStructuredData.getElementCount()) {
            CtDataType ctDataType = null;
            try {
                ctDataType = ctStructuredData.getData(n2);
            }
            catch (Exception exception) {
                logger.error("Caught exception from CtStructuredData.getData(int) on element " + n2 + ".");
                logger.throwable((Throwable)exception);
                throw new NIServerException(1, "Caught exception from CtStructuredData.getData(int) on element " + n2 + ".");
            }
            switch (n2) {
                case 0: {
                    nIVolumeID = NIfromMcConverter.toVolumeID((CtDataType)new CtString(nIESSID.toString()), ctDataType);
                    break;
                }
                case 1: {
                    nIVolumeType = NIfromMcConverter.toVolumeType(ctDataType);
                    break;
                }
                case 2: {
                    n = NIfromMcConverter.toInteger(ctDataType);
                    break;
                }
                case 3: {
                    bl = NIfromMcConverter.toBoolean(ctDataType);
                    break;
                }
            }
            ++n2;
        }
        int n3 = 1;
        while (n3 < mcActionRspArray[0].getData().length) {
            ctStructuredData = mcActionRspArray[0].getData()[n3];
            CtDataType ctDataType = null;
            CtDataType ctDataType2 = null;
            try {
                ctDataType = ctStructuredData.getData(0);
                ctDataType2 = ctStructuredData.getData(1);
            }
            catch (Exception exception) {
                logger.error("Caught exception from CtStructuredData.getData(int) on element " + n3 + ".");
                logger.throwable((Throwable)exception);
                throw new NIServerException(1, "Caught exception from CtStructuredData.getData(int) on element " + n3 + ".");
            }
            NIRankID nIRankID = NIfromMcConverter.toRankID((CtDataType)new CtString(nIESSID.toString()), ctDataType);
            Long l = new Long(NIfromMcConverter.toLong(ctDataType2));
            vector.add(nIRankID);
            hashMap.put(nIRankID, l);
            ++n3;
        }
        return new NIQueryRankExtentsResultImpl(true, 0L, nIVolumeID, nIVolumeType, bl, n, vector, hashMap);
    }

    private String toSelectString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("logicalVolumeNumber!=\"");
        stringBuffer.append("FFFF");
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    private String toSelectString(NIAddressGroupID nIAddressGroupID) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("addressGroup==\"");
        stringBuffer.append(nIAddressGroupID.getAddressGroupNumber() + "\"");
        return stringBuffer.toString();
    }

    private String toSelectString(NILSSGroupID nILSSGroupID) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("lssGroup==");
        stringBuffer.append(nILSSGroupID.getLSSGroupNumber());
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Constants {
        public static final String CLASS_NAME = "IBM.EssLogicalVolume";

        public static interface ClassAct {
            public static final String CREATE_VOLUMES = "createVolumes";
        }

        public static interface RsrcAct {
            public static final String QUERY_EXTENT_SUMMARY = "queryExtentSummary";
            public static final String QUERY_RANK_EXTENTS = "queryRankExtents";
            public static final String UNFENCE = "unfence";
        }

        public static interface Attr {
            public static final String SFI_MTMS = "storageFacilityImageMTMS";
            public static final String ACCESS_STATE = "accessState";
            public static final String ADDRESS_GROUP = "addressGroup";
            public static final String ALIAS_VOLUME_GROUP = "aliasVolumeGroup";
            public static final String CAPACITY = "capacity";
            public static final String CONFIG_STATE = "configurationState";
            public static final String CREATION_DATE = "creationDate";
            public static final String DATA_STATE = "dataState";
            public static final String DATA_SHARING_ALLOWED = "dataSharingAllowed";
            public static final String DATA_TYPE = "dataType";
            public static final String DEVICE_MTM = "deviceMTM";
            public static final String DYNAMIC_EXTENT_ALLOCATION = "dynamicSegmentAllocation";
            public static final String EXTENT_POOL = "segmentPool";
            public static final String LOGICAL_VOLUME_NUMBER = "logicalVolumeNumber";
            public static final String LSS = "logicalSubsystem";
            public static final String ORIGINAL_BASE_VOLUME_NUM = "originalBaseLogicalVolumeNumber";
            public static final String OVERRIDE_DEFAULT_PRIORITY = "overrideDefaultPriority";
            public static final String OVERRIDE_DEFAULT_PRIORITY_VALUE = "overrideDefaultPriorityValue";
            public static final String REQUESTED_CAPACITY = "requestedCapacity";
            public static final String USER_NAME = "userName";
            public static final String VOLUME_TYPE = "volumeType";
            public static final String LSS_GROUP = "lssGroup";
            public static final String ERROR_CODE = "errorCode";
        }
    }
}

