/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.hmc;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.agent.common.NIConfigServiceAgent;
import com.ibm.storage.ess.ni.agent.common.convert.domain.NIESSConverter;
import com.ibm.storage.ess.ni.agent.common.convert.domain.NIStorageFacilityConverter;
import com.ibm.storage.ess.ni.agent.common.convert.domain.NIStoragePlexConverter;
import com.ibm.storage.ess.ni.agent.common.rmcutil.NIMcSessionManager;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIStorageFacility;
import com.ibm.storage.ess.ni.application.resource.NIStoragePlex;
import com.ibm.storage.ess.ni.application.resource.NIVersion;
import com.ibm.storage.ess.ni.application.results.NICalendarResult;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIConfigResult;
import com.ibm.storage.ess.ni.application.results.NIHarvestProgressResult;
import com.ibm.storage.ess.ni.application.results.NIVPNResult;
import com.ibm.storage.ess.ni.command.extensions.NIUpdateSNMPSettingsCommand;
import com.ibm.storage.ess.ni.commandagent.NICommandAgent;
import com.ibm.storage.ess.ni.commandagent.NICommandAgentStartupException;
import com.ibm.storage.ess.ni.eventManager.snmp.NISNMPManager;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlMode;
import com.ibm.storage.ess.ni.resource.NIVersionImpl;
import com.ibm.storage.ess.ni.results.NIConfigQueryResultImpl;
import com.ibm.storage.ess.ni.results.NIVPNResultImpl;
import com.ibm.storage.ess.ni.services.NIDomainService;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;

public class NIDomainServiceAgent
extends NIConfigServiceAgent
implements NIDomainService {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$hmc$NIDomainServiceAgent == null ? (class$com$ibm$storage$ess$ni$agent$hmc$NIDomainServiceAgent = NIDomainServiceAgent.class$("com.ibm.storage.ess.ni.agent.hmc.NIDomainServiceAgent")) : class$com$ibm$storage$ess$ni$agent$hmc$NIDomainServiceAgent);
    private static final String LIC_VERSION_SCRIPT = "/opt/esshmc/bin/rsCdaGetHmcVrmf.sh";
    private static final String VPN_CONNECTION_EXE = "/opt/ccfw/bin/framework/completeCallbackSequence";
    private static final String LIC_VERSION_FILE = "com.ibm.storage.ess.ni.licversion";
    private static final String LIC_VERSION_ID = "LIC EC IDENTIFICATION NUMBER: ";
    private NICommandAgent parentCommandAgent;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$hmc$NIDomainServiceAgent;

    public NIDomainServiceAgent(NICommandAgent nICommandAgent) throws NICommandAgentStartupException {
        this.parentCommandAgent = nICommandAgent;
    }

    public NIConfigQueryResult getStoragePlex() throws NIServerException {
        return this.executeQuery("IBM.EssStoragePlex", null, new NIStoragePlexConverter());
    }

    public NIConfigResult modifyStoragePlex(NIStoragePlex nIStoragePlex) throws NIServerException {
        NIConfigResult nIConfigResult = this.executeModify("IBM.EssStoragePlex", nIStoragePlex, new NIStoragePlexConverter());
        if (nIConfigResult.isSuccessful()) {
            NISNMPManager.getMMSNMPManager().setTrapInformation(nIStoragePlex);
            NIUpdateSNMPSettingsCommand nIUpdateSNMPSettingsCommand = new NIUpdateSNMPSettingsCommand(nIStoragePlex);
            this.parentCommandAgent.sendToPeer(nIUpdateSNMPSettingsCommand);
        }
        return nIConfigResult;
    }

    public NIConfigQueryResult getStorageFacilities() throws NIServerException {
        return this.executeQuery("IBM.EssStorageFacility", null, new NIStorageFacilityConverter());
    }

    public NIConfigQueryResult getStorageFacilities(NIStorageFacilityID[] nIStorageFacilityIDArray) throws NIServerException {
        String string = this.createIdQueryString(nIStorageFacilityIDArray, new NIStorageFacilityConverter());
        return this.executeQuery("IBM.EssStorageFacility", string, new NIStorageFacilityConverter());
    }

    public NIConfigResult modifyStorageFacility(NIStorageFacility nIStorageFacility) throws NIServerException {
        return this.executeModify("IBM.EssStorageFacility", nIStorageFacility, new NIStorageFacilityConverter());
    }

    public NIConfigResult manualPowerOn(NIStorageFacility nIStorageFacility) throws NIServerException {
        NIStorageFacilityConverter nIStorageFacilityConverter = new NIStorageFacilityConverter();
        return this.executeAction("IBM.EssStorageFacility", nIStorageFacility.getID(), nIStorageFacilityConverter, "manualPowerOn", nIStorageFacilityConverter.toPowerOnAction());
    }

    public NIConfigResult manualPowerOff(NIStorageFacility nIStorageFacility) throws NIServerException {
        NIStorageFacilityConverter nIStorageFacilityConverter = new NIStorageFacilityConverter();
        return this.executeAction("IBM.EssStorageFacility", nIStorageFacility.getID(), nIStorageFacilityConverter, "manualPowerOff", nIStorageFacilityConverter.toPowerOffAction());
    }

    public NIConfigResult requestPowerControlMode(NIStorageFacilityID nIStorageFacilityID, NISFPowerControlMode nISFPowerControlMode) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIStorageFacilityConverter nIStorageFacilityConverter = new NIStorageFacilityConverter();
        return this.executeAction("IBM.EssStorageFacility", nIStorageFacilityID, nIStorageFacilityConverter, "requestPowerControlMode", nIStorageFacilityConverter.toRequestPowerControlAction(nISFPowerControlMode));
    }

    public NIConfigResult forceOffline(NIStorageFacility nIStorageFacility) throws NIServerException {
        throw new NIUnsupportedException("Command not yet supported.");
    }

    public NIConfigQueryResult getESSs() throws NIServerException {
        return this.executeQuery("IBM.EssStorageFacilityImage", null, new NIESSConverter(), NIMcSessionManager.remoteSession);
    }

    public NIConfigQueryResult getESSs(NIESSID[] nIESSIDArray) throws NIServerException {
        String string = this.createIdQueryString(nIESSIDArray, new NIESSConverter());
        return this.executeQuery("IBM.EssStorageFacilityImage", string, new NIESSConverter(), NIMcSessionManager.remoteSession);
    }

    public NIConfigQueryResult getESSs(NIStorageFacilityID nIStorageFacilityID) throws NIServerException {
        String string = new NIESSConverter().toSelectStringWithSF(nIStorageFacilityID);
        return this.executeQuery("IBM.EssStorageFacilityImage", string, new NIESSConverter(), NIMcSessionManager.remoteSession);
    }

    public NIConfigResult modifyESS(NIESS nIESS) throws NIServerException {
        return this.executeModify("IBM.EssStorageFacilityImage", nIESS, new NIESSConverter(), NIMcSessionManager.remoteSession);
    }

    public NIConfigResult forceOffline(NIESSID nIESSID) throws NIServerException {
        throw new NIUnsupportedException("Command not yet supported.");
    }

    public NIConfigQueryResult getStorageFacility(NIStorageFacilityID nIStorageFacilityID) throws NIServerException {
        return this.getStorageFacilities(new NIStorageFacilityID[]{nIStorageFacilityID});
    }

    public NIConfigQueryResult getStoragePlex(NIESSID nIESSID) throws NIServerException {
        return this.getStoragePlex();
    }

    public NIConfigQueryResult getAllESS() throws NIServerException {
        NIConfigQueryResult nIConfigQueryResult;
        NIConfigQueryResult nIConfigQueryResult2 = this.getESSs();
        if (nIConfigQueryResult2.getCode() != 0) {
            nIConfigQueryResult = nIConfigQueryResult2;
        } else {
            ArrayList<NIResourceID> arrayList = new ArrayList<NIResourceID>();
            Iterator iterator = nIConfigQueryResult2.getResourceList().iterator();
            while (iterator.hasNext()) {
                NIESS nIESS = (NIESS)iterator.next();
                arrayList.add(nIESS.getID());
            }
            nIConfigQueryResult = new NIConfigQueryResultImpl(arrayList, true, 0L);
        }
        return nIConfigQueryResult;
    }

    public NICalendarResult getCalendar(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("Command not supported on 2105 or 2107.");
    }

    public NICalendarResult setCalendar(NIESSID nIESSID, Calendar calendar) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("Command not supported on 2105 or 2107.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIVersion getManagementLevel() throws NIServerException {
        NIVersionImpl nIVersionImpl;
        String string = null;
        boolean bl = NIAgentProperties.getAgentType() == 1 || NIAgentProperties.getAgentType() == 10;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            int n;
            Object object;
            String[] stringArray;
            String string2;
            if (!bl) {
                process = Runtime.getRuntime().exec(LIC_VERSION_SCRIPT);
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                string2 = bufferedReader.readLine();
                while (string2 != null) {
                    if (!string2.trim().equals("")) {
                        string = string2;
                    }
                    string2 = bufferedReader.readLine();
                }
            } else {
                stringArray = System.getProperty("file.separator");
                object = System.getProperty(LIC_VERSION_FILE, ".." + (String)stringArray + "etc" + (String)stringArray + "SEA.README");
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream((String)object)));
                do {
                    if ((string2 = bufferedReader.readLine()) != null) continue;
                    logger.error("LIC EC IDENTIFICATION NUMBER was not found in the lic file.");
                } while ((n = string2.indexOf(LIC_VERSION_ID)) == -1);
                string = string2.substring(n + LIC_VERSION_ID.length()).trim();
            }
            stringArray = string.split("\\.");
            object = new int[stringArray.length];
            n = 0;
            while (n < stringArray.length) {
                object[n] = Integer.parseInt(stringArray[n]);
                ++n;
            }
            nIVersionImpl = new NIVersionImpl((int[])object);
        }
        catch (Exception exception) {
            logger.error("Returing dummy version, exception was caught while retrieving version:");
            logger.throwable((Throwable)exception);
            nIVersionImpl = new NIVersionImpl(new int[]{0, 0, 0, 0});
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                }
            }
            if (process != null) {
                try {
                    process.getInputStream().close();
                    process.getOutputStream().close();
                    process.getErrorStream().close();
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                }
            }
        }
        return nIVersionImpl;
    }

    public NIHarvestProgressResult getHarvestProgress(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("Command not supported on 2105 or 2107.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NIVPNResult initiateRemoteSupportVPN(int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIVPNResultImpl nIVPNResultImpl = null;
        String string = null;
        int n2 = -99;
        Process process = null;
        BufferedReader bufferedReader = null;
        try {
            process = Runtime.getRuntime().exec(VPN_CONNECTION_EXE);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string = bufferedReader.readLine().trim();
            n2 = Integer.parseInt(string);
            switch (n2) {
                case 1: {
                    logger.trace("VPN CONNECTION VIA MODEM SUCCESSED. RAS rc= " + n2);
                    nIVPNResultImpl = new NIVPNResultImpl(false, 1);
                    return nIVPNResultImpl;
                }
                case 2: {
                    logger.trace("VPN CONNECTION VIA NETWORK SUCCESSED. RAS rc= " + n2);
                    nIVPNResultImpl = new NIVPNResultImpl(false, 2);
                    return nIVPNResultImpl;
                }
                case -3: {
                    logger.error("VPN CONNECTION FAILED. HMC CANNOT MAKE SECURE CONNECTION. RAS rc= " + n2);
                    nIVPNResultImpl = new NIVPNResultImpl(false, -1099688701);
                    return nIVPNResultImpl;
                }
                case -1: {
                    logger.error("VPN CONNECTION FAILED. HMC NOT CONFIGURED AS CALL HOME SERVER. RAS rc= " + n2);
                    nIVPNResultImpl = new NIVPNResultImpl(false, -1099688703);
                    return nIVPNResultImpl;
                }
                case -2: {
                    logger.error("VPN CONNECTION FAILED. HMC OUTBOUND CONNECTIVITY NOT CONFIGURED PROPERLY. RAS rc= " + n2);
                    nIVPNResultImpl = new NIVPNResultImpl(false, -1099688702);
                    return nIVPNResultImpl;
                }
                default: {
                    logger.error("VPN CONNECTION FAILED DUE TO INTERNAL ERROR. rc= 0x" + Integer.toHexString(-1099694074));
                    logger.error("********** RAS rc= " + n2 + "**************** ");
                    nIVPNResultImpl = new NIVPNResultImpl(false, -1099694074);
                    return nIVPNResultImpl;
                }
            }
        }
        catch (Exception exception) {
            logger.error("Returing dummy VPNResult, exception was caught while executing the script");
            logger.throwable((Throwable)exception);
            nIVPNResultImpl = new NIVPNResultImpl(false, -1099688695);
            return nIVPNResultImpl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                }
            }
            if (process != null) {
                try {
                    process.getInputStream().close();
                    process.getOutputStream().close();
                    process.getErrorStream().close();
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

