/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.hmc;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIESSDomainElement;
import com.ibm.storage.ess.ni.application.resource.NIPeerConfigurationElement;
import com.ibm.storage.ess.ni.application.results.NIESSDomainResult;
import com.ibm.storage.ess.ni.application.results.NIPeerConfigurationResult;
import com.ibm.storage.ess.ni.communication.connection.NIConnectionFactory;
import com.ibm.storage.ess.ni.event.extensions.NIESSDomainElementAddedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIESSDomainElementModifiedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIESSDomainElementRemovedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIPeerDeletedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIPeerSetEventImpl;
import com.ibm.storage.ess.ni.eventManager.server.NIEventForwarder;
import com.ibm.storage.ess.ni.eventManager.server.NIEventServerImpl;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConfigurationInterface;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterEssNodeData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterEstablishConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterOutputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterSocketConnection;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.resource.NIESSDomainElementImpl;
import com.ibm.storage.ess.ni.resource.NIPeerConfigurationElementImpl;
import com.ibm.storage.ess.ni.results.NIESSDomainResultImpl;
import com.ibm.storage.ess.ni.results.NIPeerConfigurationResultImpl;
import com.ibm.storage.ess.ni.security.NISecuritySynchronizer;
import com.ibm.storage.ess.ni.services.NIInitialConfigurationService;
import com.ibm.storage.ess.ni.util.NICircularBufferOverflowException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class NIInitialConfigurationServiceImpl
implements NIInitialConfigurationService {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$hmc$NIInitialConfigurationServiceImpl == null ? (class$com$ibm$storage$ess$ni$agent$hmc$NIInitialConfigurationServiceImpl = NIInitialConfigurationServiceImpl.class$("com.ibm.storage.ess.ni.agent.hmc.NIInitialConfigurationServiceImpl")) : class$com$ibm$storage$ess$ni$agent$hmc$NIInitialConfigurationServiceImpl);
    NIMessageRouterConfigurationInterface messageRouterSM;
    public int BOX_INFO_SERVER_PORT = 1794;
    private static int POLL_TIME = 250;
    private NIMessageRouterEstablishConnectionMonitor establisher = NIMessageRouterEstablishConnectionMonitor.getConnectionTable();
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$hmc$NIInitialConfigurationServiceImpl;

    public NIInitialConfigurationServiceImpl() {
        this.messageRouterSM = (NIMessageRouterConfigurationInterface)NIMessageRouterFactory.getInstanceOf();
    }

    public NIESSDomainResult getDomainConfig() throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIESSDomainResultImpl nIESSDomainResultImpl;
        NIESSDomainElement[] nIESSDomainElementArray = new NIESSDomainElement[]{};
        Vector vector = (Vector)this.messageRouterSM.getAllKnownEssNodes();
        InetAddress[] inetAddressArray = this.messageRouterSM.getPeerIPAddresses();
        int n = -1;
        if (vector.size() == 0) {
            nIESSDomainResultImpl = new NIESSDomainResultImpl(nIESSDomainElementArray, n, true, 0L);
        } else {
            nIESSDomainElementArray = new NIESSDomainElement[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                nIESSDomainElementArray[n2] = new NIESSDomainElementImpl((NIMessageRouterEssNodeData)vector.get(n2));
                if (inetAddressArray.length > 0 && nIESSDomainElementArray[n2].getLeftNode().equals(inetAddressArray[0])) {
                    n = n2;
                }
                ++n2;
            }
            nIESSDomainResultImpl = new NIESSDomainResultImpl(nIESSDomainElementArray, n, true, 0L);
        }
        return nIESSDomainResultImpl;
    }

    public NIESSDomainResult getESSs() throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIESSDomainResultImpl nIESSDomainResultImpl;
        Vector vector = (Vector)this.messageRouterSM.getAllKnownEssNodes();
        Hashtable<String, NIESSDomainElementImpl> hashtable = new Hashtable<String, NIESSDomainElementImpl>(2, 1.0f);
        int n = -1;
        if (vector.size() == 0) {
            Vector vector2 = new Vector(0);
            nIESSDomainResultImpl = new NIESSDomainResultImpl(vector2, true, 0L);
        } else {
            Enumeration<Object> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                NIMessageRouterEssNodeData nIMessageRouterEssNodeData = (NIMessageRouterEssNodeData)enumeration.nextElement();
                if (nIMessageRouterEssNodeData.getDomainGroupID().equals("HMC")) continue;
                NIESSDomainElementImpl nIESSDomainElementImpl = (NIESSDomainElementImpl)hashtable.get(nIMessageRouterEssNodeData.getDomainGroupID());
                if (nIESSDomainElementImpl == null) {
                    nIESSDomainElementImpl = new NIESSDomainElementImpl(new NIESSID(nIMessageRouterEssNodeData.getDomainGroupID()));
                }
                if (nIMessageRouterEssNodeData.getEssServerName().endsWith("0")) {
                    nIESSDomainElementImpl.setLeftNode(nIMessageRouterEssNodeData.getPrimaryIP());
                } else {
                    nIESSDomainElementImpl.setRightNode(nIMessageRouterEssNodeData.getSecondaryIP());
                }
                hashtable.put(nIMessageRouterEssNodeData.getDomainGroupID(), nIESSDomainElementImpl);
            }
            boolean bl = false;
            Vector<NIESSDomainElement> vector3 = new Vector<NIESSDomainElement>(hashtable.size());
            enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                vector3.add((NIESSDomainElement)enumeration.nextElement());
            }
            nIESSDomainResultImpl = new NIESSDomainResultImpl(vector3, true, 0L);
        }
        return nIESSDomainResultImpl;
    }

    public NIESSDomainResult addESS(NIESSDomainElement nIESSDomainElement) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIESSDomainResultImpl nIESSDomainResultImpl = null;
        if (nIESSDomainElement == null || nIESSDomainElement.getESS() == null || nIESSDomainElement.getLeftNode() == null || nIESSDomainElement.getRightNode() == null) {
            logger.error("NULL Storage unit address.");
            return new NIESSDomainResultImpl((List)null, false, -1099694077L);
        }
        NIMessageRouterEssNodeData nIMessageRouterEssNodeData = this.messageRouterSM.getEssNode(nIESSDomainElement.getESS() + "0");
        NIMessageRouterEssNodeData nIMessageRouterEssNodeData2 = this.messageRouterSM.getEssNode(nIESSDomainElement.getESS() + "1");
        NIESSDomainElementImpl nIESSDomainElementImpl = new NIESSDomainElementImpl(nIESSDomainElement.getESS());
        if (nIMessageRouterEssNodeData != null) {
            nIESSDomainElementImpl.setLeftNode(nIMessageRouterEssNodeData.getPrimaryIP());
        }
        if (nIMessageRouterEssNodeData2 != null) {
            nIESSDomainElementImpl.setRightNode(nIMessageRouterEssNodeData2.getSecondaryIP());
        }
        if (!nIESSDomainElementImpl.equals(nIESSDomainElement)) {
            NIMessageRouterReturnStatus nIMessageRouterReturnStatus;
            NIMessageRouterReturnStatus nIMessageRouterReturnStatus2;
            try {
                NIMessageRouterEssNodeData nIMessageRouterEssNodeData3 = new NIMessageRouterEssNodeData(nIESSDomainElement.getESS().toString() + "0", nIESSDomainElement.getLeftNode(), nIESSDomainElement.getESS().toString());
                nIMessageRouterReturnStatus2 = this.messageRouterSM.addEssNode(nIMessageRouterEssNodeData3);
                nIMessageRouterEssNodeData3 = new NIMessageRouterEssNodeData(nIESSDomainElement.getESS().toString() + "1", nIESSDomainElement.getRightNode(), nIESSDomainElement.getESS().toString());
                nIMessageRouterReturnStatus = this.messageRouterSM.addEssNode(nIMessageRouterEssNodeData3);
            }
            catch (Exception exception) {
                logger.error("Exception during add storage unit");
                logger.throwable((Throwable)exception);
                nIESSDomainResultImpl = new NIESSDomainResultImpl((List)null, false, 2L);
                return nIESSDomainResultImpl;
            }
            if (nIMessageRouterReturnStatus2.getStatus() == 9 && nIMessageRouterReturnStatus.getStatus() == 9) {
                nIESSDomainResultImpl = new NIESSDomainResultImpl((List)null, true, 0L);
            } else if (nIMessageRouterReturnStatus2.getStatus() == -12 || nIMessageRouterReturnStatus.getStatus() == -12) {
                logger.error("Storage unit kona is offline [" + nIMessageRouterReturnStatus2.getStatus() + ", " + nIMessageRouterReturnStatus.getStatus() + "]");
                nIESSDomainResultImpl = new NIESSDomainResultImpl((List)null, false, -1099694070L);
            }
            NIEventForwarder nIEventForwarder = NIEventServerImpl.getForwarder();
            if (nIMessageRouterEssNodeData == null && nIMessageRouterEssNodeData2 == null) {
                nIEventForwarder.forwardEvent(new NIESSDomainElementAddedEventImpl(nIESSDomainElement));
            } else {
                nIEventForwarder.forwardEvent(new NIESSDomainElementModifiedEventImpl(nIESSDomainElementImpl, nIESSDomainElement));
            }
        } else {
            nIESSDomainResultImpl = new NIESSDomainResultImpl((List)null, true, 0L);
        }
        return nIESSDomainResultImpl;
    }

    public NIESSDomainResult removeESS(NIESSDomainElement nIESSDomainElement) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIESSDomainResultImpl nIESSDomainResultImpl;
        if (nIESSDomainElement == null || nIESSDomainElement.getESS() == null) {
            logger.error("NULL Storage unit address.");
            return new NIESSDomainResultImpl((List)null, false, -1099694077L);
        }
        NIESSDomainElementImpl nIESSDomainElementImpl = new NIESSDomainElementImpl(nIESSDomainElement.getESS());
        try {
            NIMessageRouterEssNodeData nIMessageRouterEssNodeData;
            NIMessageRouterEssNodeData nIMessageRouterEssNodeData2 = this.messageRouterSM.getEssNode(nIESSDomainElement.getESS() + "0");
            if (nIMessageRouterEssNodeData2 != null) {
                this.messageRouterSM.removeEssNode(nIMessageRouterEssNodeData2);
                nIESSDomainElementImpl.setLeftNode(nIMessageRouterEssNodeData2.getPrimaryIP());
            }
            if ((nIMessageRouterEssNodeData = this.messageRouterSM.getEssNode(nIESSDomainElement.getESS() + "1")) != null) {
                this.messageRouterSM.removeEssNode(nIMessageRouterEssNodeData);
                nIESSDomainElementImpl.setRightNode(nIMessageRouterEssNodeData.getSecondaryIP());
            }
            if (nIMessageRouterEssNodeData2 != null || nIMessageRouterEssNodeData != null) {
                NIEventForwarder nIEventForwarder = NIEventServerImpl.getForwarder();
                nIEventForwarder.forwardEvent(new NIESSDomainElementRemovedEventImpl(nIESSDomainElementImpl));
            }
            nIESSDomainResultImpl = new NIESSDomainResultImpl((List)null, true, 0L);
        }
        catch (Exception exception) {
            nIESSDomainResultImpl = new NIESSDomainResultImpl((List)null, false, 2L);
        }
        return nIESSDomainResultImpl;
    }

    public NIESSDomainResult testConnection(NIESSDomainElement nIESSDomainElement) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIESSDomainResultImpl nIESSDomainResultImpl = null;
        boolean bl = false;
        boolean bl2 = false;
        NIESSID nIESSID = nIESSDomainElement.getESS();
        try {
            NIMessageRouterEssNodeData nIMessageRouterEssNodeData = new NIMessageRouterEssNodeData(nIESSID.toString() + "0", null, nIESSID.toString());
            if (this.messageRouterSM.isNodeConnected(nIMessageRouterEssNodeData).getStatus() == 9) {
                bl = true;
            }
            if (this.messageRouterSM.isNodeConnected(nIMessageRouterEssNodeData = new NIMessageRouterEssNodeData(nIESSID.toString() + "1", null, nIESSID.toString())).getStatus() == 9) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            nIESSDomainResultImpl = new NIESSDomainResultImpl((List)null, false, 2L);
            return nIESSDomainResultImpl;
        }
        if (bl && bl2) {
            nIESSDomainResultImpl = new NIESSDomainResultImpl((List)null, true, 0L);
        } else if (!bl && !bl2) {
            nIESSDomainResultImpl = new NIESSDomainResultImpl((List)null, false, 2L);
        } else if (!bl) {
            nIESSDomainResultImpl = new NIESSDomainResultImpl((List)null, false, -1099694072L);
        } else if (!bl2) {
            nIESSDomainResultImpl = new NIESSDomainResultImpl((List)null, false, -1099694071L);
        }
        return nIESSDomainResultImpl;
    }

    public NIPeerConfigurationResult setPeer(NIPeerConfigurationElement nIPeerConfigurationElement) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIPeerConfigurationResultImpl nIPeerConfigurationResultImpl;
        block16: {
            NISecuritySynchronizer nISecuritySynchronizer = NISecuritySynchronizer.getSecuritySynchronizer();
            String string = "HMC2";
            boolean bl = false;
            logger.debug_general("NIInitialConfiguration.setPeer(" + nIPeerConfigurationElement.toString() + ")");
            try {
                logger.debug_general("  Peer found to be " + string);
                if (nIPeerConfigurationElement == null || nIPeerConfigurationElement.getSecondaryNodeIP() == null) {
                    logger.error("NULL peer IP address.");
                    return new NIPeerConfigurationResultImpl(nIPeerConfigurationElement, false, -1099694077L);
                }
                if (nIPeerConfigurationElement.getSecondaryNodeIP().isLoopbackAddress()) {
                    logger.error("Peer address given as loopback address... failing for invalid parameters");
                    return new NIPeerConfigurationResultImpl(nIPeerConfigurationElement, false, -1099694077L);
                }
                Object object = NIMessageRouterMetaData.getPrimaryInetAddress();
                if (nIPeerConfigurationElement.getSecondaryNodeIP().equals(object)) {
                    logger.error("Peer address given is the address of this server.... invalid parms");
                    return new NIPeerConfigurationResultImpl(nIPeerConfigurationElement, false, -1099694077L);
                }
                NIMessageRouterEssNodeData nIMessageRouterEssNodeData = new NIMessageRouterEssNodeData("HMC2", nIPeerConfigurationElement.getSecondaryNodeIP(), "HMC");
                object = this.messageRouterSM.addManagementPeerNode(nIMessageRouterEssNodeData);
                if (((NIMessageRouterReturnStatus)object).getStatus() == 9) {
                    nIPeerConfigurationResultImpl = new NIPeerConfigurationResultImpl(nIPeerConfigurationElement, true, 0L);
                    NIEventForwarder nIEventForwarder = NIEventServerImpl.getForwarder();
                    nIEventForwarder.forwardEvent(new NIPeerSetEventImpl(nIPeerConfigurationElement));
                    nISecuritySynchronizer.addPeer(string);
                    bl = true;
                    NIMessageRouterEssNodeData nIMessageRouterEssNodeData2 = this.messageRouterSM.getEssNode("HMC1");
                    NIMessageRouterEssNodeData nIMessageRouterEssNodeData3 = this.messageRouterSM.getEssNode("HMC2");
                    NIPeerConfigurationElementImpl nIPeerConfigurationElementImpl = new NIPeerConfigurationElementImpl(nIMessageRouterEssNodeData3.getPrimaryIP(), nIMessageRouterEssNodeData2.getPrimaryIP());
                    NIPeerSetEventImpl nIPeerSetEventImpl = new NIPeerSetEventImpl(nIPeerConfigurationElementImpl);
                    try {
                        NIMessageRouterChannel nIMessageRouterChannel;
                        NIMessageRouter nIMessageRouter;
                        block15: {
                            nIMessageRouter = NIMessageRouterFactory.getInstanceOf();
                            nIMessageRouterChannel = nIMessageRouter.createNIMessageRouterChannel(8);
                            NIMessageRouterOutputStream nIMessageRouterOutputStream = nIMessageRouterChannel.getNIMessageRouterOutputStream();
                            NIMessageRouterAddress nIMessageRouterAddress = new NIMessageRouterAddress(1710, "HMC2");
                            if (nIMessageRouterOutputStream != null) {
                                try {
                                    NIMessageRouterReturnStatus nIMessageRouterReturnStatus = nIMessageRouterOutputStream.send(nIMessageRouterAddress, nIPeerSetEventImpl);
                                    if (nIMessageRouterReturnStatus.getStatus() == 9) {
                                        logger.debug_general(" Event: " + nIPeerSetEventImpl + "Sent to EventManager on " + nIMessageRouterAddress.getEssServerName());
                                        break block15;
                                    }
                                    logger.debug_general(" send failed for: " + nIPeerSetEventImpl + "MessageRouterReturnStatus; " + nIMessageRouterReturnStatus.getStatus());
                                }
                                catch (NICircularBufferOverflowException nICircularBufferOverflowException) {
                                    logger.error("circular buffer overflow when writing set peer event to mr output stream");
                                    logger.throwable((Throwable)nICircularBufferOverflowException);
                                }
                                catch (IOException iOException) {
                                    logger.error("IOException when trying to send set peer event to HMC2");
                                    logger.throwable((Throwable)iOException);
                                }
                            } else {
                                logger.error("output stream is null when trying to send set peer event to HMC2");
                                logger.error("client connections will not be properly updated");
                            }
                        }
                        nIMessageRouter.destroyNIMessageRouterChannel(nIMessageRouterChannel);
                    }
                    catch (NIMessageRouterException nIMessageRouterException) {
                        logger.error("error creating message router channel for set peer events");
                        logger.throwable((Throwable)nIMessageRouterException);
                    }
                    break block16;
                }
                nIPeerConfigurationResultImpl = new NIPeerConfigurationResultImpl(nIPeerConfigurationElement, false, this.translateReturnCode(((NIMessageRouterReturnStatus)object).getStatus()));
                logger.error(" Unable to add peer rc=" + ((NIMessageRouterReturnStatus)object).getStatus());
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
                if (bl) {
                    nISecuritySynchronizer.removePeer();
                }
                NIPeerConfigurationResultImpl nIPeerConfigurationResultImpl2 = new NIPeerConfigurationResultImpl(nIPeerConfigurationElement, false, 2L);
                return nIPeerConfigurationResultImpl2;
            }
        }
        return nIPeerConfigurationResultImpl;
    }

    public NIPeerConfigurationResult removePeer(NIPeerConfigurationElement nIPeerConfigurationElement) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIPeerConfigurationResultImpl nIPeerConfigurationResultImpl = null;
        NIMessageRouterEssNodeData nIMessageRouterEssNodeData = this.messageRouterSM.getEssNode("HMC1");
        NIMessageRouterEssNodeData nIMessageRouterEssNodeData2 = this.messageRouterSM.getEssNode("HMC2");
        if (nIPeerConfigurationElement == null || nIPeerConfigurationElement.getSecondaryNodeIP() == null) {
            logger.error("Peer IP is null");
            nIPeerConfigurationResultImpl = new NIPeerConfigurationResultImpl(nIPeerConfigurationElement, false, -1099694077L);
        } else if (nIPeerConfigurationElement.getSecondaryNodeIP().isLoopbackAddress()) {
            logger.error("Peer address given as loopback address.... failing for invalid parameters");
            nIPeerConfigurationResultImpl = new NIPeerConfigurationResultImpl(nIPeerConfigurationElement, false, -1099694077L);
        } else if (nIMessageRouterEssNodeData == null || nIMessageRouterEssNodeData2 == null) {
            logger.error("Peer SMC does not exist.");
            nIPeerConfigurationResultImpl = new NIPeerConfigurationResultImpl(nIPeerConfigurationElement, false, -1099694069L);
        } else {
            String string = "NO_ALTERNATE";
            NISecuritySynchronizer nISecuritySynchronizer = NISecuritySynchronizer.getSecuritySynchronizer();
            NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
            if (nIPeerConfigurationElement.getSecondaryNodeIP().equals(nIMessageRouterEssNodeData.getPrimaryIP())) {
                string = nIMessageRouterEssNodeData.getEssServerName();
                nISecuritySynchronizer.removePeer();
                nIMessageRouterReturnStatus = this.messageRouterSM.removeEssNode(nIMessageRouterEssNodeData);
            } else if (nIPeerConfigurationElement.getSecondaryNodeIP().equals(nIMessageRouterEssNodeData2.getPrimaryIP())) {
                string = nIMessageRouterEssNodeData2.getEssServerName();
                nISecuritySynchronizer.removePeer();
                nIMessageRouterReturnStatus = this.messageRouterSM.removeEssNode(nIMessageRouterEssNodeData2);
            } else {
                logger.error("Invalid peer IP address given actual = " + nIPeerConfigurationElement.getSecondaryNodeIP().getHostAddress() + " smc1 = " + nIMessageRouterEssNodeData.getPrimaryIP().getHostAddress() + " smc2 = " + nIMessageRouterEssNodeData2.getPrimaryIP().getHostAddress());
                return new NIPeerConfigurationResultImpl(nIPeerConfigurationElement, false, -1099694077L);
            }
            if (nIMessageRouterReturnStatus.getStatus() == 9 || nIMessageRouterReturnStatus.getStatus() == -12) {
                nIPeerConfigurationResultImpl = new NIPeerConfigurationResultImpl(nIPeerConfigurationElement, true, this.translateReturnCode(nIMessageRouterReturnStatus.getStatus()));
                logger.debug_general("Successfully removed peer ip = " + nIPeerConfigurationElement.getSecondaryNodeIP().getHostAddress() + " rc = " + nIMessageRouterReturnStatus.getStatus());
                NIEventForwarder nIEventForwarder = NIEventServerImpl.getForwarder();
                nIEventForwarder.forwardEvent(new NIPeerDeletedEventImpl(nIPeerConfigurationElement));
            } else {
                logger.error("Remove peer failed MR rc = " + nIMessageRouterReturnStatus.getStatus());
                nISecuritySynchronizer.addPeer(string);
                nIPeerConfigurationResultImpl = new NIPeerConfigurationResultImpl(nIPeerConfigurationElement, false, this.translateReturnCode(nIMessageRouterReturnStatus.getStatus()));
            }
        }
        return nIPeerConfigurationResultImpl;
    }

    private int translateReturnCode(int n) {
        int n2 = 2;
        switch (n) {
            case 9: {
                n2 = 0;
                break;
            }
            case -20: {
                n2 = 2;
                break;
            }
            case -12: {
                n2 = -1099694070;
                break;
            }
            default: {
                logger.error(" Translate return code message router rc = " + n);
                n2 = 1;
            }
        }
        return n2;
    }

    public NIESSDomainResult getMachineInfo(NIESSDomainElement nIESSDomainElement) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        boolean bl;
        NIESSDomainResultImpl nIESSDomainResultImpl = null;
        NIESSDomainElement[] nIESSDomainElementArray = new NIESSDomainElement[]{this.getCecInfo(nIESSDomainElement.getLeftNode()), this.getCecInfo(nIESSDomainElement.getRightNode())};
        boolean bl2 = nIESSDomainElementArray[0] != null;
        boolean bl3 = bl = nIESSDomainElementArray[1] != null;
        if (bl2 && bl) {
            nIESSDomainResultImpl = new NIESSDomainResultImpl(nIESSDomainElementArray, true, 0L);
        } else if (!bl2 && !bl) {
            nIESSDomainResultImpl = new NIESSDomainResultImpl(nIESSDomainElementArray, false, 2L);
        } else if (!bl2) {
            nIESSDomainResultImpl = new NIESSDomainResultImpl(nIESSDomainElementArray, false, -1099694072L);
        } else if (!bl) {
            nIESSDomainResultImpl = new NIESSDomainResultImpl(nIESSDomainElementArray, false, -1099694071L);
        }
        return nIESSDomainResultImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NIESSDomainElement getCecInfo(InetAddress inetAddress) {
        NIConnectionFactory nIConnectionFactory = NIConnectionFactory.getConnectionFactory();
        NIESSDomainElementImpl nIESSDomainElementImpl = null;
        String string = inetAddress.getHostAddress();
        NIMessageRouterSocketConnection nIMessageRouterSocketConnection = new NIMessageRouterSocketConnection(string, inetAddress, this.BOX_INFO_SERVER_PORT, true);
        try {
            this.establisher.add(nIMessageRouterSocketConnection);
            Socket socket = null;
            int n = 0;
            while (n < 5000) {
                Thread.sleep(POLL_TIME);
                socket = this.establisher.get(string).getPrimarySocket();
                if (socket != null) break;
                n += POLL_TIME;
            }
            if (socket == null) {
                throw new Exception();
            }
            String string2 = new BufferedReader(new InputStreamReader(socket.getInputStream())).readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "@");
            if (stringTokenizer.countTokens() < 4) {
                logger.debug_general("Did not receive the correct number of fields.");
            } else {
                logger.debug_general("Receiving box info: " + string2);
                stringTokenizer.nextToken();
                NIESSID nIESSID = new NIESSID(stringTokenizer.nextToken());
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                nIESSDomainElementImpl = new NIESSDomainElementImpl(nIESSID, InetAddress.getByName(string3), InetAddress.getByName(string4), null);
            }
        }
        catch (Exception exception) {
            logger.error("Get info from " + inetAddress + " failed.");
        }
        finally {
            this.establisher.stop(string);
            nIMessageRouterSocketConnection.close();
            nIMessageRouterSocketConnection = null;
            string = null;
        }
        return nIESSDomainElementImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

