/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.hmc;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIUserAccount;
import com.ibm.storage.ess.ni.application.resource.NIUserGroup;
import com.ibm.storage.ess.ni.application.results.auditLog.NIAuditLogResult;
import com.ibm.storage.ess.ni.application.results.security.NIDaysToExpireQueryResult;
import com.ibm.storage.ess.ni.application.results.security.NIGroupsInUserAccountQueryResult;
import com.ibm.storage.ess.ni.application.results.security.NILDAPConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.security.NIMaxFailedLoginsQueryResult;
import com.ibm.storage.ess.ni.application.results.security.NIRepositoryUsedQueryResult;
import com.ibm.storage.ess.ni.application.results.security.NISecurityResult;
import com.ibm.storage.ess.ni.application.results.security.NIUserAccountQueryResult;
import com.ibm.storage.ess.ni.application.results.security.NIUserAccountsInGroupQueryResult;
import com.ibm.storage.ess.ni.application.results.security.NIUserAccountsQueryResult;
import com.ibm.storage.ess.ni.application.results.security.NIUserGroupQueryResult;
import com.ibm.storage.ess.ni.application.results.security.NIUserGroupsQueryResult;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogExportServer;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.resource.NIUserAccountImpl;
import com.ibm.storage.ess.ni.resource.NIUserGroupImpl;
import com.ibm.storage.ess.ni.results.NIAuditLogResultImpl;
import com.ibm.storage.ess.ni.results.NIDaysToExpireQueryResultImpl;
import com.ibm.storage.ess.ni.results.NIGroupsInUserAccountQueryResultImpl;
import com.ibm.storage.ess.ni.results.NILDAPConfigQueryResultImpl;
import com.ibm.storage.ess.ni.results.NIMaxFailedLoginsQueryResultImpl;
import com.ibm.storage.ess.ni.results.NIRepositoryUsedQueryResultImpl;
import com.ibm.storage.ess.ni.results.NISecurityResultImpl;
import com.ibm.storage.ess.ni.results.NIUserAccountQueryResultImpl;
import com.ibm.storage.ess.ni.results.NIUserAccountsInGroupQueryResultImpl;
import com.ibm.storage.ess.ni.results.NIUserAccountsQueryResultImpl;
import com.ibm.storage.ess.ni.results.NIUserGroupQueryResultImpl;
import com.ibm.storage.ess.ni.results.NIUserGroupsQueryResultImpl;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseHelper;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseManager;
import com.ibm.storage.ess.ni.security.NISecuritySynchronizer;
import com.ibm.storage.ess.ni.security.common.NILDAPConfiguration;
import com.ibm.storage.ess.ni.security.common.NIPasswordRules;
import com.ibm.storage.ess.ni.security.common.NISecurityTableEntry;
import com.ibm.storage.ess.ni.security.common.NISynchronizationData;
import com.ibm.storage.ess.ni.services.NISecurityService;
import java.io.File;
import java.util.Vector;

public class NISecurityServiceAgent
implements NISecurityService {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$hmc$NISecurityServiceAgent == null ? (class$com$ibm$storage$ess$ni$agent$hmc$NISecurityServiceAgent = NISecurityServiceAgent.class$("com.ibm.storage.ess.ni.agent.hmc.NISecurityServiceAgent")) : class$com$ibm$storage$ess$ni$agent$hmc$NISecurityServiceAgent);
    private NISecuritySynchronizer syncObject = NISecuritySynchronizer.getSecuritySynchronizer();
    private NISecurityDatabaseHelper databaseHelper = NISecurityDatabaseManager.getDatabaseHelper();
    private boolean localRepositoryUsed;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$hmc$NISecurityServiceAgent;

    public NISecurityServiceAgent() {
        NISecurityTableEntry nISecurityTableEntry = this.databaseHelper.getSecurityEntry();
        if (nISecurityTableEntry != null) {
            this.localRepositoryUsed = nISecurityTableEntry.getRepositoryUsed();
        } else {
            this.localRepositoryUsed = true;
            logger.error("Unable to obtain security settings in order to determine which repository to use");
        }
    }

    public NISecurityResult addUserAccount(NIUserAccount nIUserAccount) throws NIUnsupportedException {
        NISecurityResult nISecurityResult;
        if (this.localRepositoryUsed) {
            String string;
            if (nIUserAccount != null && (string = nIUserAccount.getName()) != null) {
                String string2 = ((NIUserAccountImpl)nIUserAccount).getPassword();
                if (NIPasswordRules.isPasswordFormatValid(string2, string)) {
                    String[] stringArray = this.verifyUserGroups(nIUserAccount.getUserGroups());
                    NIUserAccountImpl nIUserAccountImpl = new NIUserAccountImpl(string, string2, stringArray);
                    NISynchronizationData nISynchronizationData = new NISynchronizationData(1, 1, nIUserAccountImpl, null);
                    nISecurityResult = this.syncObject.performRequest(nISynchronizationData);
                } else {
                    nISecurityResult = new NISecurityResultImpl(false, -1099689725);
                }
            } else {
                nISecurityResult = new NISecurityResultImpl(false, -1099689716);
            }
        } else {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        }
        return nISecurityResult;
    }

    private String[] verifyUserGroups(String[] stringArray) {
        String[] stringArray2;
        String[] stringArray3 = new String[stringArray.length];
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (this.databaseHelper.getUserGroup(stringArray[n2]) != null) {
                stringArray3[n++] = stringArray[n2];
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            stringArray2 = new String[n];
            int n3 = 0;
            while (n3 < n) {
                stringArray2[n3] = stringArray3[n3];
                ++n3;
            }
        } else {
            stringArray2 = null;
        }
        return stringArray2;
    }

    public NISecurityResult deleteUserAccount(String string) throws NIUnsupportedException {
        if (!this.localRepositoryUsed) {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        }
        NISynchronizationData nISynchronizationData = new NISynchronizationData(3, 1, string, null);
        return this.syncObject.performRequest(nISynchronizationData);
    }

    public NISecurityResult modifyUserAccountName(String string, String string2) throws NIUnsupportedException {
        NISecurityResult nISecurityResult;
        if (this.localRepositoryUsed) {
            NIUserAccountImpl nIUserAccountImpl = (NIUserAccountImpl)this.databaseHelper.getUserAccount(string);
            if (nIUserAccountImpl != null) {
                if (string2 != null) {
                    nIUserAccountImpl.setName(string2);
                    NISynchronizationData nISynchronizationData = new NISynchronizationData(2, 1, nIUserAccountImpl, string);
                    nISecurityResult = this.syncObject.performRequest(nISynchronizationData);
                } else {
                    nISecurityResult = new NISecurityResultImpl(false, -1099689716);
                }
            } else {
                nISecurityResult = new NISecurityResultImpl(false, -1099689600);
            }
        } else {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        }
        return nISecurityResult;
    }

    public NISecurityResult modifyUserAccountPassword(String string, String string2) throws NIUnsupportedException {
        NISecurityResult nISecurityResult;
        if (this.localRepositoryUsed) {
            NIUserAccountImpl nIUserAccountImpl = (NIUserAccountImpl)this.databaseHelper.getUserAccount(string);
            if (nIUserAccountImpl != null) {
                boolean bl = nIUserAccountImpl.isPasswordNew(string2);
                if (NIPasswordRules.isPasswordFormatValid(string2, string) && bl) {
                    nIUserAccountImpl.setPassword(string2);
                    NISynchronizationData nISynchronizationData = new NISynchronizationData(2, 1, nIUserAccountImpl, string);
                    nISecurityResult = this.syncObject.performRequest(nISynchronizationData);
                } else {
                    nISecurityResult = !bl ? new NISecurityResultImpl(false, -1099689724) : new NISecurityResultImpl(false, -1099689725);
                }
            } else {
                nISecurityResult = new NISecurityResultImpl(false, -1099689600);
            }
        } else {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        }
        return nISecurityResult;
    }

    public NISecurityResult lockUserAccount(String string) throws NIUnsupportedException {
        NISecurityResult nISecurityResult;
        if (this.localRepositoryUsed) {
            NIUserAccountImpl nIUserAccountImpl = (NIUserAccountImpl)this.databaseHelper.getUserAccount(string);
            if (nIUserAccountImpl != null) {
                nIUserAccountImpl.setAccountLocked(true);
                NISynchronizationData nISynchronizationData = new NISynchronizationData(2, 1, nIUserAccountImpl, string);
                nISecurityResult = this.syncObject.performRequest(nISynchronizationData);
            } else {
                nISecurityResult = new NISecurityResultImpl(false, -1099689600);
            }
        } else {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        }
        return nISecurityResult;
    }

    public NISecurityResult unlockUserAccount(String string) throws NIUnsupportedException {
        NISecurityResult nISecurityResult;
        if (this.localRepositoryUsed) {
            NIUserAccountImpl nIUserAccountImpl = (NIUserAccountImpl)this.databaseHelper.getUserAccount(string);
            if (nIUserAccountImpl != null) {
                nIUserAccountImpl.setAccountLocked(false);
                nIUserAccountImpl.setNumFailedLogins(0);
                NISynchronizationData nISynchronizationData = new NISynchronizationData(2, 1, nIUserAccountImpl, string);
                nISecurityResult = this.syncObject.performRequest(nISynchronizationData);
            } else {
                nISecurityResult = new NISecurityResultImpl(false, -1099689600);
            }
        } else {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        }
        return nISecurityResult;
    }

    public NISecurityResult assignUserAccount(String string, String string2) throws NIUnsupportedException {
        NISecurityResult nISecurityResult;
        if (this.localRepositoryUsed) {
            NIUserAccountImpl nIUserAccountImpl = (NIUserAccountImpl)this.databaseHelper.getUserAccount(string);
            if (nIUserAccountImpl != null) {
                String[] stringArray = new String[]{string2};
                String[] stringArray2 = this.verifyUserGroups(stringArray);
                if (stringArray2 != null && stringArray2.length > 0) {
                    if (nIUserAccountImpl.addUserGroup(string2)) {
                        NISynchronizationData nISynchronizationData = new NISynchronizationData(2, 1, nIUserAccountImpl, string);
                        nISecurityResult = this.syncObject.performRequest(nISynchronizationData);
                    } else {
                        nISecurityResult = new NISecurityResultImpl(true, 0);
                    }
                } else {
                    nISecurityResult = new NISecurityResultImpl(false, -1099689599);
                }
            } else {
                nISecurityResult = new NISecurityResultImpl(false, -1099689600);
            }
        } else {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        }
        return nISecurityResult;
    }

    public NISecurityResult unassignUserAccount(String string, String string2) throws NIUnsupportedException {
        NISecurityResult nISecurityResult;
        if (this.localRepositoryUsed) {
            NIUserAccountImpl nIUserAccountImpl = (NIUserAccountImpl)this.databaseHelper.getUserAccount(string);
            if (nIUserAccountImpl != null) {
                String[] stringArray = new String[]{string2};
                String[] stringArray2 = this.verifyUserGroups(stringArray);
                if (stringArray2 != null && stringArray2.length > 0) {
                    if (nIUserAccountImpl.removeUserGroup(string2)) {
                        NISynchronizationData nISynchronizationData = new NISynchronizationData(2, 1, nIUserAccountImpl, string);
                        nISecurityResult = this.syncObject.performRequest(nISynchronizationData);
                    } else {
                        nISecurityResult = new NISecurityResultImpl(true, 0);
                    }
                } else {
                    nISecurityResult = new NISecurityResultImpl(false, -1099689599);
                }
            } else {
                nISecurityResult = new NISecurityResultImpl(false, -1099689600);
            }
        } else {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        }
        return nISecurityResult;
    }

    public NISecurityResult assignCustomerUserGroup(String string, String string2) throws NIUnsupportedException {
        NISecurityResult nISecurityResult = null;
        if (!this.localRepositoryUsed) {
            NIUserGroupImpl nIUserGroupImpl = (NIUserGroupImpl)this.databaseHelper.getUserGroup(string2);
            if (nIUserGroupImpl != null) {
                nIUserGroupImpl.addCustomerUserGroup(string);
                NISynchronizationData nISynchronizationData = new NISynchronizationData(2, 2, nIUserGroupImpl, null);
                nISecurityResult = this.syncObject.performRequest(nISynchronizationData);
            } else {
                nISecurityResult = new NISecurityResultImpl(false, -1099689599);
            }
        } else {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use the Local ESSNI Security repository");
        }
        return nISecurityResult;
    }

    public NISecurityResult unassignCustomerUserGroup(String string, String string2) throws NIUnsupportedException {
        NISecurityResult nISecurityResult = null;
        if (!this.localRepositoryUsed) {
            NIUserGroupImpl nIUserGroupImpl = (NIUserGroupImpl)this.databaseHelper.getUserGroup(string2);
            if (nIUserGroupImpl != null) {
                nIUserGroupImpl.removeCustomerUserGroup(string);
                NISynchronizationData nISynchronizationData = new NISynchronizationData(2, 2, nIUserGroupImpl, null);
                nISecurityResult = this.syncObject.performRequest(nISynchronizationData);
            } else {
                nISecurityResult = new NISecurityResultImpl(false, -1099689599);
            }
        } else {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use the Local ESSNI Security repository");
        }
        return nISecurityResult;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NISecurityResult setMaxFailedLogins(int n) throws NIUnsupportedException, NIServerException {
        void var3_6;
        NISecurityTableEntry nISecurityTableEntry = this.databaseHelper.getSecurityEntry();
        if (!this.localRepositoryUsed) throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        if (n < 0 || n > 9) throw new NIParameterInvalidServerException(2, (Object)new Integer(n), "The allowable range for the maximum failed logins is 0 through 9");
        if (nISecurityTableEntry != null) {
            nISecurityTableEntry.setMaxFailedLogins(n);
            NISynchronizationData nISynchronizationData = new NISynchronizationData(2, 3, nISecurityTableEntry, null);
            NISecurityResult nISecurityResult = this.syncObject.performRequest(nISynchronizationData);
            return var3_6;
        } else {
            NISecurityResultImpl nISecurityResultImpl = new NISecurityResultImpl(false, -1099689592);
        }
        return var3_6;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NISecurityResult setDaysToExpire(int n) throws NIUnsupportedException, NIServerException {
        void var3_6;
        NISecurityTableEntry nISecurityTableEntry = this.databaseHelper.getSecurityEntry();
        if (!this.localRepositoryUsed) throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        if (n < 0 || n > 9999) throw new NIParameterInvalidServerException(2, (Object)new Integer(n), "The allowable range for the days to expire is 0 through 9999");
        if (nISecurityTableEntry != null) {
            nISecurityTableEntry.setDaysToExpire(n);
            NISynchronizationData nISynchronizationData = new NISynchronizationData(2, 3, nISecurityTableEntry, null);
            NISecurityResult nISecurityResult = this.syncObject.performRequest(nISynchronizationData);
            return var3_6;
        } else {
            NISecurityResultImpl nISecurityResultImpl = new NISecurityResultImpl(false, -1099689592);
        }
        return var3_6;
    }

    public NISecurityResult setRepositoryUsed(boolean bl) throws NIUnsupportedException {
        NISecurityTableEntry nISecurityTableEntry = this.databaseHelper.getSecurityEntry();
        NISecurityResult nISecurityResult = new NISecurityResultImpl(true, 0);
        if (bl) {
            if (nISecurityTableEntry != null) {
                if (nISecurityTableEntry.getRepositoryUsed() != bl) {
                    nISecurityTableEntry.setRepositoryUsed(bl);
                    NISynchronizationData nISynchronizationData = new NISynchronizationData(2, 3, nISecurityTableEntry, null);
                    nISecurityResult = this.syncObject.performRequest(nISynchronizationData);
                }
            } else {
                nISecurityResult = new NISecurityResultImpl(false, -1099689592);
            }
        } else {
            throw new NIUnsupportedException("LDAP is not supported on this level of code");
        }
        return nISecurityResult;
    }

    public NISecurityResult setLDAPconfig(NILDAPConfiguration nILDAPConfiguration) {
        NISecurityResult nISecurityResult;
        NISecurityTableEntry nISecurityTableEntry = this.databaseHelper.getSecurityEntry();
        if (nISecurityTableEntry != null) {
            nISecurityTableEntry.setLDAPConfig(nILDAPConfiguration);
            NISynchronizationData nISynchronizationData = new NISynchronizationData(2, 3, nISecurityTableEntry, null);
            nISecurityResult = this.syncObject.performRequest(nISynchronizationData);
        } else {
            nISecurityResult = new NISecurityResultImpl(false, -1099689592);
        }
        return nISecurityResult;
    }

    public NIUserAccountsQueryResult queryUserAccounts() throws NIUnsupportedException {
        if (!this.localRepositoryUsed) {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        }
        Vector vector = this.databaseHelper.getAllUserAccountNames();
        return new NIUserAccountsQueryResultImpl(true, 0, vector);
    }

    public NIUserAccountQueryResult queryUserAccount(String string) throws NIUnsupportedException {
        NIUserAccountQueryResultImpl nIUserAccountQueryResultImpl;
        NIUserAccount nIUserAccount = this.databaseHelper.getUserAccount(string);
        if (this.localRepositoryUsed) {
            nIUserAccountQueryResultImpl = nIUserAccount != null ? new NIUserAccountQueryResultImpl(true, 0, nIUserAccount) : new NIUserAccountQueryResultImpl(false, -1099689600, null);
        } else {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        }
        return nIUserAccountQueryResultImpl;
    }

    public NIUserGroupsQueryResult queryUserGroups() {
        Vector vector = this.databaseHelper.getAllUserGroupNames();
        return new NIUserGroupsQueryResultImpl(true, 0, vector);
    }

    public NIUserGroupQueryResult queryUserGroup(String string) {
        NIUserGroup nIUserGroup = this.databaseHelper.getUserGroup(string);
        NIUserGroupQueryResultImpl nIUserGroupQueryResultImpl = nIUserGroup != null ? new NIUserGroupQueryResultImpl(true, 0, nIUserGroup) : new NIUserGroupQueryResultImpl(false, -1099689599, null);
        return nIUserGroupQueryResultImpl;
    }

    public NIGroupsInUserAccountQueryResult queryGroupsInUserAccount(String string) throws NIUnsupportedException {
        NIGroupsInUserAccountQueryResultImpl nIGroupsInUserAccountQueryResultImpl = null;
        if (this.localRepositoryUsed) {
            NIUserAccount nIUserAccount = this.databaseHelper.getUserAccount(string);
            if (nIUserAccount != null) {
                String[] stringArray = nIUserAccount.getUserGroups();
                Vector<String> vector = new Vector<String>(stringArray.length);
                int n = 0;
                while (n < stringArray.length) {
                    vector.add(stringArray[n]);
                    ++n;
                }
                nIGroupsInUserAccountQueryResultImpl = new NIGroupsInUserAccountQueryResultImpl(true, 0, vector);
            } else {
                nIGroupsInUserAccountQueryResultImpl = new NIGroupsInUserAccountQueryResultImpl(false, -1099689600, null);
            }
        } else {
            throw new NIUnsupportedException("LDAP is not supported on this level of code");
        }
        return nIGroupsInUserAccountQueryResultImpl;
    }

    public NIUserAccountsInGroupQueryResult queryUserAccountsInGroup(String string) throws NIUnsupportedException {
        NIUserAccountsInGroupQueryResultImpl nIUserAccountsInGroupQueryResultImpl;
        NIUserGroup nIUserGroup = this.databaseHelper.getUserGroup(string);
        if (this.localRepositoryUsed) {
            if (nIUserGroup != null) {
                Vector vector = this.databaseHelper.getAllUserAccounts();
                Vector<String> vector2 = new Vector<String>(vector.size());
                int n = vector.size() - 1;
                while (n >= 0) {
                    boolean bl = false;
                    String[] stringArray = ((NIUserAccount)vector.elementAt(n)).getUserGroups();
                    int n2 = 0;
                    while (!bl && n2 < stringArray.length) {
                        bl = stringArray[n2].equals(string);
                        if (bl) {
                            vector2.add(((NIUserAccount)vector.elementAt(n)).getName());
                        }
                        ++n2;
                    }
                    --n;
                }
                nIUserAccountsInGroupQueryResultImpl = new NIUserAccountsInGroupQueryResultImpl(true, 0, vector2);
            } else {
                nIUserAccountsInGroupQueryResultImpl = new NIUserAccountsInGroupQueryResultImpl(false, -1099689599, null);
            }
        } else {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        }
        return nIUserAccountsInGroupQueryResultImpl;
    }

    public NIMaxFailedLoginsQueryResult queryMaxFailedLogins() throws NIUnsupportedException {
        NIMaxFailedLoginsQueryResultImpl nIMaxFailedLoginsQueryResultImpl;
        NISecurityTableEntry nISecurityTableEntry = this.databaseHelper.getSecurityEntry();
        if (this.localRepositoryUsed) {
            nIMaxFailedLoginsQueryResultImpl = nISecurityTableEntry != null ? new NIMaxFailedLoginsQueryResultImpl(true, 0, nISecurityTableEntry.getMaxFailedLogins()) : new NIMaxFailedLoginsQueryResultImpl(false, -1099689592, 0);
        } else {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        }
        return nIMaxFailedLoginsQueryResultImpl;
    }

    public NIDaysToExpireQueryResult queryDaysToExpire() throws NIUnsupportedException {
        NIDaysToExpireQueryResultImpl nIDaysToExpireQueryResultImpl;
        NISecurityTableEntry nISecurityTableEntry = this.databaseHelper.getSecurityEntry();
        if (this.localRepositoryUsed) {
            nIDaysToExpireQueryResultImpl = nISecurityTableEntry != null ? new NIDaysToExpireQueryResultImpl(true, 0, nISecurityTableEntry.getDaysToExpire()) : new NIDaysToExpireQueryResultImpl(false, -1099689592, 0);
        } else {
            throw new NIUnsupportedException("Not supported when ESSNI Security is configured to use LDAP");
        }
        return nIDaysToExpireQueryResultImpl;
    }

    public NIRepositoryUsedQueryResult queryRepositoryUsed() {
        return new NIRepositoryUsedQueryResultImpl(true, 0, this.localRepositoryUsed);
    }

    public NILDAPConfigQueryResult queryLDAPconfig() {
        NISecurityTableEntry nISecurityTableEntry = this.databaseHelper.getSecurityEntry();
        NILDAPConfigQueryResultImpl nILDAPConfigQueryResultImpl = nISecurityTableEntry != null ? new NILDAPConfigQueryResultImpl(true, 0, nISecurityTableEntry.getLDAPConfig()) : new NILDAPConfigQueryResultImpl(false, -1099689592, null);
        return nILDAPConfigQueryResultImpl;
    }

    public NIAuditLogResult exportAuditLogFile(String string, File file) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIAuditLogResultImpl nIAuditLogResultImpl = null;
        NIAuditLogExportServer nIAuditLogExportServer = NIAuditLogExportServer.getInstance();
        String string2 = nIAuditLogExportServer.generateKey();
        int n = nIAuditLogExportServer.getPort();
        nIAuditLogResultImpl = "KEY_ERROR".equals(string2) ? new NIAuditLogResultImpl(false, 2L, string2, n) : new NIAuditLogResultImpl(true, 0L, string2, n);
        return nIAuditLogResultImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

