/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.cache.NIAgentCache;
import com.ibm.storage.ess.ni.agent.sfiserver.ci.NICpssddInterface;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIOutstandingRequestTable;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIPabsByteOS;
import com.ibm.storage.ess.ni.agent.sfiserver.performance.NIExtentPoolResultBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.performance.NIIOPortResultBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.performance.NIMultiVolumeResultBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.performance.NIRankResultBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.performance.NIVolumeResultBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.utility.NIByteArrayServices;
import com.ibm.storage.ess.ni.application.results.performance.NIExtentPoolPerformanceResult;
import com.ibm.storage.ess.ni.application.results.performance.NIPortPerformanceResult;
import com.ibm.storage.ess.ni.application.results.performance.NIRankPerformanceResult;
import com.ibm.storage.ess.ni.application.results.performance.NIVolumePerformanceResult;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.iou.NIEscrow;
import com.ibm.storage.ess.ni.iou.NIEscrowFactory;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NIExtentPoolPerformanceResultImpl;
import com.ibm.storage.ess.ni.results.NIPortPerformanceResultImpl;
import com.ibm.storage.ess.ni.results.NIRankPerformanceResultImpl;
import com.ibm.storage.ess.ni.services.NIPerformanceService;

public class NIPerformanceServiceAgent
implements NIPerformanceService {
    private static final long DEFAULT_TIMEOUT = 120000L;
    private static final int CCW_TYPE_PSF = 247;
    private static final int CCW_LENGTH = 12;
    private static final int CCW_ORDER_INDEX = 0;
    private static final int CCW_DEVICE_TYPE_INDEX = 2;
    private static final int CCW_LSS_INDEX = 4;
    private static final int CCW_VOLUME_INDEX = 5;
    private static final int CCW_SUB_ORDER_INDEX = 6;
    private static final int CCW_SUB_SUB_ORDER_INDEX = 7;
    private static final int CCW_FIELD_LENGTH_INDEX = 8;
    private static final int CCW_ID_FIELD_INDEX = 10;
    private static final byte CCW_RSSD_96_BYTE_LENGTH = 0;
    private static final byte CCW_RSSD_192_BYTE_LENGTH = 1;
    private static final byte CCW_SUB_ORDER = 1;
    private static final byte CCW_SUB_SUB_ORDER_FIRST_SET = 0;
    private static final byte CCW_SUB_SUB_ORDER_LINK_STATS = 1;
    private static final byte CCW_SUB_SUB_ORDER_RANK_STATS = 2;
    private static final byte CCW_SUB_SUB_ORDER_EXTENT_POOL_STATS = 3;
    private static final byte CCW_SUB_SUB_ORDER_TPF_PER_DEVICE_STATS = 31;
    private static final byte CCW_SUB_SUB_ORDER_ALL_PER_LSS_STATS = -1;
    private static final int ONE_BYTE_LENGTH = 8;
    private static final int TWO_BYTES = 2;
    private static final int CCW_32_AT_A_TIME = 32;
    private static final byte ORDER_PREPARE_FOR_READ_SUBSYSTEM_DATA = 24;
    private static final int CONFIGURED_LSS_NOT_FOUND = -1;
    private static final int NUMBER_OF_VOLUMES_PER_LSS = 256;
    private static final byte FIXED_BLOCK = 1;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$NIPerformanceServiceAgent == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$NIPerformanceServiceAgent = NIPerformanceServiceAgent.class$("com.ibm.storage.ess.ni.agent.sfiserver.NIPerformanceServiceAgent")) : class$com$ibm$storage$ess$ni$agent$sfiserver$NIPerformanceServiceAgent);
    private NICpssddInterface ci = NICpssddInterface.getInstance();
    private NIOutstandingRequestTable ort = NIOutstandingRequestTable.getInstance();
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$NIPerformanceServiceAgent;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$performance$NIVolumePerformanceResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$performance$NIPortPerformanceResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$performance$NIRankPerformanceResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$performance$NIExtentPoolPerformanceResult;

    public NIVolumePerformanceResult[] queryLogicalVolumePerformance(NIVolumeID[] nIVolumeIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$performance$NIVolumePerformanceResult == null ? (class$com$ibm$storage$ess$ni$application$results$performance$NIVolumePerformanceResult = NIPerformanceServiceAgent.class$("com.ibm.storage.ess.ni.application.results.performance.NIVolumePerformanceResult")) : class$com$ibm$storage$ess$ni$application$results$performance$NIVolumePerformanceResult);
        Integer n = this.ort.getNIRequestID().generateRequestID();
        logger.debug_general("PERF >>> Recieved Query for Logical Volume Performance Stats with " + nIVolumeIDArray.length + " volumes. This will result in " + (nIVolumeIDArray.length / 32 + nIVolumeIDArray.length % 32) + " CPSSDD Interface calls.");
        this.ort.storeOutstandingRequest(n, nIEscrow, new NIVolumeResultBuilder(nIVolumeIDArray), 120000L);
        int n2 = 12;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        int n5 = 0;
        int n6 = 0;
        NIPabsByteOS nIPabsByteOS = new NIPabsByteOS(247, n);
        int n7 = 32;
        int n8 = 0;
        while (n8 < nIVolumeIDArray.length) {
            byArray = this.createCCWforLogicalVolumePeformance(nIVolumeIDArray[n8]);
            n3 = nIVolumeIDArray[n8].getLSS().getLSSNumber();
            n4 = nIVolumeIDArray[n8].getVolNumber();
            byte[] byArray2 = new byte[16];
            NIByteArrayServices.storeNumberIntoCCW(byArray2, 0, 4, n8);
            if (nIVolumeIDArray.length - n5 * 32 < 32) {
                n7 = nIVolumeIDArray.length - n5 * 32;
            }
            nIPabsByteOS.addPabiArray(byArray, n7 - n6, n2, n3, n4, byArray2);
            ++n6;
            if ((n8 + 1) % 32 == 0 && n8 != 0 || n8 + 1 == nIVolumeIDArray.length) {
                this.ci.sendRequest(nIPabsByteOS.toByteArray());
                nIPabsByteOS.closeOS();
                nIPabsByteOS = new NIPabsByteOS(247, n);
                ++n5;
                n6 = 0;
            }
            ++n8;
        }
        return new NIVolumePerformanceResult[]{(NIVolumePerformanceResult)((Object)nIEscrow.issueIou())};
    }

    private byte[] createCCWforLogicalVolumePeformance(NIVolumeID nIVolumeID) {
        byte[] byArray = this.createGeneralPerformanceCCW();
        int n = nIVolumeID.getLSS().getLSSNumber();
        if (NIAgentCache.CACHE.getLssType(n) == 1) {
            byArray[2] = 1;
        }
        byArray[5] = (byte)nIVolumeID.getVolNumber();
        byArray[4] = (byte)nIVolumeID.getLSS().getLSSNumber();
        byArray[7] = 0;
        byArray[8] = 1;
        return byArray;
    }

    public NIVolumePerformanceResult[] queryLogicalVolumePerformance(NILSSID nILSSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$performance$NIVolumePerformanceResult == null ? (class$com$ibm$storage$ess$ni$application$results$performance$NIVolumePerformanceResult = NIPerformanceServiceAgent.class$("com.ibm.storage.ess.ni.application.results.performance.NIVolumePerformanceResult")) : class$com$ibm$storage$ess$ni$application$results$performance$NIVolumePerformanceResult);
        Integer n = this.ort.getNIRequestID().generateRequestID();
        this.ort.storeOutstandingRequest(n, nIEscrow, new NIMultiVolumeResultBuilder(nILSSID), 120000L);
        logger.debug_general("PERF >>> Recieved Query for Logical Volume Performance Stats with LSS " + nILSSID.getLSSNumber() + ". This will result in " + "one CPSSDD Interface call.");
        int n2 = 12;
        int n3 = nILSSID.getLSSNumber();
        NIPabsByteOS nIPabsByteOS = new NIPabsByteOS(247, n, true);
        byte[] byArray = this.createCCWforLogicalVolumePeformance(nILSSID);
        nIPabsByteOS.addPabiArray(byArray, 1, n2, n3, 0xFF & byArray[5], null);
        this.ci.sendRequest(nIPabsByteOS.toByteArray());
        nIPabsByteOS.closeOS();
        return new NIVolumePerformanceResult[]{(NIVolumePerformanceResult)((Object)nIEscrow.issueIou())};
    }

    private byte[] createCCWforLogicalVolumePeformance(NILSSID nILSSID) {
        byte[] byArray = this.createGeneralPerformanceCCW();
        int n = nILSSID.getLSSNumber();
        if (NIAgentCache.CACHE.getLssType(n) == 1) {
            byArray[2] = 1;
        }
        if (NIAgentCache.CACHE.areVolumesDefined(n)) {
            byArray[5] = (byte)NIAgentCache.CACHE.getFirstVolNum(n);
        }
        byArray[4] = (byte)n;
        byArray[7] = -1;
        byArray[8] = 1;
        return byArray;
    }

    public NIPortPerformanceResult[] queryIOPortPerformance(NIIOPortID[] nIIOPortIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIPortPerformanceResult[] nIPortPerformanceResultArray;
        if (NIAgentCache.CACHE.getFirstLssNum() != -1) {
            int n = nIIOPortIDArray[0].getInterfaceIdentifier();
            NIIOPortID nIIOPortID = nIIOPortIDArray[0];
            int n2 = 1;
            while (n2 < nIIOPortIDArray.length) {
                if (nIIOPortIDArray[n2].getInterfaceIdentifier() < n) {
                    n = nIIOPortIDArray[n2].getInterfaceIdentifier();
                    nIIOPortID = nIIOPortIDArray[n2];
                }
                ++n2;
            }
            NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$performance$NIPortPerformanceResult == null ? (class$com$ibm$storage$ess$ni$application$results$performance$NIPortPerformanceResult = NIPerformanceServiceAgent.class$("com.ibm.storage.ess.ni.application.results.performance.NIPortPerformanceResult")) : class$com$ibm$storage$ess$ni$application$results$performance$NIPortPerformanceResult);
            Integer n3 = this.ort.getNIRequestID().generateRequestID();
            logger.debug_general("PERF >>> Recieved Query for IO Port/Link Performance Stats with  " + nIIOPortIDArray.length + " IO ports. This will result in " + "one CPSSDD Interface call with the smallest ioPort being " + n + ".");
            this.ort.storeOutstandingRequest(n3, nIEscrow, new NIIOPortResultBuilder(nIIOPortIDArray), 120000L);
            int n4 = 12;
            int n5 = NIAgentCache.CACHE.getFirstLssNum();
            NIPabsByteOS nIPabsByteOS = new NIPabsByteOS(247, n3, true);
            byte[] byArray = this.createCCWforIOPortPeformance(nIIOPortID);
            nIPabsByteOS.addPabiArray(byArray, 1, n4, n5, 0xFF & byArray[5], null);
            this.ci.sendRequest(nIPabsByteOS.toByteArray());
            nIPabsByteOS.closeOS();
            nIPortPerformanceResultArray = new NIPortPerformanceResult[]{(NIPortPerformanceResult)((Object)nIEscrow.issueIou())};
        } else {
            logger.error("PERF >>> Recieved Query for IO Port/Link Performance Stats with  " + nIIOPortIDArray.length + " IO ports. Could not find a valid LSS resulting in zero calls to the CPSSDD Interface.");
            nIPortPerformanceResultArray = this.createFailedIOPortPerformanceResult(nIIOPortIDArray);
        }
        return nIPortPerformanceResultArray;
    }

    private byte[] createCCWforIOPortPeformance(NIIOPortID nIIOPortID) throws NIServerException {
        byte[] byArray = this.createGeneralPerformanceCCW();
        int n = NIAgentCache.CACHE.getFirstLssNum();
        if (NIAgentCache.CACHE.getLssType(n) == 1) {
            byArray[2] = 1;
        }
        if (NIAgentCache.CACHE.areVolumesDefined(n)) {
            byArray[5] = (byte)NIAgentCache.CACHE.getFirstVolNum(n);
        }
        byArray[4] = (byte)n;
        byArray[7] = 1;
        byArray[8] = 0;
        NIByteArrayServices.storeNumberIntoCCW(byArray, 10, 2, nIIOPortID.getInterfaceIdentifier());
        return byArray;
    }

    public NIPortPerformanceResult[] queryIOPortPerformance(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIPortPerformanceResult[] nIPortPerformanceResultArray;
        if (NIAgentCache.CACHE.getFirstLssNum() != -1) {
            NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$performance$NIPortPerformanceResult == null ? (class$com$ibm$storage$ess$ni$application$results$performance$NIPortPerformanceResult = NIPerformanceServiceAgent.class$("com.ibm.storage.ess.ni.application.results.performance.NIPortPerformanceResult")) : class$com$ibm$storage$ess$ni$application$results$performance$NIPortPerformanceResult);
            Integer n = this.ort.getNIRequestID().generateRequestID();
            logger.debug_general("PERF >>> Recieved Query for IO Port/Link Performance Stats with ESS Image number " + nIESSID.getImageNumber() + ". This will result in " + "one CPSSDD Interface call.");
            this.ort.storeOutstandingRequest(n, nIEscrow, new NIIOPortResultBuilder(nIESSID), 120000L);
            int n2 = 12;
            int n3 = NIAgentCache.CACHE.getFirstLssNum();
            NIPabsByteOS nIPabsByteOS = new NIPabsByteOS(247, n, true);
            byte[] byArray = this.createCCWforIOPortPeformance(new NIIOPortID(nIESSID, 0));
            nIPabsByteOS.addPabiArray(byArray, 1, n2, n3, 0xFF & byArray[5], null);
            this.ci.sendRequest(nIPabsByteOS.toByteArray());
            nIPabsByteOS.closeOS();
            nIPortPerformanceResultArray = new NIPortPerformanceResult[]{(NIPortPerformanceResult)((Object)nIEscrow.issueIou())};
        } else {
            logger.error("PERF >>> Recieved Query for IO Port/Link Performance Stats with ESS Image number " + nIESSID.getImageNumber() + ". This will result in " + "zero CPSSDD Interface calls. A valid LSS was not found.");
            nIPortPerformanceResultArray = this.createFailedIOPortPerformanceResult(null);
        }
        return nIPortPerformanceResultArray;
    }

    public NIRankPerformanceResult[] queryRankPerformance(NIRankID[] nIRankIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIRankPerformanceResult[] nIRankPerformanceResultArray;
        if (NIAgentCache.CACHE.getFirstLssNum() != -1) {
            int n = nIRankIDArray[0].getRankNumber();
            NIRankID nIRankID = nIRankIDArray[0];
            int n2 = 1;
            while (n2 < nIRankIDArray.length) {
                if (nIRankIDArray[n2].getRankNumber() < n) {
                    n = nIRankIDArray[n2].getRankNumber();
                    nIRankID = nIRankIDArray[n2];
                }
                ++n2;
            }
            NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$performance$NIRankPerformanceResult == null ? (class$com$ibm$storage$ess$ni$application$results$performance$NIRankPerformanceResult = NIPerformanceServiceAgent.class$("com.ibm.storage.ess.ni.application.results.performance.NIRankPerformanceResult")) : class$com$ibm$storage$ess$ni$application$results$performance$NIRankPerformanceResult);
            Integer n3 = this.ort.getNIRequestID().generateRequestID();
            logger.debug_general("PERF >>> Recieved Query for Rank Performance Stats with  " + nIRankIDArray.length + " ranks. This will result in " + "one CPSSDD Interface call with the smallest rank being " + n + ".");
            this.ort.storeOutstandingRequest(n3, nIEscrow, new NIRankResultBuilder(nIRankIDArray), 120000L);
            int n4 = 12;
            int n5 = NIAgentCache.CACHE.getFirstLssNum();
            NIPabsByteOS nIPabsByteOS = new NIPabsByteOS(247, n3, true);
            byte[] byArray = this.createCCWforRankPeformance(nIRankID);
            nIPabsByteOS.addPabiArray(byArray, 1, n4, n5, 0xFF & byArray[5], null);
            this.ci.sendRequest(nIPabsByteOS.toByteArray());
            nIPabsByteOS.closeOS();
            nIRankPerformanceResultArray = new NIRankPerformanceResult[]{(NIRankPerformanceResult)((Object)nIEscrow.issueIou())};
        } else {
            logger.error("PERF >>> Recieved Query for Rank Performance Stats with  " + nIRankIDArray.length + " ranks. This will result in " + "zero CPSSDD Interface calls. A valid LSS was not found. ");
            nIRankPerformanceResultArray = this.createFailedRankPerformanceResult(nIRankIDArray);
        }
        return nIRankPerformanceResultArray;
    }

    private byte[] createCCWforRankPeformance(NIRankID nIRankID) throws NIServerException {
        byte[] byArray = this.createGeneralPerformanceCCW();
        int n = NIAgentCache.CACHE.getFirstLssNum();
        if (NIAgentCache.CACHE.getLssType(n) == 1) {
            byArray[2] = 1;
        }
        if (NIAgentCache.CACHE.areVolumesDefined(n)) {
            byArray[5] = (byte)NIAgentCache.CACHE.getFirstVolNum(n);
        }
        byArray[4] = (byte)n;
        byArray[7] = 2;
        byArray[8] = 0;
        NIByteArrayServices.storeNumberIntoCCW(byArray, 10, 2, nIRankID.getRankNumber());
        return byArray;
    }

    public NIRankPerformanceResult[] queryRankPerformance(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIRankPerformanceResult[] nIRankPerformanceResultArray;
        if (NIAgentCache.CACHE.getFirstLssNum() != -1) {
            NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$performance$NIRankPerformanceResult == null ? (class$com$ibm$storage$ess$ni$application$results$performance$NIRankPerformanceResult = NIPerformanceServiceAgent.class$("com.ibm.storage.ess.ni.application.results.performance.NIRankPerformanceResult")) : class$com$ibm$storage$ess$ni$application$results$performance$NIRankPerformanceResult);
            Integer n = this.ort.getNIRequestID().generateRequestID();
            logger.debug_general("PERF >>> Recieved Query for Rank Performance Stats with  ESS Image number " + nIESSID.getImageNumber() + ". This will result in one CPSSDD Interface call.");
            this.ort.storeOutstandingRequest(n, nIEscrow, new NIRankResultBuilder(nIESSID), 120000L);
            int n2 = 12;
            int n3 = NIAgentCache.CACHE.getFirstLssNum();
            NIPabsByteOS nIPabsByteOS = new NIPabsByteOS(247, n, true);
            byte[] byArray = this.createCCWforRankPeformance(new NIRankID(nIESSID, 0));
            nIPabsByteOS.addPabiArray(byArray, 1, n2, n3, 0xFF & byArray[5], null);
            this.ci.sendRequest(nIPabsByteOS.toByteArray());
            nIPabsByteOS.closeOS();
            nIRankPerformanceResultArray = new NIRankPerformanceResult[]{(NIRankPerformanceResult)((Object)nIEscrow.issueIou())};
        } else {
            logger.error("PERF >>> Recieved Query for Rank Performance Stats with  ESS Image number " + nIESSID.getImageNumber() + ". This will result in zero CPSSDD Interface call. A valid LSS was not found.");
            nIRankPerformanceResultArray = this.createFailedRankPerformanceResult(null);
        }
        return nIRankPerformanceResultArray;
    }

    public NIExtentPoolPerformanceResult[] queryExtentPoolPerformance(NIExtentPoolID[] nIExtentPoolIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIExtentPoolPerformanceResult[] nIExtentPoolPerformanceResultArray;
        if (NIAgentCache.CACHE.getFirstLssNum() != -1) {
            int n = nIExtentPoolIDArray[0].getExtentPoolNumber();
            NIExtentPoolID nIExtentPoolID = nIExtentPoolIDArray[0];
            int n2 = 1;
            while (n2 < nIExtentPoolIDArray.length) {
                if (nIExtentPoolIDArray[n2].getExtentPoolNumber() < n) {
                    n = nIExtentPoolIDArray[n2].getExtentPoolNumber();
                    nIExtentPoolID = nIExtentPoolIDArray[n2];
                }
                ++n2;
            }
            NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$performance$NIExtentPoolPerformanceResult == null ? (class$com$ibm$storage$ess$ni$application$results$performance$NIExtentPoolPerformanceResult = NIPerformanceServiceAgent.class$("com.ibm.storage.ess.ni.application.results.performance.NIExtentPoolPerformanceResult")) : class$com$ibm$storage$ess$ni$application$results$performance$NIExtentPoolPerformanceResult);
            Integer n3 = this.ort.getNIRequestID().generateRequestID();
            logger.debug_general("PERF >>> Recieved Query for Extent Pool Performance Stats with  " + nIExtentPoolIDArray.length + " extent pools. This will result in " + "one CPSSDD Interface call with the smallest extent pool being " + n + ".");
            this.ort.storeOutstandingRequest(n3, nIEscrow, new NIExtentPoolResultBuilder(nIExtentPoolIDArray), 120000L);
            int n4 = 12;
            int n5 = NIAgentCache.CACHE.getFirstLssNum();
            NIPabsByteOS nIPabsByteOS = new NIPabsByteOS(247, n3, true);
            byte[] byArray = this.createCCWforExtentPoolPeformance(nIExtentPoolID);
            nIPabsByteOS.addPabiArray(byArray, 1, n4, n5, 0xFF & byArray[5], null);
            this.ci.sendRequest(nIPabsByteOS.toByteArray());
            nIPabsByteOS.closeOS();
            nIExtentPoolPerformanceResultArray = new NIExtentPoolPerformanceResult[]{(NIExtentPoolPerformanceResult)((Object)nIEscrow.issueIou())};
        } else {
            logger.error("PERF >>> Recieved Query for Extent Pool Performance Stats with  " + nIExtentPoolIDArray.length + " extent pools. This will result in " + "zero CPSSDD Interface calls. A valid LSS was not found.");
            nIExtentPoolPerformanceResultArray = this.createFailedExtentPerformanceResult(nIExtentPoolIDArray);
        }
        return nIExtentPoolPerformanceResultArray;
    }

    private byte[] createCCWforExtentPoolPeformance(NIExtentPoolID nIExtentPoolID) throws NIServerException {
        byte[] byArray = this.createGeneralPerformanceCCW();
        int n = NIAgentCache.CACHE.getFirstLssNum();
        if (NIAgentCache.CACHE.getLssType(n) == 1) {
            byArray[2] = 1;
        }
        if (NIAgentCache.CACHE.areVolumesDefined(n)) {
            byArray[5] = (byte)NIAgentCache.CACHE.getFirstVolNum(n);
        }
        byArray[4] = (byte)n;
        byArray[7] = 3;
        byArray[8] = 0;
        NIByteArrayServices.storeNumberIntoCCW(byArray, 10, 2, nIExtentPoolID.getExtentPoolNumber());
        return byArray;
    }

    public NIExtentPoolPerformanceResult[] queryExtentPoolPerformance(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIExtentPoolPerformanceResult[] nIExtentPoolPerformanceResultArray;
        if (NIAgentCache.CACHE.getFirstLssNum() != -1) {
            NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$performance$NIExtentPoolPerformanceResult == null ? (class$com$ibm$storage$ess$ni$application$results$performance$NIExtentPoolPerformanceResult = NIPerformanceServiceAgent.class$("com.ibm.storage.ess.ni.application.results.performance.NIExtentPoolPerformanceResult")) : class$com$ibm$storage$ess$ni$application$results$performance$NIExtentPoolPerformanceResult);
            Integer n = this.ort.getNIRequestID().generateRequestID();
            logger.debug_general("PERF >>> Recieved Query for Extent Pool Performance Stats with  ESS Image Number " + nIESSID.getImageNumber() + ". This will result in one CPSSDD Interface call");
            this.ort.storeOutstandingRequest(n, nIEscrow, new NIExtentPoolResultBuilder(nIESSID), 120000L);
            int n2 = 12;
            int n3 = NIAgentCache.CACHE.getFirstLssNum();
            NIPabsByteOS nIPabsByteOS = new NIPabsByteOS(247, n, true);
            byte[] byArray = this.createCCWforExtentPoolPeformance(new NIExtentPoolID(null, 0));
            nIPabsByteOS.addPabiArray(byArray, 1, n2, n3, 0xFF & byArray[5], null);
            this.ci.sendRequest(nIPabsByteOS.toByteArray());
            nIPabsByteOS.closeOS();
            nIExtentPoolPerformanceResultArray = new NIExtentPoolPerformanceResult[]{(NIExtentPoolPerformanceResult)((Object)nIEscrow.issueIou())};
        } else {
            logger.error("PERF >>> Recieved Query for Extent Pool Performance Stats with  ESS Image Number " + nIESSID.getImageNumber() + ". This will result in zero CPSSDD Interface calls." + " A valid LSS was not found.");
            nIExtentPoolPerformanceResultArray = this.createFailedExtentPerformanceResult(null);
        }
        return nIExtentPoolPerformanceResultArray;
    }

    private byte[] createGeneralPerformanceCCW() {
        byte[] byArray = new byte[12];
        byArray[0] = 24;
        byArray[6] = 1;
        return byArray;
    }

    private NIPortPerformanceResult[] createFailedIOPortPerformanceResult(NIIOPortID[] nIIOPortIDArray) {
        NIPortPerformanceResult[] nIPortPerformanceResultArray;
        if (nIIOPortIDArray != null) {
            nIPortPerformanceResultArray = new NIPortPerformanceResultImpl[nIIOPortIDArray.length];
            int n = 0;
            while (n < nIPortPerformanceResultArray.length) {
                nIPortPerformanceResultArray[n] = new NIPortPerformanceResultImpl(-1099890944L, nIIOPortIDArray[n]);
                ++n;
            }
        } else {
            nIPortPerformanceResultArray = new NIPortPerformanceResultImpl[]{new NIPortPerformanceResultImpl(-1099890944L, null)};
        }
        return nIPortPerformanceResultArray;
    }

    private NIRankPerformanceResult[] createFailedRankPerformanceResult(NIRankID[] nIRankIDArray) {
        NIRankPerformanceResult[] nIRankPerformanceResultArray;
        if (nIRankIDArray != null) {
            nIRankPerformanceResultArray = new NIRankPerformanceResultImpl[nIRankIDArray.length];
            int n = 0;
            while (n < nIRankPerformanceResultArray.length) {
                nIRankPerformanceResultArray[n] = new NIRankPerformanceResultImpl(-1099890944L, nIRankIDArray[n]);
                ++n;
            }
        } else {
            nIRankPerformanceResultArray = new NIRankPerformanceResultImpl[]{new NIRankPerformanceResultImpl(-1099890944L, null)};
        }
        return nIRankPerformanceResultArray;
    }

    private NIExtentPoolPerformanceResult[] createFailedExtentPerformanceResult(NIExtentPoolID[] nIExtentPoolIDArray) {
        NIExtentPoolPerformanceResult[] nIExtentPoolPerformanceResultArray;
        if (nIExtentPoolIDArray != null) {
            nIExtentPoolPerformanceResultArray = new NIExtentPoolPerformanceResultImpl[nIExtentPoolIDArray.length];
            int n = 0;
            while (n < nIExtentPoolPerformanceResultArray.length) {
                nIExtentPoolPerformanceResultArray[n] = new NIExtentPoolPerformanceResultImpl(-1099890944L, nIExtentPoolIDArray[n]);
                ++n;
            }
        } else {
            nIExtentPoolPerformanceResultArray = new NIExtentPoolPerformanceResultImpl[]{new NIExtentPoolPerformanceResultImpl(-1099890944L, null)};
        }
        return nIExtentPoolPerformanceResultArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

