/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver;

import com.ibm.storage.ess.ni.agent.common.NIPhysConfigServiceAgent;
import com.ibm.storage.ess.ni.agent.common.convert.physical.NIDAConverter;
import com.ibm.storage.ess.ni.agent.common.convert.physical.NIDDMConverter;
import com.ibm.storage.ess.ni.agent.common.convert.physical.NIFCInterfaceConverter;
import com.ibm.storage.ess.ni.agent.common.convert.physical.NIHAConverter;
import com.ibm.storage.ess.ni.agent.common.convert.physical.NIIOPortConverter;
import com.ibm.storage.ess.ni.agent.common.convert.physical.NINetworkPortConverter;
import com.ibm.storage.ess.ni.agent.common.convert.physical.NIStorageEnclosureConverter;
import com.ibm.storage.ess.ni.application.resource.NIIOPort;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIConfigResult;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.resource.NIFibreChannelPortImpl;
import com.ibm.storage.ess.ni.results.NIConfigResultImpl;
import com.ibm.storage.ess.ni.services.NIPhysicalConfigurationService;

public class NISFIPhysicalConfigurationServiceAgent
extends NIPhysConfigServiceAgent
implements NIPhysicalConfigurationService {
    public NIConfigQueryResult getStorageEnclosures(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        return this.executeQuery("IBM.EssStorageEnclosure", null, new NIStorageEnclosureConverter());
    }

    public NIConfigQueryResult getDeviceAdapterFRUs(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        return this.executeQuery("IBM.EssDA", null, new NIDAConverter());
    }

    public NIConfigQueryResult getHostAdapterFRUs(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        return this.executeQuery("IBM.EssHA", null, new NIHAConverter());
    }

    public NIConfigQueryResult getStorageDeviceFRUs(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        return this.executeQuery("IBM.EssDDM", null, new NIDDMConverter());
    }

    public NIConfigQueryResult getNVCCardFRUs(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("Unsupported Command");
    }

    public NIConfigQueryResult getSlotBaffleFRUs(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("Unsupported Command");
    }

    public NIConfigQueryResult getInterfaceCardFRUs(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        return this.executeQuery("IBM.EssFCIC", null, new NIFCInterfaceConverter());
    }

    public NIConfigQueryResult getESCONPorts(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("portType");
        stringBuffer.append("==");
        stringBuffer.append(10);
        return this.executeQuery("IBM.EssHAPort", stringBuffer.toString(), new NIIOPortConverter());
    }

    public NIConfigQueryResult getNetworkPorts(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("portType");
        stringBuffer.append("==");
        stringBuffer.append(1);
        return this.executeQuery("IBM.EssHAPort", stringBuffer.toString(), new NINetworkPortConverter());
    }

    public NIConfigQueryResult getFibreChannelPorts(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("portType");
        stringBuffer.append("==");
        stringBuffer.append(20);
        stringBuffer.append(" OR ");
        stringBuffer.append("portType");
        stringBuffer.append("==");
        stringBuffer.append(21);
        return this.executeQuery("IBM.EssHAPort", stringBuffer.toString(), new NIIOPortConverter());
    }

    public NIConfigQueryResult getPorts(NIIOPortID[] nIIOPortIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIIOPortConverter nIIOPortConverter = new NIIOPortConverter();
        String string = this.createIdQueryString(nIIOPortIDArray, nIIOPortConverter);
        return this.executeQuery("IBM.EssHAPort", string, nIIOPortConverter);
    }

    public NIConfigResult modifyPort(NIIOPort nIIOPort) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIFibreChannelPortImpl nIFibreChannelPortImpl;
        NIConfigResult nIConfigResult = null;
        if (nIIOPort instanceof NIFibreChannelPortImpl && (nIFibreChannelPortImpl = (NIFibreChannelPortImpl)nIIOPort).getSetMethods().contains("setTopology")) {
            NIIOPortConverter nIIOPortConverter = new NIIOPortConverter();
            nIConfigResult = this.executeAction("IBM.EssHAPort", nIIOPort.getID(), nIIOPortConverter, "changeTopology", nIIOPortConverter.toChangeTopologyAction(nIFibreChannelPortImpl));
        }
        if (nIConfigResult == null) {
            nIConfigResult = new NIConfigResultImpl(nIIOPort.getID(), true, 0L);
        }
        return nIConfigResult;
    }

    public NIConfigQueryResult getFCICFRUs(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("Not used in 2107");
    }
}

