/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.cache.NIAgentCache;
import com.ibm.storage.ess.ni.agent.sfiserver.ci.NICpssddInterface;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIOutstandingRequestTable;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIPabsByteOS;
import com.ibm.storage.ess.ni.agent.sfiserver.cs.session.NISessionResultBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.utility.NIByteArrayServices;
import com.ibm.storage.ess.ni.application.results.NISessionResult;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NISessionID;
import com.ibm.storage.ess.ni.iou.NIEscrow;
import com.ibm.storage.ess.ni.iou.NIEscrowFactory;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.NISession;
import com.ibm.storage.ess.ni.option.NISessionClose;
import com.ibm.storage.ess.ni.option.NISessionMemberAdd;
import com.ibm.storage.ess.ni.option.NISessionMemberRemove;
import com.ibm.storage.ess.ni.option.NISessionOpen;
import com.ibm.storage.ess.ni.services.NISessionService;
import com.ibm.storage.ess.ni.util.NIByteArray;

public class NISessionServiceAgent
implements NISessionService {
    private static final long DEFAULT_TIMEOUT = 120000L;
    private static final int OFFSET_NORMAL = 0;
    private static final int CCW = 247;
    private static final byte OPCODE_MANAGE_SESSION_PARAMETERS = 118;
    private static final byte OPCODE_MANAGE_SESSION_MEMBERS = 119;
    private static final byte OPTION_SESSION_CLOSE = -128;
    private static final byte OPTION_SESSION_MEMBER_REMOVE = -128;
    private static final byte OPTION_SESSION_MEMBER_RANGE = 32;
    private static final byte OPTION_LSS_FIXED_BLOCK = 16;
    private static final int MANAGE_SESSION_CCW_SIZE = 18;
    private static final int MANAGE_SESSION_CCW_RANGE_SIZE = 24;
    private static final int MANAGE_SESSION_CCW_ARRAY_SIZE = 20;
    private static final int GREATEST_VOLUME_NUMBER = 255;
    private static final int LOWEST_VOLUME_NUMBER = 0;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$NISessionServiceAgent == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$NISessionServiceAgent = NISessionServiceAgent.class$("com.ibm.storage.ess.ni.agent.sfiserver.NISessionServiceAgent")) : class$com$ibm$storage$ess$ni$agent$sfiserver$NISessionServiceAgent);
    private NICpssddInterface ci = NICpssddInterface.getInstance();
    private NIOutstandingRequestTable ort = NIOutstandingRequestTable.getInstance();
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$NISessionServiceAgent;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NISessionResult;

    public NISessionResult manageSession(NILSSID nILSSID, NISessionID nISessionID, NISession[] nISessionArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        this.checkObjectForNull(nISessionID, "sessionID is null");
        this.checkObjectForNull(nILSSID, "LSS is null");
        int n = 0;
        byte[] byArray = new byte[16];
        Integer n2 = this.ort.getNIRequestID().generateRequestID();
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NISessionResult == null ? (class$com$ibm$storage$ess$ni$application$results$NISessionResult = NISessionServiceAgent.class$("com.ibm.storage.ess.ni.application.results.NISessionResult")) : class$com$ibm$storage$ess$ni$application$results$NISessionResult);
        NISessionResultBuilder nISessionResultBuilder = new NISessionResultBuilder();
        this.ort.storeOutstandingRequest(n2, nIEscrow, nISessionResultBuilder, 120000L);
        NIPabsByteOS nIPabsByteOS = new NIPabsByteOS(247, n2);
        byte[] byArray2 = this.getCommonSessionCCW(18, nILSSID, nISessionID);
        byArray2[0] = 118;
        if (NIAgentCache.CACHE.getLssType(nILSSID.getLSSNumber()) == 1) {
            byArray2[1] = (byte)(byArray2[1] | 0x10);
        }
        if (NISessionServiceAgent.hasOption(NISessionClose.Option, nISessionArray)) {
            byArray2[1] = (byte)(byArray2[1] | 0xFFFFFF80);
        } else if (!NISessionServiceAgent.hasOption(NISessionOpen.Option, nISessionArray)) {
            logger.error("Open/Close Session was not selected in NISessionServiceAgent.manageSession");
            throw new NIUnsupportedException("No valid option (Open/Close) Chosen");
        }
        if (NIAgentCache.CACHE.areVolumesDefined(nILSSID.getLSSNumber())) {
            n = NIAgentCache.CACHE.getFirstVolNum(nILSSID.getLSSNumber());
        }
        nIPabsByteOS.addPabiArray(byArray2, 1, byArray2.length, (byte)nILSSID.getLSSNumber(), n, byArray);
        this.ci.sendRequest(nIPabsByteOS.toByteArray());
        nIPabsByteOS.closeOS();
        return (NISessionResult)((Object)nIEscrow.issueIou());
    }

    public NISessionResult manageMemberSession(NILSSID nILSSID, NISessionID nISessionID, int[] nArray, NISession[] nISessionArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        this.checkObjectForNull(nISessionID, "sessionID is null");
        this.checkObjectForNull(nILSSID, "LSS is null");
        int n = 0;
        byte[] byArray = new byte[16];
        Integer n2 = this.ort.getNIRequestID().generateRequestID();
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NISessionResult == null ? (class$com$ibm$storage$ess$ni$application$results$NISessionResult = NISessionServiceAgent.class$("com.ibm.storage.ess.ni.application.results.NISessionResult")) : class$com$ibm$storage$ess$ni$application$results$NISessionResult);
        NISessionResultBuilder nISessionResultBuilder = new NISessionResultBuilder();
        this.ort.storeOutstandingRequest(n2, nIEscrow, nISessionResultBuilder, 120000L);
        NIPabsByteOS nIPabsByteOS = new NIPabsByteOS(247, n2);
        int n3 = 20 + nArray.length * 2;
        byte[] byArray2 = this.getCommonSessionCCW(n3, nILSSID, nISessionID);
        byArray2[0] = 119;
        if (NIAgentCache.CACHE.getLssType(nILSSID.getLSSNumber()) == 1) {
            byArray2[1] = (byte)(byArray2[1] | 0x10);
        }
        if (NISessionServiceAgent.hasOption(NISessionMemberRemove.Option, nISessionArray)) {
            byArray2[1] = (byte)(byArray2[1] | 0xFFFFFF80);
        } else if (!NISessionServiceAgent.hasOption(NISessionMemberAdd.Option, nISessionArray)) {
            logger.error("Add/Remove Session Member was not selected in NISessionServiceAgent.manageMemberSession");
            throw new NIUnsupportedException("No valid option (Add/Remove) Chosen");
        }
        int n4 = 21;
        int n5 = 0;
        while (n5 < nArray.length) {
            if (255 < nArray[n5] || 0 > nArray[n5]) {
                logger.error("Volume Number is too big or small in volume array" + nArray[n5]);
                throw new NIUnsupportedException("Volume Number is too big or small" + nArray[n5]);
            }
            byArray2[n4 + 2 * n5] = (byte)nArray[n5];
            ++n5;
        }
        if (nArray.length > 0) {
            n = nArray[0];
        }
        NIByteArrayServices.storeNumberIntoCCW(byArray2, 18, 2, nArray.length);
        nIPabsByteOS.addPabiArray(byArray2, 1, byArray2.length, (byte)nILSSID.getLSSNumber(), n, byArray);
        this.ci.sendRequest(nIPabsByteOS.toByteArray());
        nIPabsByteOS.closeOS();
        return (NISessionResult)((Object)nIEscrow.issueIou());
    }

    public NISessionResult manageMemberSession(NILSSID nILSSID, NISessionID nISessionID, int n, int n2, NISession[] nISessionArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        this.checkObjectForNull(nISessionID, "sessionID is null");
        this.checkObjectForNull(nILSSID, "LSS is null");
        byte[] byArray = new byte[16];
        Integer n3 = this.ort.getNIRequestID().generateRequestID();
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NISessionResult == null ? (class$com$ibm$storage$ess$ni$application$results$NISessionResult = NISessionServiceAgent.class$("com.ibm.storage.ess.ni.application.results.NISessionResult")) : class$com$ibm$storage$ess$ni$application$results$NISessionResult);
        NISessionResultBuilder nISessionResultBuilder = new NISessionResultBuilder();
        this.ort.storeOutstandingRequest(n3, nIEscrow, nISessionResultBuilder, 120000L);
        NIPabsByteOS nIPabsByteOS = new NIPabsByteOS(247, n3);
        byte[] byArray2 = this.getCommonSessionCCW(24, nILSSID, nISessionID);
        byArray2[0] = 119;
        if (NIAgentCache.CACHE.getLssType(nILSSID.getLSSNumber()) == 1) {
            byArray2[1] = (byte)(byArray2[1] | 0x10);
        }
        byArray2[1] = (byte)(byArray2[1] | 0x20);
        if (NISessionServiceAgent.hasOption(NISessionMemberRemove.Option, nISessionArray)) {
            byArray2[1] = (byte)(byArray2[1] | 0xFFFFFF80);
        } else if (!NISessionServiceAgent.hasOption(NISessionMemberAdd.Option, nISessionArray)) {
            logger.error("Add/Remove Session Member was not selected in NISessionServiceAgent.manageMemberSession");
            throw new NIUnsupportedException("No valid option (Add/Remove) Chosen");
        }
        if (255 < n || 0 > n) {
            logger.error("First Volume Number is too big or small in volume array" + n);
            throw new NIUnsupportedException("First Volume Number is too big or small" + n);
        }
        if (255 < n2 || 0 > n2) {
            logger.error("Last Volume Number is too big or small in volume array" + n2);
            throw new NIUnsupportedException("Last Volume Number is too big or small" + n2);
        }
        byArray2[19] = 1;
        byArray2[21] = (byte)n;
        byArray2[23] = (byte)n2;
        nIPabsByteOS.addPabiArray(byArray2, 1, byArray2.length, (byte)nILSSID.getLSSNumber(), n, byArray);
        this.ci.sendRequest(nIPabsByteOS.toByteArray());
        nIPabsByteOS.closeOS();
        return (NISessionResult)((Object)nIEscrow.issueIou());
    }

    private byte[] getCommonSessionCCW(int n, NILSSID nILSSID, NISessionID nISessionID) {
        byte[] byArray = new byte[n];
        NIByteArray nIByteArray = new NIByteArray(byArray);
        nIByteArray.storeSequenceNumber(4, nILSSID.getESS().getSequence());
        byArray = nIByteArray.getByteArray();
        byArray[2] = (byte)nILSSID.getLSSNumber();
        byArray[14] = (byte)nISessionID.getSessionType();
        byArray[15] = (byte)nISessionID.getSessionNumber();
        return byArray;
    }

    private static boolean hasOption(NISession nISession, NISession[] nISessionArray) {
        int n = 0;
        while (n < nISessionArray.length) {
            if (nISessionArray[n].equals(nISession)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isLssFixedBlock(int n) {
        boolean bl = false;
        if (NIAgentCache.CACHE.getLssType(n) == 1) {
            bl = true;
        }
        return bl;
    }

    private void checkObjectForNull(Object object, String string) throws NIParameterInvalidServerException {
        if (object == null) {
            logger.error(string);
            throw new NIParameterInvalidServerException(2, object);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

