/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.cache.NIAgentCache;
import com.ibm.storage.ess.ni.agent.common.rmcutil.NIMcSessionManager;
import com.ibm.storage.ess.ni.agent.sfiserver.NIAsyncPPRCServiceAgent;
import com.ibm.storage.ess.ni.agent.sfiserver.NIConfigurationRecoveryServiceAgent;
import com.ibm.storage.ess.ni.agent.sfiserver.NICopyCommonServiceAgent;
import com.ibm.storage.ess.ni.agent.sfiserver.NIDiagnosticControlServiceAgent;
import com.ibm.storage.ess.ni.agent.sfiserver.NIFlashCopyServiceAgent;
import com.ibm.storage.ess.ni.agent.sfiserver.NIHostConfigurationServiceAgent;
import com.ibm.storage.ess.ni.agent.sfiserver.NILogicalConfigurationServiceAgent;
import com.ibm.storage.ess.ni.agent.sfiserver.NIPPRCServiceAgent;
import com.ibm.storage.ess.ni.agent.sfiserver.NIPerformanceServiceAgent;
import com.ibm.storage.ess.ni.agent.sfiserver.NISFIPhysicalConfigurationServiceAgent;
import com.ibm.storage.ess.ni.agent.sfiserver.NISessionServiceAgent;
import com.ibm.storage.ess.ni.commandagent.NICommandAgent;
import com.ibm.storage.ess.ni.commandagent.NICommandAgentStartupException;
import com.ibm.storage.ess.ni.eventManager.agent.NIEventAgent;
import com.ibm.storage.ess.ni.logging.NIFileMaintenanceThread;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterThread;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class NISfiServerCommandAgent {
    private static final String SFI_SERVER_COMMAND_AGENT_PROPERTY = "com.ibm.storage.ess.ni.agent.sfiserver";
    private static final String SIMULATOR_PROPERTY = "com.ibm.storage.ess.ni.agent.SimulatorProperty";
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$NISfiServerCommandAgent == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$NISfiServerCommandAgent = NISfiServerCommandAgent.class$("com.ibm.storage.ess.ni.agent.sfiserver.NISfiServerCommandAgent")) : class$com$ibm$storage$ess$ni$agent$sfiserver$NISfiServerCommandAgent);
    private NICommandAgent commandAgent;
    private NIMessageRouterAddress localAddress;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$NISfiServerCommandAgent;

    public NISfiServerCommandAgent() {
        this(null);
    }

    public NISfiServerCommandAgent(NIMessageRouterAddress nIMessageRouterAddress) {
        this.localAddress = nIMessageRouterAddress;
    }

    public void start() throws NICommandAgentStartupException {
        boolean bl;
        Object[] objectArray;
        Object object;
        logger.debug_general("****************Command Agent Started**********");
        NIMcSessionManager.establishSessions(true);
        this.commandAgent = new NICommandAgent();
        String string = System.getProperty(SFI_SERVER_COMMAND_AGENT_PROPERTY);
        boolean bl2 = false;
        if (string != null) {
            object = new Properties();
            try {
                ((Properties)object).load(new FileInputStream(string));
                this.commandAgent.loadConfiguration((Properties)object);
                bl2 = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.debug_general("Could not find properties file.  Using default configuration instead.");
            }
            catch (IOException iOException) {
                logger.error("Error reading properties file.");
                logger.throwable((Throwable)iOException);
            }
        }
        if (((String)(object = System.getProperty(SIMULATOR_PROPERTY, "false"))).compareTo("true") == 0 & !bl2) {
            logger.debug_general("Simulator Property turned on");
            this.commandAgent.setLocalNodeAddress(this.localAddress);
            objectArray = new Object[]{new NIPPRCServiceAgent(), new NIFlashCopyServiceAgent(), new NISessionServiceAgent(), new NIPerformanceServiceAgent(), new NIAsyncPPRCServiceAgent(), new NIDiagnosticControlServiceAgent()};
            this.commandAgent.setServiceClasses(objectArray);
            logger.debug_general("Simulator Property turned on and came to the end of the file");
        } else if (!bl2) {
            logger.debug_general("Simulator Property turned off");
            this.commandAgent.setLocalNodeAddress(this.localAddress);
            objectArray = new Object[]{new NILogicalConfigurationServiceAgent(), new NISFIPhysicalConfigurationServiceAgent(), new NIHostConfigurationServiceAgent(), new NIConfigurationRecoveryServiceAgent(), new NICopyCommonServiceAgent(), new NIPPRCServiceAgent(), new NIFlashCopyServiceAgent(), new NISessionServiceAgent(), new NIPerformanceServiceAgent(), new NIAsyncPPRCServiceAgent(), new NIDiagnosticControlServiceAgent()};
            this.commandAgent.setServiceClasses(objectArray);
        }
        this.commandAgent.startup();
        NIAgentCache.CACHE.setCommandAgent(this.commandAgent);
        boolean bl3 = bl = System.getProperty("startFastCCW") != null;
        if (bl) {
            logger.debug_general("Starting FastCCW server");
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass("com.ibm.ess.api.server.ds8000.Ds8000CcwServer");
                Object obj = clazz.newInstance();
                System.out.println(obj);
            }
            catch (Exception exception) {
                logger.error("Exception starting FastCCW server.  Shutting down.");
                logger.throwable((Throwable)exception);
            }
            logger.debug_general("FastCCW server started");
        }
        logger.debug_general("File Maintenance Thread Starting");
        NIFileMaintenanceThread.start();
    }

    public void stop() {
        logger.debug_general("File Maintenance Thread Stoping");
        NIFileMaintenanceThread.stop();
        this.commandAgent.shutdown();
    }

    private static NIMessageRouterChannel startMessageRouter(NIMessageRouter nIMessageRouter) {
        NIMessageRouterChannel nIMessageRouterChannel = null;
        NIMessageRouterThread nIMessageRouterThread = null;
        try {
            nIMessageRouterThread = new NIMessageRouterThread();
            nIMessageRouterThread.start();
            Thread.sleep(4000L);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            logger.error("Unable to create Message Router due to invalid message router metadata file.");
        }
        try {
            nIMessageRouterChannel = nIMessageRouter.createNIMessageRouterChannel(4);
        }
        catch (NIMessageRouterException nIMessageRouterException) {
            logger.throwable((Throwable)nIMessageRouterException);
            logger.error("Unable to create Message Router process channel because it is already in use.");
        }
        return nIMessageRouterChannel;
    }

    public static void main(String[] stringArray) throws NICommandAgentStartupException {
        NIMessageRouter nIMessageRouter = NIMessageRouterFactory.getInstanceOf();
        NISfiServerCommandAgent.startMessageRouter(nIMessageRouter);
        NIMessageRouterAddress nIMessageRouterAddress = new NIMessageRouterAddress(1, nIMessageRouter.getEssServerName());
        NISfiServerCommandAgent nISfiServerCommandAgent = new NISfiServerCommandAgent(nIMessageRouterAddress);
        nISfiServerCommandAgent.start();
        String string = System.getProperty(SIMULATOR_PROPERTY, "false");
        if (string.compareTo("true") == 0) {
            NIEventAgent nIEventAgent = NIEventAgent.getEventAgent(false);
        } else {
            NIEventAgent nIEventAgent = NIEventAgent.getEventAgent(true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

