/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.common;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIRequestID;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResponseData;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResultsBuilder;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NITimeoutServerException;
import com.ibm.storage.ess.ni.iou.NIEscrow;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;

public class NIOutstandingRequestTable {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$common$NIOutstandingRequestTable == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$common$NIOutstandingRequestTable = NIOutstandingRequestTable.class$("com.ibm.storage.ess.ni.agent.sfiserver.common.NIOutstandingRequestTable")) : class$com$ibm$storage$ess$ni$agent$sfiserver$common$NIOutstandingRequestTable);
    private Map map = Collections.synchronizedMap(new TreeMap());
    private Timer timer = new Timer();
    private NIRequestID id = null;
    private static NIOutstandingRequestTable ort = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$common$NIOutstandingRequestTable;

    public static NIOutstandingRequestTable getInstance() {
        if (ort == null) {
            ort = new NIOutstandingRequestTable();
            ort.setNIRequestID(new NIRequestID());
        }
        return ort;
    }

    private NIOutstandingRequestTable() {
    }

    public void storeOutstandingRequest(Integer n, NIEscrow nIEscrow, NIResultsBuilder nIResultsBuilder, long l) {
        NIOutstandingRequest nIOutstandingRequest = new NIOutstandingRequest(n, nIEscrow, nIResultsBuilder, l);
        logger.debug_general("storing request: " + nIOutstandingRequest);
        this.map.put(n, nIOutstandingRequest);
        this.timer.schedule((TimerTask)nIOutstandingRequest, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRequest(Integer n, NIResponseData nIResponseData) {
        NIOutstandingRequest nIOutstandingRequest = (NIOutstandingRequest)this.map.get(n);
        if (nIOutstandingRequest == null) {
            this.map.remove(n);
            logger.warning("null element in ORT for id: " + n);
        } else {
            NIOutstandingRequest nIOutstandingRequest2 = nIOutstandingRequest;
            synchronized (nIOutstandingRequest2) {
                logger.debug_general("updating request: " + nIOutstandingRequest);
                if (nIOutstandingRequest.builder != null) {
                    nIOutstandingRequest.builder.buildResults(nIResponseData);
                    if (nIOutstandingRequest.builder.resultsComplete()) {
                        logger.debug_general(nIOutstandingRequest + " completed.  Closing escrow");
                        this.map.remove(n);
                        nIOutstandingRequest.escrow.close(nIOutstandingRequest.builder.getResults());
                        nIOutstandingRequest.cancel();
                    }
                } else {
                    this.updateRequest(n, new NIServerException(0));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRequest(Integer n, Exception exception) {
        NIOutstandingRequest nIOutstandingRequest = (NIOutstandingRequest)this.map.get(n);
        if (nIOutstandingRequest == null) {
            this.map.remove(n);
            logger.warning("null element in ORT for id: " + n);
        } else {
            NIOutstandingRequest nIOutstandingRequest2 = nIOutstandingRequest;
            synchronized (nIOutstandingRequest2) {
                logger.debug_general(nIOutstandingRequest + " completing with exception: " + exception);
                this.map.remove(n);
                nIOutstandingRequest.escrow.close(exception);
                nIOutstandingRequest.cancel();
            }
        }
    }

    public void setNIRequestID(NIRequestID nIRequestID) {
        this.id = nIRequestID;
    }

    public NIRequestID getNIRequestID() {
        return this.id;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NIOutstandingRequest
    extends TimerTask {
        public NIEscrow escrow;
        public Integer id;
        public NIResultsBuilder builder;
        public long timeout;

        public NIOutstandingRequest(Integer n, NIEscrow nIEscrow, NIResultsBuilder nIResultsBuilder, long l) {
            this.id = n;
            this.escrow = nIEscrow;
            this.builder = nIResultsBuilder;
            this.timeout = l;
        }

        public String toString() {
            return "Outstanding Request: " + this.id + " " + (this.builder == null ? null : this.builder.getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            NIOutstandingRequest nIOutstandingRequest = this;
            synchronized (nIOutstandingRequest) {
                if (this.id != null) {
                    NIOutstandingRequestTable.this.map.remove(this.id);
                }
                if (this.escrow != null) {
                    this.escrow.close(new NITimeoutServerException(0));
                }
            }
        }

        public boolean cancel() {
            this.escrow = null;
            this.builder = null;
            this.id = null;
            return super.cancel();
        }
    }
}

