/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.cs;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIPathingReturnCodes;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResponseData;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResultsBuilder;
import com.ibm.storage.ess.ni.application.results.NICopyResult;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceIDPair;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NICopyResultImpl;

public class NICopyResultsBuilder
implements NIResultsBuilder {
    private final int ESTABLISH_FLASH_COPY_PAIR = 1;
    private final int WITHDRAW_FLASH_COPY_PAIR = 2;
    private final int RESET_CONSISTENCY_FLASH_COPY = 3;
    private final int TERMINATE_PPRC = 129;
    private final int ESTABLISH_PPRC = 130;
    private final int SUSPEND_PPRC = 131;
    private final int ESTABLISH_PPRC_PATHS = 132;
    private final int REMOVE_PPRC_PATHS = 133;
    private final int RESET_CONSISTENCY_PPRC = 134;
    private final int FREEZE_CONSISTENCY_PPRC = 135;
    private int establishType;
    private final byte BITFLAG_ESTABLISH_B3_RESTORE_WITH_CHANGES = (byte)8;
    private int numResponses = 0;
    private int receivedResponses = 0;
    private NICopyResult[] results;
    private int commandOrder;
    private String commandString;
    private NIResourceIDPair[] pair;
    private NILSSID[] lss;
    private NILSSID source;
    private NILSSID target;
    private NICopyResult singleResult;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$cs$NICopyResultsBuilder == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$cs$NICopyResultsBuilder = NICopyResultsBuilder.class$("com.ibm.storage.ess.ni.agent.sfiserver.cs.NICopyResultsBuilder")) : class$com$ibm$storage$ess$ni$agent$sfiserver$cs$NICopyResultsBuilder);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$cs$NICopyResultsBuilder;

    public NICopyResultsBuilder(NIResourceIDPair[] nIResourceIDPairArray, int n) {
        this.establishType = n;
        this.setCommandType();
        this.pair = nIResourceIDPairArray;
        this.numResponses = nIResourceIDPairArray.length;
        this.results = new NICopyResult[this.numResponses];
        logger.debug_general("CS >>> " + this.commandOrder + ": Command " + this.commandString + ".  Num of expected responses: " + this.numResponses);
    }

    public NICopyResultsBuilder(NILSSID[] nILSSIDArray, int n) {
        this.establishType = n;
        this.setCommandType();
        this.lss = nILSSIDArray;
        this.numResponses = nILSSIDArray.length;
        this.results = new NICopyResult[this.numResponses];
        logger.debug_general("CS >>> " + this.commandOrder + ": Command " + this.commandString + ".  Num of expected responses: " + this.numResponses);
    }

    public NICopyResultsBuilder(NILSSID nILSSID, NILSSID nILSSID2, int n) {
        this.establishType = n;
        this.setCommandType();
        this.source = nILSSID;
        this.target = nILSSID2;
        this.numResponses = 1;
        this.results = new NICopyResult[this.numResponses];
        logger.debug_general("CS >>> " + this.commandOrder + ": NICopyResult " + this.commandString + " command.  Num of expected responses: " + this.numResponses);
    }

    public void buildResults(NIResponseData nIResponseData) {
        int n = 0;
        boolean bl = true;
        int n2 = 1;
        int n3 = nIResponseData.getIndexToNumberOfRequests();
        int n4 = nIResponseData.getIntValueFromByteArray(n3, 1);
        do {
            NIPathingReturnCodes nIPathingReturnCodes = new NIPathingReturnCodes(nIResponseData.getPaIoctlReturnCode());
            int n5 = nIResponseData.getIndexToEssniData();
            int n6 = nIResponseData.getIntValueFromByteArray(n5, 4);
            if (!nIResponseData.wasCommandSuccessful()) {
                n = nIResponseData.getErrorCode();
                bl = false;
            } else if (!nIPathingReturnCodes.isResponseSuccessful()) {
                n = nIPathingReturnCodes.doesErrorHaveSenseData() ? nIResponseData.getErrorCode() : nIPathingReturnCodes.getErrorCode();
                bl = false;
            } else {
                bl = true;
            }
            NIResourceIDPair nIResourceIDPair = this.getResourcePair(nIResponseData);
            if (bl) {
                logger.debug_general("CS >>> " + this.commandOrder + ": Good " + this.commandString + " command for TagID: " + nIResponseData.getPaIoctlTagID() + " Number Processed " + this.receivedResponses);
            } else {
                logger.error("CS >>> " + this.commandOrder + ": Failed command " + this.commandString + " for TagID: " + nIResponseData.getPaIoctlTagID() + " Failed Error Code: " + Integer.toHexString(0xFFFFFFFF & n));
            }
            NICopyResultImpl nICopyResultImpl = new NICopyResultImpl(nIResourceIDPair, bl, n);
            if (133 == this.establishType || 132 == this.establishType) {
                this.singleResult = nICopyResultImpl;
            } else {
                this.results[n6] = nICopyResultImpl;
            }
            n = 0;
            nIResourceIDPair = null;
            bl = false;
            ++this.receivedResponses;
        } while (++n2 <= n4 && nIResponseData.getNextResponse());
    }

    private NIResourceIDPair getResourcePair(NIResponseData nIResponseData) {
        NIResourceIDPair nIResourceIDPair;
        int n = nIResponseData.getIndexToEssniData();
        int n2 = nIResponseData.getIntValueFromByteArray(n, 4);
        switch (this.establishType) {
            case 1: 
            case 2: 
            case 129: 
            case 130: 
            case 131: 
            case 134: 
            case 135: {
                nIResourceIDPair = this.pair[n2];
                break;
            }
            case 3: {
                nIResourceIDPair = new NIResourceIDPair(this.lss[n2], null);
                break;
            }
            case 132: 
            case 133: {
                nIResourceIDPair = new NIResourceIDPair(this.source, this.target);
                break;
            }
            default: {
                logger.error("CS >>> Unknow establish type " + this.establishType);
                nIResourceIDPair = new NIResourceIDPair(null, null);
            }
        }
        return nIResourceIDPair;
    }

    public Object getResults() {
        switch (this.establishType) {
            case 132: 
            case 133: {
                return this.singleResult;
            }
        }
        if (132 == this.establishType) {
            return this.singleResult;
        }
        return this.results;
    }

    public boolean resultsComplete() {
        if (this.receivedResponses >= this.numResponses) {
            logger.debug_general("CS >>> Done processing NICopyResult for command type " + this.commandString);
            return true;
        }
        return false;
    }

    private void setCommandType() {
        switch (this.establishType) {
            case 1: {
                this.commandString = "FlashCopy Establish";
                this.commandOrder = 48;
                break;
            }
            case 2: {
                this.commandString = "FlashCopy Withdraw";
                this.commandOrder = 49;
                break;
            }
            case 3: {
                this.commandString = "Reset Consistency";
                this.commandOrder = 67;
                break;
            }
            case 129: {
                this.commandString = "Terminate PPRC";
                this.commandOrder = 64;
                break;
            }
            case 130: {
                this.commandString = "Establish PPRC";
                this.commandOrder = 62;
                break;
            }
            case 131: {
                this.commandString = "Suspend PPRC";
                this.commandOrder = 63;
                break;
            }
            case 132: {
                this.commandString = "Establish PPRC Paths";
                this.commandOrder = 60;
                break;
            }
            case 133: {
                this.commandString = "Remove PPRC Paths";
                this.commandOrder = 61;
                break;
            }
            case 134: {
                this.commandString = "Reset PPRC Consistency";
                this.commandOrder = 67;
                break;
            }
            case 135: {
                this.commandString = "Freeze PPRC Consistency";
                this.commandOrder = 66;
                break;
            }
            default: {
                this.commandString = "Unknown type";
                this.commandOrder = 0;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

