/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.cs;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIPathingReturnCodes;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResponseData;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResultsBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.utility.NIByteArrayServices;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceIDPair;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NICopyServicesQueryResultImpl;
import com.ibm.storage.ess.ni.results.NIFlashCopyAttributeImpl;
import com.ibm.storage.ess.ni.results.NIQueryOutOfSyncResultImpl;
import com.ibm.storage.ess.ni.results.NIRelationshipImpl;
import com.ibm.storage.ess.ni.results.NITargetIndicatorSetResultImpl;
import com.ibm.storage.ess.ni.util.NIByteArray;
import java.util.Date;
import java.util.Vector;

public class NIQueryRelationshipResultsBuilder
implements NIResultsBuilder {
    protected static final int RELATIONSHIP_ENTRY_SIZE = 40;
    private static final int QUERY_TYPE_UNKNOWN = -1;
    private static final int QUERY_TYPE_OUT_OF_SYNC = 1000;
    private static final int QUERY_TYPE_VOLUME_PAIR = 1001;
    private static final int QUERY_TYPE_VOLUME_ID = 1002;
    private static final int QUERY_TYPE_VOLUME_RANGE = 1003;
    private static final int QUERY_TYPE_TARGET_BIT_SET = 1004;
    private static final int SIZE_OF_SENSE = 32;
    boolean isSuccessful = true;
    int errorCode = 0;
    private int queryType = -1;
    private int expectedResponses = 0;
    public int receivedResponses = 0;
    private long[] outOfSnycResults;
    private NIQueryOutOfSyncResultImpl outOfSyncImpl;
    private Vector results = new Vector();
    private NICopyServicesQueryResultImpl queryResultImpl = null;
    private NIResourceIDPair[] volumePairs = null;
    private NIVolumeID[] volume = null;
    private boolean isTargetIndicatorBitSet = false;
    private NITargetIndicatorSetResultImpl targetIndicatorBitSet = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$cs$NIQueryRelationshipResultsBuilder == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$cs$NIQueryRelationshipResultsBuilder = NIQueryRelationshipResultsBuilder.class$("com.ibm.storage.ess.ni.agent.sfiserver.cs.NIQueryRelationshipResultsBuilder")) : class$com$ibm$storage$ess$ni$agent$sfiserver$cs$NIQueryRelationshipResultsBuilder);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$cs$NIQueryRelationshipResultsBuilder;

    public NIQueryRelationshipResultsBuilder(NIResourceIDPair[] nIResourceIDPairArray, int n) {
        this.volumePairs = nIResourceIDPairArray;
        this.expectedResponses = nIResourceIDPairArray.length;
        this.queryType = n;
        logger.trace("CS >>> 46: NIQueryRelationship Number of Responses: " + this.expectedResponses + " Query Type: " + this.queryType);
        if (1000 == this.queryType) {
            this.outOfSnycResults = new long[this.expectedResponses];
            int n2 = 0;
            while (n2 < this.expectedResponses) {
                this.outOfSnycResults[n2] = -1L;
                ++n2;
            }
            return;
        }
    }

    public NIQueryRelationshipResultsBuilder(NIVolumeID[] nIVolumeIDArray, int n) {
        this.volume = nIVolumeIDArray;
        this.expectedResponses = nIVolumeIDArray.length;
        this.queryType = n;
        logger.debug_general("CS >>> 46: NIQueryRelationship Number of Responses: " + this.expectedResponses + " Query Type: " + this.queryType);
    }

    public NIQueryRelationshipResultsBuilder(NIVolumeID[] nIVolumeIDArray, int n, int n2) {
        this.volume = nIVolumeIDArray;
        this.expectedResponses = n;
        this.queryType = n2;
        logger.debug_general("CS >>> 46: NIQueryRelationship Number of Responses: " + this.expectedResponses + " Query Type: " + this.queryType);
    }

    private void convertRawData(NIResponseData nIResponseData, int n) {
        byte[] byArray = nIResponseData.getRawData();
        int n2 = nIResponseData.getIndexToEssniData();
        NIByteArray nIByteArray = new NIByteArray(byArray);
        int n3 = nIByteArray.extractInt(n2);
        int n4 = this.getInt32(byArray, n);
        if (40 != byArray[n + 4]) {
            logger.error(" CS >>> 46: bad entry type: " + byArray[n + 4], this.getClass().getName(), "convertRawData", null);
        }
        if (1004 == this.queryType) {
            this.isTargetIndicatorBitSet = (byArray[n + 5] & 8) != 0;
            logger.debug_general("CS >>>  46: Is Target Indicator Set for LSS.Volume? " + Integer.toHexString(0xFF & this.volume[n3].getLSS().getLSSNumber()) + "." + Integer.toHexString(0xFF & this.volume[n3].getVolNumber()) + " " + this.isTargetIndicatorBitSet);
            return;
        }
        int n5 = n += 16;
        if (0 == n4) {
            if (1001 == this.queryType) {
                int n6 = 0xFF & ((NIVolumeID)this.volumePairs[n3].getSource()).getLSS().getLSSNumber();
                int n7 = 0xFF & ((NIVolumeID)this.volumePairs[n3].getSource()).getVolNumber();
                int n8 = 0xFF & ((NIVolumeID)this.volumePairs[n3].getSource()).getLSS().getLSSNumber();
                int n9 = 0xFF & ((NIVolumeID)this.volumePairs[n3].getSource()).getVolNumber();
                logger.trace("CS >>> 46: No Relationship Found For Source LSS.Dev Target LSS.Dev " + n6 + "." + n7 + " " + n8 + "." + n9);
                return;
            }
            if (1003 == this.queryType) {
                logger.trace("CS >>> 46: No Relationship Found For The Volume " + Integer.toHexString(0xFF & this.volume[n3].getLSS().getLSSNumber()) + "." + Integer.toHexString(0xFF & this.volume[n3].getVolNumber()) + " in Range Group");
            } else if (1000 != this.queryType) {
                logger.trace("CS >>> 46: No Relationship Found For LSS.Dev " + Integer.toHexString(0xFF & this.volume[n3].getLSS().getLSSNumber()) + "." + Integer.toHexString(0xFF & this.volume[n3].getVolNumber()));
            }
        }
        int n10 = 0;
        while (n10 < n4) {
            int n11 = n5 + 40 * n10;
            int n12 = 0xFF & byArray[n11];
            int n13 = 0xFF & byArray[n11 + 1];
            boolean bl = (byArray[n11 + 2] & 0x80) != 0;
            NIResourceIDPair nIResourceIDPair = this.getResourcePair(n12, n13, bl, n3);
            if (null != nIResourceIDPair) {
                boolean bl2;
                String string = Integer.toHexString(((NIVolumeID)nIResourceIDPair.getSource()).getLSS().getLSSNumber());
                String string2 = Integer.toHexString(((NIVolumeID)nIResourceIDPair.getSource()).getVolNumber());
                String string3 = Integer.toHexString(((NIVolumeID)nIResourceIDPair.getTarget()).getLSS().getLSSNumber());
                String string4 = Integer.toHexString(((NIVolumeID)nIResourceIDPair.getTarget()).getVolNumber());
                byte[] byArray2 = new byte[]{(byte)(0xFF & byArray[n11 + 2]), (byte)(0xFF & byArray[n11 + 3])};
                boolean bl3 = bl2 = (byArray2[0] & 0x40) != 0;
                if (!bl2) {
                    logger.debug_general("CS >>> 46: Not in a Full Volume Relationship for Source LSS.DEV -> Target LSS.DEV " + string + "." + string2 + " -> " + string3 + "." + string4);
                } else {
                    int n14 = this.getInt32(byArray, n11 + 24);
                    if (1000 == this.queryType) {
                        this.outOfSnycResults[n3] = n14;
                    } else {
                        long l = 0xFFFFFFFFL & (long)this.getInt32(byArray, n11 + 4);
                        long l2 = 1000L * NIByteArrayServices.getLongValueFromByteArray(byArray, n11 + 28, 4);
                        long l3 = 1000L * NIByteArrayServices.getLongValueFromByteArray(byArray, n11 + 32, 4);
                        boolean bl4 = (byArray2[0] & 0x80) == 0;
                        boolean bl5 = (byArray2[0] & 0x20) == 0;
                        boolean bl6 = (byArray2[0] & 0x10) != 0;
                        boolean bl7 = (byArray2[0] & 8) != 0;
                        boolean bl8 = (byArray2[0] & 4) != 0;
                        boolean bl9 = (byArray2[0] & 2) != 0;
                        boolean bl10 = (byArray2[0] & 1) != 0;
                        boolean bl11 = (byArray2[1] & 0x80) != 0;
                        boolean bl12 = (byArray2[1] & 0x40) != 0;
                        logger.debug_general("CS >>> 46: Relationship: " + string + "." + string2 + " -> " + string3 + "." + string4 + "\n\t\t\t>>> 46: Is Src: " + bl4 + "  IsTgt: " + bl + "  IsFullVlm: " + bl2 + "  IsPers: " + bl7 + "  ChangeRcrd: " + bl10 + "  WasEstWBGC: " + bl5 + "  BGC: " + bl6 + " \n\t\t\t>>> 46: TgtWrtInhib: " + bl8 + "  ValidateSet: " + bl9 + "  Revertible: " + bl11 + "  SrcWrtInhib: " + bl12 + " OutOfSync: " + n14 + " Sequence Num:" + l + " \n\t\t\t>>> 46: Creation Time: " + new Date(l2) + "  Last Sync Time: " + new Date(l3));
                        boolean bl13 = true;
                        if (bl9) {
                            bl13 = false;
                            this.errorCode = 3865;
                        }
                        NIFlashCopyAttributeImpl nIFlashCopyAttributeImpl = new NIFlashCopyAttributeImpl(bl4, bl, bl2, bl7, bl10, bl5, bl6, bl8, new Date(l2), new Date(l3), bl13, bl11, bl12, n14, l);
                        NIRelationshipImpl nIRelationshipImpl = new NIRelationshipImpl(nIResourceIDPair, nIFlashCopyAttributeImpl);
                        this.results.addElement(nIRelationshipImpl);
                    }
                }
            }
            ++n10;
        }
    }

    private NIResourceIDPair getResourcePair(int n, int n2, boolean bl, int n3) {
        NIResourceIDPair nIResourceIDPair = null;
        if (null == this.volumePairs) {
            if (null != this.volume) {
                NILSSID nILSSID = null;
                nILSSID = new NILSSID(this.volume[n3].getESS(), n);
                nIResourceIDPair = !bl ? new NIResourceIDPair(this.volume[n3], new NIVolumeID(nILSSID, n2)) : new NIResourceIDPair(new NIVolumeID(nILSSID, n2), this.volume[n3]);
                int n4 = this.volume[n3].getLSS().getLSSNumber();
                int n5 = this.volume[n3].getVolNumber();
                logger.trace(" CS >>> 46: Addressed Client LSS.Vol: " + Integer.toHexString(n4) + "." + Integer.toHexString(n5) + " Partner LSS.Vol: " + Integer.toHexString(n) + "." + Integer.toHexString(n2) + " \n>>> 46:  \t\t\tIs Addressed volume a target? : " + bl);
            }
        } else {
            NIVolumeID nIVolumeID = (NIVolumeID)this.volumePairs[n3].getSource();
            NIVolumeID nIVolumeID2 = (NIVolumeID)this.volumePairs[n3].getTarget();
            int n6 = ((NIVolumeID)this.volumePairs[n3].getTarget()).getLSS().getLSSNumber();
            int n7 = ((NIVolumeID)this.volumePairs[n3].getTarget()).getVolNumber();
            logger.trace(" CS >>> 46: Addressed Client LSS.Vol: " + Integer.toHexString(n6) + "." + Integer.toHexString(n7) + " Query LSS.Vol: " + Integer.toHexString(n) + "." + Integer.toHexString(n2));
            if (n == n6 && n2 == n7) {
                if (!bl) {
                    nIResourceIDPair = this.volumePairs[n3];
                } else {
                    return null;
                }
            }
        }
        return nIResourceIDPair;
    }

    private int getInt32(byte[] byArray, int n) {
        return ((byArray[n + 0] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    public void buildResults(NIResponseData nIResponseData) {
        int n = 0;
        int n2 = nIResponseData.getIndexToNumberOfRequests();
        int n3 = nIResponseData.getIntValueFromByteArray(n2, 1);
        logger.debug_general("Number of requests " + n3);
        int n4 = 1;
        do {
            int n5 = 0;
            NIPathingReturnCodes nIPathingReturnCodes = new NIPathingReturnCodes(nIResponseData.getPaIoctlReturnCode());
            boolean bl = true;
            if (this.receivedResponses < this.expectedResponses) {
                boolean bl2;
                n = nIResponseData.getIndexToOutputData();
                boolean bl3 = bl2 = nIResponseData.getPaIoctlReturnCode() == nIPathingReturnCodes.getDeviceNotDefinedCode();
                if (!nIResponseData.wasCommandSuccessful()) {
                    this.errorCode = nIResponseData.getErrorCode();
                    this.isSuccessful = false;
                    bl = false;
                } else if (!nIPathingReturnCodes.isResponseSuccessful()) {
                    n5 = nIPathingReturnCodes.doesErrorHaveSenseData() ? nIResponseData.getErrorCode() : nIPathingReturnCodes.getErrorCode();
                    if (!bl2 || 1004 == this.queryType) {
                        logger.debug_general("CS >>> 46: Failed on Query.  Query Type: " + this.queryType + " Lss: 0x" + Integer.toHexString(0xFF & nIResponseData.getLss()) + " Dev: 0x" + Integer.toHexString(0xFF & nIResponseData.getDevice()) + " Sense Data: \n\t\t\t" + NIByteArrayServices.getHexString(nIResponseData.getSenseData(32), 32, "46"));
                        this.isSuccessful = false;
                        bl = false;
                        this.errorCode = n5;
                    }
                }
                if (bl && nIResponseData.getPaIoctlReturnCode() != nIPathingReturnCodes.getDeviceNotDefinedCode()) {
                    n = nIResponseData.getIndexToOutputData();
                    this.convertRawData(nIResponseData, n);
                } else if (!(1001 != this.queryType && 1003 != this.queryType && 1002 != this.queryType || bl)) {
                    NIRelationshipImpl nIRelationshipImpl;
                    byte[] byArray = nIResponseData.getRawData();
                    int n6 = nIResponseData.getIndexToEssniData();
                    NIByteArray nIByteArray = new NIByteArray(byArray);
                    int n7 = nIByteArray.extractInt(n6);
                    NIFlashCopyAttributeImpl nIFlashCopyAttributeImpl = new NIFlashCopyAttributeImpl(this.errorCode);
                    if (1001 == this.queryType) {
                        nIRelationshipImpl = new NIRelationshipImpl(this.volumePairs[n7], nIFlashCopyAttributeImpl);
                        this.results.addElement(nIRelationshipImpl);
                    } else {
                        nIRelationshipImpl = new NIRelationshipImpl(new NIResourceIDPair(this.volume[n7], this.volume[n7]), nIFlashCopyAttributeImpl);
                        this.results.addElement(nIRelationshipImpl);
                    }
                }
            } else {
                logger.error("CS >>> 46: received response data when already " + this.receivedResponses + " responses received");
            }
            ++this.receivedResponses;
        } while (++n4 <= n3 && nIResponseData.getNextResponse());
        logger.debug_general("CS >>> 46: Number of querries processed " + this.receivedResponses + " of " + this.expectedResponses + " expected.");
        if (this.resultsComplete()) {
            if (1000 == this.queryType) {
                this.outOfSyncImpl = new NIQueryOutOfSyncResultImpl(this.outOfSnycResults, this.isSuccessful, this.errorCode);
            } else if (1004 == this.queryType) {
                this.targetIndicatorBitSet = new NITargetIndicatorSetResultImpl(this.isTargetIndicatorBitSet, this.isSuccessful, this.errorCode);
            } else {
                this.queryResultImpl = new NICopyServicesQueryResultImpl(this.results, this.isSuccessful, this.errorCode);
            }
        }
    }

    public Object getResults() {
        if (1000 == this.queryType) {
            logger.debug_general("CS >>> 46: Result complete for Query type out of sync.");
            return this.outOfSyncImpl;
        }
        if (1004 == this.queryType) {
            logger.debug_general("CS >>> 46: Result complete for Query type is target indicator set. Is the Target bit set? " + this.targetIndicatorBitSet.isTargetIndicsatorSet());
            System.out.println("is target set? " + this.targetIndicatorBitSet.isTargetIndicsatorSet());
            return this.targetIndicatorBitSet;
        }
        if (this.queryResultImpl == null) {
            System.out.println("CS >>> 46: The result is null");
        }
        logger.debug_general("CS >>> 46: Result complete for Query FlashCopy Type: " + this.queryType);
        return this.queryResultImpl;
    }

    public boolean resultsComplete() {
        return this.receivedResponses >= this.expectedResponses;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

