/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.cs.pprc;

import com.ibm.storage.ess.ni.util.NIAsciiEbcdicConverter;

public class NI0FQueryParser {
    public static final byte MASK_TRUSTED_PRIME_FOR_RESYNC = 1;
    public static final byte MASK_CASCADING = 1;
    public static final byte MASK_SECONDARY_READ_ENABLED = 4;
    public static final byte MASK_PPRC_STATE = 56;
    public static final byte PPRC_STATE_EXTENDED_DISTANCE = 8;
    public static final byte PPRC_STATE_SYNCHRONOUS = 0;
    public static final byte PPRC_STATE_EXTENDED_DISTANCE_FIRST_PASS = 40;
    public static final byte PAIR_STATE_NONE = 0;
    public static final byte PAIR_STATE_COPY_PENDING = 1;
    public static final byte PAIR_STATE_FULL_COPY = 2;
    public static final byte PAIR_STATE_SUSPENDED_HOST_PRIMARY = 3;
    public static final byte PAIR_STATE_SUSPENDED_HOST_SECONDARY = 4;
    public static final byte PAIR_STATE_SUSPENDED_PRIMARY_CU_UPDATE_SECONDARY = 5;
    public static final byte PAIR_STATE_SUSPENDED_INTERNAL_CONDITION = 6;
    public static final byte PAIR_STATE_SUSPENDED_SECONDARY_CU_STATE_CHANGE = 7;
    public static final byte PAIR_STATE_SUSPENDED_SECONDARY_INTERNAL = 8;
    public static final byte PAIR_STATE_SUSPENDED_IML = 9;
    public static final byte PAIR_STATE_SUSPENDED_HOST_FREEZE = 10;
    public static final byte PAIR_STATE_VOLUME_NOT_CONFIGURED = 11;
    public static final byte PATH_STATUS_NONE = 0;
    public static final byte PATH_STATUS_ESTABLISHED_ESCON = 1;
    public static final byte PATH_STATUS_INITIALIZATION_FAILED = 2;
    public static final byte PATH_STATUS_TIME_OUT = 3;
    public static final byte PATH_STATUS_PRIMARY_RESOURCE_UNAVAILABLE = 4;
    public static final byte PATH_STATUS_SECONDARY_RESOURCE_UNAVAILABLE = 5;
    public static final byte PATH_STATUS_SECONDARY_CU_SEQUENCE_OR_LSS_NUM_MISMATCH = 6;
    public static final byte PATH_STATUS_SECONDARY_CU_SSID_MISMATCH = 7;
    public static final byte PATH_STATUS_ESCON_OFFLINE = 8;
    public static final byte PATH_STATUS_ESTABLISH_FAILED_WITH_RETRY = 9;
    public static final byte PATH_STATUS_PORT_STATE_INVALID = 10;
    public static final byte PATH_STATUS_CONFIGURATION_ERROR = 16;
    public static final byte PATH_STATUS_ESTABLISHED_FCP = 19;
    public static final byte PATH_STATUS_FCP_LINK_DOWN = 20;
    public static final byte PATH_STATUS_FCP_RETRY_EXCEEDED = 21;
    public static final byte PATH_STATUS_FCP_SECONDARY_NOT_PPRC_CAPABLE = 22;
    public static final byte PATH_STATUS_FCP_SECONDARY_UNAVAILABLE = 23;
    public static final byte PATH_STATUS_FCP_PRIMARY_LOGIN_EXCEEDED = 24;
    public static final byte PATH_STATUS_FCP_SECONDARY_LOGIN_EXCEEDED = 25;
    private static final byte[] MASK_BIT_NUMS;
    private static final int BYTE_VOLUME_COPY_STATE = 0;
    private static final int BYTE_FLAG_1 = 1;
    private static final int BYTE_VOLUME_CODES_FB = 2;
    private static final int BYTE_FLAG_2 = 3;
    private static final int BYTE_LSS_PRIMARY = 4;
    private static final int BYTE_VOLUME_PRIMARY = 5;
    private static final int BYTE_LSS_SECONDARY = 6;
    private static final int BYTE_VOLUME_SECONDARY = 7;
    private static final int BYTE_PPRC_ID = 8;
    private static final int BYTE_FLAG_3 = 10;
    private static final int BYTE_CU_SEQUENCE_PRIMARY = 12;
    private static final int BYTE_CU_SSID_PRIMARY = 22;
    private static final int BYTE_CU_SEQUENCE_SECONDARY = 26;
    private static final int BYTE_CU_SSID_SECONDARY = 36;
    private static final int BYTE_MULTI_USE_SUSPEND_TIME_OR_PENDING_TRACKS = 42;
    private static final int BYTE_FLAGS_VOLUME_INFORMATION = 50;
    private static final int BYTE_TRACK_SIZE = 51;
    private static final int BYTE_NUM_TRACKS = 54;
    private static final int BYTE_COUNT_VALID_CU = 59;
    private static final int[] BYTE_PATH_CU_SEQUENCE_SECONDARY;
    private static final int[] BYTE_PATH_CU_SSID_SECONDARY;
    private static final int[] BYTE_PATH_LSS_SECONDARY;
    private static final int[] BYTE_PATH_NUM_VALID_ENTRIES;
    private static final int[][] BYTE_PATH_SAID_PRIMARY;
    private static final int[][] BYTE_PATH_SAID_SECONDARY;
    private static final int[][] BYTE_PATH_STATUS;
    private static final int BYTE_PATH_WWNN_PRIMARY = 384;
    private static final int[] BYTE_PATH_WWNN_SECONDARY;
    private byte[] rawData = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI0FQueryParser;

    public NI0FQueryParser(byte[] byArray) {
        this.rawData = byArray;
    }

    public int getPrimaryVolumeNumber() {
        return this.rawData[5];
    }

    public int getSecondaryVolumeNumber() {
        return this.rawData[7];
    }

    public int getPrimaryLssNumber() {
        return this.rawData[4];
    }

    public int getSecondaryLssNumber() {
        return this.rawData[6];
    }

    public byte getVolumeRemoteCopyState() {
        return this.rawData[0];
    }

    public byte getFlagByte1() {
        return this.rawData[1];
    }

    public byte getFlagByte2() {
        return this.rawData[3];
    }

    public byte getFlagByte3() {
        return this.rawData[10];
    }

    public byte getFBVOlumeCodes() {
        return this.rawData[2];
    }

    public int getPPRCID() {
        return this.convertToInt(8, 2);
    }

    public String getPrimaryCUSequence() {
        return this.convertSequenceNumber(12);
    }

    public int getPrimarySSID() {
        return this.convertToInt(22, 2);
    }

    public String getSecondaryCUSequence() {
        return this.convertSequenceNumber(26);
    }

    public int getSecondarySSID() {
        return this.convertToInt(36, 2);
    }

    public long getOutOfSyncTracks() {
        long l = -1L;
        if ((this.rawData[1] & MASK_BIT_NUMS[3]) == 0) {
            l = this.convertToLong(42, 8);
        }
        return l;
    }

    public long getSuspensionTime() {
        long l = -1L;
        if ((this.rawData[1] & MASK_BIT_NUMS[3]) != 0) {
            l = this.convertToLong(42, 8);
        }
        return l;
    }

    public byte getVolumeInformationFlags() {
        return this.rawData[50];
    }

    public int getTrackSize() {
        return this.convertToInt(51, 4);
    }

    public int getNumTracks() {
        return this.convertToInt(54, 4);
    }

    public byte getValidControlUnitCount() {
        return this.rawData[59];
    }

    public String getPathSecondaryCUSequenceNum(int n) {
        return this.convertSequenceNumber(BYTE_PATH_CU_SEQUENCE_SECONDARY[n]);
    }

    public int getPathSecondarySSID(int n) {
        return this.convertToInt(BYTE_PATH_CU_SSID_SECONDARY[n], 2);
    }

    public byte getPathSecondaryLSSNumber(int n) {
        return this.rawData[BYTE_PATH_LSS_SECONDARY[n]];
    }

    public byte getPathCount(int n) {
        return this.rawData[BYTE_PATH_NUM_VALID_ENTRIES[n]];
    }

    public int getPrimarySAID(int n, int n2) {
        return this.convertToInt(BYTE_PATH_SAID_PRIMARY[n][n2], 2);
    }

    public int getSecondarySAID(int n, int n2) {
        return this.convertToInt(BYTE_PATH_SAID_SECONDARY[n][n2], 2);
    }

    public byte getPathStatus(int n, int n2) {
        return this.rawData[BYTE_PATH_STATUS[n][n2]];
    }

    private String convertSequenceNumber(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 5;
        while (n2 < 10) {
            stringBuffer.append((char)NIAsciiEbcdicConverter.convertToASCII(this.rawData[n + n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public long getPrimaryCUWWNN() {
        return this.convertToLong(384, 8);
    }

    public long getSecondaryCUWWNN(int n) {
        return this.convertToLong(BYTE_PATH_WWNN_SECONDARY[n], 8);
    }

    private int convertToInt(int n, int n2) {
        if (!($assertionsDisabled || 0 < n2 && n2 <= 4)) {
            throw new AssertionError();
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 <<= 8;
            n3 |= this.rawData[n + n4] & 0xFF;
            ++n4;
        }
        return n3;
    }

    private long convertToLong(int n, int n2) {
        if (!($assertionsDisabled || 0 < n2 && n2 <= 8)) {
            throw new AssertionError();
        }
        long l = 0L;
        int n3 = 0;
        while (n3 < n2) {
            l <<= 8;
            l |= (long)(this.rawData[n + n3] & 0xFF);
            ++n3;
        }
        return l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI0FQueryParser == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI0FQueryParser = NI0FQueryParser.class$("com.ibm.storage.ess.ni.agent.sfiserver.cs.pprc.NI0FQueryParser")) : class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI0FQueryParser).desiredAssertionStatus();
        MASK_BIT_NUMS = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        BYTE_PATH_CU_SEQUENCE_SECONDARY = new int[]{62, 142, 222, 302};
        BYTE_PATH_CU_SSID_SECONDARY = new int[]{72, 152, 232, 312};
        BYTE_PATH_LSS_SECONDARY = new int[]{74, 154, 234, 314};
        BYTE_PATH_NUM_VALID_ENTRIES = new int[]{75, 155, 235, 315};
        BYTE_PATH_SAID_PRIMARY = new int[][]{{76, 84, 92, 100, 108, 116, 124, 132}, {156, 164, 172, 180, 188, 196, 204, 212}, {236, 244, 252, 260, 268, 276, 284, 292}, {316, 324, 332, 340, 348, 356, 364, 372}};
        BYTE_PATH_SAID_SECONDARY = new int[][]{{80, 88, 96, 104, 112, 120, 128, 136}, {160, 168, 176, 184, 192, 200, 208, 216}, {240, 248, 256, 264, 272, 280, 288, 296}, {320, 328, 336, 344, 352, 360, 368, 376}};
        BYTE_PATH_STATUS = new int[][]{{83, 91, 99, 107, 115, 123, 131, 139}, {163, 171, 179, 187, 195, 203, 211, 219}, {243, 251, 259, 267, 275, 283, 291, 299}, {323, 331, 339, 347, 355, 363, 371, 379}};
        BYTE_PATH_WWNN_SECONDARY = new int[]{392, 400, 408, 416};
    }
}

