/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.cs.pprc;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIFCPPortID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NIFCPCandidateConnectionImpl;
import java.util.List;
import java.util.Vector;

public class NI49QueryParser {
    private static final int BYTE_FLAGS = 4;
    private static final int BYTE_NUM_SECONDARY_ADAPTERS = 6;
    private static final int BYTE_WWNN_PRIMARY = 8;
    private static final int BYTE_WWNN_SECONDARY = 16;
    private static final int BYTE_SECONDARY_ADAPTER_START = 24;
    private static final int OFFSET_PRIMARY_ADAPTER_BITMAP = 2;
    private static final int[] MASK_BIT;
    private int byteNumSystemAdapterEntries = -1;
    private int bytePrimaryAdapterStart = -1;
    private int bitmapSize = -1;
    private byte[] rawData = null;
    private int numberOfSecondaryAdapters = 0;
    private static final Logger logger;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI49QueryParser;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NI49QueryParser(byte[] byArray) {
        this.rawData = byArray;
        this.numberOfSecondaryAdapters = this.convertToInt(6, 2);
        this.byteNumSystemAdapterEntries = 24 + 2 * this.numberOfSecondaryAdapters;
        this.bytePrimaryAdapterStart = this.byteNumSystemAdapterEntries + 4;
        this.bitmapSize = this.numberOfSecondaryAdapters / 8;
    }

    public int getFlags() {
        return this.convertToInt(4, 2);
    }

    public long getSecondaryWWNN() {
        System.out.println(" secondary wwnn " + this.convertToLong(16, 8));
        return this.convertToLong(16, 8);
    }

    public long getPrimaryWWNN() {
        System.out.println(" primary wwnn " + this.convertToLong(8, 8));
        return this.convertToLong(8, 8);
    }

    public List getValidConnections(NIESSID nIESSID, NIESSID nIESSID2) {
        int n;
        Vector<NIFCPCandidateConnectionImpl> vector = new Vector<NIFCPCandidateConnectionImpl>();
        int n2 = this.convertToInt(this.byteNumSystemAdapterEntries, 2);
        logger.trace(" number of adapt entries " + n2);
        int[] nArray = new int[this.numberOfSecondaryAdapters];
        int n3 = 0;
        while (n3 < this.numberOfSecondaryAdapters) {
            n = 24 + n3 * 2;
            nArray[n3] = this.convertToInt(n, 2);
            ++n3;
        }
        n = 0;
        while (n < n2) {
            int n4 = this.bytePrimaryAdapterStart + (this.bitmapSize + 4) * n;
            int n5 = this.convertToInt(n4 + 2, 2);
            if (0 == n5) {
                NIFCPPortID nIFCPPortID = new NIFCPPortID(nIESSID, this.convertToInt(n4, 2));
                Vector vector2 = this.getNthElementForSecondaryPort(n4);
                int n6 = 0;
                while (n6 < vector2.size()) {
                    NIFCPPortID nIFCPPortID2 = new NIFCPPortID(nIESSID2, nArray[(Integer)vector2.get(n6)]);
                    vector.add(new NIFCPCandidateConnectionImpl(nIFCPPortID, nIFCPPortID2));
                    logger.debug_general("CS >>>  FCP Candidate: " + Integer.toHexString(nIFCPPortID.getPortID()) + " -> " + Integer.toHexString(nIFCPPortID2.getPortID()));
                    ++n6;
                }
            }
            ++n;
        }
        return vector;
    }

    Vector getNthElementForSecondaryPort(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 0;
        while (n2 < this.bitmapSize) {
            int n3 = this.convertToInt(n + 4 + n2, 1);
            if (0 != n3) {
                if ((n3 & 0x80) > 0) {
                    vector.add(new Integer(n2 * 8 + 1 - 1));
                }
                if ((n3 & 0x40) > 0) {
                    vector.add(new Integer(n2 * 8 + 2 - 1));
                }
                if ((n3 & 0x20) > 0) {
                    vector.add(new Integer(n2 * 8 + 3 - 1));
                }
                if ((n3 & 0x10) > 0) {
                    vector.add(new Integer(n2 * 8 + 4 - 1));
                }
                if ((n3 & 8) > 0) {
                    vector.add(new Integer(n2 * 8 + 5 - 1));
                }
                if ((n3 & 4) > 0) {
                    vector.add(new Integer(n2 * 8 + 6 - 1));
                }
                if ((n3 & 2) > 0) {
                    vector.add(new Integer(n2 * 8 + 7 - 1));
                }
                if ((n3 & 1) > 0) {
                    vector.add(new Integer(n2 * 8 + 8 - 1));
                }
            }
            ++n2;
        }
        return vector;
    }

    private int convertToInt(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        if (!($assertionsDisabled || 0 < n2 && n2 <= 4)) {
            throw new AssertionError();
        }
        int n5 = n2 - 1;
        while (n5 >= 0) {
            n3 += NI49QueryParser.unsignedByteToInt(this.rawData[n4++]) << 8 * n5;
            --n5;
        }
        return n3;
    }

    public static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    private long convertToLong(int n, int n2) {
        if (!($assertionsDisabled || 0 < n2 && n2 <= 8)) {
            throw new AssertionError();
        }
        long l = 0L;
        int n3 = 0;
        while (n3 < n2) {
            l <<= 8;
            l &= (long)this.rawData[n + n3];
            ++n3;
        }
        return l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI49QueryParser == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI49QueryParser = NI49QueryParser.class$("com.ibm.storage.ess.ni.agent.sfiserver.cs.pprc.NI49QueryParser")) : class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI49QueryParser).desiredAssertionStatus();
        MASK_BIT = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
        logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI49QueryParser == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI49QueryParser = NI49QueryParser.class$("com.ibm.storage.ess.ni.agent.sfiserver.cs.pprc.NI49QueryParser")) : class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI49QueryParser);
    }
}

