/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.cs.pprc;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.sfiserver.utility.NIByteArrayServices;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.util.NIAsciiEbcdicConverter;
import java.util.Date;

public class NI50QueryParser {
    private static final Logger logger;
    public static final byte MASK_TRUSTED_PRIME_FOR_RESYNC = 1;
    public static final byte MASK_CASCADING = 1;
    public static final byte MASK_SECONDARY_READ_ENABLED = 4;
    public static final byte MASK_PPRC_SUSPEND_STATE = 63;
    public static final byte MASK_SECONDARY_VOLUME_RESERVED = -128;
    public static final byte MASK_VOLUME_HAS_PINNED_DATA = 32;
    public static final byte MASK_VOLUME_IN_PATH_GROUP = 16;
    public static final byte MASK_VOLUME_IN_XRC_SESSION = 8;
    public static final byte MASK_VOLUME_IN_CONCURRENT_COPY_SESSION = 4;
    public static final byte MASK_VOLUME_IN_FLC_RELATIONSHIP = 2;
    public static final byte PPRC_STATE_EXTENDED_DISTANCE = 8;
    public static final byte PPRC_STATE_SYNCHRONOUS = 0;
    public static final byte PPRC_STATE_EXTENDED_DISTANCE_FIRST_PASS = 40;
    public static final byte PAIR_STATE_NONE = 0;
    public static final byte PAIR_STATE_COPY_PENDING = 1;
    public static final byte PAIR_STATE_FULL_COPY = 2;
    public static final byte PAIR_STATE_SUSPENDED_HOST_PRIMARY = 3;
    public static final byte PAIR_STATE_SUSPENDED_HOST_SECONDARY = 4;
    public static final byte PAIR_STATE_SUSPENDED_PRIMARY_CU_UPDATE_SECONDARY = 5;
    public static final byte PAIR_STATE_SUSPENDED_INTERNAL_CONDITION = 6;
    public static final byte PAIR_STATE_SUSPENDED_SECONDARY_CU_STATE_CHANGE = 7;
    public static final byte PAIR_STATE_SUSPENDED_SECONDARY_INTERNAL = 8;
    public static final byte PAIR_STATE_SUSPENDED_IML = 9;
    public static final byte PAIR_STATE_SUSPENDED_HOST_FREEZE = 10;
    public static final byte PAIR_STATE_VOLUME_NOT_CONFIGURED = 11;
    public static final int PAIR_FLAG_BYTE_ONE_PRIMARY_ADDRESSED = 128;
    public static final int PAIR_FLAG_BYTE_ONE_PATHING_NOT_ACTIVE = 64;
    public static final int PAIR_FLAG_BYTE_ONE_RETRANSMITTING_RANGE = 16;
    public static final int PAIR_FLAG_BYTE_ONE_CRITICAL_WRITE_STATE = 8;
    public static final int PAIR_FLAG_BYTE_ONE_VPD_SET = 4;
    public static final int PAIR_FLAG_BYTE_ONE_CONSISTENCY_GROUPING = 2;
    public static final int PAIR_FLAG_BYTE_ONE_FB_VOLUME = 1;
    public static final int PPRC_FLAG_BYTE_TWO_SYNCHRONIZING = 128;
    public static final byte PPRC_FLAG_BYTE_TWO_SECONDARY_ALLOWED = 64;
    public static final byte PPRC_FLAG_BYTE_TWO_SECONDARY_READ_ENABLED = 4;
    public static final byte PPRC_FLAG_BYTE_TWO_STATE_SYNCHRONOUS = 56;
    public static final byte PPRC_FLAG_BYTE_TWO_STATE_EXTENDED_DISTANCE = 8;
    public static final byte PPRC_FLAG_BYTE_TWO_STATE_ORDERED_VOLUME_ASYCN = 16;
    public static final byte PPRC_FLAG_BYTE_TWO_STATE_ORDERED_LSS_ASYCN = 24;
    public static final byte PPRC_FLAG_BYTE_TWO_STATE_CONSISTENT_ASYCN = 32;
    public static final byte PPRC_FLAG_BYTE_TWO_STATE_EXTENDED_DISTANCE_FIRST_PASS = 40;
    public static final int PPRC_FLAG_BYTE_THREE_AUTO_UNSUSPEND = 128;
    public static final byte PATH_STATUS_NONE = 0;
    public static final byte PATH_STATUS_ESTABLISHED_ESCON = 1;
    public static final byte PATH_STATUS_INITIALIZATION_FAILED = 2;
    public static final byte PATH_STATUS_TIME_OUT = 3;
    public static final byte PATH_STATUS_PRIMARY_RESOURCE_UNAVAILABLE = 4;
    public static final byte PATH_STATUS_SECONDARY_RESOURCE_UNAVAILABLE = 5;
    public static final byte PATH_STATUS_SECONDARY_CU_SEQUENCE_OR_LSS_NUM_MISMATCH = 6;
    public static final byte PATH_STATUS_SECONDARY_CU_SSID_MISMATCH = 7;
    public static final byte PATH_STATUS_ESCON_OFFLINE = 8;
    public static final byte PATH_STATUS_ESTABLISH_FAILED_WITH_RETRY = 9;
    public static final byte PATH_STATUS_PORT_STATE_INVALID = 10;
    public static final byte PATH_STATUS_CONFIGURATION_ERROR = 16;
    public static final byte PATH_STATUS_ESTABLISHED_FCP = 19;
    public static final byte PATH_STATUS_FCP_LINK_DOWN = 20;
    public static final byte PATH_STATUS_FCP_RETRY_EXCEEDED = 21;
    public static final byte PATH_STATUS_FCP_SECONDARY_NOT_PPRC_CAPABLE = 22;
    public static final byte PATH_STATUS_FCP_SECONDARY_UNAVAILABLE = 23;
    public static final byte PATH_STATUS_FCP_PRIMARY_LOGIN_EXCEEDED = 24;
    public static final byte PATH_STATUS_FCP_SECONDARY_LOGIN_EXCEEDED = 25;
    public static final byte CASCADE_ENABLED = 1;
    private static final byte[] MASK_BIT_NUMS;
    private static final int BYTE_VOLUME_COPY_STATE = 0;
    private static final int BYTE_FLAG_1 = 1;
    private static final int BYTE_VOLUME_CODES_FB = 2;
    private static final int BYTE_FLAG_2 = 3;
    private static final int BYTE_LSS_PRIMARY = 4;
    private static final int BYTE_VOLUME_PRIMARY = 5;
    private static final int BYTE_LSS_SECONDARY = 6;
    private static final int BYTE_VOLUME_SECONDARY = 7;
    private static final int BYTE_PPRC_ID = 8;
    private static final int BYTE_FLAG_3 = 10;
    private static final int BYTE_CU_SEQUENCE_PRIMARY = 12;
    private static final int BYTE_CU_SSID_PRIMARY = 22;
    private static final int BYTE_INDEX_PATH_ENTRY_WITH_SECONDARY_PAIR_INFO = 25;
    private static final int BYTE_CU_SEQUENCE_SECONDARY = 26;
    private static final int BYTE_CU_SSID_SECONDARY = 36;
    private static final int BYTE_FLAGS_VOLUME_INFORMATION = 38;
    private static final int BYTE_PATH_CC_1ST_CYLINDER_OOS = 40;
    private static final int BYTE_PATH_CC_LASTCYLINDER_OOS = 48;
    private static final int BYTE_MULTI_USE_SUSPEND_TIME_OR_PENDING_TRACKS = 56;
    private static final int BYTE_TRACK_SIZE = 64;
    private static final int BYTE_NUM_TRACKS = 72;
    private static final int BYTE_WWNN_PRIMARY = 80;
    private static final int BYTE_CREATE_TIME = 88;
    private static final int BYTE_PATH_PPRC_SYNC_TIME = 92;
    private static final int BYTE_ADDRESSED_DEV_MACHINE_TYPE = 98;
    private static final int BYTE_ADDRESSED_DEV_POM = 105;
    private static final int BYTE_PARTNER_DEV_MACHINE_TYPE = 109;
    private static final int BYTE_PARTNER_DEV_POM = 113;
    private static final int BYTE_COUNT_VALID_CU = 127;
    private static final int[] BYTE_PATH_CU_SEQUENCE_SECONDARY;
    private static final int[] BYTE_PATH_WWNN_SECONDARY;
    private static final int[] BYTE_PATH_CU_SSID_SECONDARY;
    private static final int[] BYTE_PATH_LSS_SECONDARY;
    private static final int[] BYTE_PATH_MACHINE_TYPE_SECONDARY;
    private static final int[] BYTE_PATH_MACHINE_MODEL_SECONDARY;
    private static final int[] BYTE_PATH_POM_SECONDARY;
    private static final int[] BYTE_PATH_NUM_VALID_ENTRIES;
    private static final int[][] BYTE_PATH_SAID_PRIMARY;
    private static final int[][] BYTE_PATH_SAID_SECONDARY;
    private static final int[][] BYTE_PATH_STATUS;
    private static final int TWO_BYTES = 2;
    private static final int FOUR_BYTES = 4;
    private static final int EIGHT_BYTES = 8;
    private static final int ESS_TYPE_LENGTH = 4;
    private static final int ESS_TYPE_FIELD_LENGTH = 6;
    private static final int ESS_CU_SEQUENCE_NUMBER_FIELD_LENGTH = 10;
    private static final int ESS_MODEL_LENGTH = 3;
    private static final int ESS_POM_LENGTH = 2;
    private byte[] rawData = null;
    private boolean valid;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI50QueryParser;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NI50QueryParser(byte[] byArray) {
        this.rawData = byArray;
        this.valid = true;
    }

    private boolean isStringValid(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            if (this.rawData[n + n3] == 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private String getTargetESSType(int n) {
        if (this.isStringValid(BYTE_PATH_MACHINE_TYPE_SECONDARY[n] + 2, 4)) {
            return this.convertToString(BYTE_PATH_MACHINE_TYPE_SECONDARY[n] + 2, 4);
        }
        return "Unknown";
    }

    private String getTargetESSModel(int n) {
        return this.convertToString(BYTE_PATH_MACHINE_MODEL_SECONDARY[n], 3);
    }

    private String getTargetESSPOM(int n) {
        if (this.isStringValid(BYTE_PATH_POM_SECONDARY[n], 2)) {
            return this.convertToString(BYTE_PATH_POM_SECONDARY[n], 2);
        }
        return "Unknown";
    }

    private String convertToString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append((char)NIAsciiEbcdicConverter.convertToASCII(this.rawData[n + n3]));
            ++n3;
        }
        return stringBuffer.toString();
    }

    public NIESSID getTargetESS(int n) {
        return new NIESSID(this.getTargetESSType(n), this.getTargetESSPOM(n), this.getPathSecondaryCUSequenceNum(n), this.getSecondaryCUWWNN(n));
    }

    public NILSSID getTargetLSS(int n) {
        return new NILSSID(this.getTargetESS(n), this.getPathSecondaryLSSNumber(n), this.getPathSecondarySSID(n));
    }

    public int getPrimaryVolumeNumber() {
        return 0xFF & this.rawData[5];
    }

    public int getSecondaryVolumeNumber() {
        return 0xFF & this.rawData[7];
    }

    public int getPrimaryLssNumber() {
        return 0xFF & this.rawData[4];
    }

    public int getSecondaryLssNumber() {
        return 0xFF & this.rawData[6];
    }

    public long getSecondaryCUWWNN() {
        if ((0xFF & this.rawData[25]) == 0) {
            if (this.valid) {
                String string = NIByteArrayServices.getHexString(this.rawData, this.rawData.length);
                logger.error("CS >>> Invalid Data From Microcode !!! " + string);
                this.valid = false;
            }
            return this.getSecondaryCUWWNN(0);
        }
        int n = (0xFF & this.rawData[25]) - 1;
        return this.getSecondaryCUWWNN(n);
    }

    public String getAddressedVolumeMachineType() {
        return this.convertToString(98, 4);
    }

    public String getAddressedVolumePOM() {
        return this.convertToString(105, 2);
    }

    public String getPartnerVolumePOM() {
        return this.convertToString(113, 2);
    }

    public String getPartnerMachineType() {
        return this.convertToString(109, 4);
    }

    public String getSecondaryMachineType() {
        if ((0xFF & this.rawData[25]) == 0) {
            if (this.valid) {
                String string = NIByteArrayServices.getHexString(this.rawData, this.rawData.length);
                logger.error("CS >>> Invalid Data From Microcode !!! " + string);
                this.valid = false;
            }
            return this.getTargetESSType(0);
        }
        int n = (0xFF & this.rawData[25]) - 1;
        return this.getTargetESSType(n);
    }

    public String getSecondaryPOM() {
        if ((0xFF & this.rawData[25]) == 0) {
            if (this.valid) {
                String string = NIByteArrayServices.getHexString(this.rawData, this.rawData.length);
                logger.error("CS >>> Invalid Data From Microcode !!! " + string);
                this.valid = false;
            }
            return this.getTargetESSPOM(0);
        }
        int n = (0xFF & this.rawData[25]) - 1;
        return this.getTargetESSPOM(n);
    }

    public int getVolumeRemoteCopyState() {
        return 0xFF & this.rawData[0];
    }

    public int getFlagByte1() {
        return 0xFF & this.rawData[1];
    }

    public int getFlagByte2() {
        return 0xFF & this.rawData[3];
    }

    public int getFlagByte3() {
        return 0xFF & this.rawData[10];
    }

    public int getFBVOlumeCodes() {
        return 0xFF & this.rawData[2];
    }

    public int getPPRCID() {
        return this.convertToInt(8, 2);
    }

    public String getPrimaryCUSequence() {
        return this.convertSequenceNumber(12);
    }

    public int getPrimarySSID() {
        return this.convertToInt(22, 2);
    }

    public String getSecondaryCUSequence() {
        return this.convertSequenceNumber(26);
    }

    public int getSecondarySSID() {
        return this.convertToInt(36, 2);
    }

    public long getOutOfSyncTracks() {
        long l = -1L;
        if ((this.rawData[1] & MASK_BIT_NUMS[3]) == 0) {
            l = this.convertToLong(56, 8);
        }
        return l;
    }

    public long getCreateTime() {
        return this.convertToLong(88, 4);
    }

    public long getSuspensionTime() {
        long l = -1L;
        if ((this.rawData[1] & MASK_BIT_NUMS[3]) != 0) {
            l = this.convertToLong(56, 8);
        }
        return l;
    }

    public byte getVolumeInformationFlags() {
        return (byte)(0xFF & this.rawData[38]);
    }

    public int getTrackSize() {
        return this.convertToInt(64, 8);
    }

    public int getNumTracks() {
        return this.convertToInt(72, 8);
    }

    public byte getValidControlUnitCount() {
        return (byte)(0xFF & this.rawData[127]);
    }

    public String getPathSecondaryCUSequenceNum(int n) {
        if (this.isStringValid(BYTE_PATH_CU_SEQUENCE_SECONDARY[n], 10)) {
            return this.convertSequenceNumber(BYTE_PATH_CU_SEQUENCE_SECONDARY[n]);
        }
        return NIESSID.SEQUENCE_UNKNOWN;
    }

    public int getPathSecondarySSID(int n) {
        return this.convertToInt(BYTE_PATH_CU_SSID_SECONDARY[n], 2);
    }

    public int getPathSecondaryLSSNumber(int n) {
        return 0xFF & this.rawData[BYTE_PATH_LSS_SECONDARY[n]];
    }

    public int getPathCount(int n) {
        return 0xFF & this.rawData[BYTE_PATH_NUM_VALID_ENTRIES[n]];
    }

    public int getPrimarySAID(int n, int n2) {
        return this.convertToInt(BYTE_PATH_SAID_PRIMARY[n][n2], 2);
    }

    public int getSecondarySAID(int n, int n2) {
        return this.convertToInt(BYTE_PATH_SAID_SECONDARY[n][n2], 2);
    }

    public int getPathStatus(int n, int n2) {
        return 0xFF & this.rawData[BYTE_PATH_STATUS[n][n2]];
    }

    private String convertSequenceNumber(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 5;
        while (n2 < 10) {
            stringBuffer.append((char)NIAsciiEbcdicConverter.convertToASCII(this.rawData[n + n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public long getPrimaryCUWWNN() {
        return this.convertToLong(80, 8);
    }

    public long getSecondaryCUWWNN(int n) {
        return this.convertToLong(BYTE_PATH_WWNN_SECONDARY[n], 8);
    }

    private int convertToInt(int n, int n2) {
        if (!($assertionsDisabled || 0 < n2 && n2 <= 4)) {
            throw new AssertionError();
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 <<= 8;
            n3 |= this.rawData[n + n4] & 0xFF;
            ++n4;
        }
        return n3;
    }

    private long convertToLong(int n, int n2) {
        if (!($assertionsDisabled || 0 < n2 && n2 <= 8)) {
            throw new AssertionError();
        }
        long l = 0L;
        int n3 = 0;
        while (n3 < n2) {
            l <<= 8;
            l |= (long)(this.rawData[n + n3] & 0xFF);
            ++n3;
        }
        return l;
    }

    private boolean isBitSet(int n, byte by) {
        return (this.rawData[n] & by) != 0;
    }

    public boolean isSecondaryVolumeReserved() {
        return this.isBitSet(38, (byte)-128);
    }

    public boolean isSecondaryVolumeHavePinnedData() {
        return this.isBitSet(38, (byte)32);
    }

    public boolean isVolumeInPathGroup() {
        return this.isBitSet(38, (byte)16);
    }

    public boolean isVolumeInXRCSession() {
        return this.isBitSet(38, (byte)8);
    }

    public boolean isVolumeInConcurrentCopySession() {
        return this.isBitSet(38, (byte)4);
    }

    public boolean isVolumeInFlashCopyRelationship() {
        return this.isBitSet(38, (byte)2);
    }

    public boolean isVolumeCascading() {
        return this.isBitSet(38, (byte)1);
    }

    public Date getPPRCCreateTime() {
        int n = this.convertToInt(88, 4);
        Date date = new Date(n);
        return date;
    }

    public Date getPPRCSyncTime() {
        long l = 1000L * this.convertToLong(92, 4);
        Date date = new Date(l);
        return date;
    }

    public int getCCOf1stCylinderOutOfSync() {
        return this.convertToInt(40, 4);
    }

    public int getCCOfLastLastCylinderOutOfSync() {
        return this.convertToInt(48, 4);
    }

    public boolean isValid() {
        return this.valid;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI50QueryParser == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI50QueryParser = NI50QueryParser.class$("com.ibm.storage.ess.ni.agent.sfiserver.cs.pprc.NI50QueryParser")) : class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI50QueryParser).desiredAssertionStatus();
        logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI50QueryParser == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI50QueryParser = NI50QueryParser.class$("com.ibm.storage.ess.ni.agent.sfiserver.cs.pprc.NI50QueryParser")) : class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NI50QueryParser);
        MASK_BIT_NUMS = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        BYTE_PATH_CU_SEQUENCE_SECONDARY = new int[]{130, 229, 328, 427};
        BYTE_PATH_WWNN_SECONDARY = new int[]{140, 239, 338, 437};
        BYTE_PATH_CU_SSID_SECONDARY = new int[]{148, 247, 346, 445};
        BYTE_PATH_LSS_SECONDARY = new int[]{150, 249, 348, 447};
        BYTE_PATH_MACHINE_TYPE_SECONDARY = new int[]{151, 250, 349, 448};
        BYTE_PATH_MACHINE_MODEL_SECONDARY = new int[]{157, 256, 355, 454};
        BYTE_PATH_POM_SECONDARY = new int[]{160, 259, 358, 457};
        BYTE_PATH_NUM_VALID_ENTRIES = new int[]{162, 261, 360, 459};
        BYTE_PATH_SAID_PRIMARY = new int[][]{{163, 171, 179, 187, 195, 203, 211, 219}, {262, 270, 278, 286, 294, 302, 310, 318}, {361, 369, 377, 385, 393, 401, 409, 417}, {460, 468, 476, 484, 492, 500, 508, 516}};
        BYTE_PATH_SAID_SECONDARY = new int[][]{{167, 175, 183, 191, 199, 207, 215, 223}, {266, 274, 282, 290, 298, 306, 314, 322}, {365, 373, 381, 389, 397, 405, 413, 421}, {464, 472, 480, 488, 496, 504, 512, 520}};
        BYTE_PATH_STATUS = new int[][]{{170, 178, 186, 194, 202, 210, 218, 226}, {269, 277, 285, 293, 301, 309, 317, 325}, {368, 376, 384, 392, 400, 408, 416, 424}, {467, 475, 483, 491, 499, 507, 515, 523}};
    }
}

