/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.cs.pprc;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIPathingReturnCodes;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResponseData;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResultsBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.cs.pprc.NI49QueryParser;
import com.ibm.storage.ess.ni.application.results.NIFCPCandidateConnection;
import com.ibm.storage.ess.ni.application.results.NIPPRCCandidateConnection;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NICandidateConnectionResultImpl;
import java.util.List;

public class NIFCPQueryResultsBuilder
implements NIResultsBuilder {
    private boolean resultsComplete = false;
    private NICandidateConnectionResultImpl results = null;
    private NIESSID primaryEss = null;
    private NIESSID secondaryEss = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NIFCPQueryResultsBuilder == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NIFCPQueryResultsBuilder = NIFCPQueryResultsBuilder.class$("com.ibm.storage.ess.ni.agent.sfiserver.cs.pprc.NIFCPQueryResultsBuilder")) : class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NIFCPQueryResultsBuilder);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NIFCPQueryResultsBuilder;

    public NIFCPQueryResultsBuilder(NIESSID nIESSID, NIESSID nIESSID2) {
        this.primaryEss = nIESSID;
        this.secondaryEss = nIESSID2;
    }

    public synchronized void buildResults(NIResponseData nIResponseData) {
        int n = 0;
        NIPathingReturnCodes nIPathingReturnCodes = new NIPathingReturnCodes(nIResponseData.getPaIoctlReturnCode());
        this.resultsComplete = true;
        if (!nIResponseData.wasCommandSuccessful()) {
            this.results = new NICandidateConnectionResultImpl(false, nIResponseData.getErrorCode());
            logger.error("NIPathQueryResultsBuilder: buildResults: Command failed before microcode, Error Code = " + nIResponseData.getErrorCode());
        } else if (!nIPathingReturnCodes.isResponseSuccessful()) {
            if (nIPathingReturnCodes.doesErrorHaveSenseData()) {
                n = nIResponseData.getErrorCode();
                logger.error("NIPathQueryResultsBuilder: buildResults: Command failed in microcode, has sense data: " + n);
            } else {
                n = nIPathingReturnCodes.getErrorCode();
                logger.error("NIPathQueryResultsBuilder: buildResults: Command failed in microcode, pa error code: " + n);
            }
            this.results = new NICandidateConnectionResultImpl(false, n);
        } else {
            byte[] byArray = nIResponseData.getLargeOutputDataArray();
            NI49QueryParser nI49QueryParser = new NI49QueryParser(byArray);
            List list = nI49QueryParser.getValidConnections(this.primaryEss, this.secondaryEss);
            NIPPRCCandidateConnection[] nIPPRCCandidateConnectionArray = new NIFCPCandidateConnection[list.size()];
            list.toArray(nIPPRCCandidateConnectionArray);
            this.results = new NICandidateConnectionResultImpl(nIPPRCCandidateConnectionArray);
            logger.debug_general("FCP Query Path Result Done.  Results Null?: " + (this.results == null));
        }
    }

    public synchronized Object getResults() {
        return this.results;
    }

    public synchronized boolean resultsComplete() {
        return this.resultsComplete;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

