/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.cs.pprc;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIPathingReturnCodes;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResponseData;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResultsBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.cs.pprc.NI50QueryParser;
import com.ibm.storage.ess.ni.agent.sfiserver.utility.NIByteArrayServices;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceIDPair;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NICopyServicesQueryResultImpl;
import com.ibm.storage.ess.ni.results.NIPPRCAttributeImpl;
import com.ibm.storage.ess.ni.results.NIPPRCStateImpl;
import com.ibm.storage.ess.ni.results.NIQueryOutOfSyncResultImpl;
import com.ibm.storage.ess.ni.results.NIRelationshipImpl;
import java.util.Date;
import java.util.Vector;

public class NIPPRCRelationshipQueryResultsBuilder
implements NIResultsBuilder {
    private Vector relationships;
    private NIResourceIDPair[] volumePairs;
    private int[] relationType;
    private long[] outOfSyncArray;
    private NICopyServicesQueryResultImpl results = null;
    private NIQueryOutOfSyncResultImpl outOfSyncResults = null;
    private int numOfExpectedResults;
    private int numOfResults = 0;
    private long errorCode = 0L;
    private boolean resultsComplete = false;
    private boolean isSuccessful = true;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NIPPRCRelationshipQueryResultsBuilder == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NIPPRCRelationshipQueryResultsBuilder = NIPPRCRelationshipQueryResultsBuilder.class$("com.ibm.storage.ess.ni.agent.sfiserver.cs.pprc.NIPPRCRelationshipQueryResultsBuilder")) : class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NIPPRCRelationshipQueryResultsBuilder);
    private int queryType;
    private static final int PAIR_QUERY = 1;
    private static final int RANGE_QUERY = 2;
    private static final int OUT_OF_SYNC_QUERY = 3;
    private static int PRIMARY_DEVICE_ADDRESSED = 1;
    private static int SECONDARY_DEVICE_ADDRESSED = 2;
    private NIVolumeID[] rangeVolumes;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$cs$pprc$NIPPRCRelationshipQueryResultsBuilder;

    public NIPPRCRelationshipQueryResultsBuilder(NIVolumeID[] nIVolumeIDArray, int n, int n2) {
        this.rangeVolumes = nIVolumeIDArray;
        this.numOfExpectedResults = n;
        this.queryType = 2;
        this.relationType = new int[n];
        this.relationships = new Vector();
        logger.debug_general("CS >>> 50: NIQueryRelationship Number of Responses Expected PPRC range query(type " + this.queryType + "): " + this.numOfExpectedResults);
    }

    public NIPPRCRelationshipQueryResultsBuilder(NIResourceIDPair[] nIResourceIDPairArray, int n) {
        this.numOfExpectedResults = nIResourceIDPairArray.length;
        this.volumePairs = new NIResourceIDPair[nIResourceIDPairArray.length];
        this.volumePairs = nIResourceIDPairArray;
        if (1 == n) {
            this.queryType = 1;
            logger.debug_general("CS >>> 50 Rel: NIQueryRelationship Number of PPRC Pair Responses: " + this.numOfExpectedResults + " Query Type : PPRC Resource Pair Query(" + this.queryType + ")");
            this.relationships = new Vector();
        } else if (3 == n) {
            this.outOfSyncArray = new long[nIResourceIDPairArray.length];
            this.queryType = 3;
            logger.debug_general("CS >>> 50 Rel: NIQueryRelationship Number of PPRC Out of Sync Responses: " + this.numOfExpectedResults + " Query Type (" + this.queryType + ")");
            int n2 = 0;
            while (n2 < nIResourceIDPairArray.length) {
                this.outOfSyncArray[n2] = -1L;
                ++n2;
            }
        }
    }

    public NIPPRCRelationshipQueryResultsBuilder(long[] lArray) {
        this.outOfSyncArray = lArray;
        this.numOfExpectedResults = lArray.length;
        this.queryType = 3;
        logger.debug_general("CS >>> 50 Rel: NIQueryRelationship Number of Responses Expected PPRC Out of Sync query: " + this.numOfExpectedResults);
    }

    public void buildResults(NIResponseData nIResponseData) {
        int n = nIResponseData.getIndexToNumberOfRequests();
        int n2 = nIResponseData.getIntValueFromByteArray(n, 1);
        int n3 = 1;
        long l = 0L;
        boolean bl = true;
        do {
            byte[] byArray;
            String string;
            int n4;
            int n5;
            String string2;
            int n6 = nIResponseData.getIndexToEssniData();
            int n7 = nIResponseData.getIntValueFromByteArray(n6, 4);
            boolean bl2 = false;
            NIPathingReturnCodes nIPathingReturnCodes = new NIPathingReturnCodes(nIResponseData.getPaIoctlReturnCode());
            if (2 == this.queryType) {
                string2 = this.rangeVolumes[n7].getESS().getSequence();
                n5 = this.rangeVolumes[n7].getLSS().getLSSNumber();
                n4 = this.rangeVolumes[n7].getVolNumber();
                string = string2 + "." + Integer.toHexString(n5) + "." + Integer.toHexString(n4);
            } else {
                string2 = ((NIVolumeID)this.volumePairs[n7].getSource()).getESS().getSequence();
                n5 = ((NIVolumeID)this.volumePairs[n7].getSource()).getLSS().getLSSNumber();
                n4 = ((NIVolumeID)this.volumePairs[n7].getSource()).getVolNumber();
                string = string2 + "." + Integer.toHexString(n5) + "." + Integer.toHexString(n4);
            }
            if (!nIResponseData.wasCommandSuccessful()) {
                this.isSuccessful = false;
                l = this.errorCode = (long)(0xFF & nIResponseData.getErrorCode());
                logger.error("CS >>> 50 Rel: Query Pair command failed at CI for SN.LSS.Dev with error: " + string + " " + Long.toHexString(this.errorCode));
            } else if (!nIPathingReturnCodes.isResponseSuccessful()) {
                if (nIPathingReturnCodes.doesErrorHaveSenseData()) {
                    String string3 = NIByteArrayServices.getHexString(nIResponseData.getSenseData(32), 32, "50 Rel");
                    l = this.errorCode = (long)nIResponseData.getErrorCode();
                    logger.error("CS >>> 50 Rel: Query PPRC Pair command failed at PA with error for volume : " + string + " " + Long.toHexString(this.errorCode) + " Sense Data: \n\t\t\t" + string3);
                    this.isSuccessful = false;
                } else if (nIResponseData.getPaIoctlReturnCode() != nIPathingReturnCodes.getDeviceNotDefinedCode()) {
                    l = this.errorCode = (long)nIPathingReturnCodes.getErrorCode();
                    logger.error("CS >>> 50 Rel: Query Pair command failed at PA for SN.LSS.DEV with error: " + string + " " + Long.toHexString(this.errorCode));
                    this.isSuccessful = false;
                } else {
                    bl = false;
                }
            }
            if (bl) {
                byArray = nIResponseData.getOutputDataArray();
                switch (this.queryType) {
                    case 2: {
                        this.buildRangeRelationship(byArray, n7, l);
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.buildPairRelationship(byArray, n7, l);
                    }
                }
            }
            bl = true;
            byArray = null;
            l = 0L;
            ++this.numOfResults;
        } while (++n3 <= n2 && nIResponseData.getNextResponse());
        logger.debug_general("CS >>> 50 Rel: " + this.numOfResults + " of " + this.numOfExpectedResults + " PPRC Pair Responses.");
    }

    void buildPairRelationship(byte[] byArray, int n, long l) {
        boolean bl;
        if (l != 0L) {
            if (3 == this.queryType) {
                return;
            }
            NIPPRCAttributeImpl nIPPRCAttributeImpl = new NIPPRCAttributeImpl(l);
            NIRelationshipImpl nIRelationshipImpl = new NIRelationshipImpl(this.volumePairs[n], nIPPRCAttributeImpl);
            this.relationships.add(nIRelationshipImpl);
            return;
        }
        NI50QueryParser nI50QueryParser = new NI50QueryParser(byArray);
        int n2 = nI50QueryParser.getVolumeRemoteCopyState();
        int n3 = nI50QueryParser.getFlagByte1();
        boolean bl2 = n2 == 0 || n2 == 11;
        boolean bl3 = bl = (n3 & 0x80) == 0;
        if (bl2 || !bl) {
            return;
        }
        String string = nI50QueryParser.getPrimaryCUSequence();
        String string2 = nI50QueryParser.getAddressedVolumeMachineType();
        int n4 = nI50QueryParser.getPrimaryLssNumber();
        int n5 = nI50QueryParser.getPrimaryVolumeNumber();
        int n6 = nI50QueryParser.getPrimarySSID();
        String string3 = nI50QueryParser.getSecondaryCUSequence();
        String string4 = nI50QueryParser.getSecondaryMachineType();
        int n7 = nI50QueryParser.getSecondaryLssNumber();
        int n8 = nI50QueryParser.getSecondaryVolumeNumber();
        int n9 = nI50QueryParser.getSecondarySSID();
        long l2 = ((NIVolumeID)this.volumePairs[n].getSource()).getESS().getWWNN();
        int n10 = 0xFF & ((NIVolumeID)this.volumePairs[n].getSource()).getLSS().getLSSNumber();
        int n11 = 0xFF & ((NIVolumeID)this.volumePairs[n].getSource()).getVolNumber();
        String string5 = ((NIVolumeID)this.volumePairs[n].getSource()).getESS().getSequence();
        String string6 = ((NIVolumeID)this.volumePairs[n].getSource()).getESS().getType();
        NIESSID nIESSID = ((NIVolumeID)this.volumePairs[n].getSource()).getESS();
        long l3 = ((NIVolumeID)this.volumePairs[n].getTarget()).getESS().getWWNN();
        int n12 = 0xFF & ((NIVolumeID)this.volumePairs[n].getTarget()).getLSS().getLSSNumber();
        int n13 = 0xFF & ((NIVolumeID)this.volumePairs[n].getTarget()).getVolNumber();
        String string7 = ((NIVolumeID)this.volumePairs[n].getTarget()).getESS().getSequence();
        String string8 = ((NIVolumeID)this.volumePairs[n].getTarget()).getESS().getType();
        NIESSID nIESSID2 = ((NIVolumeID)this.volumePairs[n].getTarget()).getESS();
        logger.trace("CS >>> 50 Rel: ResourceSequenceNum.ResourcePrimaryLssNum.resourcePrimaryVolumeNum + resourceSecondarySequenceNum.resourceSecondaryLssNum.resourceSecondaryVolumeNum  CS >>> 50 Rel: " + string5 + "." + n10 + "." + n11 + "." + string7 + "." + n12 + "." + n13);
        logger.trace(n4 + "." + n5 + "." + n7 + "." + n8);
        if (string.equals(string5) && string2.equals(string6) && n4 == n10 && n5 == n11 && string3.equals(string7) && string4.equals(string8) && n7 == n12 && n8 == n13) {
            if (3 == this.queryType) {
                this.outOfSyncArray[n] = nI50QueryParser.getOutOfSyncTracks();
                return;
            }
            NIPPRCAttributeImpl nIPPRCAttributeImpl = this.getAttributes(nI50QueryParser);
            NILSSID nILSSID = new NILSSID(nIESSID, n4, n6);
            NIVolumeID nIVolumeID = new NIVolumeID(nILSSID, n5);
            NILSSID nILSSID2 = new NILSSID(nIESSID2, n7, n9);
            NIVolumeID nIVolumeID2 = new NIVolumeID(nILSSID2, n8);
            NIResourceIDPair nIResourceIDPair = new NIResourceIDPair(nIVolumeID, nIVolumeID2);
            NIRelationshipImpl nIRelationshipImpl = new NIRelationshipImpl(nIResourceIDPair, nIPPRCAttributeImpl);
            this.relationships.add(nIRelationshipImpl);
        } else {
            logger.trace("CS >>> 50 Rel: Primary Addressed Sequence.MachineType.Lss.Vol \n\t\t\t 50 Rel: " + string + "." + string2 + "." + n4 + "." + n5 + "\n>>> 50 Rel: Secondary Addressed Sequence.MachineType.Lss.vol \n" + "\t\t\t>>> 50 Rel: " + string3 + "." + string4 + "." + n7 + "." + n8 + "\n>>> 50 Rel: Client Primary Sequence.MachineType.Lss.vol \n" + "\t\t\t>>> 50 Rel: " + string5 + "." + string2 + "." + n10 + "." + n11 + "\n>>> 50 Rel: Client Secondary Sequence.MachineType.Lss.vol\n" + "\t\t\t>>> 50 Rel: " + string7 + "." + string4 + "." + n12 + "." + n13);
        }
    }

    void buildRangeRelationship(byte[] byArray, int n, long l) {
        String string;
        long l2;
        String string2;
        String string3;
        String string4;
        boolean bl;
        boolean bl2;
        if (l != 0L) {
            logger.debug_general("Error Code " + l + " numOfresp: " + this.numOfResults);
            NIPPRCAttributeImpl nIPPRCAttributeImpl = new NIPPRCAttributeImpl(l);
            NIRelationshipImpl nIRelationshipImpl = new NIRelationshipImpl(new NIResourceIDPair(this.rangeVolumes[n], this.rangeVolumes[n]), nIPPRCAttributeImpl);
            this.relationships.add(nIRelationshipImpl);
            return;
        }
        NI50QueryParser nI50QueryParser = new NI50QueryParser(byArray);
        int n2 = nI50QueryParser.getVolumeRemoteCopyState();
        boolean bl3 = bl2 = n2 == 0 || n2 == 11;
        if (bl2) {
            return;
        }
        int n3 = nI50QueryParser.getFlagByte1();
        boolean bl4 = (n3 & 0x80) != 0;
        boolean bl5 = bl = !bl4;
        if (bl) {
            if (this.relationType[n] == PRIMARY_DEVICE_ADDRESSED) {
                return;
            }
            this.relationType[n] = PRIMARY_DEVICE_ADDRESSED;
        } else {
            if (this.relationType[n] == SECONDARY_DEVICE_ADDRESSED) {
                return;
            }
            this.relationType[n] = SECONDARY_DEVICE_ADDRESSED;
        }
        String string5 = this.rangeVolumes[n].getESS().getManufacturePlant();
        long l3 = this.rangeVolumes[n].getESS().getWWNN();
        if (bl) {
            string4 = nI50QueryParser.getAddressedVolumeMachineType();
            string3 = nI50QueryParser.getAddressedVolumePOM();
            string2 = nI50QueryParser.getSecondaryMachineType();
            l2 = nI50QueryParser.getSecondaryCUWWNN();
            string = nI50QueryParser.getSecondaryPOM();
        } else {
            string2 = nI50QueryParser.getAddressedVolumeMachineType();
            string4 = nI50QueryParser.getPartnerMachineType();
            l2 = l3;
            string3 = nI50QueryParser.getPartnerVolumePOM();
            string = nI50QueryParser.getAddressedVolumePOM();
        }
        String string6 = nI50QueryParser.getPrimaryCUSequence();
        long l4 = nI50QueryParser.getPrimaryCUWWNN();
        int n4 = nI50QueryParser.getPrimaryLssNumber();
        int n5 = nI50QueryParser.getPrimarySSID();
        int n6 = nI50QueryParser.getPrimaryVolumeNumber();
        NIESSID nIESSID = new NIESSID(string4, string3, string6, l4);
        NILSSID nILSSID = new NILSSID(nIESSID, n4, n5);
        NIVolumeID nIVolumeID = new NIVolumeID(nILSSID, n6);
        String string7 = nI50QueryParser.getSecondaryCUSequence();
        int n7 = nI50QueryParser.getSecondarySSID();
        int n8 = nI50QueryParser.getSecondaryLssNumber();
        int n9 = nI50QueryParser.getSecondaryVolumeNumber();
        NIESSID nIESSID2 = new NIESSID(string2, string, string7, l2);
        NILSSID nILSSID2 = new NILSSID(nIESSID2, n8, n7);
        NIVolumeID nIVolumeID2 = new NIVolumeID(nILSSID2, n9);
        NIResourceIDPair nIResourceIDPair = new NIResourceIDPair(nIVolumeID, nIVolumeID2);
        NIPPRCAttributeImpl nIPPRCAttributeImpl = this.getAttributes(nI50QueryParser);
        NIRelationshipImpl nIRelationshipImpl = new NIRelationshipImpl(nIResourceIDPair, nIPPRCAttributeImpl);
        this.relationships.add(nIRelationshipImpl);
    }

    NIPPRCAttributeImpl getAttributes(NI50QueryParser nI50QueryParser) {
        boolean bl;
        int n = nI50QueryParser.getVolumeRemoteCopyState();
        int n2 = nI50QueryParser.getFlagByte1();
        int n3 = nI50QueryParser.getFlagByte2();
        int n4 = nI50QueryParser.getFlagByte3();
        byte by = nI50QueryParser.getVolumeInformationFlags();
        boolean bl2 = (n2 & 4) == 4;
        boolean bl3 = (n2 & 0x10) == 16;
        boolean bl4 = (n2 & 8) == 8;
        boolean bl5 = (n2 & 0x80) == 0;
        boolean bl6 = (n2 & 2) == 2 && bl5;
        boolean bl7 = (n2 & 1) != 1;
        boolean bl8 = (n3 & 8) == 8;
        boolean bl9 = (n3 & 0x38) == 0;
        boolean bl10 = n == 2;
        boolean bl11 = n == 1;
        boolean bl12 = !bl10 && !bl11;
        boolean bl13 = (n3 & 4) == 4;
        boolean bl14 = (n3 & 0x40) == 64;
        boolean bl15 = (n3 & 0x40) == 64;
        boolean bl16 = (n3 & 0x10) == 16;
        boolean bl17 = (n3 & 0x18) == 24;
        boolean bl18 = (n3 & 0x20) == 32;
        boolean bl19 = bl = (n3 & 0x80) == 128;
        int n5 = bl8 && bl5 ? ((n3 & 0x28) == 40 ? 0 : 1) : -1;
        boolean bl20 = (n4 & 0x80) == 128;
        int n6 = 0;
        if ((1 & by) != 0) {
            n6 = 1;
        }
        int n7 = bl12 ? n : 0;
        Date date = new Date(nI50QueryParser.getSuspensionTime() == -1L ? -1L : nI50QueryParser.getSuspensionTime() * 1000L);
        Date date2 = new Date(nI50QueryParser.getCreateTime() * 1000L);
        long l = nI50QueryParser.getOutOfSyncTracks();
        boolean bl21 = nI50QueryParser.isValid();
        logger.debug_general("CS >>> 50 Rel: PPRC Pair: Source SequenceNum.LSS.VOL. = 0x: " + nI50QueryParser.getPrimaryCUSequence() + "." + Integer.toHexString(nI50QueryParser.getPrimaryLssNumber()) + "." + Integer.toHexString(nI50QueryParser.getPrimaryVolumeNumber()) + "  ->  Secondary SequenceNum.LSS.VOL = 0x: " + nI50QueryParser.getSecondaryCUSequence() + "." + Integer.toHexString(nI50QueryParser.getSecondaryLssNumber()) + "." + Integer.toHexString(nI50QueryParser.getSecondaryVolumeNumber()) + "\n\t\t>>> 50 Rel: " + "Is Valid: " + bl21 + "; Is Primary Device Addressed: " + bl5 + "; Is Extended Distance: " + bl8 + "; Is Synchronous: " + bl9 + "; Is Full Duplex: " + bl10 + "\n\t\t>>> 50 Rel: Is Copy Pending: " + bl11 + "; Is Suspended: " + bl12 + "; PPRC Consistency Group: " + bl6 + "\n\t\t>>> 50 Rel: Ordered Vol Async: " + bl16 + "; Ordered LSS Async: " + bl17 + "; Consistent Asyn PPRC: " + bl18 + "\n\t\t>>> 50 Rel: Is Secondary Read Enabled: " + bl13 + "; SecondaryRequestRetransmission: " + bl3 + "\n\t\t>>> 50 Rel: Suspend Reason: " + n7 + "; CriticalWriteMode: " + bl4 + "; Suspend Time: " + date + "; VDP Set: " + bl2 + "\n\t\t>>> 50 Rel: Eligable for Auto Unsuspend: " + bl20 + "; Trusted Primed for Resync: " + bl + "; First Pass State: " + n5 + "; Out of Sync Tracks: " + l + "; cascadeEnabled: " + n6);
        NIPPRCStateImpl nIPPRCStateImpl = new NIPPRCStateImpl(n, bl5);
        NIPPRCAttributeImpl nIPPRCAttributeImpl = new NIPPRCAttributeImpl(nIPPRCStateImpl, bl5, bl14, bl3, bl4, bl2, bl6, bl7, bl, bl15, bl9, bl8, bl16, bl17, bl18, n5, bl13, bl20, false, date2, date, l, bl21, n6);
        return nIPPRCAttributeImpl;
    }

    public Object getResults() {
        if (3 == this.queryType) {
            return this.outOfSyncResults;
        }
        return this.results;
    }

    public boolean resultsComplete() {
        if (this.numOfResults < this.numOfExpectedResults) {
            return false;
        }
        logger.debug_general("CS >>> 50 Rel: Completed Processing PPRC Query Type: " + this.queryType);
        if (3 == this.queryType) {
            this.outOfSyncResults = new NIQueryOutOfSyncResultImpl(this.outOfSyncArray, this.isSuccessful, this.errorCode);
        } else {
            this.results = new NICopyServicesQueryResultImpl(this.relationships, this.isSuccessful, this.errorCode);
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

