/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.performance;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIPathingReturnCodes;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResponseData;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResultsBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.utility.NIByteArrayServices;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.results.NIExtentPoolPerformanceResultImpl;
import java.util.Calendar;

public class NIExtentPoolResultBuilder
implements NIResultsBuilder {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIExtentPoolResultBuilder == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIExtentPoolResultBuilder = NIExtentPoolResultBuilder.class$("com.ibm.storage.ess.ni.agent.sfiserver.performance.NIExtentPoolResultBuilder")) : class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIExtentPoolResultBuilder);
    private boolean resultsComplete = false;
    private NIExtentPoolID[] inputExtents;
    private NIExtentPoolPerformanceResultImpl[] results = null;
    private NIESSID essID;
    private static final int CCW_RESPONSE_NUMBER_OF_RESPONSES_INDEX = 0;
    private static final int CCW_RESPONSE_EXTENT_POOL_VALID_INDEX = 24;
    private static final int CCW_RESPONSE_EXTENT_POOL_ID_INDEX = 28;
    private static final int CCW_RESPONSE_EXTENT_TYPE_INDEX = 30;
    private static final int CCW_RESPONSE_REAL_EXTENT_POOL_CAPACITY_INDEX = 32;
    private static final int CCW_RESPONSE_NUMBER_REAL_EXTENTS_IN_POOL_INDEX = 36;
    private static final int CCW_RESPONSE_NUMBER_REAL_ALLOCATED_EXTENTS_IN_POOL_INDEX = 40;
    private static final int CCW_RESPONSE_REAL_EXTENT_CONVERSATIONS_INDEX = 44;
    private static final int CCW_RESPONSE_VIRTUAL_EXTENT_POOL_CAPACITY_INDEX = 48;
    private static final int CCW_RESPONSE_NUMBER_VIRTUAL_EXTENTS_IN_POOL_INDEX = 52;
    private static final int CCW_RESPONSE_VIRTUAL_EXTENT_CONVERSATIONS_INDEX = 56;
    private static final int CCW_RESPONSE_VIRTUAL_EXTENTS_SRC_OF_DYNAMIC_RELOCATION_INDEX = 60;
    private static final int CCW_RESPONSE_VIRTUAL_EXTENTS_TARGET_OF_DYNAMIC_RELOCATION_INDEX = 64;
    private static final int EXTENT_POOL_PERFORMANCE_SHIFT_A_BYTE = 8;
    private static final int EXTENT_POOL_PERFORMANCE_4_BYTE_LENGTH = 4;
    private static final int EXTENT_POOL_PERFORMANCE_2_BYTE_LENGTH = 2;
    private static final int EXTENT_POOL_PERFORMANCE_1_BYTE_LENGTH = 1;
    private static final int EXTENT_POOL_PERFORMANCE_RESPONSE_LENGTH = 52;
    private static final int EXTENT_POOL_PERFORMANCE_HEADER_LENGTH = 28;
    private static final int GOOD_STATUS = 0;
    private static final int EXTENT_TYPE_CKD = 132;
    private static final int EXTENT_TYPE_FB = 4;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIExtentPoolResultBuilder;

    public NIExtentPoolResultBuilder(NIESSID nIESSID) {
        this.essID = nIESSID;
        this.inputExtents = null;
        logger.debug_general("PERF >>> NIExtentPoolResultBuilder with NIESSID " + nIESSID.toString());
    }

    public NIExtentPoolResultBuilder(NIExtentPoolID[] nIExtentPoolIDArray) {
        this.essID = nIExtentPoolIDArray[0].getESS();
        this.inputExtents = nIExtentPoolIDArray;
        logger.debug_general("PERF >>> NIExtentPoolResultBuilder by array of length " + nIExtentPoolIDArray.length);
    }

    public void buildResults(NIResponseData nIResponseData) {
        boolean bl = true;
        int n = 0;
        NIPathingReturnCodes nIPathingReturnCodes = new NIPathingReturnCodes(nIResponseData.getPaIoctlReturnCode());
        if (!nIResponseData.wasCommandSuccessful()) {
            bl = false;
            n = nIResponseData.getErrorCode();
        } else if (!nIPathingReturnCodes.isResponseSuccessful()) {
            bl = false;
            n = nIPathingReturnCodes.doesErrorHaveSenseData() ? nIResponseData.getErrorCode() : nIPathingReturnCodes.getErrorCode();
        }
        if (bl) {
            logger.debug_general("PERF >>> NIExtentPoolResultBuilder Successful response for TagID: " + nIResponseData.getPaIoctlTagID() + ".");
            int n2 = nIResponseData.getIndexToOutputData();
            int n3 = nIResponseData.getIntValueFromByteArray(n2 + 0, 2);
            this.results = new NIExtentPoolPerformanceResultImpl[n3];
            logger.debug_general("PERF >> NIExtentPoolResultBuilder Received " + n3 + " responses from the CI for TagID: " + nIResponseData.getPaIoctlTagID());
            int n4 = 0;
            while (n4 < n3) {
                this.results[n4] = this.convertRawData(nIResponseData, n4);
                ++n4;
            }
            if (this.inputExtents != null) {
                this.parseResults();
            }
        } else {
            logger.error("PERF >>> NIExtentPoolResultBuilder Failure for TagID: " + nIResponseData.getPaIoctlTagID() + "\n Failed Error Code: 0x" + Integer.toHexString(n) + "\n Failed with Sense Data: " + NIByteArrayServices.getHexString(nIResponseData.getSenseData(32)));
            if (this.inputExtents != null) {
                this.results = new NIExtentPoolPerformanceResultImpl[this.inputExtents.length];
                int n5 = 0;
                while (n5 < this.inputExtents.length) {
                    this.results[n5] = new NIExtentPoolPerformanceResultImpl(n, this.inputExtents[n5]);
                    ++n5;
                }
            } else {
                this.results = new NIExtentPoolPerformanceResultImpl[1];
                this.results[0] = new NIExtentPoolPerformanceResultImpl(n, null);
            }
        }
        this.resultsComplete = true;
    }

    private NIExtentPoolPerformanceResultImpl convertRawData(NIResponseData nIResponseData, int n) {
        int n2;
        byte[] byArray = nIResponseData.getRawData();
        byte by = byArray[(n2 = nIResponseData.getIndexToOutputData()) + 24];
        boolean bl = (by & 0x80) == 128;
        NIExtentPoolID nIExtentPoolID = new NIExtentPoolID(this.essID, nIResponseData.getIntValueFromByteArray(n2 + n * 52 + 28, 2));
        int n3 = nIResponseData.getIntValueFromByteArray(n2 + n * 52 + 30, 1);
        NIExtentType nIExtentType = null;
        if (n3 == 132) {
            nIExtentType = NIExtentTypeCKD.Option;
        } else if (n3 == 4) {
            nIExtentType = NIExtentTypeFB.Option;
        } else {
            logger.error("PERF >>> NIExtentPoolResultBuilder: Extent Type not valid!");
        }
        long l = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * 52 + 32, 4));
        long l2 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * 52 + 40, 4));
        long l3 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * 52 + 36, 4));
        long l4 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * 52 + 44, 4));
        long l5 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * 52 + 48, 4));
        long l6 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * 52 + 52, 4));
        long l7 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * 52 + 56, 4));
        long l8 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * 52 + 60, 4));
        long l9 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * 52 + 64, 4));
        Calendar calendar = Calendar.getInstance();
        return new NIExtentPoolPerformanceResultImpl(bl, nIExtentPoolID, nIExtentType, l, l2, l3, l4, l5, l6, l7, l8, l9, calendar, true, 0L);
    }

    private void parseResults() {
        NIExtentPoolPerformanceResultImpl[] nIExtentPoolPerformanceResultImplArray = this.results;
        this.results = new NIExtentPoolPerformanceResultImpl[this.inputExtents.length];
        int n = 0;
        while (n < this.inputExtents.length) {
            NIExtentPoolID nIExtentPoolID = this.inputExtents[n];
            this.results[n] = null;
            int n2 = 0;
            while (this.results[n] == null && n2 < nIExtentPoolPerformanceResultImplArray.length) {
                if (nIExtentPoolPerformanceResultImplArray[n2].getExtentPool().equals(nIExtentPoolID)) {
                    this.results[n] = nIExtentPoolPerformanceResultImplArray[n2];
                }
                ++n2;
            }
            if (this.results[n] == null) {
                this.results[n] = new NIExtentPoolPerformanceResultImpl(-1099890943L, nIExtentPoolID);
            }
            ++n;
        }
    }

    public Object getResults() {
        return this.results;
    }

    public boolean resultsComplete() {
        return this.resultsComplete;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

