/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.performance;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIPathingReturnCodes;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResponseData;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResultsBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.utility.NIByteArrayServices;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NIPortPerformanceResultImpl;
import java.util.Calendar;

public class NIIOPortResultBuilder
implements NIResultsBuilder {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIIOPortResultBuilder == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIIOPortResultBuilder = NIIOPortResultBuilder.class$("com.ibm.storage.ess.ni.agent.sfiserver.performance.NIIOPortResultBuilder")) : class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIIOPortResultBuilder);
    private boolean resultsComplete = false;
    private NIPortPerformanceResultImpl[] results = null;
    private NIESSID essID;
    private NIIOPortID[] inputIOPorts;
    private static final int IO_PERFORMANCE_NUMB_RESPONSES_INDEX = 0;
    private static final int IO_PERFORMANCE_LINK_TYPE_INDEX = 28;
    private static final int IO_PERFORMANCE_INTERFACE_TYPE_INDEX = 34;
    private static final int IO_PERFORMANCE_BYTE_INCREMENT_INDEX = 30;
    private static final int IO_PERFORMANCE_TIME_INCREMENT_INDEX = 31;
    private static final int IO_PERFORMANCE_ECKD_BYTES_READ_INDEX = 36;
    private static final int IO_PERFORMANCE_ECKD_BYTE_WRITES_INDEX = 40;
    private static final int IO_PERFORMANCE_ECKD_READ_OPERATIONS_INDEX = 44;
    private static final int IO_PERFORMANCE_ECKD_WRITE_OPERATIONS_INDEX = 48;
    private static final int IO_PERFORMANCE_ECKD_READ_TIME_INDEX = 52;
    private static final int IO_PERFORMANCE_ECKD_WRITE_TIME_INDEX = 56;
    private static final int IO_PERFORMANCE_PPRC_SEND_BYTES_INDEX = 60;
    private static final int IO_PERFORMANCE_PPRC_RECIEVED_BYTES_INDEX = 64;
    private static final int IO_PERFORMANCE_PPRC_SEND_OPERATIONS_INDEX = 68;
    private static final int IO_PERFORMANCE_PPRC_RECIEVED_OPERATIONS_INDEX = 72;
    private static final int IO_PERFORMANCE_PPRC_SEND_TIME_INDEX = 76;
    private static final int IO_PERFORMANCE_PPRC_RECIEVED_TIME_INDEX = 80;
    private static final int IO_PERFORMANCE_SCSI_BYTES_READ_INDEX = 84;
    private static final int IO_PERFORMANCE_SCSI_BYTE_WRITES_INDEX = 88;
    private static final int IO_PERFORMANCE_SCSI_READ_OPERATIONS_INDEX = 92;
    private static final int IO_PERFORMANCE_SCSI_WRITE_OPERATIONS_INDEX = 96;
    private static final int IO_PERFORMANCE_SCSI_READ_TIME_INDEX = 100;
    private static final int IO_PERFORMANCE_SCSI_WRITE_TIME_INDEX = 104;
    private static final int IO_PERFORMANCE_SHIFT_A_BYTE = 8;
    private static final int IO_PERFORMANCE_4_BYTE_LENGTH = 4;
    private static final int IO_PERFORMANCE_2_BYTE_LENGTH = 2;
    private static final int GOOD_STATUS = 0;
    private static int IO_PERFORMANCE_LENGTH = 96;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIIOPortResultBuilder;

    public NIIOPortResultBuilder(NIESSID nIESSID) {
        this.essID = nIESSID;
        this.inputIOPorts = null;
        logger.debug_general("PERF >>> NIIOPortResultBuilder on NIESSID " + nIESSID.toString());
    }

    public NIIOPortResultBuilder(NIIOPortID[] nIIOPortIDArray) {
        this.essID = nIIOPortIDArray[0].getESS();
        this.inputIOPorts = nIIOPortIDArray;
        logger.debug_general("PERF >>> NIIOPortResultBuilder by array of length " + nIIOPortIDArray.length);
    }

    public void buildResults(NIResponseData nIResponseData) {
        boolean bl = true;
        int n = 0;
        NIPathingReturnCodes nIPathingReturnCodes = new NIPathingReturnCodes(nIResponseData.getPaIoctlReturnCode());
        if (!nIResponseData.wasCommandSuccessful()) {
            bl = false;
            n = nIResponseData.getErrorCode();
        } else if (!nIPathingReturnCodes.isResponseSuccessful()) {
            bl = false;
            n = nIPathingReturnCodes.doesErrorHaveSenseData() ? nIResponseData.getErrorCode() : nIPathingReturnCodes.getErrorCode();
        }
        if (bl) {
            logger.debug_general("PERF >>> NIIOPortResultBuilder Successful response for TagID: " + nIResponseData.getPaIoctlTagID() + ".");
            int n2 = nIResponseData.getIndexToOutputData();
            int n3 = nIResponseData.getIntValueFromByteArray(n2 + 0, 2);
            this.results = new NIPortPerformanceResultImpl[n3];
            logger.debug_general("PERF >> NIIOPortResultBuilder Received " + n3 + " responses from the CI for TagID: " + nIResponseData.getPaIoctlTagID());
            int n4 = 0;
            while (n4 < n3) {
                this.results[n4] = this.convertRawData(nIResponseData, n4);
                ++n4;
            }
            if (this.inputIOPorts != null) {
                this.parseResults();
            } else if (n3 == 0) {
                this.results = new NIPortPerformanceResultImpl[1];
                this.results[0] = new NIPortPerformanceResultImpl(-1099890943L, null);
            }
        } else {
            logger.error("PERF >> NIIOPortResultBuilder Failure for TagID: " + nIResponseData.getPaIoctlTagID() + "\n Failed with Error Code: 0x" + Integer.toHexString(n) + "\n Failed with Sense Data: " + NIByteArrayServices.getHexString(nIResponseData.getSenseData(32)));
            if (this.inputIOPorts != null) {
                this.results = new NIPortPerformanceResultImpl[this.inputIOPorts.length];
                int n5 = 0;
                while (n5 < this.inputIOPorts.length) {
                    this.results[n5] = new NIPortPerformanceResultImpl(n, this.inputIOPorts[n5]);
                    ++n5;
                }
            } else {
                this.results = new NIPortPerformanceResultImpl[1];
                this.results[0] = new NIPortPerformanceResultImpl(n, null);
            }
        }
        this.resultsComplete = true;
    }

    private NIPortPerformanceResultImpl convertRawData(NIResponseData nIResponseData, int n) {
        byte[] byArray = nIResponseData.getRawData();
        int n2 = nIResponseData.getIndexToOutputData();
        byte by = byArray[n2 + n * IO_PERFORMANCE_LENGTH + 28];
        int n3 = nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 34, 2);
        NIIOPortID nIIOPortID = new NIIOPortID(this.essID, n3);
        byte by2 = byArray[n2 + n * IO_PERFORMANCE_LENGTH + 30];
        byte by3 = byArray[n2 + n * IO_PERFORMANCE_LENGTH + 31];
        long l = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 36, 4));
        long l2 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 40, 4));
        long l3 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 44, 4));
        long l4 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 48, 4));
        long l5 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 52, 4));
        long l6 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 56, 4));
        long l7 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 84, 4));
        long l8 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 92, 4));
        long l9 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 88, 4));
        long l10 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 96, 4));
        long l11 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 64, 4));
        long l12 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 60, 4));
        long l13 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 72, 4));
        long l14 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 68, 4));
        long l15 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 76, 4));
        long l16 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 80, 4));
        long l17 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 104, 4));
        long l18 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n2 + n * IO_PERFORMANCE_LENGTH + 100, 4));
        Calendar calendar = Calendar.getInstance();
        return new NIPortPerformanceResultImpl(by, calendar, nIIOPortID, by2, by3, l, l3, l2, l4, l5, l6, l7, l8, l9, l10, l11, l12, l14, l13, l15, l16, l18, l17, true, 0L);
    }

    private void parseResults() {
        NIPortPerformanceResultImpl[] nIPortPerformanceResultImplArray = this.results;
        this.results = new NIPortPerformanceResultImpl[this.inputIOPorts.length];
        int n = 0;
        while (n < this.inputIOPorts.length) {
            NIIOPortID nIIOPortID = this.inputIOPorts[n];
            this.results[n] = null;
            int n2 = 0;
            while (this.results[n] == null && n2 < nIPortPerformanceResultImplArray.length) {
                if (nIPortPerformanceResultImplArray[n2].getIOPort().equals(nIIOPortID)) {
                    this.results[n] = nIPortPerformanceResultImplArray[n2];
                }
                ++n2;
            }
            if (this.results[n] == null) {
                this.results[n] = new NIPortPerformanceResultImpl(-1099890943L, nIIOPortID);
            }
            ++n;
        }
    }

    public Object getResults() {
        return this.results;
    }

    public boolean resultsComplete() {
        return this.resultsComplete;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

