/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.performance;

import com.ibm.storage.ess.ni.agent.sfiserver.common.NIPathingReturnCodes;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResponseData;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResultsBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.performance.NIVolumeResultBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.utility.NIByteArrayServices;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.results.NIVolumePerformanceResultImpl;
import java.util.Calendar;

public class NIMultiVolumeResultBuilder
extends NIVolumeResultBuilder
implements NIResultsBuilder {
    private NILSSID lssid;

    public NIMultiVolumeResultBuilder(NILSSID nILSSID) {
        this.lssid = nILSSID;
        this.results = null;
        this.volumes = null;
        this.numbResponses = 0;
        this.recievedResponses = 0;
        NIVolumeResultBuilder.logger.debug_general("PERF >>> NIMultiVolumeResultBuilder with NILSSID " + nILSSID.toString());
    }

    public void buildResults(NIResponseData nIResponseData) {
        boolean bl = true;
        int n = 0;
        NIPathingReturnCodes nIPathingReturnCodes = new NIPathingReturnCodes(nIResponseData.getPaIoctlReturnCode());
        if (!nIResponseData.wasCommandSuccessful()) {
            bl = false;
            n = nIResponseData.getErrorCode();
        }
        if (!nIPathingReturnCodes.isResponseSuccessful()) {
            bl = false;
            n = nIPathingReturnCodes.doesErrorHaveSenseData() ? nIResponseData.getErrorCode() : nIPathingReturnCodes.getErrorCode();
        }
        if (bl) {
            NIVolumeResultBuilder.logger.debug_general("PERF >>> NIMultiVolumeResultBuilder Successful response for TagID: " + nIResponseData.getPaIoctlTagID() + ".");
            this.numbResponses = nIResponseData.getByteCount() / 192;
            NIVolumeResultBuilder.logger.debug_general("PERF >> NIMultiVolumeResultBuilder Recieved " + this.numbResponses + " responses from the CI for TagID: " + nIResponseData.getPaIoctlTagID());
            if (this.numbResponses > 0) {
                this.results = new NIVolumePerformanceResultImpl[this.numbResponses];
                int n2 = 0;
                while (n2 < this.numbResponses) {
                    this.results[this.recievedResponses] = this.convertRawData(nIResponseData, n2);
                    ++this.recievedResponses;
                    ++n2;
                }
            } else {
                this.results = new NIVolumePerformanceResultImpl[1];
                this.results[0] = new NIVolumePerformanceResultImpl(3856L, null);
            }
        } else {
            NIVolumeResultBuilder.logger.error("PERF >> NIMultiVolumeResultBuilder Failure for TagID: " + nIResponseData.getPaIoctlTagID() + "\n Failed with Error Code: 0x" + Integer.toHexString(n) + "\n Failed with Sense Data: " + NIByteArrayServices.getHexString(nIResponseData.getSenseData(32)));
            this.results = new NIVolumePerformanceResultImpl[1];
            this.results[0] = new NIVolumePerformanceResultImpl(n, null);
        }
    }

    protected NIVolumePerformanceResultImpl convertRawData(NIResponseData nIResponseData, int n) {
        byte[] byArray = nIResponseData.getRawData();
        int n2 = nIResponseData.getIndexToOutputData();
        int n3 = nIResponseData.getIndexToInputData();
        int n4 = nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 94, 2);
        NIVolumeID nIVolumeID = new NIVolumeID(this.lssid, nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 1, 1));
        int n5 = nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 114, 2);
        int n6 = NIResponseData.unsignedByteToInt(byArray[n * 192 + n2 + 116]);
        NIExtentType nIExtentType = null;
        if (n6 == 132) {
            nIExtentType = NIExtentTypeCKD.Option;
        } else if (n6 == 4) {
            nIExtentType = NIExtentTypeFB.Option;
        } else {
            NIVolumeResultBuilder.logger.error("PERF >>> NIVolumeResultBuilder: Extent Type not valid!");
        }
        long l = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 4, 4));
        long l2 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 8, 4));
        long l3 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 20, 4));
        long l4 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 24, 4));
        long l5 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 12, 4));
        long l6 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 28, 4));
        long l7 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 36, 4));
        long l8 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 40, 4));
        long l9 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 44, 4));
        long l10 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 48, 4));
        long l11 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 16, 4));
        long l12 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 32, 4));
        long l13 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 52, 4));
        long l14 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 56, 4));
        long l15 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 60, 4));
        long l16 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 64, 4));
        long l17 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 68, 4));
        long l18 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 76, 4));
        long l19 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 80, 4));
        long l20 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 72, 4));
        long l21 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 104, 4));
        long l22 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 84, 4));
        long l23 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 89, 4));
        long l24 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 96, 4));
        long l25 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 100, 4));
        long l26 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 136, 4));
        long l27 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 140, 4));
        long l28 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 144, 4));
        long l29 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 148, 4));
        long l30 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 152, 4));
        byte by = byArray[n * 192 + n2 + 93];
        int n7 = 0;
        int n8 = 0;
        if ((by & 6) == 0) {
            n8 = 128;
            n7 = 16;
        }
        boolean bl = false;
        if ((by & 1) == 1) {
            bl = true;
        }
        long l31 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 108, 4));
        byte by2 = byArray[n * 192 + n2 + 117];
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if ((by2 & 0xFFFFFF80) == 128) {
            bl4 = true;
        }
        if ((by2 & 0x40) == 64) {
            bl3 = true;
        }
        if ((by2 & 0x20) == 32) {
            bl2 = true;
        }
        int n9 = nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 112, 1);
        boolean bl5 = false;
        if (n9 == 2) {
            bl5 = true;
        }
        long l32 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 120, 4));
        long l33 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 124, 4));
        long l34 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 128, 4));
        long l35 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 132, 4));
        long l36 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 156, 4));
        long l37 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 160, 4));
        long l38 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 164, 4));
        long l39 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 168, 4));
        long l40 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 172, 4));
        long l41 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n * 192 + n2 + 176, 4));
        Calendar calendar = Calendar.getInstance();
        return new NIVolumePerformanceResultImpl(nIVolumeID, calendar, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, n8, n7, l31, n5, nIExtentType, bl5, l32, l33, l34, l35, l36, l37, bl, l38, l39, l40, l41, bl2, bl4, bl3, true, 0L);
    }

    public Object getResults() {
        return this.results;
    }

    public boolean resultsComplete() {
        return this.numbResponses == this.recievedResponses;
    }
}

