/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.performance;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIPathingReturnCodes;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResponseData;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResultsBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.utility.NIByteArrayServices;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NIRankPerformanceResultImpl;
import java.util.Calendar;

public class NIRankResultBuilder
implements NIResultsBuilder {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIRankResultBuilder == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIRankResultBuilder = NIRankResultBuilder.class$("com.ibm.storage.ess.ni.agent.sfiserver.performance.NIRankResultBuilder")) : class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIRankResultBuilder);
    private boolean resultsComplete = false;
    private NIRankID[] inputRanks;
    private NIRankPerformanceResultImpl[] results = null;
    private NIESSID essID;
    private int arrayProcessed = 0;
    private static final int CCW_RANK_SIZE_INDEX = 2;
    private static final int CCW_ARRAY_SIZE_INDEX = 26;
    private static final int CCW_RESPONSE_RANK_POOL_ID_INDEX = 28;
    private static final int CCW_RESPONSE_EXTNET_POOL_NUMBER_INDEX = 30;
    private static final int CCW_ARRAY_COUNT_IN_RANK_INDEX = 32;
    private static final int CCW_RESPONSE_RANK_READ_BYTES = 36;
    private static final int CCW_RESPONSE_RANK_BYTES_WRITTEN = 40;
    private static final int CCW_RESPONSE_RANK_READ_OPERATIONS = 44;
    private static final int CCW_RESPONSE_RANK_WRITE_OPERATIONS = 48;
    private static final int CCW_RESPONSE_RANK_READ_RESPONSE_TIME = 52;
    private static final int CCW_RESPONSE_RANK_WRITE_RESPONSE_TIME = 56;
    private static final int RANK_RESULT_SHIFT_A_BYTE = 8;
    private static final int RANK_RESULT_4_BYTE_LENGTH = 4;
    private static final int RANK_RESULT_2_BYTE_LENGTH = 2;
    private static final int RANK_RESULT_1_BYTE_LENGTH = 1;
    private static final int RANK_RESULT_HEADER_LENGTH = 28;
    private static final int GOOD_STATUS = 0;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIRankResultBuilder;

    public NIRankResultBuilder(NIESSID nIESSID) {
        this.essID = nIESSID;
        this.inputRanks = null;
        logger.debug_general("PERF >>> NIRankResultBuilder with NIESSID " + nIESSID.toString());
    }

    public NIRankResultBuilder(NIRankID[] nIRankIDArray) {
        this.essID = nIRankIDArray[0].getESS();
        this.inputRanks = nIRankIDArray;
        logger.debug_general("PERF >>> NIRankResultBuilder by array of length " + nIRankIDArray.length);
    }

    public void buildResults(NIResponseData nIResponseData) {
        boolean bl = true;
        int n = 0;
        NIPathingReturnCodes nIPathingReturnCodes = new NIPathingReturnCodes(nIResponseData.getPaIoctlReturnCode());
        if (!nIResponseData.wasCommandSuccessful()) {
            bl = false;
            n = nIResponseData.getErrorCode();
        } else if (!nIPathingReturnCodes.isResponseSuccessful()) {
            bl = false;
            n = nIPathingReturnCodes.doesErrorHaveSenseData() ? nIResponseData.getErrorCode() : nIPathingReturnCodes.getErrorCode();
        }
        if (bl) {
            logger.debug_general("PERF >>> NIRankResultBuilder Successful response for TagID: " + nIResponseData.getPaIoctlTagID() + ".");
            byte[] byArray = nIResponseData.getRawData();
            int n2 = nIResponseData.getIndexToOutputData();
            int n3 = nIResponseData.getIntValueFromByteArray(n2 + 2, 2);
            int n4 = nIResponseData.getIntValueFromByteArray(n2 + 26, 2);
            int n5 = nIResponseData.getIntValueFromByteArray(nIResponseData.getIndexToOutputData(), 2);
            this.results = new NIRankPerformanceResultImpl[n5];
            logger.debug_general("PERF >> NIRankResultBuilder Received " + n5 + " responses from the CI for TagID: " + nIResponseData.getPaIoctlTagID());
            int n6 = 0;
            while (n6 < n5) {
                this.results[n6] = this.convertRawData(nIResponseData, n2);
                n2 += n3 + this.arrayProcessed * n4;
                ++n6;
            }
            if (this.inputRanks != null) {
                this.parseResults();
            }
        } else {
            logger.error("PERF >> NIRankResultBuilder Failure for TagID: " + nIResponseData.getPaIoctlTagID() + "\n Failed with Error Code: 0x" + Integer.toHexString(n) + "\n Failed with Sense Data: " + NIByteArrayServices.getHexString(nIResponseData.getSenseData(32)));
            if (this.inputRanks != null) {
                this.results = new NIRankPerformanceResultImpl[this.inputRanks.length];
                int n7 = 0;
                while (n7 < this.inputRanks.length) {
                    this.results[n7] = new NIRankPerformanceResultImpl(n, this.inputRanks[n7]);
                    ++n7;
                }
            } else {
                this.results = new NIRankPerformanceResultImpl[1];
                this.results[0] = new NIRankPerformanceResultImpl(n, null);
            }
        }
        this.resultsComplete = true;
    }

    private NIRankPerformanceResultImpl convertRawData(NIResponseData nIResponseData, int n) {
        NIRankID nIRankID = new NIRankID(this.essID, nIResponseData.getIntValueFromByteArray(n + 28, 2));
        long l = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 36, 4));
        long l2 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 44, 4));
        long l3 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 40, 4));
        long l4 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 48, 4));
        long l5 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 52, 4));
        long l6 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 56, 4));
        Calendar calendar = Calendar.getInstance();
        this.arrayProcessed = nIResponseData.getIntValueFromByteArray(n + 32, 1);
        return new NIRankPerformanceResultImpl(nIRankID, l, l2, l3, l4, calendar, l5, l6, true, 0L);
    }

    private void parseResults() {
        NIRankPerformanceResultImpl[] nIRankPerformanceResultImplArray = this.results;
        this.results = new NIRankPerformanceResultImpl[this.inputRanks.length];
        int n = 0;
        while (n < this.inputRanks.length) {
            NIRankID nIRankID = this.inputRanks[n];
            this.results[n] = null;
            int n2 = 0;
            while (this.results[n] == null && n2 < nIRankPerformanceResultImplArray.length) {
                if (nIRankPerformanceResultImplArray[n2].getRank().equals(nIRankID)) {
                    this.results[n] = nIRankPerformanceResultImplArray[n2];
                }
                ++n2;
            }
            if (this.results[n] == null) {
                this.results[n] = new NIRankPerformanceResultImpl(-1099890943L, nIRankID);
            }
            ++n;
        }
    }

    public Object getResults() {
        return this.results;
    }

    public boolean resultsComplete() {
        return this.resultsComplete;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

