/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.performance;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIPathingReturnCodes;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResponseData;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResultsBuilder;
import com.ibm.storage.ess.ni.agent.sfiserver.utility.NIByteArrayServices;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.results.NIVolumePerformanceResultImpl;
import java.util.Calendar;

public class NIVolumeResultBuilder
implements NIResultsBuilder {
    protected static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIVolumeResultBuilder == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIVolumeResultBuilder = NIVolumeResultBuilder.class$("com.ibm.storage.ess.ni.agent.sfiserver.performance.NIVolumeResultBuilder")) : class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIVolumeResultBuilder);
    protected int numbResponses;
    protected int recievedResponses = 0;
    protected NIVolumePerformanceResultImpl[] results;
    protected NIESSID essID;
    protected NIVolumeID[] volumes;
    protected static final int VOLUME_DEVICE_ADDRESS_INDEX = 1;
    protected static final int VOLUME_READ_NORMAL_REQUESTS_INDEX = 4;
    protected static final int VOLUME_READ_NORMAL_REQUESTS_HITS_INDEX = 8;
    protected static final int VOLUME_WRITE_NORMAL_REQUESTS_INDEX = 12;
    protected static final int VOLUME_DASD_FAST_WRITE_REQUESTS_HITS_INDEX = 16;
    protected static final int VOLUME_READ_SEQUENTIAL_REQUESTS_INDEX = 20;
    protected static final int VOLUME_READ_SEQUENTIAL_REQUESTS_HITS_INDEX = 24;
    protected static final int VOLUME_WRITE_SEQUENTIAL_REQUESTS_INDEX = 28;
    protected static final int VOLUME_DASD_FAST_WRITE_SEQUENTIAL_REQUESTS_HITS_INDEX = 32;
    protected static final int VOLUME_READ_CACHE_FAST_WRITE_REQUESTS_INDEX = 36;
    protected static final int VOLUME_READ_CACHE_FAST_WRITE_REQUESTS_HITS_INDEX = 40;
    protected static final int VOLUME_CACHE_FAST_WRITE_REQUESTS_INDEX = 44;
    protected static final int VOLUME_CACHE_FAST_WRITE_REQUESTS_HITS_INDEX = 48;
    protected static final int VOLUME_INHIBIT_CACHE_LOADING_REQUESTS_INDEX = 52;
    protected static final int VOLUME_BYPASS_CACHE_REQUESTS_INDEX = 56;
    protected static final int VOLUME_SEQUENTIAL_DASD_CACHE_TRANSFER_OPERATION_COUNT_INDEX = 60;
    protected static final int VOLUME_DASD_CACHE_TRANSFER_OPERATION_COUNT_INDEX = 64;
    protected static final int VOLUME_CACHE_DASD_TRANSFER_OPERATION_COUNT_INDEX = 68;
    protected static final int VOLUME_DASD_FAST_WRITE_OPERATIONS_DELAYED_BY_NVS_INDEX = 72;
    protected static final int VOLUME_NORMAL_DASD_FAST_WRITE_WRITE_OPERATION_COUNT_INDEX = 76;
    protected static final int VOLUME_NORMAL_SEQUENTIAL_DASD_FAST_WRITE_OPERTAION_COUNT_INDEX = 80;
    protected static final int VOLUME_RECORD_CACHE_READ_MISSES_INDEX = 84;
    protected static final int VOLUME_QUICK_WRITE_PROMOTES_INDEX = 89;
    protected static final int VOLUME_INCREMENT_INDEX = 93;
    protected static final int VOLUME_SSID_INDEX = 94;
    protected static final int VOLUME_IRREGULAR_TRACK_ACCESS_INDEX = 96;
    protected static final int VOLUME_IRREGULAR_TRACK_ACCESS_HITS_INDEX = 100;
    protected static final int VOLUME_OPERATIONS_DELAYED_BY_CACHE_SPACE_INDEX = 104;
    protected static final int VOLUME_LOWER_ITERFACE_ACTIVITY_INDEX = 108;
    protected static final int VOLUME_NON_VOLUME_INFO_INDEX = 112;
    protected static final int VOLUME_EXTENT_POOL_ID_INDEX = 114;
    protected static final int VOLUME_EXTENT_TYPE_INDEX = 116;
    protected static final int VOLUME_EXTENT_FLAGS_INDEX = 117;
    protected static final int VOLUME_PHYSICAL_STORAGE_READ_OPERATIONS_INDEX = 120;
    protected static final int VOLUME_PHYSICAL_STORAGE_WRITE_OPERATIONS_INDEX = 124;
    protected static final int VOLUME_PHYSICAL_STORAGE_BYTES_READ_INDEX = 128;
    protected static final int VOLUME_PHYSICAL_STORAGE_BYTES_WRITTEN_INDEX = 132;
    protected static final int VOLUME_RECORD_MODE_READ_OPERATIONS_INDEX = 136;
    protected static final int VOLUME_TRACKS_READ_FOR_CC_OR_XRC_INDEX = 140;
    protected static final int VOLUME_CONTAMINATING_WRITES_FOR_CC_OR_XRC_INDEX = 144;
    protected static final int VOLUME_TRACKS_TRANSFERED_TO_PPRC_PAIR = 148;
    protected static final int VOLUME_NVS_SPACE_ALLOCATIONS_INDEX = 152;
    protected static final int VOLUME_PHYSICAL_STORAGE_READ_RESPONSE_TIME_INDEX = 156;
    protected static final int VOLUME_PHYSICAL_STORAGE_WRITE_RESPONSE_TIME_INDEX = 160;
    protected static final int VOLUME_BYTES_READ_INDEX = 164;
    protected static final int VOLUME_BYTES_WRITTEN_INDEX = 168;
    protected static final int VOLUME_READ_ACCUMULATED_TIME_INDEX = 172;
    protected static final int VOLUME_WRITE_ACCUMULATED_TIME_INDEX = 176;
    protected static final int VOLUME_RESULT_LENGTH = 192;
    protected static final int OFFSET_TO_PA_IOCTL_BYTE_COUNT = 74;
    protected static final int EXTENT_TYPE_CKD = 132;
    protected static final int EXTENT_TYPE_FB = 4;
    protected static final int CCW_LSS_ID_INDEX = 4;
    protected static final int VOLUME_1_BYTE_LENGTH = 1;
    protected static final int VOLUME_2_BYTE_LENGTH = 2;
    protected static final int VOLUME_4_BYTE_LENGTH = 4;
    protected static final int VOLUME_16_BYTE_LENGTH = 16;
    protected static final int GOOD_STATUS = 0;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$performance$NIVolumeResultBuilder;

    public NIVolumeResultBuilder(NIVolumeID[] nIVolumeIDArray) {
        this.numbResponses = nIVolumeIDArray.length;
        this.results = new NIVolumePerformanceResultImpl[this.numbResponses];
        this.essID = nIVolumeIDArray[0].getLSS().getESS();
        this.volumes = nIVolumeIDArray;
        logger.debug_general("PERF >>> NIVolumeResultBuilder with NIVolumeID array  Num of expected responses: " + this.numbResponses);
    }

    protected NIVolumeResultBuilder() {
        this.numbResponses = 0;
        this.results = null;
        this.essID = null;
        this.volumes = null;
        logger.debug_general("PERF >>> NIVolumeResultBuilder with an LSS");
    }

    public void buildResults(NIResponseData nIResponseData) {
        int n = nIResponseData.getIntValueFromByteArray(nIResponseData.getIndexToNumberOfRequests(), 1);
        logger.debug_general("PERF >>> NIVolumeResultBuilder Recieved " + n + " responses for TagID: " + nIResponseData.getPaIoctlTagID());
        int n2 = 0;
        do {
            this.results[this.recievedResponses++] = this.convertRawData(nIResponseData);
        } while (++n2 < n && nIResponseData.getNextResponse());
    }

    protected NIVolumePerformanceResultImpl convertRawData(NIResponseData nIResponseData) {
        byte[] byArray = nIResponseData.getRawData();
        int n = nIResponseData.getIndexToOutputData();
        int n2 = nIResponseData.getIndexToInputData();
        boolean bl = true;
        int n3 = 0;
        NIPathingReturnCodes nIPathingReturnCodes = new NIPathingReturnCodes(nIResponseData.getPaIoctlReturnCode());
        if (!nIResponseData.wasCommandSuccessful()) {
            bl = false;
            n3 = nIResponseData.getErrorCode();
        } else if (!nIPathingReturnCodes.isResponseSuccessful()) {
            bl = false;
            n3 = nIPathingReturnCodes.doesErrorHaveSenseData() ? nIResponseData.getErrorCode() : nIPathingReturnCodes.getErrorCode();
        }
        if (!bl) {
            int n4 = nIResponseData.getIntValueFromByteArray(n2 - 16, 16);
            NIVolumeID nIVolumeID = this.volumes[n4];
            logger.error("PERF >>> NIVolumeResultBuilder Failure on volume number: " + nIVolumeID.getVolNumber() + "\n Failed Error Code: 0x" + Integer.toHexString(n3) + "\n Failed with Sense Data : " + NIByteArrayServices.getHexString(nIResponseData.getSenseData(32)));
            return new NIVolumePerformanceResultImpl(n3, nIVolumeID);
        }
        logger.debug_general("PERF >>> NIVolumeResultBuilder Successful response for TagID: " + nIResponseData.getPaIoctlTagID() + ".");
        int n5 = nIResponseData.getIntValueFromByteArray(n2 + 4, 1);
        int n6 = nIResponseData.getIntValueFromByteArray(n + 94, 2);
        NIVolumeID nIVolumeID = new NIVolumeID(new NILSSID(this.essID, n5, n6), nIResponseData.getIntValueFromByteArray(n + 1, 1));
        int n7 = nIResponseData.getIntValueFromByteArray(n + 114, 2);
        int n8 = NIResponseData.unsignedByteToInt(byArray[n + 116]);
        NIExtentType nIExtentType = null;
        if (n8 == 132) {
            nIExtentType = NIExtentTypeCKD.Option;
        } else if (n8 == 4) {
            nIExtentType = NIExtentTypeFB.Option;
        } else {
            logger.error("PERF >>> NIVolumeResultBuilder: Extent Type not valid!");
        }
        long l = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 4, 4));
        long l2 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 8, 4));
        long l3 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 20, 4));
        long l4 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 24, 4));
        long l5 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 12, 4));
        long l6 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 28, 4));
        long l7 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 36, 4));
        long l8 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 40, 4));
        long l9 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 44, 4));
        long l10 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 48, 4));
        long l11 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 16, 4));
        long l12 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 32, 4));
        long l13 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 52, 4));
        long l14 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 56, 4));
        long l15 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 60, 4));
        long l16 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 64, 4));
        long l17 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 68, 4));
        long l18 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 76, 4));
        long l19 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 80, 4));
        long l20 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 72, 4));
        long l21 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 104, 4));
        long l22 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 84, 4));
        long l23 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 89, 4));
        long l24 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 96, 4));
        long l25 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 100, 4));
        long l26 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 136, 4));
        long l27 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 140, 4));
        long l28 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 144, 4));
        long l29 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 148, 4));
        long l30 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 152, 4));
        byte by = byArray[n + 93];
        int n9 = 0;
        int n10 = 0;
        if ((by & 6) == 0) {
            n10 = 128;
            n9 = 16;
        }
        boolean bl2 = false;
        if ((by & 1) == 1) {
            bl2 = true;
        }
        long l31 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 108, 4));
        byte by2 = byArray[n + 117];
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if ((by2 & 0xFFFFFF80) == 128) {
            bl5 = true;
        }
        if ((by2 & 0x40) == 64) {
            bl4 = true;
        }
        if ((by2 & 0x20) == 32) {
            bl3 = true;
        }
        int n11 = nIResponseData.getIntValueFromByteArray(n + 112, 1);
        boolean bl6 = false;
        if (n11 == 2) {
            bl6 = true;
        }
        long l32 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 120, 4));
        long l33 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 124, 4));
        long l34 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 128, 4));
        long l35 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 132, 4));
        long l36 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 156, 4));
        long l37 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 160, 4));
        long l38 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 164, 4));
        long l39 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 168, 4));
        long l40 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 172, 4));
        long l41 = NIResponseData.unsignedIntToLong(nIResponseData.getIntValueFromByteArray(n + 176, 4));
        Calendar calendar = Calendar.getInstance();
        return new NIVolumePerformanceResultImpl(nIVolumeID, calendar, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, n10, n9, l31, n7, nIExtentType, bl6, l32, l33, l34, l35, l36, l37, bl2, l38, l39, l40, l41, bl3, bl5, bl4, bl, n3);
    }

    public Object getResults() {
        return this.results;
    }

    public boolean resultsComplete() {
        return this.numbResponses == this.recievedResponses;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

