/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.application;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.NIServicesInfo;
import com.ibm.storage.ess.ni.client.extensions.services.NI1750ServicesHolder;
import com.ibm.storage.ess.ni.client.extensions.services.NI2105ServicesHolder;
import com.ibm.storage.ess.ni.client.extensions.services.NI2107ServicesHolder;
import com.ibm.storage.ess.ni.client.extensions.services.NIServicesHolder;
import com.ibm.storage.ess.ni.client.services.NIEventExecutor;
import com.ibm.storage.ess.ni.client.services.NIEventServiceImpl;
import com.ibm.storage.ess.ni.communication.client.NICommunicationClient;
import com.ibm.storage.ess.ni.communication.connection.NIConnectionFactory;
import com.ibm.storage.ess.ni.communication.connection.NITimedConnectionFactory;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIReliableCommunicationsClient;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIReliableCommunicationsClientImpl;
import com.ibm.storage.ess.ni.exception.NIAuthenticationFailureException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.security.common.NIAuthenticationInfo;
import com.ibm.storage.ess.ni.services.NIAsyncPPRCService;
import com.ibm.storage.ess.ni.services.NICLService;
import com.ibm.storage.ess.ni.services.NICodeLoadService;
import com.ibm.storage.ess.ni.services.NIConfigurationRecoveryService;
import com.ibm.storage.ess.ni.services.NICopyCommonService;
import com.ibm.storage.ess.ni.services.NIDiagnosticControlService;
import com.ibm.storage.ess.ni.services.NIDomainService;
import com.ibm.storage.ess.ni.services.NIESSNIService;
import com.ibm.storage.ess.ni.services.NIEnterpriseService;
import com.ibm.storage.ess.ni.services.NIEventService;
import com.ibm.storage.ess.ni.services.NIFRURepairService;
import com.ibm.storage.ess.ni.services.NIFlashCopyService;
import com.ibm.storage.ess.ni.services.NIHostConfigurationService;
import com.ibm.storage.ess.ni.services.NIInitialConfigurationService;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import com.ibm.storage.ess.ni.services.NIOfflineDomainService;
import com.ibm.storage.ess.ni.services.NIPPRCService;
import com.ibm.storage.ess.ni.services.NIPerformanceService;
import com.ibm.storage.ess.ni.services.NIPhysicalConfigurationService;
import com.ibm.storage.ess.ni.services.NIProblemLogService;
import com.ibm.storage.ess.ni.services.NISecurityService;
import com.ibm.storage.ess.ni.services.NISessionService;
import com.ibm.storage.ess.ni.services.NITraceService;
import java.net.InetAddress;

public class NIServices {
    public static final int CONNECTION_SUCCESSFUL = 0;
    public static final int CONNECTION_ESTABLISHED_WITH_ONE_SERVER_ONLY = 1;
    public static final int CONNECTION_FAILED = 3;
    public static final int CONNECTION_FAILED_INVALID_PEERS = 4;
    public static final int CONNECTION_TYPE_NOT_CONNECTED = 0;
    public static final int CONNECTION_TYPE_2105 = 5;
    public static final int CONNECTION_TYPE_2107 = 3;
    public static final int CONNECTION_TYPE_1750 = 1;
    public static final int CONNECTION_TYPE_OFFLINE = 10;
    public static final int CONNECTION_TYPE_SIMULATION = 11;
    private NIServicesInfo serverInfo;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$application$NIServices == null ? (class$com$ibm$storage$ess$ni$application$NIServices = NIServices.class$("com.ibm.storage.ess.ni.application.NIServices")) : class$com$ibm$storage$ess$ni$application$NIServices);
    private NIAuthenticationInfo securityInfo;
    protected NIReliableCommunicationsClient commClient2107;
    protected NICommunicationClient commClient2105;
    protected int connected = 3;
    protected int connectionType = 0;
    private NIEventServiceImpl eventService2105;
    private com.ibm.storage.ess.ni.client.extensions.services.event.NIEventServiceImpl eventService2107;
    private InetAddress revertToAddress = null;
    protected NIServicesHolder servicesHolder = NIServicesHolder.getDummyServicesHolder();
    private boolean distinctConnection = false;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$NIServices;

    public NIServices(NIServicesInfo nIServicesInfo, NIAuthenticationInfo nIAuthenticationInfo) {
        this.serverInfo = nIServicesInfo;
        this.securityInfo = nIAuthenticationInfo;
    }

    public NIServices(NIServicesInfo nIServicesInfo, NIAuthenticationInfo nIAuthenticationInfo, boolean bl) {
        this(nIServicesInfo, nIAuthenticationInfo);
        this.distinctConnection = bl;
    }

    public synchronized int connect() throws NIUnavailableServerException, NIAuthenticationFailureException {
        if (this.connectionType == 0) {
            logger.debug_general("Attempting to connect to a 2107+ server.");
            this.connect2107();
            if (this.connected == 3) {
                NIEventServiceImpl nIEventServiceImpl = new NIEventServiceImpl();
                NIEventExecutor nIEventExecutor = new NIEventExecutor(nIEventServiceImpl);
                logger.debug_general("Connection to the 2107+ server failed, now attempting to connect to a 2105 server.");
                this.connect2105(nIEventServiceImpl, nIEventExecutor);
                this.eventService2105 = nIEventServiceImpl;
            }
            if (this.connected == 0 && this.connectionType == 5) {
                logger.debug_general("Successfuly connected to a 2105 server.");
                this.eventService2105.setCommunicationTransporter(this.commClient2105);
                this.eventService2105.start();
                this.servicesHolder = new NI2105ServicesHolder(this.commClient2105, this.eventService2105);
            }
            if (!(this.connected != 0 && this.connected != 1 || this.connectionType != 3 && this.connectionType != 11)) {
                this.servicesHolder = new NI2107ServicesHolder(this.commClient2107);
            } else if (!(this.connected != 0 && this.connected != 1 || this.connectionType != 1 && this.connectionType != 10)) {
                this.servicesHolder = new NI1750ServicesHolder(this.commClient2107);
            }
            if (this.connected == 3 || this.connected == 4 || this.connectionType == 0) {
                logger.error("connection failed, calling disconnect... connected=" + this.connected + ", connectionType=" + this.connectionType);
                this.disconnect();
            }
        } else if (!this.checkConnection()) {
            return 3;
        }
        return this.connected;
    }

    private void connect2105(NIEventServiceImpl nIEventServiceImpl, NIEventExecutor nIEventExecutor) throws NIAuthenticationFailureException, NIUnavailableServerException {
        InetAddress inetAddress = this.serverInfo.getAddress(0);
        this.commClient2105 = new NICommunicationClient(inetAddress, nIEventExecutor, this.securityInfo);
        this.connected = 3;
        this.connectionType = 0;
        try {
            this.commClient2105.connect();
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.connected = 3;
            this.connectionType = 0;
            throw nIUnavailableServerException;
        }
        catch (NIAuthenticationFailureException nIAuthenticationFailureException) {
            this.connected = 3;
            this.connectionType = 0;
            throw nIAuthenticationFailureException;
        }
        this.connected = 0;
        this.connectionType = 5;
    }

    private void connect2107() throws NIAuthenticationFailureException, NIUnavailableServerException {
        InetAddress[] inetAddressArray = this.serverInfo.toArray();
        this.commClient2107 = !this.distinctConnection ? NIReliableCommunicationsClientImpl.getInstance(inetAddressArray, this.securityInfo) : NIReliableCommunicationsClientImpl.getDistinctInstance(inetAddressArray, this.securityInfo);
        this.commClient2107.setRevertToAddress(this.revertToAddress);
        this.connected = 3;
        this.connectionType = 0;
        try {
            this.connected = this.commClient2107.connect();
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.connected = 3;
            this.connectionType = 0;
            this.commClient2107.disconnect();
            this.commClient2107 = null;
            return;
        }
        catch (NIAuthenticationFailureException nIAuthenticationFailureException) {
            this.connected = 3;
            this.connectionType = 0;
            this.commClient2107.disconnect();
            this.commClient2107 = null;
            throw nIAuthenticationFailureException;
        }
        if (this.connected == 4) {
            this.connectionType = 0;
            return;
        }
        this.connected = 0;
        this.connectionType = this.commClient2107.getConnectionType();
    }

    public synchronized void disconnect() {
        if (this.connectionType == 5) {
            logger.debug_general("Disconnecting from the 2105 server.");
            this.commClient2105.disconnect();
            if (this.eventService2105 != null) {
                this.eventService2105.stopDequeuing();
            }
        }
        if (this.commClient2107 != null) {
            logger.debug_general("Disconnecting from the 2107+ server.");
            this.commClient2107.disconnect();
        }
        this.commClient2105 = null;
        this.eventService2105 = null;
        this.commClient2107 = null;
        this.eventService2107 = null;
        this.servicesHolder = NIServicesHolder.getDummyServicesHolder();
        if (this.connected != 4) {
            this.connected = 3;
        }
        this.connectionType = 0;
    }

    public synchronized boolean checkConnection() {
        if (this.commClient2105 == null && this.commClient2107 == null) {
            return false;
        }
        if (this.connectionType == 5) {
            if (this.commClient2105 == null) {
                this.connectionType = 0;
                return false;
            }
            if (this.connected == 3) {
                this.commClient2105.disconnect();
            }
            return this.commClient2105.checkConnection();
        }
        if (this.connectionType == 3 || this.connectionType == 1 || this.connectionType == 10 || this.connectionType == 11) {
            if (this.commClient2107 == null) {
                this.connectionType = 0;
                return false;
            }
            return this.commClient2107.checkConnection();
        }
        return false;
    }

    public synchronized NIDiagnosticControlService getDiagnosticControlService() {
        return this.servicesHolder.getDiagnosticControlService();
    }

    public synchronized NIAsyncPPRCService getAsyncPPRCService() {
        return this.servicesHolder.getAsyncPPRCService();
    }

    public synchronized NIConfigurationRecoveryService getConfigurationRecoveryService() {
        return this.servicesHolder.getConfigurationRecoveryService();
    }

    public synchronized NICopyCommonService getCopyCommonService() {
        return this.servicesHolder.getCopyCommonService();
    }

    public synchronized NIDomainService getDomainService() {
        return this.servicesHolder.getDomainService();
    }

    public synchronized NIEnterpriseService getEnterpriseService() {
        return this.servicesHolder.getEnterpriseService();
    }

    public synchronized NIESSNIService getEssniService() {
        return this.servicesHolder.getEssniService();
    }

    public synchronized NIEventService getEventService() {
        return this.servicesHolder.getEventService();
    }

    public synchronized NIFlashCopyService getFlashCopyService() {
        return this.servicesHolder.getFlashCopyService();
    }

    public synchronized NIHostConfigurationService getHostConfigurationService() {
        return this.servicesHolder.getHostConfigurationService();
    }

    public synchronized NILogicalConfigurationService getLogicalConfigurationService() {
        return this.servicesHolder.getLogicalConfigurationService();
    }

    public synchronized NIOfflineDomainService getOfflineDomainService() {
        return this.servicesHolder.getOfflineDomainService();
    }

    public synchronized NIPerformanceService getPerformanceService() {
        return this.servicesHolder.getPerformanceService();
    }

    public synchronized NIPhysicalConfigurationService getPhysicalConfigurationService() {
        return this.servicesHolder.getPhysicalConfigurationService();
    }

    public synchronized NIPPRCService getPPRCService() {
        return this.servicesHolder.getPPRCService();
    }

    public synchronized NISecurityService getSecurityService() {
        return this.servicesHolder.getSecurityService();
    }

    public synchronized NISessionService getSessionService() {
        return this.servicesHolder.getSessionService();
    }

    public synchronized NICLService getCLService() {
        return this.servicesHolder.getCLService();
    }

    public synchronized NIFRURepairService getFRURepairService() {
        return this.servicesHolder.getFRURepairService();
    }

    public synchronized NIProblemLogService getProblemLogService() {
        return this.servicesHolder.getProblemLogService();
    }

    public synchronized NICodeLoadService getCodeLoadService() {
        return this.servicesHolder.getCodeLoadService();
    }

    public synchronized NITraceService getTraceService() {
        return this.servicesHolder.getTraceService();
    }

    public synchronized NIInitialConfigurationService getInitialConfigurationService() {
        return this.servicesHolder.getInitialConfigurationService();
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public NIServicesInfo getServerInfo() {
        return this.serverInfo;
    }

    public InetAddress getRevertToAddress() {
        InetAddress inetAddress = this.revertToAddress;
        if (this.commClient2107 != null && (inetAddress = this.commClient2107.getRevertToAddress()) == null) {
            inetAddress = this.revertToAddress;
        }
        return inetAddress;
    }

    public void setRevertToAddress(InetAddress inetAddress) {
        this.revertToAddress = inetAddress;
        if (this.commClient2107 != null) {
            this.commClient2107.setRevertToAddress(inetAddress);
        }
    }

    public long getSocketConnectionTimeout() {
        NITimedConnectionFactory nITimedConnectionFactory = NIConnectionFactory.getTimedConnectionFactory();
        return nITimedConnectionFactory.getSocketConnectionTimeout();
    }

    public void setSocketConnectionTimeout(long l) {
        NITimedConnectionFactory nITimedConnectionFactory = NIConnectionFactory.getTimedConnectionFactory();
        nITimedConnectionFactory.setSocketConnectionTimeout(l);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

