/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.application.resource;

import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import java.io.Serializable;
import java.util.Collections;
import java.util.Vector;

public class NIVolumeMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Vector volumeList;

    public NIVolumeMap() {
        this.volumeList = new Vector(256, 256);
    }

    public NIVolumeMap(NIVolumeID[] nIVolumeIDArray) {
        this.volumeList = new Vector(nIVolumeIDArray.length, 256);
        int n = 0;
        while (n < nIVolumeIDArray.length) {
            this.volumeList.add(nIVolumeIDArray[n]);
            ++n;
        }
        Collections.sort(this.volumeList);
    }

    public void add(NIVolumeID nIVolumeID) {
        int n = Collections.binarySearch(this.volumeList, nIVolumeID);
        if (n < 0) {
            int n2 = Math.abs(n + 1);
            this.volumeList.add(n2, nIVolumeID);
        }
    }

    public void remove(NIVolumeID nIVolumeID) {
        int n = Collections.binarySearch(this.volumeList, nIVolumeID);
        if (n >= 0) {
            this.volumeList.remove(n);
        }
    }

    public boolean contains(NIVolumeID nIVolumeID) {
        int n = Collections.binarySearch(this.volumeList, nIVolumeID);
        return n >= 0;
    }

    public int size() {
        return this.volumeList.size();
    }

    public NIVolumeID[] toArray() {
        NIVolumeID[] nIVolumeIDArray = new NIVolumeID[this.volumeList.size()];
        int n = 0;
        while (n < nIVolumeIDArray.length) {
            nIVolumeIDArray[n] = (NIVolumeID)this.volumeList.get(n);
            ++n;
        }
        return nIVolumeIDArray;
    }
}

