/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.auditLog;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.results.auditLog.NIAuditLogResult;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogExportState;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NIAuditLogResultImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.zip.GZIPInputStream;

public class NIAuditLogExportClient {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$auditLog$NIAuditLogExportClient == null ? (class$com$ibm$storage$ess$ni$auditLog$NIAuditLogExportClient = NIAuditLogExportClient.class$("com.ibm.storage.ess.ni.auditLog.NIAuditLogExportClient")) : class$com$ibm$storage$ess$ni$auditLog$NIAuditLogExportClient);
    private NIAuditLogResultImpl result;
    private InetAddress address;
    private String key;
    private int port;
    private static Charset charset = Charset.forName("US-ASCII");
    private static CharsetEncoder encoder = charset.newEncoder();
    private static CharsetDecoder decoder = charset.newDecoder();
    private static ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$auditLog$NIAuditLogExportClient;

    public NIAuditLogExportClient(InetAddress inetAddress, NIAuditLogResultImpl nIAuditLogResultImpl) {
        this.address = inetAddress;
        this.result = nIAuditLogResultImpl;
        this.key = nIAuditLogResultImpl.getKey();
        this.port = nIAuditLogResultImpl.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NIAuditLogResult exportAuditLog(File var1_1) {
        block18: {
            NIAuditLogExportClient.logger.enter(this.getClass().getName(), "exportAuditLog");
            var2_2 = null;
            var4_3 = new NIAuditLogResultImpl(true, 0L, this.key, this.port);
            try {
                try {
                    NIAuditLogExportClient.logger.debug_general("Connecting to server: " + this.address + " on port " + this.port);
                    var2_2 = NIAuditLogExportClient.createSocketChannel(this.address, this.port);
                    var2_2.finishConnect();
                    NIAuditLogExportClient.logger.debug_general("Sending validation key [" + this.key + "] to the server");
                    var2_2.write(NIAuditLogExportClient.encoder.encode(CharBuffer.wrap(this.key)));
                    NIAuditLogExportClient.buffer.clear();
                    var3_4 = var2_2.read(NIAuditLogExportClient.buffer);
                    NIAuditLogExportClient.logger.debug_detailed("Read " + var3_4 + " bytes from the server");
                    if (var3_4 == -1) {
                        NIAuditLogExportClient.logger.error("No bytes read, validation failed");
                        var4_3 = new NIAuditLogResultImpl(false, 2L, this.key, this.port);
                    } else {
                        NIAuditLogExportClient.buffer.flip();
                        var5_5 = NIAuditLogExportClient.decoder.decode(NIAuditLogExportClient.buffer);
                        NIAuditLogExportClient.logger.debug_detailed("Validation response: " + var5_5.toString());
                        if (!var5_5.toString().equals("VALIDATED")) {
                            NIAuditLogExportClient.logger.error("Validation failed, incorrect key");
                            var4_3 = new NIAuditLogResultImpl(false, 2L, this.key, this.port);
                        } else {
                            try {
                                NIAuditLogExportClient.logger.debug_general("Validation successful");
                                var6_7 = new File(var1_1.getParentFile(), this.key);
                                var6_7.deleteOnExit();
                                var7_9 = new FileOutputStream(var6_7, false).getChannel();
                                NIAuditLogExportClient.buffer.clear();
                                var2_2.write(NIAuditLogExportClient.encoder.encode(CharBuffer.wrap("BEGIN_TX")));
                                var8_10 = 1L;
                                while (true) {
                                    if (var8_10 <= 0L) {
                                        var7_9.close();
                                        this.uncompressFile(var6_7, var1_1);
                                        var6_7.delete();
                                        break;
                                    }
                                    var8_10 = var7_9.transferFrom((ReadableByteChannel)var2_2, var7_9.position(), NIAuditLogExportState.CHUNK_SIZE);
                                    var7_9.position(var7_9.position() + var8_10);
                                }
                            }
                            catch (IOException var6_8) {
                                NIAuditLogExportClient.logger.throwable((Throwable)var6_8);
                                var4_3 = new NIAuditLogResultImpl(false, -1099688446L, this.key, this.port);
                            }
                        }
                    }
                    var11_11 = null;
                    if (var2_2 == null) break block18;
                }
                catch (IOException var5_6) {
                    NIAuditLogExportClient.logger.error("A problem was encountered while exporting the audit log: " + var5_6);
                    NIAuditLogExportClient.logger.throwable((Throwable)var5_6);
                    var4_3 = new NIAuditLogResultImpl(false, 2L, this.key, this.port);
                    var11_12 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (IOException var12_15) {}
                    }
                    break block18;
                }
            }
            catch (Throwable var10_17) {
                var11_13 = null;
                if (var2_2 == null) throw var10_17;
                ** try [egrp 3[TRYBLOCK] [5 : 567->574)] { 
lbl75:
                // 1 sources

                var2_2.close();
                throw var10_17;
lbl77:
                // 1 sources

                catch (IOException var12_16) {
                    // empty catch block
                }
                throw var10_17;
            }
            try {}
            catch (IOException var12_14) {}
            var2_2.close();
        }
        NIAuditLogExportClient.logger.exit(this.getClass().getName(), "exportAuditLog", (Object)var4_3);
        return var4_3;
    }

    private void uncompressFile(File file, File file2) throws IOException {
        int n;
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(file));
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        while ((n = gZIPInputStream.read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        gZIPInputStream.close();
        ((OutputStream)fileOutputStream).close();
    }

    private static SocketChannel createSocketChannel(InetAddress inetAddress, int n) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.connect(new InetSocketAddress(inetAddress, n));
        return socketChannel;
    }

    public static void main(String[] stringArray) throws UnknownHostException {
        NIAuditLogExportClient nIAuditLogExportClient = new NIAuditLogExportClient(InetAddress.getLocalHost(), new NIAuditLogResultImpl(true, 0L, "key", 8001));
        nIAuditLogExportClient.exportAuditLog(new File("c:\\auditLog.txt"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

