/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.auditLog;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogCommandConverter;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogCommandInfo;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogCommandResponseQueue;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogEntryImpl;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogFileHandler;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogTable;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogTableEntry;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogUtil;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.communication.extensions.server.NIClientConnection;
import com.ibm.storage.ess.ni.communication.extensions.server.NICommunicationServer;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.lang.reflect.Method;
import java.util.Vector;

public class NIAuditLogProcessor
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$auditLog$NIAuditLogProcessor == null ? (class$com$ibm$storage$ess$ni$auditLog$NIAuditLogProcessor = NIAuditLogProcessor.class$("com.ibm.storage.ess.ni.auditLog.NIAuditLogProcessor")) : class$com$ibm$storage$ess$ni$auditLog$NIAuditLogProcessor);
    private static final String CMD_CONVERT_PREFIX = "convert";
    private static final Class[] CMD_CONVERT_ARGS = new Class[]{class$com$ibm$storage$ess$ni$command$extensions$NICommand == null ? (class$com$ibm$storage$ess$ni$command$extensions$NICommand = NIAuditLogProcessor.class$("com.ibm.storage.ess.ni.command.extensions.NICommand")) : class$com$ibm$storage$ess$ni$command$extensions$NICommand};
    private NIAuditLogCommandResponseQueue responseQueue;
    private NIAuditLogTable auditLogTable = NIAuditLogTable.getInstance();
    private String logLocation = "";
    private boolean running = true;
    private NIAuditLogEntryImpl logEntry = new NIAuditLogEntryImpl();
    private NIAuditLogFileHandler fileHandler = NIAuditLogFileHandler.getInstance();
    private NIAuditLogCommandConverter commandConverter = new NIAuditLogCommandConverter();
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$auditLog$NIAuditLogProcessor;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$command$extensions$NICommand;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$auditLog$NIAuditLogCommandConverter;

    public NIAuditLogProcessor() {
        super("NIAuditLogProcessor");
        this.responseQueue = NIAuditLogCommandResponseQueue.getInstance();
        this.logLocation = NIAuditLogUtil.getLogLocation();
    }

    public void run() {
        logger.enter("NIAuditLogProcessor", "run");
        while (this.running) {
            try {
                NICommand nICommand = this.responseQueue.dequeue();
                this.processResponse(nICommand);
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                logger.debug_general("processor interrupted", "NIAuditLogProcessor", "run", null);
            }
            catch (Exception exception) {
                logger.error("Unexpected error occurred");
                logger.throwable((Throwable)exception);
            }
        }
        logger.exit("NIAuditLogProcessor", "run");
    }

    private void processResponse(NICommand nICommand) {
        this.logEntry.reset();
        String string = this.auditLogTable.getEntryID(nICommand.getMethodName());
        boolean bl = false;
        if (string != null) {
            try {
                nICommand.checkException();
            }
            catch (Exception exception) {
                bl = true;
                this.logEntries(string, nICommand);
            }
            if (!bl && nICommand.retrieveResponseData() != null) {
                this.logEntries(string, nICommand);
            }
        }
    }

    private void logEntries(String string, NICommand nICommand) {
        NIAuditLogTableEntry nIAuditLogTableEntry = this.auditLogTable.getEntry(string);
        if (nIAuditLogTableEntry == null) {
            logger.error("Invalid audit log entry, entryID = " + string);
            return;
        }
        this.logEntry.setStaticFields(nIAuditLogTableEntry);
        this.logEntry.setUserName(this.getUserName(nICommand));
        this.logEntry.setLogLocation(this.logLocation);
        this.logEntry.setTime();
        if (nICommand.getParameters().length == 0) {
            this.logEntry.setExitCode("-1");
            return;
        }
        String string2 = nICommand.getMethodName();
        StringBuffer stringBuffer = new StringBuffer(CMD_CONVERT_PREFIX);
        stringBuffer.append(string2.substring(0, 1).toUpperCase());
        stringBuffer.append(string2.substring(1));
        Vector vector = new Vector();
        try {
            Method method = (class$com$ibm$storage$ess$ni$auditLog$NIAuditLogCommandConverter == null ? (class$com$ibm$storage$ess$ni$auditLog$NIAuditLogCommandConverter = NIAuditLogProcessor.class$("com.ibm.storage.ess.ni.auditLog.NIAuditLogCommandConverter")) : class$com$ibm$storage$ess$ni$auditLog$NIAuditLogCommandConverter).getDeclaredMethod(stringBuffer.toString(), CMD_CONVERT_ARGS);
            vector = (Vector)method.invoke((Object)this.commandConverter, nICommand);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
        if (vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                this.logEntry.setCommandInfo((NIAuditLogCommandInfo)vector.elementAt(n));
                this.fileHandler.output(this.logEntry.toString());
                ++n;
            }
        } else {
            this.fileHandler.output(this.logEntry.toString());
        }
    }

    private String getUserName(NICommand nICommand) {
        NICommunicationServer nICommunicationServer = null;
        String string = "";
        try {
            nICommunicationServer = NICommunicationServer.getInstanceOf();
        }
        catch (Exception exception) {
            logger.error("Failed to get NICommunicationServer");
            logger.throwable((Throwable)exception);
            return string;
        }
        NIClientConnection nIClientConnection = nICommunicationServer.getClient(nICommand.getID().getClientID());
        if (nIClientConnection != null) {
            string = nIClientConnection.getAuthenticationInfo().getUsername();
        }
        return string;
    }

    public void shutdown() {
        logger.debug_general("Shutting down NIAuditLogProcessor.");
        this.running = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

