/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.callhome.server;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.callhome.common.NICallHomeMessage;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConfigurationInterface;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterInputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterOutputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.sa.remotevpn.IBMRemoteClient;
import com.ibm.storage.ess.ni.sa.remotevpn.IBMRemoteClientFactory;
import java.io.IOException;

public class NICallHomeServer
implements Runnable {
    private NIMessageRouterChannel channel;
    private NIMessageRouterOutputStream mros;
    private NIMessageRouterInputStream mris;
    private Thread executionThread;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$callhome$server$NICallHomeServer == null ? (class$com$ibm$storage$ess$ni$callhome$server$NICallHomeServer = NICallHomeServer.class$("com.ibm.storage.ess.ni.callhome.server.NICallHomeServer")) : class$com$ibm$storage$ess$ni$callhome$server$NICallHomeServer);
    private boolean killed = false;
    private NIMessageRouterConfigurationInterface mrConfigInterface;
    private IBMRemoteClient remoteClient;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$callhome$server$NICallHomeServer;

    public synchronized void start() {
        block2: {
            logger.debug_general("start called");
            if (this.executionThread != null) break block2;
            this.killed = false;
            try {
                this.channel = NIMessageRouterFactory.getInstanceOf().createNIMessageRouterChannel(911);
                this.mros = this.channel.getNIMessageRouterOutputStream();
                this.mris = this.channel.getNIMessageRouterInputStream();
                this.mrConfigInterface = (NIMessageRouterConfigurationInterface)NIMessageRouterFactory.getInstanceOf();
                this.remoteClient = IBMRemoteClientFactory.getInstance();
                this.executionThread = new Thread((Runnable)this, "NICallHomeServer");
                this.executionThread.start();
            }
            catch (NIMessageRouterException nIMessageRouterException) {
                logger.error("Exception when creating a message router channel... unable to start call home server");
                logger.throwable((Throwable)nIMessageRouterException);
            }
        }
    }

    public synchronized void shutdown() {
        this.killed = true;
        logger.debug_general("shutdown called");
        if (this.executionThread != null) {
            try {
                this.channel.close();
                this.channel = null;
                this.mros = null;
                this.mris = null;
            }
            catch (IOException iOException) {
                logger.error("Exception when trying to close MR channel");
                logger.throwable((Throwable)iOException);
            }
            this.executionThread.interrupt();
        }
    }

    public void run() {
        NICallHomeMessage nICallHomeMessage = null;
        Object var3_2 = null;
        while (!this.killed) {
            try {
                try {
                    nICallHomeMessage = (NICallHomeMessage)this.mris.readObject();
                    logger.debug_general("received message from " + nICallHomeMessage.getReturnAddress() + ", callhome ID " + nICallHomeMessage.getMessageID());
                }
                catch (InterruptedException interruptedException) {
                    logger.error("Interrupted while reading from the input stream... continuing");
                    logger.throwable((Throwable)interruptedException);
                    continue;
                }
                catch (NIMessageRouterException nIMessageRouterException) {
                    logger.error("MessageRouterException receieved while reading from the input stream");
                    logger.throwable((Throwable)nIMessageRouterException);
                    continue;
                }
                int n = this.remoteClient.sendCallHomeModem(nICallHomeMessage.getMessageString());
                nICallHomeMessage.setReturnCode(n);
                logger.debug_general("remoteClient.sendCallHome returned " + n);
                try {
                    NIMessageRouterReturnStatus nIMessageRouterReturnStatus = this.mros.send(nICallHomeMessage.getReturnAddress(), nICallHomeMessage);
                    if (nIMessageRouterReturnStatus.getStatus() != 9) {
                        logger.error("failed to send response to " + nICallHomeMessage.getReturnAddress() + " MRReturnStatus=" + nIMessageRouterReturnStatus.getStatus());
                        continue;
                    }
                    logger.debug_general("response sent successfully");
                }
                catch (IOException iOException) {
                    logger.error("IOException when trying to send the response back to " + nICallHomeMessage.getReturnAddress());
                    logger.throwable((Throwable)iOException);
                }
            }
            catch (Throwable throwable) {
                logger.error("Caught throwable in run loop:");
                logger.throwable(throwable);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

