/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.client.extensions.services;

import com.ibm.storage.ess.ni.application.results.security.NISecurityResult;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogExportClient;
import com.ibm.storage.ess.ni.client.extensions.services.NIHMCServiceInvocationHandler;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.command.extensions.NISecurityCommand;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIReliableCommunicationsClient;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.messageRouter.common.NIESSNIConstants;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.results.NIAuditLogResultImpl;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;

public class NISecurityServiceInvocationHandler
extends NIHMCServiceInvocationHandler
implements NIESSNIConstants {
    private NIReliableCommunicationsClient rcc;
    private static final String EXPORT_AUDIT_LOG = "exportAuditLogFile";
    private static final NIMessageRouterAddress DEFAULT_ADDRESS = new NIMessageRouterAddress(6, "HMC");
    private static final NIMessageRouterAddress MC1_ADDRESS = new NIMessageRouterAddress(6, "HMC1");
    private static final NIMessageRouterAddress MC2_ADDRESS = new NIMessageRouterAddress(6, "HMC2");

    public NISecurityServiceInvocationHandler(NIReliableCommunicationsClient nIReliableCommunicationsClient) {
        super(nIReliableCommunicationsClient);
        this.rcc = nIReliableCommunicationsClient;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (method.getName().equals(EXPORT_AUDIT_LOG)) {
            Object object2 = null;
            try {
                object2 = super.invoke(object, method, objectArray);
            }
            catch (NIUnavailableServerException nIUnavailableServerException) {
                object2 = new NIAuditLogResultImpl(false, -1099688447L, null, 0);
            }
            return object2;
        }
        return super.invoke(object, method, objectArray);
    }

    protected NICommand[] getCommands(Method method, Object[] objectArray, Class[] classArray) throws NIParameterInvalidServerException {
        NICommand[] nICommandArray = new NICommand[]{new NISecurityCommand(method, objectArray)};
        NIMessageRouterAddress nIMessageRouterAddress = DEFAULT_ADDRESS;
        if (method.getName().equals(EXPORT_AUDIT_LOG)) {
            String string = (String)objectArray[0];
            File file = (File)objectArray[1];
            if (string.equals("0")) {
                nIMessageRouterAddress = MC1_ADDRESS;
            } else if (string.equals("1")) {
                nIMessageRouterAddress = MC2_ADDRESS;
            } else {
                throw new NIParameterInvalidServerException(2, null, "Invalid HMC value.");
            }
            if (file == null) {
                throw new NIParameterInvalidServerException(2, null, "Invalid file location.");
            }
        }
        nICommandArray[0].getAddress().setDestinationAddress(nIMessageRouterAddress);
        return nICommandArray;
    }

    protected Object processResults(NICommand[] nICommandArray) throws Exception {
        NIAuditLogResultImpl nIAuditLogResultImpl;
        Object object = super.processResults(nICommandArray);
        if (nICommandArray[0].getMethodName().equals("modifyUserAccountPassword") && ((NISecurityResult)object).isSuccessful()) {
            super.updateConnectionPassword((String)nICommandArray[0].getParameters()[0], (String)nICommandArray[0].getParameters()[1]);
        } else if (nICommandArray[0].getMethodName().equals(EXPORT_AUDIT_LOG) && (nIAuditLogResultImpl = (NIAuditLogResultImpl)object).isSuccessful()) {
            Object[] objectArray = nICommandArray[0].getParameters();
            InetAddress inetAddress = this.rcc.getServerAddressByIndex(Integer.parseInt((String)objectArray[0]));
            if (inetAddress == null) {
                object = new NIAuditLogResultImpl(false, -1099688447L, null, 0);
            } else {
                NIAuditLogExportClient nIAuditLogExportClient = new NIAuditLogExportClient(inetAddress, nIAuditLogResultImpl);
                object = nIAuditLogExportClient.exportAuditLog((File)objectArray[1]);
            }
        }
        return object;
    }
}

