/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.client.extensions.services.event;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.event.NIEventListener;
import com.ibm.storage.ess.ni.client.extensions.services.event.NIEventListenerThread;
import com.ibm.storage.ess.ni.client.extensions.services.event.NIEventListenerThreadPool;
import com.ibm.storage.ess.ni.event.NIEventImpl;
import com.ibm.storage.ess.ni.event.NIEventLostEventImpl;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.util.NIQueue;
import com.ibm.storage.ess.ni.util.NIQueueFullException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class NIEventDistributor
extends Thread {
    private NIQueue eventQueue;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$client$extensions$services$event$NIEventDistributor == null ? (class$com$ibm$storage$ess$ni$client$extensions$services$event$NIEventDistributor = NIEventDistributor.class$("com.ibm.storage.ess.ni.client.extensions.services.event.NIEventDistributor")) : class$com$ibm$storage$ess$ni$client$extensions$services$event$NIEventDistributor);
    private NIEventListenerThreadPool threadPool;
    private TreeMap listeners = new TreeMap(new NIEventDistributorComparator());
    private static final int EVENT_QUEUE_SIZE = 500;
    private static final double EVENT_QUEUE_REDUCTION_PERCENT = 5.0;
    private int numToFire;
    private int numFired;
    private boolean killed = false;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$client$extensions$services$event$NIEventDistributor;

    public NIEventDistributor() {
        super("NIEventDistributor");
        this.threadPool = new NIEventListenerThreadPool(5, 20);
        this.eventQueue = new NIQueue(500, 5.0);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addListener(int n, NIEventListener nIEventListener, Class clazz) {
        Serializable serializable;
        boolean bl = true;
        TreeMap treeMap = (TreeMap)this.listeners.get(clazz);
        if (treeMap == null) {
            treeMap = new TreeMap();
            serializable = this.listeners;
            synchronized (serializable) {
                this.listeners.put(clazz, treeMap);
            }
        }
        logger.debug_detailed("entered addListener");
        serializable = new Integer(n);
        Vector<NIEventListener> vector = (Vector<NIEventListener>)treeMap.get(serializable);
        logger.debug_detailed("got listener vector");
        if (vector != null) {
            if (!vector.contains(nIEventListener)) {
                logger.debug_detailed("about to get vector lock");
                Vector<NIEventListener> vector2 = vector;
                synchronized (vector2) {
                    vector.add(nIEventListener);
                }
                logger.debug_detailed("releasing vector lock");
            }
        } else {
            logger.debug_detailed("creating new listenerVector");
            vector = new Vector<NIEventListener>();
            vector.add(nIEventListener);
            TreeMap treeMap2 = treeMap;
            synchronized (treeMap2) {
                treeMap.put((TreeMap)serializable, vector);
            }
        }
        logger.debug_detailed("exiting addListener");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeListener(int n, NIEventListener nIEventListener, Class clazz) {
        boolean bl = false;
        TreeMap treeMap = (TreeMap)this.listeners.get(clazz);
        if (treeMap == null) {
            bl = true;
        } else {
            Integer n2 = new Integer(n);
            Vector vector = (Vector)treeMap.get(n2);
            if (vector != null) {
                Vector vector2 = vector;
                synchronized (vector2) {
                    vector.remove(nIEventListener);
                }
                if (vector.isEmpty()) {
                    TreeMap treeMap2 = treeMap;
                    synchronized (treeMap2) {
                        treeMap.remove(n2);
                    }
                    if (treeMap.isEmpty()) {
                        TreeMap treeMap3 = this.listeners;
                        synchronized (treeMap3) {
                            this.listeners.remove(clazz);
                        }
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Vector removeAllListeners(int n) {
        Integer n2 = new Integer(n);
        Vector<Class> vector = new Vector<Class>();
        TreeMap treeMap = this.listeners;
        synchronized (treeMap) {
            Set set = this.listeners.keySet();
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                TreeMap treeMap2;
                Class clazz = (Class)iterator.next();
                TreeMap treeMap3 = treeMap2 = (TreeMap)this.listeners.get(clazz);
                synchronized (treeMap3) {
                    treeMap2.remove(n2);
                }
                if (!treeMap2.isEmpty()) continue;
                vector.add(clazz);
            }
            iterator = vector.iterator();
            while (iterator.hasNext()) {
                this.listeners.remove(iterator.next());
            }
        }
        return vector;
    }

    public void enqueue(NIEventImpl nIEventImpl) {
        logger.debug_detailed("Distributor enqueuing event");
        try {
            this.eventQueue.enqueue(nIEventImpl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Illegal argument given to enqueue: " + nIEventImpl);
            logger.throwable((Throwable)illegalArgumentException);
        }
        catch (NIQueueFullException nIQueueFullException) {
            logger.error("Event queue is full... clearing queue and sending EventLostEvent");
            this.eventQueue.clear();
            this.enqueue(new NIEventLostEventImpl());
        }
    }

    public NIEventImpl dequeue() {
        NIEventImpl nIEventImpl = null;
        try {
            nIEventImpl = (NIEventImpl)this.eventQueue.dequeue();
        }
        catch (InterruptedException interruptedException) {
            logger.debug_detailed("Interrupted while waiting for event to dequeue");
        }
        return nIEventImpl;
    }

    public void shutdown() {
        this.threadPool.shutdown();
        this.killed = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.killed) {
            Object object;
            NIEventImpl nIEventImpl = this.dequeue();
            logger.debug_detailed("RUN: Dequeued event " + nIEventImpl);
            if (nIEventImpl == null) continue;
            Class[] classArray = nIEventImpl.getListenerTypes();
            this.numFired = 0;
            this.numToFire = 0;
            int n = 0;
            while (n < classArray.length) {
                TreeMap treeMap = (TreeMap)this.listeners.get(classArray[n]);
                if (treeMap != null) {
                    Iterator<Object> iterator;
                    Collection<Object> collection;
                    TreeMap treeMap2;
                    object = treeMap;
                    synchronized (object) {
                        treeMap2 = new TreeMap();
                        collection = treeMap.keySet();
                        iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            treeMap2.put(e, new Vector((Vector)treeMap.get(e)));
                        }
                    }
                    collection = treeMap2.values();
                    iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        Vector vector = (Vector)iterator.next();
                        if (vector == null) continue;
                        this.numToFire += vector.size();
                        Iterator iterator2 = vector.iterator();
                        while (!this.killed && iterator2.hasNext()) {
                            logger.debug_detailed("EventDistributor firing off event listener");
                            NIEventListener nIEventListener = (NIEventListener)iterator2.next();
                            logger.debug_detailed("RUN: getting a free thread");
                            NIEventListenerThread nIEventListenerThread = this.threadPool.getFreeThread();
                            logger.debug_detailed("RUN: calling the callback method on the thread");
                            logger.debug_general("NIEventDistributor: Firing event " + nIEventImpl.getClass().getName() + " to listener " + nIEventListener);
                            nIEventListenerThread.callback(nIEventListener, nIEventImpl, this);
                        }
                    }
                }
                ++n;
            }
            logger.debug_detailed("started off " + this.numToFire + " event listeners");
            object = this;
            synchronized (object) {
                while (!this.killed && this.numFired < this.numToFire) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug_detailed("interrupted while waiting for listeners (" + this.numFired + "/" + this.numToFire + " completed) for event " + nIEventImpl);
                    }
                }
            }
            logger.debug_detailed("finished " + this.numFired + " listeners for event" + nIEventImpl);
        }
        this.threadPool.shutdown();
    }

    public synchronized void eventProcessed() {
        ++this.numFired;
        this.notify();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NIEventDistributorComparator
    implements Comparator {
        private NIEventDistributorComparator() {
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }
}

