/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.command.extensions;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.command.extensions.NIConnectionCommand;
import com.ibm.storage.ess.ni.command.extensions.timeouts.NICommandTimeoutOracle;
import com.ibm.storage.ess.ni.commandagent.common.NIResponseInterface;
import com.ibm.storage.ess.ni.commandagent.common.NIServicesInterface;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class NIGetPeerHMCAddressCommand
extends NIConnectionCommand {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$command$extensions$NIGetPeerHMCAddressCommand == null ? (class$com$ibm$storage$ess$ni$command$extensions$NIGetPeerHMCAddressCommand = NIGetPeerHMCAddressCommand.class$("com.ibm.storage.ess.ni.command.extensions.NIGetPeerHMCAddressCommand")) : class$com$ibm$storage$ess$ni$command$extensions$NIGetPeerHMCAddressCommand);
    private InetAddress peerHMCAddress;
    public static final int OLD_VERSION = 0;
    public static final int HMC_ONE = 1;
    public static final int HMC_TWO = 2;
    private int hmcNumber = 0;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$command$extensions$NIGetPeerHMCAddressCommand;

    public void setHMCNumber(int n) {
        if (n == 1 || n == 2) {
            this.hmcNumber = n;
        }
    }

    public int getHMCNumber() {
        return this.hmcNumber;
    }

    public NIGetPeerHMCAddressCommand() {
        this.setTimeout(NICommandTimeoutOracle.getTimeout(this));
    }

    public void setPeerHMCAddress(InetAddress inetAddress) {
        this.peerHMCAddress = inetAddress;
    }

    public InetAddress getPeerHMCAddress() {
        return this.peerHMCAddress;
    }

    public void execute(NIServicesInterface nIServicesInterface, NIResponseInterface nIResponseInterface) {
        try {
            if (NIAgentProperties.getAgentType() == 3) {
                NetworkInterface networkInterface = NetworkInterface.getByName("eth2");
                if (networkInterface != null) {
                    Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                    if (enumeration.hasMoreElements()) {
                        this.peerHMCAddress = enumeration.nextElement();
                        logger.debug_general("eth2 found, setting peer to " + this.peerHMCAddress);
                    }
                } else {
                    logger.debug_general("there was no eth2... leave the peerAddress alone");
                }
            }
        }
        catch (SocketException socketException) {
            logger.error("socket exception while trying to get eth2 network interface");
            logger.throwable((Throwable)socketException);
        }
        this.getAddress().reverseAddress();
        nIResponseInterface.send(this);
    }

    public String toString() {
        return "NIGetPeerHMCAddressCommand (" + this.getAddress() + "): " + this.peerHMCAddress;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

