/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.commandagent.infrastructure;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.commandagent.common.NIResponseInterface;
import com.ibm.storage.ess.ni.commandagent.common.NIServicesInterface;
import com.ibm.storage.ess.ni.commandagent.infrastructure.NICommandProcessorMonitor;
import com.ibm.storage.ess.ni.exception.NITimeoutServerException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.util.NIQueue;

public class NICommandProcessor
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$commandagent$infrastructure$NICommandProcessor == null ? (class$com$ibm$storage$ess$ni$commandagent$infrastructure$NICommandProcessor = NICommandProcessor.class$("com.ibm.storage.ess.ni.commandagent.infrastructure.NICommandProcessor")) : class$com$ibm$storage$ess$ni$commandagent$infrastructure$NICommandProcessor);
    private long commandCount = 0L;
    private long totalTime = 0L;
    private boolean stopping;
    private NIResponseInterface responseInterface;
    private NIServicesInterface services;
    private NIQueue queue = null;
    private boolean running = false;
    private int number = -1;
    private NICommandProcessorMonitor monitor = null;
    private NICommand command = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$commandagent$infrastructure$NICommandProcessor;

    public NICommandProcessor(NIQueue nIQueue, NIServicesInterface nIServicesInterface, NIResponseInterface nIResponseInterface, NICommandProcessorMonitor nICommandProcessorMonitor, int n) {
        super("NICommandProcessor " + n);
        this.queue = nIQueue;
        this.services = nIServicesInterface;
        this.responseInterface = nIResponseInterface;
        this.number = n;
        this.monitor = nICommandProcessorMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.enter("NICommandProcessor", "run");
        this.running = true;
        long l = 0L;
        while (this.running) {
            block9: {
                Object var7_5;
                try {
                    try {
                        this.command = (NICommand)this.queue.dequeue();
                        logger.trace("processing command: " + this.command, "NICommandProcessor", "run", null);
                        l = System.currentTimeMillis();
                        ++this.commandCount;
                        this.command.execute(this.services, this.responseInterface);
                        this.totalTime += System.currentTimeMillis() - l;
                        logger.trace("finished processing command: " + this.command, "NICommandProcessor", "run", null);
                        if (logger.debug_detailedLoggingEnabled()) {
                            logger.debug_detailed("time to process command: " + this.totalTime);
                            logger.debug_detailed("average processing time: " + this.totalTime / this.commandCount);
                        }
                        this.command.clearResourceSetMethods();
                        this.monitor.updateProcessorComplete(this.number);
                        this.command = null;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.interrupted();
                        logger.debug_general("processor interrupted", "NICommandProcessor", "run", null);
                        var7_5 = null;
                        this.command = null;
                        break block9;
                    }
                    catch (Exception exception) {
                        logger.error("Unexpected exception occurred");
                        logger.throwable((Throwable)exception);
                        var7_5 = null;
                        this.command = null;
                        break block9;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        this.command = null;
                        logger.error("OOM occurred, attempting recovery");
                        logger.debug_general("before GC call, free mem: " + Runtime.getRuntime().freeMemory());
                        System.gc();
                        Thread.yield();
                        logger.debug_general("after GC call, free mem: " + Runtime.getRuntime().freeMemory());
                        logger.throwable((Throwable)outOfMemoryError);
                        var7_5 = null;
                        this.command = null;
                    }
                    var7_5 = null;
                    this.command = null;
                }
                catch (Throwable throwable) {
                    var7_5 = null;
                    this.command = null;
                    throw throwable;
                }
            }
            if (this.stopping) {
                this.running = !this.queue.isEmpty();
            }
            this.command = null;
        }
        this.monitor.processorEnded(this.number);
        logger.exit("NICommandProcessor", "run");
    }

    public void stopRunning() throws InterruptedException {
        logger.enter("NICommandProcessor", "stopRunning");
        this.stopping = true;
        this.interrupt();
        Thread.yield();
        if (!this.isInterrupted()) {
            this.join();
        }
        if (this.command != null) {
            try {
                this.command.callback(new NITimeoutServerException(0, "Command agent is shutting down. Command execution started but response will not be sent back."));
            }
            catch (Exception exception) {
                logger.error("Encountered a problem cancelling currently executing command.");
                logger.throwable((Throwable)exception);
            }
        }
        logger.exit("NICommandProcessor", "stopRunning");
    }

    public double getAverageProcessingTime() {
        return (double)this.totalTime / (double)this.commandCount;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

