/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.commandagent.infrastructure;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.command.extensions.NICommandTransporter;
import com.ibm.storage.ess.ni.command.extensions.NIUnsupportedCommand;
import com.ibm.storage.ess.ni.commandagent.common.NIResponseInterface;
import com.ibm.storage.ess.ni.commandagent.infrastructure.NICommandCommunicator;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterInputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterOutputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import java.io.IOException;

public class NIMRCommandCommunicator
implements NICommandCommunicator,
NIResponseInterface {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$commandagent$infrastructure$NIMRCommandCommunicator == null ? (class$com$ibm$storage$ess$ni$commandagent$infrastructure$NIMRCommandCommunicator = NIMRCommandCommunicator.class$("com.ibm.storage.ess.ni.commandagent.infrastructure.NIMRCommandCommunicator")) : class$com$ibm$storage$ess$ni$commandagent$infrastructure$NIMRCommandCommunicator);
    private NIMessageRouterAddress localAddress;
    private NIMessageRouterInputStream mris = null;
    private NIMessageRouterOutputStream mros = null;
    private NIMessageRouterChannel mrc;
    NIMessageRouter messageRouterInterface;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$commandagent$infrastructure$NIMRCommandCommunicator;

    public NIMRCommandCommunicator(NIMessageRouterAddress nIMessageRouterAddress) {
        this.localAddress = nIMessageRouterAddress;
    }

    public NICommand receive() throws NIMessageRouterException, InterruptedException, IOException {
        NICommandTransporter nICommandTransporter = (NICommandTransporter)this.mris.readObject();
        NICommand nICommand = nICommandTransporter.getCommand();
        logger.debug_general("Recieving command from Message Router: " + nICommand);
        while (nICommand == null) {
            nICommandTransporter.getAddress().reverseAddress();
            nICommandTransporter.setCommand(new NIUnsupportedCommand(nICommandTransporter));
            this.send(nICommandTransporter);
            nICommandTransporter = (NICommandTransporter)this.mris.readObject();
            nICommand = nICommandTransporter.getCommand();
        }
        return nICommand;
    }

    public boolean send(NICommand nICommand) {
        return this.send(new NICommandTransporter(nICommand));
    }

    private boolean send(NICommandTransporter nICommandTransporter) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = null;
        try {
            nIMessageRouterReturnStatus = this.mros.send(nICommandTransporter.getAddress().getDestinationAddress(), nICommandTransporter);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            logger.error("Exception while sending command to message router: " + nICommandTransporter.getCommand());
        }
        if (nIMessageRouterReturnStatus.getStatus() != 1 && nIMessageRouterReturnStatus.getStatus() != 9) {
            logger.error("Status of send to the NIMessageRouterOutputStream was " + nIMessageRouterReturnStatus.getStatus() + " for the command: " + nICommandTransporter.getCommand());
        } else {
            logger.debug_general("Sent command to Message Router: " + nICommandTransporter.getCommand());
        }
        return nIMessageRouterReturnStatus.getStatus() == 9;
    }

    public boolean connect() throws NIMessageRouterException {
        this.messageRouterInterface = NIMessageRouterFactory.getInstanceOf();
        this.mrc = this.messageRouterInterface.createNIMessageRouterChannel(this.localAddress.getProcessChannelID());
        this.mris = this.mrc.getNIMessageRouterInputStream();
        this.mros = this.mrc.getNIMessageRouterOutputStream();
        logger.debug_general("connected to message router");
        return true;
    }

    public boolean disconnect() {
        if (this.mrc != null && this.messageRouterInterface != null) {
            this.messageRouterInterface.destroyNIMessageRouterChannel(this.mrc);
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

