/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.communication.NICommunication;
import com.ibm.storage.ess.ni.communication.NICommunicationExecutor;
import com.ibm.storage.ess.ni.communication.NIHandlerMonitor;
import com.ibm.storage.ess.ni.communication.NITestCommunication;
import com.ibm.storage.ess.ni.communication.NIUnsupportedCommunication;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.net.Socket;

public class NIHandler
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$NIHandler == null ? (class$com$ibm$storage$ess$ni$communication$NIHandler = NIHandler.class$("com.ibm.storage.ess.ni.communication.NIHandler")) : class$com$ibm$storage$ess$ni$communication$NIHandler);
    private Socket initiatorConnection;
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private NICommunicationExecutor executor;
    private NIHandlerMonitor monitor;
    private boolean running = false;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$NIHandler;

    public NIHandler(Socket socket, NICommunicationExecutor nICommunicationExecutor) {
        super("NIHandlerThread");
        this.initiatorConnection = socket;
        this.executor = nICommunicationExecutor;
        this.monitor = null;
        this.in = null;
        this.out = null;
    }

    public void run() {
        block14: {
            try {
                if (this.initiatorConnection != null) {
                    this.out = new ObjectOutputStream(this.initiatorConnection.getOutputStream());
                    this.in = new ObjectInputStream(this.initiatorConnection.getInputStream());
                    break block14;
                }
                if (this.monitor != null) {
                    this.monitor.handleConnectionProblem(this);
                }
                return;
            }
            catch (IOException iOException) {
                if (this.monitor != null) {
                    this.monitor.handleConnectionProblem(this);
                }
                return;
            }
        }
        NICommunication nICommunication = null;
        this.running = true;
        while (this.running) {
            try {
                nICommunication = (NICommunication)this.in.readObject();
                logger.debug_detailed("received NICommunication");
                if (nICommunication instanceof NITestCommunication) {
                    this.sendResponse(nICommunication);
                    continue;
                }
                this.sendResponse(this.executor.execute(nICommunication));
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.throwable((Throwable)classNotFoundException);
                this.handleUnsupportedCommunication();
            }
            catch (InvalidClassException invalidClassException) {
                logger.throwable((Throwable)invalidClassException);
                this.handleUnsupportedCommunication();
            }
            catch (OptionalDataException optionalDataException) {
                logger.throwable((Throwable)optionalDataException);
                this.handleUnsupportedCommunication();
            }
            catch (IOException iOException) {
                logger.debug_general("Connection problem detected, most likely disconnecting client", "NIHandler", "run", null);
                if (this.monitor != null) {
                    logger.debug_detailed("calling handleConnectionProblem");
                    this.monitor.handleConnectionProblem(this);
                    continue;
                }
                this.running = false;
            }
            catch (ClassCastException classCastException) {
                logger.throwable((Throwable)classCastException);
            }
        }
    }

    private void sendResponse(NICommunication nICommunication) {
        block2: {
            try {
                this.out.writeObject(nICommunication);
                this.out.flush();
            }
            catch (IOException iOException) {
                if (this.monitor == null) break block2;
                this.monitor.handleConnectionProblem(this);
            }
        }
    }

    private void handleUnsupportedCommunication() {
        NIUnsupportedCommunication nIUnsupportedCommunication = new NIUnsupportedCommunication();
        this.sendResponse(nIUnsupportedCommunication);
        if (this.monitor != null) {
            this.monitor.handleUnsupportedCommunication(this);
        }
    }

    public void close() throws IOException {
        this.running = false;
        if (this.initiatorConnection != null) {
            this.initiatorConnection.close();
        }
    }

    public void setMonitor(NIHandlerMonitor nIHandlerMonitor) {
        this.monitor = nIHandlerMonitor;
    }

    public NICommunicationExecutor getExecutor() {
        return this.executor;
    }

    public synchronized void setExecutor(NICommunicationExecutor nICommunicationExecutor) {
        this.executor = nICommunicationExecutor;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

