/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.communication.NICommunication;
import com.ibm.storage.ess.ni.communication.NICommunicationNotSupportedException;
import com.ibm.storage.ess.ni.communication.NITestCommunication;
import com.ibm.storage.ess.ni.communication.NIUnsupportedCommunication;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class NIInitiator {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$NIInitiator == null ? (class$com$ibm$storage$ess$ni$communication$NIInitiator = NIInitiator.class$("com.ibm.storage.ess.ni.communication.NIInitiator")) : class$com$ibm$storage$ess$ni$communication$NIInitiator);
    private Socket serverConnection;
    private ObjectInputStream in;
    private ObjectOutputStream out;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$NIInitiator;

    public NIInitiator(Socket socket) throws IOException {
        this.serverConnection = socket;
        this.in = new ObjectInputStream(this.serverConnection.getInputStream());
        this.out = new ObjectOutputStream(this.serverConnection.getOutputStream());
    }

    public synchronized NICommunication send(NICommunication nICommunication) throws NICommunicationNotSupportedException, IOException {
        NICommunication nICommunication2 = null;
        try {
            logger.debug_detailed("Sending a communication: " + nICommunication);
            this.out.writeObject(nICommunication);
            this.out.flush();
            this.out.reset();
            logger.debug_detailed("Reading the response");
            nICommunication2 = (NICommunication)this.in.readObject();
            logger.debug_detailed("got the response: " + nICommunication2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error("ClassNotFoundException caught", "NIInitiator", "send", null);
            logger.throwable((Throwable)classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            logger.error("ClassCastException caught", "NIInitiator", "send", null);
            logger.throwable((Throwable)classCastException);
        }
        catch (NotSerializableException notSerializableException) {
            throw new NICommunicationNotSupportedException(nICommunication, notSerializableException.getMessage());
        }
        if (nICommunication2 instanceof NIUnsupportedCommunication) {
            throw new NICommunicationNotSupportedException(nICommunication);
        }
        nICommunication = nICommunication2;
        return nICommunication;
    }

    public boolean isConnectionAlive() {
        boolean bl = true;
        try {
            NITestCommunication nITestCommunication = new NITestCommunication();
            nITestCommunication = (NITestCommunication)this.send(nITestCommunication);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void close() throws IOException {
        logger.debug_detailed("Closing inputStream");
        this.in.close();
        logger.debug_detailed("Closing outputStream");
        this.out.close();
        logger.debug_detailed("closing socket");
        this.serverConnection.close();
        logger.exit("NIInitiator", "close");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

