/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.extensions;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.communication.NICommunication;
import com.ibm.storage.ess.ni.communication.extensions.NIHeartbeatCommunication;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.communication.extensions.common.NIZippedCommunication;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class NIInitiator {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$extensions$NIInitiator == null ? (class$com$ibm$storage$ess$ni$communication$extensions$NIInitiator = NIInitiator.class$("com.ibm.storage.ess.ni.communication.extensions.NIInitiator")) : class$com$ibm$storage$ess$ni$communication$extensions$NIInitiator);
    private static final Logger detailedLogger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$extensions$NITransmissionLogger == null ? (class$com$ibm$storage$ess$ni$communication$extensions$NITransmissionLogger = NIInitiator.class$("com.ibm.storage.ess.ni.communication.extensions.NITransmissionLogger")) : class$com$ibm$storage$ess$ni$communication$extensions$NITransmissionLogger);
    private Socket serverConnection;
    private ObjectOutputStream out;
    private String label;
    private String name;
    private String addr;
    private NIClientConnectionToken token;
    private boolean zipped = false;
    private static int nextInstance = 0;
    private static Object instanceLock = new Object();
    private int instanceID;
    private boolean closed = false;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$extensions$NIInitiator;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$extensions$NITransmissionLogger;

    public NIInitiator(Socket socket, String string) throws IOException {
        this.serverConnection = socket;
        this.out = new ObjectOutputStream(this.serverConnection.getOutputStream());
        this.name = string;
        this.addr = "?";
        this.getInstanceID();
        if (this.serverConnection != null) {
            this.addr = this.serverConnection.getInetAddress().getHostAddress().toString();
        }
        this.label = "<" + string + "(#" + this.instanceID + "):client #?-->" + this.addr + "> ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getInstanceID() {
        Object object = instanceLock;
        synchronized (object) {
            this.instanceID = nextInstance++;
        }
        return this.instanceID;
    }

    public synchronized void send(NICommunication nICommunication) throws NIUnsupportedException, IOException {
        if (!this.closed) {
            try {
                detailedLogger.debug_general(this.label + "sending: " + nICommunication);
                if (this.zipped) {
                    this.out.writeObject(new NIZippedCommunication(nICommunication));
                    this.out.flush();
                    this.out.reset();
                }
                this.out.writeObject(nICommunication);
                this.out.flush();
                this.out.reset();
            }
            catch (NotSerializableException notSerializableException) {
                throw new NIUnsupportedException(notSerializableException.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                logger.warning("Null pointer during send. Socket must have been closed");
                return;
            }
        } else {
            throw new IOException("Initiator closed, no sockets to send with");
        }
    }

    public boolean isConnectionAlive() {
        boolean bl = true;
        try {
            NIHeartbeatCommunication nIHeartbeatCommunication = new NIHeartbeatCommunication();
            this.send(nIHeartbeatCommunication);
        }
        catch (Exception exception) {
            logger.error(this.label + "exception when trying to test the connection");
            logger.throwable((Throwable)exception);
            bl = false;
        }
        return bl;
    }

    public void close() throws IOException {
        try {
            if (this.serverConnection != null) {
                this.serverConnection.close();
                this.serverConnection = null;
                this.out = null;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.closed = true;
    }

    public void setName(String string) {
        this.name = string;
        this.label = "<" + string + "(#" + this.instanceID + "):client #" + (this.token == null ? "?" : this.token.toString()) + "-->" + this.addr + "> ";
    }

    public void setToken(NIClientConnectionToken nIClientConnectionToken) {
        this.token = nIClientConnectionToken;
        this.label = "<" + this.name + "(#" + this.instanceID + "):client #" + (nIClientConnectionToken == null ? "?" : nIClientConnectionToken.toString()) + "-->" + this.addr + "> ";
    }

    public void goZipped() {
        this.zipped = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

